/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client;

import com.mojang.minecraft.MinecraftError;
import com.mojang.minecraft.MinecraftException;
import com.mojang.minecraft.client.MinecraftApplet;
import com.mojang.minecraft.client.MinecraftImpl;
import com.mojang.minecraft.client.Timer;
import com.mojang.minecraft.client.entity.EntityPlayerSP;
import com.mojang.minecraft.client.entity.item.ItemRenderer;
import com.mojang.minecraft.client.entity.model.ModelBiped;
import com.mojang.minecraft.client.gui.GuiBuild;
import com.mojang.minecraft.client.gui.GuiChat;
import com.mojang.minecraft.client.gui.GuiConflictWarning;
import com.mojang.minecraft.client.gui.GuiConnecting;
import com.mojang.minecraft.client.gui.GuiErrorScreen;
import com.mojang.minecraft.client.gui.GuiGameOver;
import com.mojang.minecraft.client.gui.GuiIngame;
import com.mojang.minecraft.client.gui.GuiIngameMenu;
import com.mojang.minecraft.client.gui.GuiInventory;
import com.mojang.minecraft.client.gui.GuiMainMenu;
import com.mojang.minecraft.client.gui.GuiPreSeasonWorld;
import com.mojang.minecraft.client.gui.GuiScreen;
import com.mojang.minecraft.client.gui.GuiUnused;
import com.mojang.minecraft.client.gui.LoadingScreenRenderer;
import com.mojang.minecraft.client.level.tile.fx.TextureCloudsFX;
import com.mojang.minecraft.client.level.tile.fx.TextureCompassFX;
import com.mojang.minecraft.client.level.tile.fx.TextureFlamesFX;
import com.mojang.minecraft.client.level.tile.fx.TextureGearFX;
import com.mojang.minecraft.client.level.tile.fx.TextureGearIdleFX;
import com.mojang.minecraft.client.level.tile.fx.TextureLavaFX;
import com.mojang.minecraft.client.level.tile.fx.TextureLavaFlowFX;
import com.mojang.minecraft.client.level.tile.fx.TextureLeavesFX;
import com.mojang.minecraft.client.level.tile.fx.TextureWaterFX;
import com.mojang.minecraft.client.level.tile.fx.TextureWaterOverlayFX;
import com.mojang.minecraft.client.level.tile.fx.TexureWaterFlowFX;
import com.mojang.minecraft.client.mods.TexturePackList;
import com.mojang.minecraft.client.network.NetClientHandler;
import com.mojang.minecraft.client.player.controller.ControllerHelper;
import com.mojang.minecraft.client.player.controller.GameSettings;
import com.mojang.minecraft.client.player.controller.GameWindowListener;
import com.mojang.minecraft.client.player.controller.MouseHelper;
import com.mojang.minecraft.client.player.controller.MovementInputFromOptions;
import com.mojang.minecraft.client.player.controller.PlayerController;
import com.mojang.minecraft.client.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.client.render.EffectRenderer;
import com.mojang.minecraft.client.render.EntityRenderer;
import com.mojang.minecraft.client.render.FontRenderer;
import com.mojang.minecraft.client.render.GLAllocation;
import com.mojang.minecraft.client.render.OpenGlCapsChecker;
import com.mojang.minecraft.client.render.RenderEngine;
import com.mojang.minecraft.client.render.RenderGlobal;
import com.mojang.minecraft.client.render.RenderManager;
import com.mojang.minecraft.client.render.ScaledResolution;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.client.render.WorldRenderer;
import com.mojang.minecraft.client.sound.SoundManager;
import com.mojang.minecraft.client.sound.ThreadDownloadResources;
import com.mojang.minecraft.client.util.ScreenShotHelper;
import com.mojang.minecraft.client.util.Session;
import com.mojang.minecraft.client.util.SkinManager;
import com.mojang.minecraft.core.entity.EntityClientPlayerMP;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.MovingObjectPosition;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.enums.EnumOS2;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.enums.EnumWeather;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.core.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.core.level.generate.IChunkProvider;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.core.util.MathHelper;
import com.mojang.minecraft.core.util.ThreadDisplayMode;
import com.mojang.minecraft.core.util.ThreadSleepForever;
import com.mojang.minecraft.core.util.UnexpectedThrowable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public abstract class Minecraft
implements Runnable {
    public static byte[] field_28006_b = new byte[0xA00000];
    private static Minecraft theMinecraft;
    public PlayerController playerController;
    private boolean isFullscreen = false;
    private boolean hasCrashed = false;
    public int displayWidth;
    public int displayHeight;
    private OpenGlCapsChecker glCapabilities;
    public Timer timer;
    public World mcWorld;
    public RenderGlobal renderGlobal;
    public EntityPlayerSP thePlayer;
    public EntityLiving renderViewEntity;
    public EffectRenderer effectRenderer;
    public Session session = null;
    public String field_175_j;
    public Canvas mcCanvas;
    public boolean field_173_l = true;
    public volatile boolean isGamePaused = false;
    public RenderEngine renderEngine;
    public FontRenderer fontRender;
    public GuiScreen currentScreen = null;
    public LoadingScreenRenderer loadScreen;
    public EntityRenderer entityRenderer;
    private ThreadDownloadResources downloadResourcesThread;
    private ThreadDisplayMode getDisplayModesThread;
    private int ticksRan = 0;
    private int leftClickCounter = 0;
    private int field_142_Q;
    private int field_141_R;
    public String field_166_s = null;
    public int field_165_t = 0;
    public GuiIngame ingameGUI;
    public boolean skipRenderWorld = false;
    public ModelBiped field_162_w;
    public MovingObjectPosition objectMouseOver = null;
    public GameSettings options;
    protected MinecraftApplet mcApplet;
    public SoundManager soundMGR;
    public MouseHelper mouseHelper;
    public TexturePackList texturePackList;
    public File mcDataDir;
    public static long[] frameTimes;
    public static int numRecordedFrameTimes;
    private String serverName;
    private int serverPort;
    private TextureWaterFX textureWaterFX;
    private TextureLavaFX textureLavaFX;
    private TextureWaterOverlayFX waterOverlay;
    private static File dataFolder;
    public volatile boolean running = true;
    public String debug = "";
    boolean isTakingScreenshot;
    long field_151_H = -1L;
    public boolean inGameHasFocus = false;
    private int mouseTicksRan = 0;
    public boolean enableRain = false;
    long systemTime;
    private int joinPlayerCounter = 0;
    private Vec3D savedPlayerPos;
    public static boolean isIRIX;
    public static boolean isMACOS;
    public boolean hasChimed = false;
    public static String chime;
    public static String versionNumber;
    public static String version;
    public static ControllerHelper controller;
    public boolean controllerDetected;
    public TextureCloudsFX cloudtex;
    public static boolean playtesting;
    public SkinManager skins;
    public ArrayList<String> messages = new ArrayList();

    static {
        frameTimes = new long[512];
        numRecordedFrameTimes = 0;
        dataFolder = null;
        chime = "";
        versionNumber = "v1.1.12";
        version = "Minecraft Alpha " + versionNumber;
        playtesting = false;
    }

    public Minecraft(Component component, Canvas canvas, MinecraftApplet minecraftapplet, int i, int j, boolean flag) {
        this.timer = new Timer(20.0f);
        this.loadScreen = new LoadingScreenRenderer(this);
        this.entityRenderer = new EntityRenderer(this);
        this.field_162_w = new ModelBiped(0.0f);
        this.soundMGR = new SoundManager();
        this.textureWaterFX = new TextureWaterFX();
        this.textureLavaFX = new TextureLavaFX();
        this.waterOverlay = new TextureWaterOverlayFX();
        this.systemTime = System.currentTimeMillis();
        this.field_142_Q = i;
        this.field_141_R = j;
        this.isFullscreen = flag;
        this.mcApplet = minecraftapplet;
        new ThreadSleepForever(this, "Timer hack thread");
        this.mcCanvas = canvas;
        this.displayWidth = i;
        this.displayHeight = j;
        this.isFullscreen = flag;
        this.savedPlayerPos = Vec3D.createVectorHelper(0.0, 128.0, 0.0);
        isIRIX = false;
        isMACOS = false;
        theMinecraft = this;
        this.controllerDetected = false;
        this.cloudtex = new TextureCloudsFX(1, this, 21);
    }

    public void onMinecraftCrash(UnexpectedThrowable unexpectedthrowable) {
        this.hasCrashed = true;
        this.displayUnexpectedThrowable(unexpectedthrowable);
    }

    public abstract void displayUnexpectedThrowable(UnexpectedThrowable var1);

    public void setServer(String s, int i) {
        this.serverName = s;
        this.serverPort = i;
    }

    public void startupScreen() throws LWJGLException {
        if (this.mcCanvas != null) {
            Graphics g = this.mcCanvas.getGraphics();
            if (g != null) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.displayWidth, this.displayHeight);
                g.dispose();
            }
            Display.setParent((Canvas)this.mcCanvas);
        } else if (this.isFullscreen) {
            Display.setFullscreen((boolean)true);
            this.displayWidth = Display.getDisplayMode().getWidth();
            this.displayHeight = Display.getDisplayMode().getHeight();
            if (this.displayWidth <= 0) {
                this.displayWidth = 1;
            }
            if (this.displayHeight <= 0) {
                this.displayHeight = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.displayWidth, this.displayHeight));
        }
        Display.setTitle((String)version);
        try {
            Display.create((PixelFormat)new PixelFormat().withDepthBits(24));
        }
        catch (LWJGLException lwjglexception) {
            lwjglexception.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        RenderManager.subManager.itemRenderer = new ItemRenderer(this);
        this.mcDataDir = Minecraft.getMinecraftDir();
        this.options = new GameSettings(this, this.mcDataDir);
        this.texturePackList = new TexturePackList(this, this.mcDataDir);
        this.renderEngine = new RenderEngine(this.texturePackList, this.options);
        this.fontRender = new FontRenderer(this.options, "/default.png", this.renderEngine);
        this.showMahjong();
        Keyboard.create();
        Mouse.create();
        this.mouseHelper = new MouseHelper(this.mcCanvas);
        this.checkGLError("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.checkGLError("Startup");
        this.glCapabilities = new OpenGlCapsChecker();
        this.soundMGR.initialize(this.options);
        this.renderEngine.bindTextureFX(this.textureLavaFX);
        this.renderEngine.bindTextureFX(this.textureWaterFX);
        this.renderEngine.bindTextureFX(this.waterOverlay);
        this.renderEngine.bindTextureFX(new TextureCompassFX(this));
        this.renderEngine.bindTextureFX(new TexureWaterFlowFX());
        this.renderEngine.bindTextureFX(new TextureLavaFlowFX());
        this.renderEngine.bindTextureFX(new TextureFlamesFX(0));
        this.renderEngine.bindTextureFX(new TextureFlamesFX(1));
        this.renderEngine.bindTextureFX(new TextureGearFX(16));
        this.renderEngine.bindTextureFX(new TextureGearFX(17));
        this.renderEngine.bindTextureFX(new TextureGearIdleFX(0));
        this.renderEngine.bindTextureFX(new TextureGearIdleFX(1));
        this.renderEngine.bindTextureFX(new TextureLeavesFX(0, this));
        this.renderEngine.bindTextureFX(new TextureLeavesFX(1, this));
        this.renderGlobal = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        this.effectRenderer = new EffectRenderer(this.mcWorld, this.renderEngine, this);
        try {
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkGLError("Post startup");
        this.ingameGUI = new GuiIngame(this);
        this.skins = new SkinManager(this);
        if (this.serverName != null) {
            this.setCurrentScreen(new GuiConnecting(this, this.serverName, this.serverPort));
        } else {
            while (this.options.soundVolume != 0.0f && !this.soundMGR.getLoaded()) {
            }
            this.setCurrentScreen(new GuiMainMenu());
        }
    }

    private void showMahjong() throws LWJGLException {
        int oldScale = this.options.guiScale;
        this.options.guiScale = 0;
        ScaledResolution scaledresolution = new ScaledResolution(this.displayWidth, this.displayHeight, this);
        int i = scaledresolution.getScaledWidth();
        int j = scaledresolution.getScaledHeight();
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)i, (double)j, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        int c = 256;
        int c1 = 256;
        if (!isMACOS && !isIRIX) {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang.png"));
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            this.drawPng((this.displayWidth / 2 - c) / 2, (this.displayHeight / 2 - c1) / 2, 0, 0, c, c1);
        } else if (isIRIX) {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/sgi_grad.png"));
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 2.0);
            tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang_silicongraphics.png"));
            tessellator.startDrawingQuads();
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            this.drawPng2((this.displayWidth / 2 - 112) / 2, (this.displayHeight / 4 - 22) / 2, 0, 0, 112, 22);
        } else {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang_apple.png"));
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.setColorOpaque_I(0xFFFFFF);
            this.drawPng((this.displayWidth / 2 - c) / 2, (this.displayHeight / 2 - c1) / 2, 0, 0, c, c1);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
        this.options.guiScale = oldScale;
        try {
            this.getDisplayModesThread = new ThreadDisplayMode(this, true);
            this.getDisplayModesThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawPng(int x, int y, int u, int v, int u2, int v2) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + v2, 0.0, (float)(u + 0) * f, (float)(v + v2) * f1);
        tessellator.addVertexWithUV(x + u2, y + v2, 0.0, (float)(u + u2) * f, (float)(v + v2) * f1);
        tessellator.addVertexWithUV(x + u2, y + 0, 0.0, (float)(u + u2) * f, (float)(v + 0) * f1);
        tessellator.addVertexWithUV(x + 0, y + 0, 0.0, (float)(u + 0) * f, (float)(v + 0) * f1);
        tessellator.draw();
    }

    public void drawPng2(int x, int y, int u, int v, int u2, int v2) {
        float f = 0.00891f;
        float f1 = 0.045f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + v2, 0.0, (float)(u + 0) * f, (float)(v + v2) * f1);
        tessellator.addVertexWithUV(x + u2, y + v2, 0.0, (float)(u + u2) * f, (float)(v + v2) * f1);
        tessellator.addVertexWithUV(x + u2, y + 0, 0.0, (float)(u + u2) * f, (float)(v + 0) * f1);
        tessellator.addVertexWithUV(x + 0, y + 0, 0.0, (float)(u + 0) * f, (float)(v + 0) * f1);
        tessellator.draw();
    }

    public static File getMinecraftDir() {
        if (dataFolder == null) {
            dataFolder = Minecraft.getAppDir("minecraft");
        }
        return dataFolder;
    }

    public static File getAppDir(String s) {
        File file;
        String s1 = System.getProperty("user.home", ".");
        switch (Minecraft.getCurrentOS()) {
            case linux: 
            case solaris: {
                file = new File(s1, '.' + s + '/');
                break;
            }
            case windows: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    file = new File(s2, "." + s + '/');
                    break;
                }
                file = new File(s1, '.' + s + '/');
                break;
            }
            case macos: {
                file = new File(s1, "Library/Application Support/" + s);
                break;
            }
            default: {
                file = new File(s1, s + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS2 getCurrentOS() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS2.windows;
        }
        if (s.contains("mac")) {
            isMACOS = true;
            chime = "random.bong";
            if (s.contains("os 9")) {
                return EnumOS2.macos9;
            }
            return EnumOS2.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS2.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS2.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS2.linux;
        }
        if (s.contains("irix")) {
            isIRIX = true;
            chime = "random.indy";
            return EnumOS2.irix;
        }
        if (s.contains("unix")) {
            return EnumOS2.linux;
        }
        return EnumOS2.unknown;
    }

    public void playChime() {
        if (isMACOS) {
            System.out.println("BONG");
            this.soundMGR.playSoundFX("random.mac_chord", 1.0f, 1.0f);
        }
    }

    public void setCurrentScreen(GuiScreen guiscreen) {
        if (this.currentScreen instanceof GuiUnused) {
            return;
        }
        if (this.currentScreen != null) {
            this.currentScreen.onGuiClosed();
        }
        if (guiscreen == null && this.mcWorld == null) {
            guiscreen = new GuiMainMenu();
        } else if (guiscreen == null && this.thePlayer.health <= 0) {
            guiscreen = new GuiGameOver();
        }
        this.currentScreen = guiscreen;
        if (guiscreen != null) {
            this.setIngameNotInFocus();
            ScaledResolution scaledresolution = new ScaledResolution(this.displayWidth, this.displayHeight, this);
            int i = scaledresolution.getScaledWidth();
            int j = scaledresolution.getScaledHeight();
            guiscreen.setResolution(this, i, j);
            this.skipRenderWorld = false;
        } else {
            this.setIngameFocus();
        }
    }

    private void checkGLError(String s) {
        int i = GL11.glGetError();
        if (i != 0) {
            String s1 = GLU.gluErrorString((int)i);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + s);
            System.out.println(i + ": " + s1);
            System.exit(0);
        }
    }

    public void shutdownMinecraftApplet() {
        if (this.mcApplet != null) {
            this.mcApplet.clearApplet();
        }
        try {
            if (this.downloadResourcesThread != null) {
                this.downloadResourcesThread.closeMinecraft();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("Stopping!");
            this.changeWorld1(null);
            try {
                GLAllocation.deleteTexturesAndDisplayLists();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.soundMGR.closeMinecraft();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
            if (!this.hasCrashed) {
                System.exit(0);
            }
        }
        System.gc();
    }

    public void run() {
        this.running = true;
        try {
            this.startupScreen();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.onMinecraftCrash(new UnexpectedThrowable("Failed to start game", exception));
            return;
        }
        try {
            try {
                long l = System.currentTimeMillis();
                int i = 0;
                block14: while (this.running) {
                    try {
                        AxisAlignedBB.clearBoundingBoxPool();
                        Vec3D.initialize();
                        if (this.mcCanvas == null && Display.isCloseRequested()) {
                            this.shutdown();
                        }
                        if (this.isGamePaused && this.mcWorld != null) {
                            float f = this.timer.renderPartialTicks;
                            this.timer.updateTimer();
                            this.timer.renderPartialTicks = f;
                        } else {
                            this.timer.updateTimer();
                        }
                        int j = 0;
                        while (j < this.timer.elapsedTicks) {
                            ++this.ticksRan;
                            try {
                                this.runTick();
                            }
                            catch (MinecraftException minecraftexception) {
                                this.mcWorld = null;
                                this.changeWorld1(null);
                                this.setCurrentScreen(new GuiConflictWarning());
                            }
                            ++j;
                        }
                        if (this.controllerDetected) {
                            controller.poll();
                        }
                        this.checkGLError("Pre render");
                        this.soundMGR.func_338_a(this.thePlayer, this.timer.renderPartialTicks);
                        GL11.glEnable((int)3553);
                        if (this.mcWorld != null) {
                            while (this.mcWorld.updatingLighting()) {
                            }
                        }
                        if (!this.skipRenderWorld) {
                            if (this.playerController != null) {
                                this.playerController.setPartialTime(this.timer.renderPartialTicks);
                            }
                            this.entityRenderer.updateCameraAndRender(this.timer.renderPartialTicks);
                        }
                        if (!Display.isActive()) {
                            if (this.isFullscreen) {
                                this.toggleFullscreen();
                            }
                            Thread.sleep(10L);
                        }
                        if (Keyboard.isKeyDown((int)65)) {
                            Display.update();
                        }
                        this.screenshotListener();
                        if (Keyboard.isKeyDown((int)64)) {
                            this.drawLagometer();
                        } else {
                            this.field_151_H = System.nanoTime();
                        }
                        Thread.yield();
                        Display.update();
                        Display.setVSyncEnabled((boolean)this.options.vSync);
                        if (!(this.mcCanvas == null || this.isFullscreen || this.mcCanvas.getWidth() == this.displayWidth && this.mcCanvas.getHeight() == this.displayHeight)) {
                            this.displayWidth = this.mcCanvas.getWidth();
                            this.displayHeight = this.mcCanvas.getHeight();
                            if (this.displayWidth <= 0) {
                                this.displayWidth = 1;
                            }
                            if (this.displayHeight <= 0) {
                                this.displayHeight = 1;
                            }
                            this.resize(this.displayWidth, this.displayHeight);
                        }
                        this.checkGLError("Post render");
                        ++i;
                        this.isGamePaused = !this.isServer() && this.currentScreen != null && this.currentScreen.doesGuiPauseGame();
                        while (true) {
                            if (System.currentTimeMillis() < l + 1000L) continue block14;
                            this.debug = i + " fps, " + WorldRenderer.chunksUpdated + " chunk updates";
                            WorldRenderer.chunksUpdated = 0;
                            l += 1000L;
                            i = 0;
                        }
                    }
                    catch (MinecraftException mcex) {
                        this.mcWorld = null;
                        this.changeWorld(null, "");
                        this.setCurrentScreen(new GuiConflictWarning());
                    }
                    catch (OutOfMemoryError outofex) {
                        this.func_28002_e();
                        this.setCurrentScreen(new GuiErrorScreen());
                        System.gc();
                    }
                }
            }
            catch (MinecraftError l) {
                this.shutdownMinecraftApplet();
            }
            catch (Throwable throwable) {
                this.mcWorld = null;
                this.func_28002_e();
                throwable.printStackTrace();
                this.onMinecraftCrash(new UnexpectedThrowable("Unexpected error", throwable));
                this.shutdownMinecraftApplet();
            }
        }
        finally {
            this.shutdownMinecraftApplet();
        }
    }

    public void func_28002_e() {
        try {
            field_28006_b = new byte[0];
            this.renderGlobal.func_28137_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AxisAlignedBB.func_28196_a();
            Vec3D.func_28215_a();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.changeWorld1(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void screenshotListener() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                this.ingameGUI.addChatMessage(ScreenShotHelper.saveScreenshot(dataFolder, this.displayWidth, this.displayHeight));
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    private void drawLagometer() {
        if (this.field_151_H == -1L) {
            this.field_151_H = System.nanoTime();
        }
        long l = System.nanoTime();
        Minecraft.frameTimes[Minecraft.numRecordedFrameTimes++ & Minecraft.frameTimes.length - 1] = l - this.field_151_H;
        this.field_151_H = l;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.displayWidth, (double)this.displayHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20200000);
        tessellator.addVertex(0.0, this.displayHeight - 100, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight - 100, 0.0);
        tessellator.draw();
        long l1 = 0L;
        int i = 0;
        while (i < frameTimes.length) {
            l1 += frameTimes[i];
            ++i;
        }
        int j = (int)(l1 / 200000L / (long)frameTimes.length);
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20400000);
        tessellator.addVertex(0.0, this.displayHeight - j, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight, 0.0);
        tessellator.addVertex(frameTimes.length, this.displayHeight - j, 0.0);
        tessellator.draw();
        tessellator.startDrawing(1);
        int k = 0;
        while (k < frameTimes.length) {
            int i1 = (k - numRecordedFrameTimes & frameTimes.length - 1) * 255 / frameTimes.length;
            int j1 = i1 * i1 / 255;
            j1 = j1 * j1 / 255;
            int k1 = j1 * j1 / 255;
            k1 = k1 * k1 / 255;
            tessellator.setColorOpaque_I(-16777216 + k1 + j1 * 256 + i1 * 65536);
            long l2 = frameTimes[k] / 200000L;
            tessellator.addVertex((float)k + 0.5f, (float)((long)this.displayHeight - l2) + 0.5f, 0.0);
            tessellator.addVertex((float)k + 0.5f, (float)this.displayHeight + 0.5f, 0.0);
            ++k;
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (!Display.isActive()) {
            return;
        }
        if (this.inGameHasFocus) {
            return;
        }
        this.inGameHasFocus = true;
        this.mouseHelper.grabMouseCursor();
        this.setCurrentScreen(null);
        this.mouseTicksRan = this.ticksRan + 10000;
    }

    public void setIngameNotInFocus() {
        if (!this.inGameHasFocus) {
            return;
        }
        if (this.thePlayer != null) {
            this.thePlayer.resetPlayerKeyState();
        }
        this.inGameHasFocus = false;
        this.mouseHelper.ungrabMouseCursor();
    }

    public void displayInGameMenu() {
        if (this.currentScreen != null) {
            return;
        }
        if (this.thePlayer != null && this.thePlayer.loopHandler != null) {
            this.thePlayer.loopHandler.killLoops();
        }
        this.setCurrentScreen(new GuiIngameMenu());
    }

    private void func_119_a(int i, boolean flag) {
        if (this.playerController.isCreative) {
            return;
        }
        if (i == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (flag && this.objectMouseOver != null && this.objectMouseOver.typeOfHit == 0 && i == 0) {
            int j = this.objectMouseOver.blockX;
            int k = this.objectMouseOver.blockY;
            int l = this.objectMouseOver.blockZ;
            this.playerController.sendRemovingBlock(j, k, l, this.objectMouseOver.sideHit);
            this.effectRenderer.addBlockHitEffects(j, k, l, this.objectMouseOver.sideHit);
        } else {
            this.playerController.resetBlockRemoving();
        }
    }

    private void clickMouse(int i) {
        ItemStack itemstack;
        if (i == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (i == 0) {
            this.thePlayer.swingItem();
        }
        if (this.objectMouseOver == null) {
            if (i == 0 && !(this.playerController instanceof PlayerControllerCreative)) {
                this.leftClickCounter = 10;
            }
        } else if (this.objectMouseOver.typeOfHit == 1) {
            if (this.mcWorld.multiplayerWorld) {
                if (i == 0) {
                    this.playerController.attackEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
                if (i == 1) {
                    this.playerController.interactWithEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
            } else {
                if (i == 0) {
                    this.thePlayer.attackEntity(this.objectMouseOver.entityHit);
                }
                if (i == 1) {
                    this.thePlayer.useCurrentItemOnEntity(this.objectMouseOver.entityHit);
                }
            }
        } else if (this.objectMouseOver.typeOfHit == 0) {
            int j = this.objectMouseOver.blockX;
            int k = this.objectMouseOver.blockY;
            int i1 = this.objectMouseOver.blockZ;
            int j1 = this.objectMouseOver.sideHit;
            Block block = Block.allBlocks[this.mcWorld.getBlockId(j, k, i1)];
            if (i == 0) {
                this.mcWorld.func_612_i(j, k, i1, this.objectMouseOver.sideHit);
                if (block != Block.bedrock || this.thePlayer.field_777_c >= 100) {
                    this.playerController.clickBlock(j, k, i1, this.objectMouseOver.sideHit);
                } else if (block == Block.bedrock && this.thePlayer.isCreative) {
                    this.playerController.clickBlock(j, k, i1, this.objectMouseOver.sideHit);
                }
            } else {
                int k1;
                ItemStack itemstack2 = this.thePlayer.inventory.getCurrentItem();
                int n = k1 = itemstack2 == null ? 0 : itemstack2.stackSize;
                if (this.playerController.sendPlaceBlock(this.thePlayer, this.mcWorld, itemstack2, j, k, i1, j1)) {
                    this.thePlayer.swingItem();
                }
                if (itemstack2 == null) {
                    return;
                }
                if (itemstack2.stackSize == 0 && !this.playerController.isCreative) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                } else if (itemstack2.stackSize != k1) {
                    this.entityRenderer.itemRenderer.func_891_b();
                }
            }
        }
        if (i == 1 && (this.objectMouseOver == null || this.objectMouseOver != null && this.objectMouseOver.typeOfHit == 0) && (itemstack = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.sendUseItem(this.thePlayer, this.mcWorld, itemstack)) {
            int l = itemstack.stackSize;
            if (this.objectMouseOver != null && this.objectMouseOver.typeOfHit == 0 && itemstack.itemID == Item.compass.shiftedIndex) {
                return;
            }
            ItemStack itemstack1 = itemstack.useItemRightClick(this.mcWorld, this.thePlayer);
            if (this.playerController.isCreative) {
                itemstack1.stackSize = 1;
            }
            if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != l) {
                this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = itemstack1;
                this.entityRenderer.itemRenderer.func_896_c();
                if (itemstack1.stackSize == 0) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                }
            }
        }
    }

    public void toggleFullscreen() {
        try {
            this.isFullscreen = !this.isFullscreen;
            System.out.println("Toggle fullscreen!");
            if (this.isFullscreen) {
                ArrayList<DisplayMode> Resolutions = new ArrayList<DisplayMode>();
                try {
                    DisplayMode[] modes = Display.getAvailableDisplayModes();
                    int i = 0;
                    while (i < modes.length) {
                        DisplayMode current = modes[i];
                        Resolutions.add(current);
                        ++i;
                    }
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
                if (this.options.displayMode == 0) {
                    Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                } else {
                    Display.setDisplayMode((DisplayMode)((DisplayMode)Resolutions.get(this.options.displayMode - 1)));
                }
                this.displayWidth = Display.getDisplayMode().getWidth();
                this.displayHeight = Display.getDisplayMode().getHeight();
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            } else {
                if (this.mcCanvas != null) {
                    this.displayWidth = this.mcCanvas.getWidth();
                    this.displayHeight = this.mcCanvas.getHeight();
                } else {
                    this.displayWidth = this.field_142_Q;
                    this.displayHeight = this.field_141_R;
                }
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
                Display.setDisplayMode((DisplayMode)new DisplayMode(this.field_142_Q, this.field_141_R));
            }
            this.setIngameNotInFocus();
            Display.setFullscreen((boolean)this.isFullscreen);
            Display.update();
            if (this.isFullscreen) {
                this.setIngameFocus();
            }
            if (this.currentScreen != null) {
                this.setIngameNotInFocus();
                this.resize(this.displayWidth, this.displayHeight);
            }
            System.out.println("Size: " + this.displayWidth + ", " + this.displayHeight);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resize(int i, int j) {
        if (i <= 0) {
            i = 1;
        }
        if (j <= 0) {
            j = 1;
        }
        this.displayWidth = i;
        this.displayHeight = j;
        if (this.currentScreen != null) {
            ScaledResolution scaledresolution = new ScaledResolution(i, j, this);
            int k = scaledresolution.getScaledWidth();
            int l = scaledresolution.getScaledHeight();
            this.currentScreen.setResolution(this, k, l);
        }
    }

    private void pickBlock() {
        if (this.objectMouseOver != null) {
            int i = this.mcWorld.getBlockId(this.objectMouseOver.blockX, this.objectMouseOver.blockY, this.objectMouseOver.blockZ);
            if (i == Block.stepDouble.blockID) {
                i = Block.stepSingle.blockID;
            }
            if (i == Block.bedrock.blockID) {
                i = Block.stone.blockID;
            }
            if (i == Block.doorWood.blockID) {
                i = Item.doorWood.shiftedIndex;
            }
            if (i == Block.doorSteel.blockID) {
                i = Item.doorSteel.shiftedIndex;
            }
            if (i == Block.crops.blockID) {
                i = Item.seeds.shiftedIndex;
            }
            if (i == Block.pressurePlateWoodIdle.blockID) {
                i = Item.sign.shiftedIndex;
            }
            if (i == Block.signPost.blockID) {
                i = Item.sign.shiftedIndex;
            }
            if (i == Block.redWire.blockID) {
                i = Item.red_dust.shiftedIndex;
            }
            this.thePlayer.inventory.setCurrentItem(i, 1, this.playerController instanceof PlayerControllerCreative);
        }
    }

    public void runTick() {
        this.ingameGUI.updateTick();
        this.entityRenderer.getMouseOver(1.0f);
        if (this.thePlayer != null) {
            this.thePlayer.func_462_n();
        }
        if (!this.isGamePaused && this.mcWorld != null) {
            this.playerController.updateController();
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain.png"));
        if (!this.isGamePaused) {
            this.renderEngine.updateDynamicTextures();
        }
        if (this.currentScreen == null && this.thePlayer != null && this.thePlayer.health <= 0) {
            this.setCurrentScreen(null);
        }
        if (this.currentScreen != null) {
            this.mouseTicksRan = this.ticksRan + 10000;
        }
        if (this.currentScreen != null) {
            this.currentScreen.handleInput();
            if (this.currentScreen != null) {
                this.currentScreen.updateScreen();
            }
        }
        if (this.currentScreen == null || this.currentScreen.field_948_f) {
            while (Mouse.next()) {
                long l = System.currentTimeMillis() - this.systemTime;
                if (l > 200L) continue;
                int j = Mouse.getEventDWheel();
                if (j != 0) {
                    this.thePlayer.inventory.changeCurrentItem(j);
                }
                if (this.currentScreen == null) {
                    if (!this.inGameHasFocus && Mouse.getEventButtonState()) {
                        this.setIngameFocus();
                        continue;
                    }
                    if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState()) {
                        this.clickMouse(0);
                        this.mouseTicksRan = this.ticksRan;
                    }
                    if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                        this.clickMouse(1);
                        this.mouseTicksRan = this.ticksRan;
                    }
                    if (Mouse.getEventButton() != 2 || !Mouse.getEventButtonState()) continue;
                    this.pickBlock();
                    continue;
                }
                if (this.currentScreen == null) continue;
                this.currentScreen.handleMouseInput();
            }
            if (this.leftClickCounter > 0) {
                --this.leftClickCounter;
            }
            while (Controllers.next()) {
                controller.poll();
                int i = 0;
                while (i < Minecraft.controller.controller.getButtonCount()) {
                    this.thePlayer.handleControllerButton(i, controller.isButtonPressed(i));
                    ++i;
                }
                this.thePlayer.handleControllerStick(controller.getXAxisValue(), controller.getYAxisValue());
                int j = 0;
                if (controller.getPovX() < 0.0f) {
                    j = 1;
                } else if (controller.getPovX() > 0.0f) {
                    j = -1;
                }
                if (j != 0) {
                    this.thePlayer.inventory.changeCurrentItem(j);
                }
                if (this.currentScreen != null || this.inGameHasFocus || Minecraft.controller.pressedButton < 0) continue;
                this.setIngameFocus();
            }
            while (Keyboard.next()) {
                this.thePlayer.handleKeyPress(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.toggleFullscreen();
                    continue;
                }
                if (this.currentScreen != null) {
                    this.currentScreen.handleKeyboardInput();
                } else {
                    if (Keyboard.getEventKey() == 1) {
                        this.displayInGameMenu();
                    }
                    if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                        this.forceReload();
                    }
                    if (Keyboard.getEventKey() == 63) {
                        boolean bl = this.options.thirdPersonView = !this.options.thirdPersonView;
                    }
                    if (Keyboard.getEventKey() == 65) {
                        boolean bl = this.enableRain = !this.enableRain;
                    }
                    if (Keyboard.getEventKey() == 66) {
                        boolean bl = this.options.smoothCamera = !this.options.smoothCamera;
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindBuild.keyCode && this.thePlayer.isCreative) {
                        this.setCurrentScreen(new GuiBuild(this, 0));
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindInventory.keyCode) {
                        this.setCurrentScreen(new GuiInventory(this.thePlayer));
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindDrop.keyCode) {
                        if (this.thePlayer instanceof EntityClientPlayerMP) {
                            EntityClientPlayerMP entmp = (EntityClientPlayerMP)this.thePlayer;
                            entmp.dropCurrentItem();
                        } else {
                            this.thePlayer.dropInventory(this.thePlayer.inventory.decrStackSize(this.thePlayer.inventory.currentItem, 1), false);
                        }
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindChat.keyCode) {
                        this.setCurrentScreen(new GuiChat());
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindSaveLocation.keyCode && this.thePlayer.isCreative) {
                        this.savedPlayerPos = Vec3D.createVectorHelper(this.thePlayer.posX, this.thePlayer.posY, this.thePlayer.posZ);
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindLoadLocation.keyCode && this.thePlayer.isCreative) {
                        this.thePlayer.setPosition(this.savedPlayerPos.xCoord, this.savedPlayerPos.yCoord, this.savedPlayerPos.zCoord);
                    }
                }
                int i = 0;
                while (i < 9) {
                    if (Keyboard.getEventKey() == 2 + i) {
                        this.thePlayer.inventory.currentItem = i;
                    }
                    ++i;
                }
                if (Keyboard.getEventKey() != this.options.keyBindToggleFog.keyCode) continue;
                this.options.setOptionValue(4, !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) ? 1 : -1);
            }
            if (this.currentScreen == null) {
                if (Mouse.isButtonDown((int)0) && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.field_1380_a / 4.0f && this.inGameHasFocus) {
                    this.clickMouse(0);
                    this.mouseTicksRan = this.ticksRan;
                }
                if (Mouse.isButtonDown((int)1) && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.field_1380_a / 4.0f && this.inGameHasFocus) {
                    this.clickMouse(1);
                    this.mouseTicksRan = this.ticksRan;
                }
                if (!Mouse.isButtonDown((int)1) && this.thePlayer != null && this.thePlayer.getUsing()) {
                    System.out.println("STOPPING A CLICK");
                    this.playerController.sendStoppedUsing(this.thePlayer);
                }
            }
            this.func_119_a(0, this.currentScreen == null && Mouse.isButtonDown((int)0) && this.inGameHasFocus);
        }
        if (this.mcWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.mcWorld.joinEntityInSurroundings(this.thePlayer);
                }
            }
            this.mcWorld.difficulty = this.options.difficulty;
            if (this.mcWorld.multiplayerWorld) {
                this.mcWorld.difficulty = this.mcWorld.multiplayerDifficulty;
            } else {
                this.mcWorld.setSaveInterval(this.options.chunkSavingInterval);
            }
            if (!this.isGamePaused) {
                this.entityRenderer.updateRenderer();
            }
            if (!this.isGamePaused) {
                this.renderGlobal.updateClouds();
            }
            if (!this.isGamePaused) {
                this.mcWorld.updateEntityList();
            }
            if (!this.isGamePaused || this.isServer()) {
                this.mcWorld.tick();
            }
            if (!this.isGamePaused && this.mcWorld != null) {
                this.mcWorld.randomDisplayUpdates(MathHelper.floor_double(this.thePlayer.posX), MathHelper.floor_double(this.thePlayer.posY), MathHelper.floor_double(this.thePlayer.posZ));
            }
            if (!this.isGamePaused) {
                this.effectRenderer.updateEffects();
            }
        }
        this.systemTime = System.currentTimeMillis();
    }

    private void forceReload() {
        System.out.println("FORCING RELOAD!");
        this.soundMGR = new SoundManager();
        this.soundMGR.initialize(this.options);
        this.downloadResourcesThread.addRootResource();
    }

    public boolean isServer() {
        return this.mcWorld != null && this.mcWorld.multiplayerWorld;
    }

    public void startWorld(String s, EnumSeason season, EnumWeather weather, boolean cheatsEnabled, int worldType) {
        this.changeWorld1(null);
        System.gc();
        World world = new World(new File(Minecraft.getMinecraftDir(), "NSSSsaves"), s, season, weather, cheatsEnabled, worldType, this);
        this.messages.clear();
        if (world.isNewWorld) {
            world.justLoaded = false;
            this.changeWorld(world, "Generating level");
        } else {
            world.justLoaded = true;
            if (!world.loadedSinceOneOneTwelve) {
                System.out.println("World is out of date!");
                this.setCurrentScreen(new GuiPreSeasonWorld(null, world));
                System.out.println("A");
            } else {
                this.changeWorld(world, "Loading level");
            }
        }
    }

    public void bindClouds() {
        this.renderEngine.bindTextureFXCloud(this.cloudtex);
    }

    public void changeWorld1(World world) {
        this.changeWorld(world, "");
    }

    public void changeWorld(World world, String s) {
        this.soundMGR.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.mcWorld != null) {
            this.mcWorld.saveWorldIndirectly(this.loadScreen);
        }
        this.mcWorld = world;
        if (world != null) {
            this.playerController.func_717_a(world);
            world.field_1038_m = this.fontRender;
            if (!this.isServer()) {
                this.thePlayer = (EntityPlayerSP)world.func_661_a(EntityPlayerSP.class);
            } else if (this.thePlayer != null) {
                this.thePlayer.preparePlayerToSpawn();
                if (world != null) {
                    world.entityJoinedWorld(this.thePlayer);
                }
            }
            if (!world.multiplayerWorld) {
                this.func_120_d(s);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(world);
                this.thePlayer.preparePlayerToSpawn();
                this.playerController.flipPlayer(this.thePlayer);
            }
            this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
            if (this.renderGlobal != null) {
                this.renderGlobal.changeWorld(world);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(world);
            }
            this.playerController.initiateInventory(this.thePlayer);
            world.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (world.isNewWorld) {
                world.saveWorldIndirectly(this.loadScreen);
            }
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
    }

    private void func_120_d(String s) {
        this.loadScreen.func_596_a(s);
        this.loadScreen.func_595_d("Building terrain");
        int questionMark = 128;
        int i = 0;
        int prog = questionMark * 2 / 16 + 1;
        prog *= prog;
        int k = -questionMark;
        while (k <= questionMark) {
            int spawnX = this.mcWorld.spawnX;
            int spawnZ = this.mcWorld.spawnZ;
            if (this.thePlayer != null) {
                spawnX = (int)this.thePlayer.posX;
                spawnZ = (int)this.thePlayer.posZ;
            }
            int j1 = -questionMark;
            while (j1 <= questionMark) {
                this.loadScreen.setProgess(i++ * 100 / prog);
                this.mcWorld.getBlockId(spawnX + k, 64, spawnZ + j1);
                j1 += 16;
            }
            k += 16;
        }
        this.loadScreen.func_595_d("Simulating world for a bit");
        prog = 2000;
        this.mcWorld.func_656_j();
    }

    public void installResource(String s, File file) {
        int i = s.indexOf("/");
        String s1 = s.substring(0, i);
        s = s.substring(i + 1);
        if (s1.equalsIgnoreCase("sound")) {
            this.soundMGR.addToSoundPool(s, file);
        } else if (s1.equalsIgnoreCase("newsound")) {
            this.soundMGR.addToSoundPool(s, file);
        } else if (s1.equalsIgnoreCase("streaming")) {
            this.soundMGR.addToStreamingPool(s, file);
        } else if (s1.equalsIgnoreCase("music")) {
            this.soundMGR.addToMusicPool(s, file);
        } else if (s1.equalsIgnoreCase("newmusic")) {
            this.soundMGR.addToMusicPool(s, file);
        } else if (s1.equalsIgnoreCase("loops")) {
            this.soundMGR.addToLoopsPool(s, file);
        }
    }

    public OpenGlCapsChecker getOpenGlCapsChecker() {
        return this.glCapabilities;
    }

    public String getDebugInfoRenders() {
        return this.renderGlobal.getDebugInfoRenders();
    }

    public String getDebugInfoEntities() {
        return this.renderGlobal.getDebugInfoEntities();
    }

    public String getDebugInfoParticlesAndGfx() {
        return "Particles: " + this.effectRenderer.getStatistics() + (". Gfx: " + GL11.glGetString((int)7937) + " ") + this.mcWorld.loadedEntites();
    }

    public String getDebugInfoGfx() {
        return "Gfx: " + GL11.glGetString((int)7937) + " ";
    }

    public void respawn() {
        this.mcWorld.func_622_a();
        int j = 0;
        if (this.thePlayer != null) {
            j = this.thePlayer.entityId;
            this.mcWorld.setEntityDead(this.thePlayer);
        }
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.mcWorld);
        this.thePlayer.preparePlayerToSpawn();
        this.playerController.flipPlayer(this.thePlayer);
        this.mcWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
        this.thePlayer.entityId = j;
        this.playerController.initiateInventory(this.thePlayer);
        this.func_120_d("Respawning");
        if (this.currentScreen instanceof GuiGameOver) {
            this.setCurrentScreen(null);
        }
    }

    public void respawn(boolean flag, int i) {
        IChunkProvider ichunkprovider;
        System.out.println("RESPAWNING!");
        ChunkCoordinates chunkcoordinates = null;
        ChunkCoordinates chunkcoordinates1 = null;
        boolean flag1 = true;
        if (this.thePlayer != null && !flag && (chunkcoordinates = this.thePlayer.getPlayerSpawnCoordinate()) != null) {
            chunkcoordinates1 = EntityPlayer.func_25060_a(this.mcWorld, chunkcoordinates);
        }
        if (chunkcoordinates1 == null) {
            chunkcoordinates1 = this.mcWorld.getSpawnPoint();
            flag1 = false;
        }
        if ((ichunkprovider = this.mcWorld.chunkProvider) instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(chunkcoordinates1.x >> 4, chunkcoordinates1.z >> 4);
        }
        this.mcWorld.updateEntityList();
        int j = 0;
        if (this.thePlayer != null) {
            j = this.thePlayer.entityId;
            this.mcWorld.setEntityDead(this.thePlayer);
            this.mcWorld.justLoaded = false;
        }
        this.renderViewEntity = null;
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.mcWorld);
        this.renderViewEntity = this.thePlayer;
        this.thePlayer.preparePlayerToSpawn();
        if (flag1) {
            this.thePlayer.setPlayerSpawnCoordinate(chunkcoordinates);
            this.thePlayer.setLocationAndAngles((float)chunkcoordinates1.x + 0.5f, (float)chunkcoordinates1.y + 0.1f, (float)chunkcoordinates1.z + 0.5f, 0.0f, 0.0f);
        }
        this.playerController.flipPlayer(this.thePlayer);
        this.mcWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
        this.thePlayer.entityId = j;
        this.thePlayer.func_6420_o();
        this.playerController.initiateInventory(this.thePlayer);
        this.func_120_d("Respawning");
        if (this.currentScreen instanceof GuiGameOver) {
            this.setCurrentScreen(null);
        }
    }

    public static void start(String username, String uuid, String token) {
        Minecraft.startMainThread(username, token, uuid, null);
    }

    public static void startMainThread(String s, String sessionId, String uuid, String s2) {
        boolean flag = false;
        String username = s;
        Frame frame = new Frame("Minecraft");
        Canvas canvas = new Canvas();
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvas, "Center");
        canvas.setPreferredSize(new Dimension(854, 480));
        frame.pack();
        frame.setLocationRelativeTo(null);
        MinecraftImpl minecraftimpl = new MinecraftImpl(frame, canvas, null, 854, 480, flag, frame);
        Thread thread = new Thread((Runnable)minecraftimpl, "Minecraft main thread");
        thread.setPriority(10);
        minecraftimpl.field_173_l = false;
        minecraftimpl.field_175_j = "www.minecraft.net";
        System.out.println(String.valueOf(username) + " " + sessionId + " " + uuid);
        minecraftimpl.session = username != null && sessionId != null && uuid != null ? new Session(username, sessionId, uuid) : (username != null && sessionId != null ? new Session(username, sessionId) : new Session("Player" + System.currentTimeMillis() % 1000L, "", ""));
        if (s2 != null) {
            String[] as = s2.split(":");
            minecraftimpl.setServer(as[0], Integer.parseInt(as[1]));
        }
        frame.setVisible(true);
        frame.addWindowListener(new GameWindowListener(minecraftimpl, thread));
        thread.start();
    }

    public NetClientHandler getSendQueue() {
        if (this.thePlayer instanceof EntityClientPlayerMP) {
            return ((EntityClientPlayerMP)this.thePlayer).sendQueue;
        }
        return null;
    }

    public static void main(String[] args) {
        String username = args.length > 0 ? args[0] : "Player";
        String uuid = args.length > 1 ? args[1] : "0";
        String token = args.length > 2 ? args[2] : "0";
        Minecraft.start(username, uuid, token);
    }

    public static Minecraft getMinecraft() {
        return theMinecraft;
    }
}

