/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.entity;

import com.mojang.minecraft.client.entity.EntityFX;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.core.level.World;

public class EntityLightningBugFX
extends EntityFX {
    float field_673_a;

    public EntityLightningBugFX(World world, double d, double d1, double d2) {
        this(world, d, d1, d2, 1.0f);
    }

    public EntityLightningBugFX(World world, double d, double d1, double d2, float f) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.motionX *= 0.1;
        this.motionY *= 0.2;
        this.motionZ *= 0.1;
        this.particleBlue = (float)(Math.random() * 0.1);
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleScale *= f;
        this.field_673_a = this.particleScale;
        this.particleMaxAge = 40;
        this.particleMaxAge = (int)((float)this.particleMaxAge * f);
        this.noClip = false;
    }

    public float getEntityBrightness(float f) {
        return 1.0f;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float f6 = ((float)this.particleAge + f) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.field_673_a * f6;
        super.renderParticle(tessellator, f, f1, f2, f3, f4, f5);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setEntityDead();
        }
        this.particleTextureIndex = 0;
        this.particleGreen = (float)((double)this.particleGreen - 0.02);
        this.particleRed = (float)((double)this.particleRed - 0.02);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        if (this.posY == this.prevPosY) {
            this.motionX *= 1.2;
            this.motionZ *= 1.2;
        }
        this.motionX *= (double)0.96f;
        this.motionY *= (double)0.96f;
        this.motionZ *= (double)0.96f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }
}

