/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.entity;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.entity.EntityPickupFX;
import com.mojang.minecraft.client.gui.GuiChest;
import com.mojang.minecraft.client.gui.GuiCrafting;
import com.mojang.minecraft.client.gui.GuiEditSign;
import com.mojang.minecraft.client.gui.GuiFurnace;
import com.mojang.minecraft.client.player.controller.MovementInput;
import com.mojang.minecraft.client.player.controller.PlayerControllerCamera;
import com.mojang.minecraft.client.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.client.sound.AmbientLoopHandler;
import com.mojang.minecraft.client.util.Session;
import com.mojang.minecraft.client.util.SkinManager;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.IInventory;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.core.entity.tile.TileEntitySign;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.nbt.NBTTagCompound;
import com.mojang.minecraft.core.util.MathHelper;

public class EntityPlayerSP
extends EntityPlayer {
    public MovementInput currentInput;
    private Minecraft mc;
    public AmbientLoopHandler loopHandler;
    private int stamina;
    private boolean exhausted;
    private int ambientTicks = 0;

    public EntityPlayerSP(Minecraft minecraft, World world, Session session) {
        super(world);
        this.mc = minecraft;
        this.stamina = this.getMaxStamina();
        this.playerName = session.username;
        this.speeb = 0.0f;
        this.maxSpeeb = 0.2f;
        this.modelRene = false;
        if (session != null && session.username != null && session.username.length() > 0) {
            SkinManager cfr_ignored_0 = this.mc.skins;
            SkinManager.getSkinFromName(this.playerName, this);
        }
        this.loopHandler = new AmbientLoopHandler(world, this);
    }

    public int getMaxStamina() {
        return this.health * 20;
    }

    public boolean getIsExhausted() {
        return this.exhausted;
    }

    public int getStamina() {
        return this.stamina;
    }

    public void setStamina(int stam) {
        this.stamina = stam;
        if (stam == this.getMaxStamina()) {
            this.exhausted = false;
        }
    }

    public Double getExhaustion() {
        return 1.0 - (double)this.stamina / 400.0;
    }

    public void updateEntityActionState() {
        super.updateEntityActionState();
        this.movingLeftRight = this.currentInput.movementLeftRight;
        this.movingForwardBack = this.currentInput.movementForwardBack;
        this.movingUpDown = this.isCamera ? this.currentInput.movementUpDown : 0.0f;
        this.isJumping = this.currentInput.movementIsJumping;
        this.setRunning(this.currentInput.movementIsRunning && !this.exhausted);
        if (this.stamina <= 0) {
            this.exhausted = true;
        }
        if (this.stamina < this.getMaxStamina() && (!this.isRunning() || this.exhausted)) {
            ++this.stamina;
            if (this.stamina >= this.getMaxStamina()) {
                this.exhausted = false;
            }
        }
        if (this.stamina > this.getMaxStamina()) {
            this.stamina = this.getMaxStamina();
        }
    }

    private float getDirection() {
        int yaw1;
        float yaw = this.rotationYaw;
        float moveForward = this.movingForwardBack;
        float moveStrafing = this.movingLeftRight;
        yaw += (float)(moveForward < 0.0f ? 180 : 0);
        int n = moveForward == 0.0f ? 90 : (yaw1 = moveForward < 0.0f ? -45 : 45);
        if (moveStrafing < 0.0f) {
            yaw += (float)yaw1;
        }
        if (moveStrafing > 0.0f) {
            yaw -= (float)yaw1;
        }
        return yaw * ((float)Math.PI / 180);
    }

    public double getSpeed() {
        return Math.sqrt(MathHelper.square(this.motionX) + MathHelper.square(this.motionZ));
    }

    public void setSpeed(double speed) {
        this.motionX = (double)(-MathHelper.sin(this.getDirection())) * speed;
        this.motionZ = (double)MathHelper.cos(this.getDirection()) * speed;
    }

    public void onLivingUpdate() {
        if (this.speeb > this.maxSpeeb) {
            this.speeb = this.maxSpeeb;
        }
        this.currentInput.applyCurrentMovement(this);
        if (this.currentInput.movementIsSneaking && this.ySize < 0.2f) {
            this.ySize = 0.2f;
        }
        if (!(this.exhausted || !this.isRunning() || this.isInWeb || this.currentInput.movementForwardBack == 0.0f && this.currentInput.movementLeftRight == 0.0f || this.worldObj.difficulty >= 3 || this.entityBeingRidden != null || this.handleWaterMovement() || this.handleLavaMovement())) {
            if (this.worldObj.difficulty == 2 && !this.isCreative) {
                this.stamina -= 2;
            }
            this.maxSpeeb = 0.2f;
            this.currentInput.movementForwardBack *= 10.0f;
            this.currentInput.movementLeftRight *= 10.0f;
        } else {
            this.maxSpeeb = 0.15f;
        }
        if (this.isCreative && this.mc.playerController != new PlayerControllerCreative(this.mc) && this.mc.playerController != new PlayerControllerCamera(this.mc)) {
            this.mc.playerController = new PlayerControllerCreative(this.mc);
        }
        if (this.noClip && (this.currentInput.movementForwardBack != 0.0f || this.currentInput.movementLeftRight != 0.0f)) {
            this.maxSpeeb = 0.5f;
            if (this.isRunning()) {
                this.maxSpeeb = 1.0f;
            }
        }
        super.onLivingUpdate();
    }

    public void resetPlayerKeyState() {
        this.currentInput.resetMovement();
    }

    public void handleKeyPress(int i, boolean flag) {
        this.currentInput.getCurrentMovement(i, flag);
    }

    public void handleControllerButton(int i, boolean flag) {
        this.currentInput.getCurrentMovementGamepad(i, flag);
    }

    public void handleControllerStick(float axis, float rotate) {
        this.currentInput.getCurrentMovementJoystick(axis, rotate);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Score", this.score);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.score = nbttagcompound.getInteger("Score");
    }

    public void displayGUIChest(IInventory iinventory) {
        this.mc.setCurrentScreen(new GuiChest(this.inventory, iinventory));
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
        this.mc.setCurrentScreen(new GuiEditSign(tileentitysign));
    }

    public void respawnPlayer() {
        this.mc.respawn(false, 0);
    }

    public void displayWorkbenchGUI(int i, int j, int k) {
        this.mc.setCurrentScreen(new GuiCrafting(this.inventory, this.worldObj, i, j, k));
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
        this.mc.setCurrentScreen(new GuiFurnace(this.inventory, tileentityfurnace));
    }

    public void attackEntity(Entity entity) {
        int i = this.inventory.getDamageVsEntity(entity);
        if (i > 0) {
            entity.attackEntityFrom(this, i);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity);
                if (itemstack.stackSize <= 0) {
                    itemstack.func_1097_a(this);
                    this.destroyCurrentEquippedItem();
                }
            }
        }
    }

    public void onEntityUpdate() {
        super.onEntityUpdate();
        this.loopHandler.update();
    }

    public void onItemPickup(Entity entity, int i) {
        this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.mcWorld, entity, this, -0.5f));
    }

    public int getPlayerArmorValue() {
        return this.inventory.getTotalArmorValue();
    }

    public void useCurrentItemOnEntity(Entity entity) {
        if (entity.interact(this)) {
            return;
        }
        ItemStack itemstack = this.getCurrentEquippedItem();
        if (itemstack != null && entity instanceof EntityLiving) {
            itemstack.useItemOnEntity((EntityLiving)entity);
            if (itemstack.stackSize <= 0) {
                itemstack.func_1097_a(this);
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public void sendChatMessage(String s) {
    }

    public void func_462_n() {
    }

    public boolean getIsSneaking() {
        return this.currentInput.movementIsSneaking;
    }

    public double getRealMoveSpeed() {
        if (this.isRunning()) {
            return 0.75;
        }
        return 0.5;
    }

    public int posXInt() {
        return (int)Math.round(this.posX);
    }

    public int posYInt() {
        return (int)Math.round(this.posY);
    }

    public int posZInt() {
        return (int)Math.round(this.posZ);
    }

    public void setHealth(int i) {
        int j = this.health - i;
        if (j <= 0) {
            this.health = i;
            if (j < 0) {
                this.heartsLife = this.maxHealth / 2;
            }
        } else {
            this.lifeTimer = j;
            this.prevHealth = this.health;
            this.heartsLife = this.maxHealth;
            this.damageEntity(j);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
    }

    public void closeScreen() {
        super.closeScreen();
        this.mc.setCurrentScreen(null);
    }
}

