/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.entity;

import com.mojang.minecraft.client.entity.EntityFX;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.level.World;

public class EntityStarsFX
extends EntityFX {
    float field_673_a;
    EntityPlayer boundPlayer;
    int flipflop = 1;

    public EntityStarsFX(World world, double d, double d1, double d2) {
        this(world, d, d1, d2, 1.0f);
    }

    public EntityStarsFX(World world, double d, double d1, double d2, float f) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.particleGreen = this.particleBlue = (float)(1.0 - Math.random() * 0.1);
        this.particleRed = this.particleBlue;
        this.particleScale *= 0.75f;
        this.particleScale *= f;
        this.field_673_a = this.particleScale;
        this.particleMaxAge = (int)(1.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * f);
        this.noClip = false;
    }

    public EntityStarsFX(World world, EntityPlayer player, float f) {
        super(world, player.posX, player.posY, player.posZ, 0.0, 0.0, 0.0);
        this.boundPlayer = player;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.particleScale *= 0.75f;
        this.particleScale *= f;
        this.field_673_a = this.particleScale;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * f);
        this.noClip = false;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float f6 = ((float)this.particleAge + f) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.field_673_a * f6 * 0.25f;
        super.renderParticle(tessellator, f, f1, f2, f3, f4, f5);
    }

    public void onUpdate() {
        this.flipflop *= -1;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.posX += Math.random() * (double)this.flipflop * 0.75;
        this.posY += Math.random() * (double)this.flipflop * 0.75;
        this.posZ += Math.random() * (double)this.flipflop * 0.75;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setEntityDead();
        }
        this.particleTextureIndex = 0;
    }
}

