/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.entity.model;

import com.mojang.minecraft.client.render.GLAllocation;
import com.mojang.minecraft.client.render.PositionTexureVertex;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.client.render.TexturedQuad;
import org.lwjgl.opengl.GL11;

public class ModelRenderer {
    private PositionTexureVertex[] corners;
    private TexturedQuad[] faces;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean field_1402_i = false;
    public int scalex;
    public int scaley;

    public ModelRenderer(int i, int j, int x, int y) {
        this.textureOffsetX = i;
        this.textureOffsetY = j;
        this.scalex = x;
        this.scaley = y;
    }

    public ModelRenderer(int i, int j) {
        this.textureOffsetX = i;
        this.textureOffsetY = j;
    }

    public void func_921_a(float f, float f1, float f2, int i, int j, int k) {
        this.addBox(f, f1, f2, i, j, k, 0.0f);
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k, float f3) {
        this.corners = new PositionTexureVertex[8];
        this.faces = new TexturedQuad[6];
        float f4 = f + (float)i;
        float f5 = f1 + (float)j;
        float f6 = f2 + (float)k;
        f -= f3;
        f1 -= f3;
        f2 -= f3;
        f4 += f3;
        f5 += f3;
        f6 += f3;
        if (this.mirror) {
            float f7 = f4;
            f4 = f;
            f = f7;
        }
        PositionTexureVertex positiontexurevertex = new PositionTexureVertex(f, f1, f2, 0.0f, 0.0f);
        PositionTexureVertex positiontexurevertex1 = new PositionTexureVertex(f4, f1, f2, 0.0f, 8.0f);
        PositionTexureVertex positiontexurevertex2 = new PositionTexureVertex(f4, f5, f2, 8.0f, 8.0f);
        PositionTexureVertex positiontexurevertex3 = new PositionTexureVertex(f, f5, f2, 8.0f, 0.0f);
        PositionTexureVertex positiontexurevertex4 = new PositionTexureVertex(f, f1, f6, 0.0f, 0.0f);
        PositionTexureVertex positiontexurevertex5 = new PositionTexureVertex(f4, f1, f6, 0.0f, 8.0f);
        PositionTexureVertex positiontexurevertex6 = new PositionTexureVertex(f4, f5, f6, 8.0f, 8.0f);
        PositionTexureVertex positiontexurevertex7 = new PositionTexureVertex(f, f5, f6, 8.0f, 0.0f);
        this.corners[0] = positiontexurevertex;
        this.corners[1] = positiontexurevertex1;
        this.corners[2] = positiontexurevertex2;
        this.corners[3] = positiontexurevertex3;
        this.corners[4] = positiontexurevertex4;
        this.corners[5] = positiontexurevertex5;
        this.corners[6] = positiontexurevertex6;
        this.corners[7] = positiontexurevertex7;
        this.faces[0] = new TexturedQuad(new PositionTexureVertex[]{positiontexurevertex5, positiontexurevertex1, positiontexurevertex2, positiontexurevertex6}, this.textureOffsetX + k + i, this.textureOffsetY + k, this.textureOffsetX + k + i + k, this.textureOffsetY + k + j);
        this.faces[1] = new TexturedQuad(new PositionTexureVertex[]{positiontexurevertex, positiontexurevertex4, positiontexurevertex7, positiontexurevertex3}, this.textureOffsetX + 0, this.textureOffsetY + k, this.textureOffsetX + k, this.textureOffsetY + k + j);
        this.faces[2] = new TexturedQuad(new PositionTexureVertex[]{positiontexurevertex5, positiontexurevertex4, positiontexurevertex, positiontexurevertex1}, this.textureOffsetX + k, this.textureOffsetY + 0, this.textureOffsetX + k + i, this.textureOffsetY + k);
        this.faces[3] = new TexturedQuad(new PositionTexureVertex[]{positiontexurevertex7, positiontexurevertex6, positiontexurevertex2, positiontexurevertex3}, this.textureOffsetX + k + i, this.textureOffsetY + 0, this.textureOffsetX + k + i + i, this.textureOffsetY + k);
        this.faces[4] = new TexturedQuad(new PositionTexureVertex[]{positiontexurevertex1, positiontexurevertex, positiontexurevertex3, positiontexurevertex2}, this.textureOffsetX + k, this.textureOffsetY + k, this.textureOffsetX + k + i, this.textureOffsetY + k + j);
        this.faces[5] = new TexturedQuad(new PositionTexureVertex[]{positiontexurevertex4, positiontexurevertex5, positiontexurevertex6, positiontexurevertex7}, this.textureOffsetX + k + i + k, this.textureOffsetY + k, this.textureOffsetX + k + i + k + i, this.textureOffsetY + k + j);
        if (this.mirror) {
            int l = 0;
            while (l < this.faces.length) {
                this.faces[l].func_809_a();
                ++l;
            }
        }
    }

    public void setRotationPoint(float f, float f1, float f2) {
        this.rotationPointX = f;
        this.rotationPointY = f1;
        this.rotationPointZ = f2;
    }

    public void render(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            GL11.glCallList((int)this.displayList);
            GL11.glTranslatef((float)(-this.rotationPointX * f), (float)(-this.rotationPointY * f), (float)(-this.rotationPointZ * f));
        } else {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void postRender(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        }
    }

    private void compileDisplayList(float f) {
        this.displayList = GLAllocation.generateDisplayLists(1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.instance;
        int i = 0;
        while (i < this.faces.length) {
            this.faces[i].func_808_a(tessellator, f);
            ++i;
        }
        GL11.glEndList();
        this.compiled = true;
    }
}

