/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.entity.render;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.GuiFurnace;
import com.mojang.minecraft.client.render.FontRenderer;
import com.mojang.minecraft.client.render.Render;
import com.mojang.minecraft.client.render.RenderBlocks;
import com.mojang.minecraft.client.render.RenderEngine;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.player.inventory.Slot;
import com.mojang.minecraft.core.util.MathHelper;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class RenderItem
extends Render {
    private RenderBlocks renderBlocks = new RenderBlocks();
    private Random field_200_e = new Random();
    public boolean field_27004_a;

    public RenderItem() {
        this.shadowSize = 0.15f;
        this.field_194_c = 0.75f;
    }

    public void initialize(EntityItem entityitem, double d, double d1, double d2, float f, float f1) {
        this.field_200_e.setSeed(187L);
        ItemStack itemstack = entityitem.item;
        GL11.glPushMatrix();
        float f2 = MathHelper.sin(((float)entityitem.age + f1) / 10.0f + entityitem.field_804_d) * 0.1f + 0.1f;
        float f3 = (((float)entityitem.age + f1) / 20.0f + entityitem.field_804_d) * 57.29578f;
        int byte0 = 1;
        if (entityitem.item.stackSize > 1) {
            byte0 = 2;
        }
        if (entityitem.item.stackSize > 5) {
            byte0 = 3;
        }
        if (entityitem.item.stackSize > 20) {
            byte0 = 4;
        }
        GL11.glTranslatef((float)((float)d), (float)((float)d1 + f2), (float)((float)d2));
        GL11.glEnable((int)32826);
        if (itemstack.itemID == 0) {
            System.out.println("Got a bad item ID!");
            itemstack.itemID = new Random().nextInt(64);
        }
        if (itemstack.itemID < 256 && RenderBlocks.getRenderItemType(Block.allBlocks[itemstack.itemID].getRenderType())) {
            GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
            this.loadTexture("/terrain.png");
            float f4 = 0.25f;
            if (!Block.allBlocks[itemstack.itemID].renderAsNormalBlock() && itemstack.itemID != Block.stepSingle.blockID) {
                f4 = 0.5f;
            }
            GL11.glScalef((float)f4, (float)f4, (float)f4);
            int j = 0;
            while (j < byte0) {
                GL11.glPushMatrix();
                if (j > 0) {
                    float f5 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f7 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    float f9 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.2f / f4;
                    GL11.glTranslatef((float)f5, (float)f7, (float)f9);
                }
                this.renderBlocks.renderThrownItems(Block.allBlocks[itemstack.itemID]);
                GL11.glPopMatrix();
                ++j;
            }
        } else {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            int i = itemstack.getIconIndex();
            if (itemstack.itemID < 256) {
                this.loadTexture("/terrain.png");
            } else {
                this.loadTexture("/gui/items.png");
            }
            Tessellator tessellator = Tessellator.instance;
            float f6 = (float)(i % 16 * 16 + 0) / 256.0f;
            float f8 = (float)(i % 16 * 16 + 16) / 256.0f;
            float f10 = (float)(i / 16 * 16 + 0) / 256.0f;
            float f11 = (float)(i / 16 * 16 + 16) / 256.0f;
            float f12 = 1.0f;
            float f13 = 0.5f;
            float f14 = 0.25f;
            int k = 0;
            while (k < byte0) {
                GL11.glPushMatrix();
                if (k > 0) {
                    float f15 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f16 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float f17 = (this.field_200_e.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)f15, (float)f16, (float)f17);
                }
                GL11.glRotatef((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                tessellator.addVertexWithUV(0.0f - f13, 0.0f - f14, 0.0, f6, f11);
                tessellator.addVertexWithUV(f12 - f13, 0.0f - f14, 0.0, f8, f11);
                tessellator.addVertexWithUV(f12 - f13, 1.0f - f14, 0.0, f8, f10);
                tessellator.addVertexWithUV(0.0f - f13, 1.0f - f14, 0.0, f6, f10);
                tessellator.draw();
                GL11.glPopMatrix();
                ++k;
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public void renderItemBlock(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i, int j) {
        if (itemstack == null) {
            return;
        }
        if (itemstack.itemID == 0) {
            System.out.println("Got a bad item ID!");
            itemstack.itemID = new Random().nextInt(64);
        }
        if (itemstack.itemID < 256 && RenderBlocks.getRenderItemType(Block.allBlocks[itemstack.itemID].getRenderType())) {
            int k = itemstack.itemID;
            renderengine.bindTex(renderengine.getTex("/terrain.png"));
            Block block = Block.allBlocks[k];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(i - 2), (float)(j + 3), (float)0.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)8.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            this.renderBlocks.renderThrownItems(block);
            GL11.glPopMatrix();
        } else if (itemstack.getIconIndex() >= 0) {
            GL11.glDisable((int)2896);
            if (itemstack.itemID < 256) {
                renderengine.bindTex(renderengine.getTex("/terrain.png"));
            } else {
                renderengine.bindTex(renderengine.getTex("/gui/items.png"));
            }
            this.renderTexturedQuad(i, j, itemstack.getIconIndex() % 16 * 16, itemstack.getIconIndex() / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void drawItemIntoGui(FontRenderer fontrenderer, RenderEngine renderengine, int i, int j, int k, int l, int i1) {
        if (i < 256 && RenderBlocks.getRenderItemType(Block.allBlocks[i].getRenderType())) {
            int j1 = i;
            renderengine.bindTex(renderengine.getTex("/terrain.png"));
            Block block = Block.allBlocks[j1];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(l - 2), (float)(i1 + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            int l1 = 0xFFFFFF;
            float f2 = (float)(l1 >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(l1 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(l1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)f2, (float)f4, (float)f5, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlocks.renderThrownItems(block);
            GL11.glPopMatrix();
        } else if (k >= 0) {
            GL11.glDisable((int)2896);
            if (i < 256) {
                renderengine.bindTex(renderengine.getTex("/terrain.png"));
            } else {
                renderengine.bindTex(renderengine.getTex("/gui/items.png"));
            }
            int k1 = 0xFFFFFF;
            float f = (float)(k1 >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(k1 >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(k1 & 0xFF) / 255.0f;
            if (this.field_27004_a) {
                GL11.glColor4f((float)f, (float)f1, (float)f3, (float)1.0f);
            }
            this.renderTexturedQuad(l, i1, k % 16 * 16, k / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
    }

    public void renderItemIntoGUI(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int i, int j) {
        if (itemstack == null) {
            return;
        }
        this.drawItemIntoGui(fontrenderer, renderengine, itemstack.itemID, itemstack.getItemDamage(), itemstack.getIconIndex(), i, j);
    }

    public void renderTextDmg(FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, boolean mouseOver, Slot slot, int x, int y) {
        String s;
        if (itemstack == null) {
            return;
        }
        if (itemstack.stackSize > 1) {
            s = "" + itemstack.stackSize;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s, x + 19 - 2 - fontrenderer.getStringWidth(s), y + 6 + 3, 0xFFFFFF);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.itemID == Item.compass.shiftedIndex) {
            s = "" + Minecraft.getMinecraft().thePlayer.getDistanceFromMeasureOrSpawn();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s, x + 19 - 2 - fontrenderer.getStringWidth(s), y, 0xFFFF00);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (Minecraft.getMinecraft().options.hints) {
            int slotType = 0;
            if (slot != null && slot.inventory instanceof TileEntityFurnace) {
                slotType = slot.slotIndex + 10;
            }
            if (Minecraft.getMinecraft().currentScreen instanceof GuiFurnace && TileEntityFurnace.getCookTime(itemstack) > 0 && (mouseOver || slotType == 11)) {
                String s2 = "";
                int time = TileEntityFurnace.getCookTime(itemstack) / 20 * itemstack.stackSize;
                if (time >= 10000) {
                    s2 = time / 10000 + "K";
                } else {
                    s2 = "" + time / 10;
                    if (time % 10 == 5) {
                        s2 = String.valueOf(s2) + ".5";
                    }
                }
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                fontrenderer.drawStringWithShadow(s2, x + 19 - 2 - fontrenderer.getStringWidth(s2), y, 0xFF8000);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
        }
        if (itemstack.itemDamage > 0) {
            int k = 13 - itemstack.itemDamage * 13 / itemstack.getMaxDmg();
            int l = 255 - itemstack.itemDamage * 255 / itemstack.getMaxDmg();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            Tessellator tessellator = Tessellator.instance;
            int i1 = 255 - l << 16 | l << 8;
            int j1 = (255 - l) / 4 << 16 | 0x3F00;
            this.func_162_a(tessellator, x + 2, y + 13, 13, 2, 0);
            this.func_162_a(tessellator, x + 2, y + 13, 12, 1, j1);
            this.func_162_a(tessellator, x + 2, y + 13, k, 1, i1);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void func_162_a(Tessellator tessellator, int i, int j, int k, int l, int i1) {
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(i1);
        tessellator.addVertex(i + 0, j + 0, 0.0);
        tessellator.addVertex(i + 0, j + l, 0.0);
        tessellator.addVertex(i + k, j + l, 0.0);
        tessellator.addVertex(i + k, j + 0, 0.0);
        tessellator.draw();
    }

    public void renderTexturedQuad(int i, int j, int k, int l, int i1, int j1) {
        float f = 0.0f;
        float f1 = 0.00390625f;
        float f2 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(i + 0, j + j1, f, (float)(k + 0) * f1, (float)(l + j1) * f2);
        tessellator.addVertexWithUV(i + i1, j + j1, f, (float)(k + i1) * f1, (float)(l + j1) * f2);
        tessellator.addVertexWithUV(i + i1, j + 0, f, (float)(k + i1) * f1, (float)(l + 0) * f2);
        tessellator.addVertexWithUV(i + 0, j + 0, f, (float)(k + 0) * f1, (float)(l + 0) * f2);
        tessellator.draw();
    }

    public void doRender(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.initialize((EntityItem)entity, d, d1, d2, f, f1);
    }
}

