/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.entity.render;

import com.mojang.minecraft.client.entity.EntityPlayerSP;
import com.mojang.minecraft.client.entity.model.ModelBiped;
import com.mojang.minecraft.client.entity.model.ModelPlayer;
import com.mojang.minecraft.client.entity.model.ModelPlayerRene;
import com.mojang.minecraft.client.entity.render.RenderLiving;
import com.mojang.minecraft.client.render.FontRenderer;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemArmor;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class RenderPlayer
extends RenderLiving {
    private ModelPlayer modelBipedMain;
    private ModelBiped modelArmorChestplate;
    private ModelBiped modelArmor;
    private ModelPlayerRene modelRene;
    private ModelPlayer modelSteve;
    private static final String[] armorFilenamePrefix = new String[]{"cloth", "chain", "iron", "diamond", "gold", "sponge", "quiver"};

    public RenderPlayer() {
        super(new ModelPlayer(0.0f), 0.5f);
        this.modelBipedMain = (ModelPlayer)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
        this.modelRene = new ModelPlayerRene(0.0f);
        this.modelSteve = new ModelPlayer(0.0f);
        bobbing = true;
    }

    protected boolean setArmorModel(EntityPlayer entityplayer, int i) {
        Item item;
        ItemStack itemstack = entityplayer.inventory.armorItemInSlot(3 - i);
        if (itemstack != null && (item = itemstack.getItem()) instanceof ItemArmor) {
            ItemArmor itemarmor = (ItemArmor)item;
            this.loadTexture("/armor/" + armorFilenamePrefix[itemarmor.armorMaterial] + "_" + (i != 2 ? 1 : 2) + ".png");
            ModelBiped modelbiped = i != 2 ? this.modelArmorChestplate : this.modelArmor;
            modelbiped.bipedHead.showModel = i == 0;
            modelbiped.bipedHeadwear.showModel = i == 0;
            modelbiped.bipedBody.showModel = i == 1 || i == 2;
            modelbiped.bipedRightArm.showModel = i == 1;
            modelbiped.bipedLeftArm.showModel = i == 1;
            modelbiped.bipedRightLeg.showModel = i == 2 || i == 3;
            modelbiped.bipedLeftLeg.showModel = i == 2 || i == 3;
            this.func_169_a(modelbiped);
            return true;
        }
        return false;
    }

    public void func_188_a(EntityPlayer entityplayer, double d, double d1, double d2, float f, float f1) {
        Item item;
        if (entityplayer.modelRene) {
            this.mainModel = this.modelRene;
            this.modelBipedMain = this.modelRene;
        } else {
            this.mainModel = this.modelSteve;
            this.modelBipedMain = this.modelSteve;
        }
        ItemStack stack = entityplayer.inventory.armorItemInSlot(1);
        if (stack != null && (item = stack.getItem()) instanceof ItemArmor) {
            this.modelArmor.field_1243_l = this.modelBipedMain.field_1243_l;
        }
        this.modelBipedMain = entityplayer.modelRene ? this.modelRene : this.modelBipedMain;
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        this.modelBipedMain.field_1278_i = itemstack != null;
        this.modelArmor.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmorChestplate.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmor.bipedIsSneaking = this.modelBipedMain.bipedIsSneaking = entityplayer.getIsSneaking();
        this.modelArmorChestplate.bipedIsSneaking = this.modelBipedMain.bipedIsSneaking;
        ModelBiped.oldWalking = entityplayer.isRunning();
        bobbing = entityplayer.isRunning();
        super.func_171_a(entityplayer, d, d1 - (double)entityplayer.yOffset, d2, f, f1);
        this.modelBipedMain.bipedIsSneaking = false;
        this.modelArmor.bipedIsSneaking = false;
        this.modelArmorChestplate.bipedIsSneaking = false;
        this.modelBipedMain.field_1278_i = false;
        this.modelArmor.field_1278_i = false;
        this.modelArmorChestplate.field_1278_i = false;
        FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
        float f2 = 1.6f;
        float f3 = 0.01666667f * f2;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        float f4 = entityplayer.getDistanceToEntity(this.renderManager.livingPlayer);
        f3 = (float)((double)f3 * (Math.sqrt(f4) / 2.0));
        GL11.glScalef((float)(-f3), (float)(-f3), (float)f3);
        String s = entityplayer.playerName;
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int i = fontrenderer.getStringWidth(s) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-i - 1, -1.0, 0.0);
        tessellator.addVertex(-i - 1, 8.0, 0.0);
        tessellator.addVertex(i + 1, 8.0, 0.0);
        tessellator.addVertex(i + 1, -1.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    protected void renderSpecials(EntityPlayer entityplayer, float f) {
        ItemStack itemstack1;
        if (entityplayer.playerName == "deadmau5" && entityplayer.playerName == "deadmau5") {
            int i = 0;
            while (i < 2) {
                float f2 = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * f - (entityplayer.prevRenderYawOffset + (entityplayer.renderYawOffset - entityplayer.prevRenderYawOffset) * f);
                float f6 = entityplayer.prevRotationPitch + (entityplayer.rotationPitch - entityplayer.prevRotationPitch) * f;
                GL11.glPushMatrix();
                GL11.glRotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)f6, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.375f * (float)(i * 2 - 1)), (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.375f, (float)0.0f);
                GL11.glRotatef((float)(-f6), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(-f2), (float)0.0f, (float)1.0f, (float)0.0f);
                float f7 = 1.333333f;
                GL11.glScalef((float)f7, (float)f7, (float)f7);
                this.modelBipedMain.renderEars(0.0625f);
                GL11.glPopMatrix();
                ++i;
            }
        }
        if (this.loadDownloadableImageTexture(entityplayer.cloakURL, null)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double d = entityplayer.field_20066_r + (entityplayer.field_20063_u - entityplayer.field_20066_r) * (double)f - (entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)f);
            double d1 = entityplayer.field_20065_s + (entityplayer.field_20062_v - entityplayer.field_20065_s) * (double)f - (entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)f);
            double d2 = entityplayer.field_20064_t + (entityplayer.field_20061_w - entityplayer.field_20064_t) * (double)f - (entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)f);
            float f8 = entityplayer.prevRenderYawOffset + (entityplayer.renderYawOffset - entityplayer.prevRenderYawOffset) * f;
            double d3 = MathHelper.sin(f8 * 3.141593f / 180.0f);
            double d4 = -MathHelper.cos(f8 * 3.141593f / 180.0f);
            float f9 = (float)d1 * 10.0f;
            if (f9 < -6.0f) {
                f9 = -6.0f;
            }
            if (f9 > 32.0f) {
                f9 = 32.0f;
            }
            float f10 = (float)(d * d3 + d2 * d4) * 100.0f;
            float f11 = (float)(d * d4 - d2 * d3) * 100.0f;
            if (f10 < 0.0f) {
                f10 = 0.0f;
            }
            float f12 = entityplayer.field_775_e + (entityplayer.field_774_f - entityplayer.field_775_e) * f;
            f9 += MathHelper.sin((entityplayer.prevDistanceWalkedModified + (entityplayer.distanceWalkedModified - entityplayer.prevDistanceWalkedModified) * f) * 6.0f) * 32.0f * f12;
            if (entityplayer.isSneaking()) {
                f9 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + f10 / 2.0f + f9), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f11 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f11 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((itemstack1 = entityplayer.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
            if (entityplayer.fishEntity != null) {
                itemstack1 = new ItemStack(Item.fishingRod, 1);
            }
            if (itemstack1.itemID >= 256) {
                float f1 = this.renderManager.worldObj.getBrightness(MathHelper.floor_double(entityplayer.posX), MathHelper.floor_double(entityplayer.posY), MathHelper.floor_double(entityplayer.posZ));
                if (entityplayer.getEntityBrightness(1.0f) == 1.0f) {
                    f1 = 1.0f;
                }
            }
            if (itemstack1.itemID < 256) {
                float f3 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)(f3 *= 0.75f), (float)(-f3), (float)f3);
            } else if (Item.itemsList[itemstack1.itemID].isFull3D()) {
                float f4 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
                GL11.glScalef((float)f4, (float)(-f4), (float)f4);
                GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                float f5 = 0.375f;
                GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
                GL11.glScalef((float)f5, (float)f5, (float)f5);
                GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.renderManager.itemRenderer.renderItem(entityplayer, itemstack1);
            GL11.glPopMatrix();
        }
    }

    protected void func_186_b(EntityPlayer entityplayer, float f) {
        float f1 = 0.9375f;
        GL11.glScalef((float)f1, (float)f1, (float)f1);
    }

    public void renderArmViewModel(EntityPlayer entityplayer) {
        this.modelBipedMain = entityplayer instanceof EntityPlayerSP && entityplayer.modelRene ? this.modelRene : this.modelSteve;
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.rotateAngleX = 0.0f;
        this.modelBipedMain.bipedRightArm.render(0.0625f);
    }

    protected void func_168_a(EntityLiving entityliving, float f) {
        this.func_186_b((EntityPlayer)entityliving, f);
    }

    protected boolean func_166_a(EntityLiving entityliving, int i) {
        return this.setArmorModel((EntityPlayer)entityliving, i);
    }

    protected void func_174_b(EntityLiving entityliving, float f) {
        this.renderSpecials((EntityPlayer)entityliving, f);
    }

    public void func_171_a(EntityLiving entityliving, double d, double d1, double d2, float f, float f1) {
        this.func_188_a((EntityPlayer)entityliving, d, d1, d2, f, f1);
    }

    public void doRender(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.func_188_a((EntityPlayer)entity, d, d1, d2, f, f1);
    }
}

