/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.entity.tile;

import com.mojang.minecraft.client.entity.tile.TileEntityMobSpawnerRenderer;
import com.mojang.minecraft.client.entity.tile.TileEntitySignRenderer;
import com.mojang.minecraft.client.entity.tile.TileEntitySpecialRenderer;
import com.mojang.minecraft.client.render.FontRenderer;
import com.mojang.minecraft.client.render.RenderEngine;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.tile.TileEntity;
import com.mojang.minecraft.core.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.core.entity.tile.TileEntitySign;
import com.mojang.minecraft.core.level.World;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileEntityRenderer {
    private Map<Class<?>, TileEntitySpecialRenderer> field_1542_m = new HashMap();
    public static TileEntityRenderer instance = new TileEntityRenderer();
    private FontRenderer field_1541_n;
    public static double field_1553_b;
    public static double field_1552_c;
    public static double field_1551_d;
    public RenderEngine field_1550_e;
    public World field_1549_f;
    public EntityPlayer field_1548_g;
    public float field_1547_h;
    public float field_1546_i;
    public double field_1545_j;
    public double field_1544_k;
    public double field_1543_l;

    private TileEntityRenderer() {
        this.field_1542_m.put(TileEntitySign.class, new TileEntitySignRenderer());
        this.field_1542_m.put(TileEntityMobSpawner.class, new TileEntityMobSpawnerRenderer());
        for (TileEntitySpecialRenderer tileentityspecialrenderer : this.field_1542_m.values()) {
            tileentityspecialrenderer.func_928_a(this);
        }
    }

    public TileEntitySpecialRenderer getSpecialRendererForClass(Class<?> class1) {
        TileEntitySpecialRenderer tileentityspecialrenderer = this.field_1542_m.get(class1);
        if (tileentityspecialrenderer == null && class1 != TileEntity.class) {
            tileentityspecialrenderer = this.getSpecialRendererForClass(class1.getSuperclass());
            this.field_1542_m.put(class1, tileentityspecialrenderer);
        }
        return tileentityspecialrenderer;
    }

    public boolean checkIfTileEntity(TileEntity tileentity) {
        if (tileentity == null) {
            return false;
        }
        return this.getSpecialRendererForEntity(tileentity) != null;
    }

    public TileEntitySpecialRenderer getSpecialRendererForEntity(TileEntity tileentity) {
        return this.getSpecialRendererForClass(tileentity.getClass());
    }

    public void cacheActiveRenderInfo(World world, RenderEngine renderengine, FontRenderer fontrenderer, EntityPlayer entityplayer, float f) {
        this.field_1549_f = world;
        this.field_1550_e = renderengine;
        this.field_1548_g = entityplayer;
        this.field_1541_n = fontrenderer;
        this.field_1547_h = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * f;
        this.field_1546_i = entityplayer.prevRotationPitch + (entityplayer.rotationPitch - entityplayer.prevRotationPitch) * f;
        this.field_1545_j = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f;
        this.field_1544_k = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f;
        this.field_1543_l = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f;
    }

    public void renderTileEntity(TileEntity tileentity, float f) {
        if (tileentity.func_480_a(this.field_1545_j, this.field_1544_k, this.field_1543_l) < 4096.0) {
            float f1 = this.field_1549_f.getBrightness(tileentity.x, tileentity.y, tileentity.z);
            GL11.glColor3f((float)f1, (float)f1, (float)f1);
            this.renderTileEntityAt(tileentity, (double)tileentity.x - field_1553_b, (double)tileentity.y - field_1552_c, (double)tileentity.z - field_1551_d, f);
        }
    }

    public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f) {
        TileEntitySpecialRenderer tileentityspecialrenderer = this.getSpecialRendererForEntity(tileentity);
        if (tileentityspecialrenderer != null) {
            tileentityspecialrenderer.renderTileEntityAt(tileentity, d, d1, d2, f);
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_1541_n;
    }
}

