/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.ChatAllowedCharacters;
import com.mojang.minecraft.client.gui.GuiScreen;
import com.mojang.minecraft.client.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.client.player.controller.PlayerControllerSP;
import com.mojang.minecraft.client.render.ScaledResolution;
import com.mojang.minecraft.client.util.SkinManager;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityChicken;
import com.mojang.minecraft.core.entity.EntityCow;
import com.mojang.minecraft.core.entity.EntityCreeper;
import com.mojang.minecraft.core.entity.EntityGiant;
import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.EntityLightningBolt;
import com.mojang.minecraft.core.entity.EntityMob;
import com.mojang.minecraft.core.entity.EntityMobs;
import com.mojang.minecraft.core.entity.EntityPig;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.EntitySheep;
import com.mojang.minecraft.core.entity.EntitySkeleton;
import com.mojang.minecraft.core.entity.EntitySlime;
import com.mojang.minecraft.core.entity.EntitySpider;
import com.mojang.minecraft.core.entity.EntityZombie;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.enums.EnumWeather;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.util.IdMap;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.lwjgl.input.Keyboard;

public class GuiChat
extends GuiScreen {
    static String[] PLAYER_COLORS = new String[]{"c", "b", "a", "5", "6", "e", "d", "7"};
    private String message = "";
    private int updateCounter = 0;
    private int history = 0;
    private String messageInProgress = "";

    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void updateScreen() {
        ++this.updateCounter;
    }

    public void sendText(String s) {
        this.mc.ingameGUI.addChatMessage(s);
    }

    public static String computePlayerColor(String name) {
        byte[] pName = null;
        try {
            pName = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int length = pName.length;
        int oddShift = 1 - length % 2;
        int value = 0;
        int i = 0;
        while (i < length) {
            byte by = pName[i];
            int rev = length - (i + 1) + oddShift;
            value = rev % 4 >= 2 ? (value -= by) : (value += by);
            ++i;
        }
        if ((value %= 8) < 0) {
            value = PLAYER_COLORS.length + value;
        }
        System.out.println(value);
        return PLAYER_COLORS[value];
    }

    protected void keyTyped(char c, int i) {
        String s;
        if (i == 1) {
            this.mc.setCurrentScreen(null);
            return;
        }
        if (c == '\u0016') {
            int j;
            s = GuiScreen.getClipboardString();
            if (s == null) {
                s = "";
            }
            if ((j = 256 - this.message.length()) > s.length()) {
                j = s.length();
            }
            if (j > 0) {
                this.message = String.valueOf(this.message) + s.substring(0, j);
            }
        }
        if (i == 28) {
            s = this.message.trim();
            this.mc.messages.add(this.message);
            this.messageInProgress = "";
            if (s.length() > 0) {
                this.mc.thePlayer.sendChatMessage(s);
            }
            this.mc.setCurrentScreen(null);
            if (!this.mc.isServer()) {
                if (this.message.startsWith("/") && !this.mc.thePlayer.worldObj.cheatsDisabled) {
                    this.handleCommand(this.message.replaceFirst("/", ""));
                } else if (!this.message.startsWith("/")) {
                    this.sendText("<\u00a7" + this.mc.thePlayer.chatColor + this.mc.session.username + "\u00a7f> " + this.message);
                }
            }
            return;
        }
        if (i == 14 && this.message.length() > 0) {
            this.message = this.message.substring(0, this.message.length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0 && this.message.length() < 256) {
            this.message = String.valueOf(this.message) + c;
        }
        if (i == 200 || i == 208) {
            if (i == 200) {
                if (this.history == 0) {
                    this.messageInProgress = this.message;
                }
                ++this.history;
            } else {
                --this.history;
            }
            if (this.history > this.mc.messages.size()) {
                this.history = this.mc.messages.size();
            }
            if (this.history <= 0) {
                this.history = 0;
            }
            this.message = this.history != 0 ? this.mc.messages.get(this.mc.messages.size() - this.history) : this.messageInProgress;
        }
    }

    private Block getBlockIfExist(int id) {
        int i = 0;
        while (i < Block.allBlocks.length) {
            if (Block.allBlocks[i] != null && Block.allBlocks[i].blockID == id) {
                return Block.allBlocks[i];
            }
            ++i;
        }
        return null;
    }

    private Item getItemIfExist(int id) {
        int i = 0;
        while (i < Item.itemsList.length) {
            if (Item.itemsList[i] != null && Item.itemsList[i].shiftedIndex == id) {
                return Item.itemsList[i];
            }
            ++i;
        }
        return null;
    }

    private void handleCommand(String command) {
        String[] commandArgs = command.split(" ");
        if (Minecraft.playtesting) {
            this.sendText("Cheats are disabled for this stage of playtesting.");
            return;
        }
        if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
            block175: {
                if (commandArgs.length <= 3 && commandArgs.length >= 2) {
                    try {
                        int id;
                        block174: {
                            id = 0;
                            try {
                                id = Integer.parseInt(commandArgs[1]);
                            }
                            catch (Exception ex) {
                                id = IdMap.getItem(commandArgs[1]);
                                if (id != -1) break block174;
                                this.sendText("Invalid item: " + commandArgs[1]);
                                if (commandArgs[1].equals("null")) {
                                    this.mc.changeWorld(null, "");
                                }
                                return;
                            }
                        }
                        Block blk = this.getBlockIfExist(id);
                        Item itm = null;
                        int size = 64;
                        if (commandArgs.length == 3) {
                            size = Integer.parseInt(commandArgs[2]);
                        }
                        if (blk == null) {
                            itm = this.getItemIfExist(id);
                            if (itm != null) {
                                if (commandArgs.length < 3) {
                                    size = itm.maxStackSize;
                                }
                                this.sendText("Giving " + size + " of item " + id);
                                EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(itm, size));
                                entityitem.delayBeforeCanPickup = 10;
                                this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                            } else {
                                this.sendText("\u00a7cInvalid item: " + id);
                            }
                            break block175;
                        }
                        this.sendText("Giving " + size + " of item " + id);
                        EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(blk, size));
                        entityitem.delayBeforeCanPickup = 10;
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                    }
                    catch (Exception ex) {
                        this.sendText("\u00a7cInvalid syntax for command: " + command);
                        ex.printStackTrace();
                    }
                } else if (commandArgs.length < 2) {
                    this.sendText("\u00a7cThis requires 2 or more arguments!");
                } else {
                    this.sendText("\u00a7cThis command cannot accept more than 3 arguments!");
                }
            }
            return;
        }
        if (commandArgs.length == 2) {
            if (commandArgs[0].equalsIgnoreCase("setwinter")) {
                try {
                    commandArgs[1] = commandArgs[1].toLowerCase();
                    if (commandArgs[1].equalsIgnoreCase("true") || commandArgs[1].equalsIgnoreCase("false")) {
                        this.mc.thePlayer.worldObj.snowCovered = Boolean.parseBoolean(commandArgs[1]);
                        if (this.mc.thePlayer.worldObj.snowCovered) {
                            this.mc.thePlayer.worldObj.weather = EnumWeather.precipitation;
                            this.mc.thePlayer.worldObj.season = EnumSeason.winter;
                        } else {
                            this.mc.thePlayer.worldObj.weather = EnumWeather.clear;
                            this.mc.thePlayer.worldObj.season = EnumSeason.summer;
                        }
                    } else {
                        this.sendText("\u00a7cYou cannot set winter to " + commandArgs[1] + "!");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("setseason")) {
                try {
                    commandArgs[1] = commandArgs[1].toLowerCase();
                    if (commandArgs[1].equalsIgnoreCase("winter") || commandArgs[1].equalsIgnoreCase("spring") || commandArgs[1].equalsIgnoreCase("summer") || commandArgs[1].equalsIgnoreCase("fall") || commandArgs[1].equalsIgnoreCase("cycle")) {
                        this.mc.thePlayer.worldObj.season = EnumSeason.valueOf(commandArgs[1].toLowerCase());
                    } else {
                        this.sendText("\u00a7cYou cannot set season to " + commandArgs[1] + "!");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("setweather")) {
                try {
                    commandArgs[1] = commandArgs[1].toLowerCase();
                    if (commandArgs[1].equalsIgnoreCase("clear") || commandArgs[1].equalsIgnoreCase("precipitation") || commandArgs[1].equalsIgnoreCase("seasonal")) {
                        this.mc.thePlayer.worldObj.weather = EnumWeather.valueOf(commandArgs[1].toLowerCase());
                    } else {
                        this.sendText("\u00a7cYou cannot set weather to " + commandArgs[1] + "!");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("summon")) {
                Random rand = new Random();
                Entity entitysummon = null;
                if (commandArgs[1].equalsIgnoreCase("slime")) {
                    entitysummon = new EntitySlime(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("mob")) {
                    entitysummon = new EntityMob(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("monster")) {
                    entitysummon = new EntityMobs(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("zombie")) {
                    entitysummon = new EntityZombie(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("creeper")) {
                    entitysummon = new EntityCreeper(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("skeleton")) {
                    entitysummon = new EntitySkeleton(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("sheep")) {
                    entitysummon = new EntitySheep(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("pig")) {
                    entitysummon = new EntityPig(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("cow")) {
                    entitysummon = new EntityCow(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("chicken")) {
                    entitysummon = new EntityChicken(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("giant")) {
                    entitysummon = new EntityGiant(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("spider")) {
                    entitysummon = new EntitySpider(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("player")) {
                    entitysummon = new EntityPlayer(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("lightning")) {
                    entitysummon = new EntityLightningBolt(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY - 2.0, this.mc.thePlayer.posZ);
                }
                if (entitysummon != null) {
                    if (this.mc.objectMouseOver != null && this.mc.thePlayer.worldObj.getBlockId(this.mc.objectMouseOver.blockX, this.mc.objectMouseOver.blockY, this.mc.objectMouseOver.blockZ) == Block.mobSpawner.blockID) {
                        TileEntityMobSpawner tile = (TileEntityMobSpawner)this.mc.thePlayer.worldObj.getBlockTileEntity(this.mc.objectMouseOver.blockX, this.mc.objectMouseOver.blockY, this.mc.objectMouseOver.blockZ);
                        tile.entityID = commandArgs[1];
                    } else {
                        entitysummon.setLocationAndAngles(this.mc.thePlayer.posX, this.mc.thePlayer.posY + 0.5, this.mc.thePlayer.posZ, rand.nextFloat() * 360.0f, 0.0f);
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entitysummon);
                        if (entitysummon instanceof EntityLightningBolt) {
                            this.mc.thePlayer.worldObj.addWeatherEffect(entitysummon);
                        }
                        if (entitysummon instanceof EntityPlayer) {
                            int chance = rand.nextInt(10);
                            switch (chance) {
                                case 0: {
                                    ((EntityPlayer)entitysummon).playerName = "Noptch";
                                    break;
                                }
                                case 1: {
                                    ((EntityPlayer)entitysummon).playerName = "DirtPiper";
                                    break;
                                }
                                case 2: {
                                    ((EntityPlayer)entitysummon).playerName = "Vulpovile";
                                    break;
                                }
                                case 3: {
                                    ((EntityPlayer)entitysummon).playerName = "VivianFox";
                                    break;
                                }
                                case 4: {
                                    ((EntityPlayer)entitysummon).playerName = "deadmau5";
                                    break;
                                }
                                case 5: {
                                    ((EntityPlayer)entitysummon).playerName = "Herobrine";
                                    break;
                                }
                                case 6: {
                                    ((EntityPlayer)entitysummon).playerName = "GenericPnPMonior";
                                    break;
                                }
                                case 7: {
                                    ((EntityPlayer)entitysummon).playerName = "Steve";
                                    break;
                                }
                                case 8: {
                                    ((EntityPlayer)entitysummon).playerName = "Rene";
                                    ((EntityPlayer)entitysummon).modelRene = true;
                                    break;
                                }
                                case 9: {
                                    ((EntityPlayer)entitysummon).playerName = "jom";
                                }
                            }
                            if (!(((EntityPlayer)entitysummon).playerName.equals("Rene") || ((EntityPlayer)entitysummon).playerName.equals("Steve") || ((EntityPlayer)entitysummon).playerName.equals("Herobrine"))) {
                                SkinManager.getSkinFromName(((EntityPlayer)entitysummon).playerName, (EntityPlayer)entitysummon);
                            }
                            ((EntityPlayer)entitysummon).yOffset = 0.0f;
                            this.mc.mcWorld.obtainEntitySkin(entitysummon);
                        }
                    }
                } else {
                    this.sendText("\u00a7cA " + commandArgs[1] + " is not a valid entity!");
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("gamemode")) {
                if (commandArgs[1].equalsIgnoreCase("survival") || commandArgs[1].equalsIgnoreCase("s") || commandArgs[1].equalsIgnoreCase("0")) {
                    this.mc.playerController = new PlayerControllerSP(this.mc);
                    this.mc.thePlayer.isCreative = false;
                    this.mc.thePlayer.isCamera = false;
                    this.sendText("Your game mode has been set to survival.");
                } else if (commandArgs[1].equalsIgnoreCase("creative") || commandArgs[1].equalsIgnoreCase("c") || commandArgs[1].equalsIgnoreCase("1")) {
                    if (Minecraft.playtesting) {
                        this.sendText("Creative mode is not available for this stage of playtesting.");
                    } else {
                        this.mc.playerController = new PlayerControllerCreative(this.mc);
                        this.mc.thePlayer.isCreative = true;
                        this.mc.thePlayer.isCamera = false;
                        this.sendText("Your game mode has been set to creative.");
                    }
                } else {
                    this.sendText("\u00a7c" + commandArgs[1] + " is not a valid game mode!");
                }
                return;
            }
        } else if (commandArgs.length == 3) {
            if (commandArgs[0].equalsIgnoreCase("summon") && commandArgs[1].equalsIgnoreCase("player")) {
                Random rand = new Random();
                EntityPlayer entitysummon = new EntityPlayer(this.mc.thePlayer.worldObj);
                entitysummon.setLocationAndAngles(this.mc.thePlayer.posX, this.mc.thePlayer.posY + 0.5, this.mc.thePlayer.posZ, rand.nextFloat() * 360.0f, 0.0f);
                this.mc.thePlayer.worldObj.entityJoinedWorld(entitysummon);
                entitysummon.playerName = commandArgs[2];
                SkinManager.getSkinFromName(entitysummon.playerName, entitysummon);
                entitysummon.yOffset = 0.0f;
                this.mc.mcWorld.obtainEntitySkin(entitysummon);
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("time")) {
                try {
                    if (commandArgs[1].equalsIgnoreCase("add")) {
                        int ticks = Integer.parseInt(commandArgs[2]);
                        this.mc.thePlayer.worldObj.worldTime += (long)ticks;
                    } else if (commandArgs[1].equalsIgnoreCase("set")) {
                        if (commandArgs[2].equalsIgnoreCase("day")) {
                            this.mc.thePlayer.worldObj.worldTime += 24000L - this.mc.thePlayer.worldObj.worldTime % 24000L;
                        } else if (commandArgs[2].equalsIgnoreCase("night")) {
                            this.mc.thePlayer.worldObj.worldTime += 24000L - this.mc.thePlayer.worldObj.worldTime % 13000L;
                        } else {
                            int ticks = Integer.parseInt(commandArgs[2]);
                            this.mc.thePlayer.worldObj.worldTime = ticks;
                        }
                    } else {
                        this.sendText("\u00a7cInvalid parameter for time command: " + commandArgs[1] + ". Use 'add' or 'set'");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 4) {
            if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
                try {
                    int id = Integer.parseInt(commandArgs[1]);
                    int size = Integer.parseInt(commandArgs[2]);
                    int damage = Integer.parseInt(commandArgs[3]);
                    Block blk = this.getBlockIfExist(id);
                    Item itm = null;
                    if (blk == null) {
                        itm = this.getItemIfExist(id);
                        if (itm != null) {
                            this.sendText("Giving " + size + " of item " + id + " with damage " + damage);
                            EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(itm.shiftedIndex, size, damage));
                            entityitem.delayBeforeCanPickup = 10;
                            this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                        } else {
                            this.sendText("\u00a7cInvalid item: " + id);
                        }
                    } else {
                        this.sendText("Giving " + size + " of item " + id + " with damage " + damage);
                        this.sendText("Damage invalid for block, ignoring");
                        EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(blk, size));
                        entityitem.delayBeforeCanPickup = 10;
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("teleport") || commandArgs[0].equalsIgnoreCase("tp")) {
                try {
                    int x = Integer.parseInt(commandArgs[1]);
                    int y = Integer.parseInt(commandArgs[2]);
                    int z = Integer.parseInt(commandArgs[3]);
                    if (this.mc.thePlayer.worldObj.getBlockId(x, y, z) != 0) {
                        // empty if block
                    }
                    y = this.getHighestBlock(this.mc.thePlayer.worldObj, x, y, z);
                    this.mc.thePlayer.setPosition(x, y, z);
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 5) {
            if (commandArgs[0].equalsIgnoreCase("summon")) {
                Random rand = new Random();
                Entity entitysummon = null;
                int x = Integer.parseInt(commandArgs[2]);
                int y = Integer.parseInt(commandArgs[3]);
                int z = Integer.parseInt(commandArgs[4]);
                if (commandArgs[1].equalsIgnoreCase("slime")) {
                    entitysummon = new EntitySlime(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("mob")) {
                    entitysummon = new EntityMob(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("monster")) {
                    entitysummon = new EntityMobs(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("zombie")) {
                    entitysummon = new EntityZombie(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("creeper")) {
                    entitysummon = new EntityCreeper(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("skeleton")) {
                    entitysummon = new EntitySkeleton(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("sheep")) {
                    entitysummon = new EntitySheep(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("pig")) {
                    entitysummon = new EntityPig(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("cow")) {
                    entitysummon = new EntityCow(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("chicken")) {
                    entitysummon = new EntityChicken(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("giant")) {
                    entitysummon = new EntityGiant(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("spider")) {
                    entitysummon = new EntitySpider(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("player")) {
                    entitysummon = new EntityPlayer(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("lightning")) {
                    entitysummon = new EntityLightningBolt(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY - 2.0, this.mc.thePlayer.posZ);
                }
                if (entitysummon != null) {
                    entitysummon.setLocationAndAngles(x, y, z, rand.nextFloat() * 360.0f, 0.0f);
                    this.mc.thePlayer.worldObj.entityJoinedWorld(entitysummon);
                    if (entitysummon instanceof EntityLightningBolt) {
                        this.mc.thePlayer.worldObj.addWeatherEffect(entitysummon);
                    }
                    if (entitysummon instanceof EntityPlayer) {
                        int chance = rand.nextInt(10);
                        switch (chance) {
                            case 0: {
                                ((EntityPlayer)entitysummon).playerName = "Noptch";
                                break;
                            }
                            case 1: {
                                ((EntityPlayer)entitysummon).playerName = "DirtPiper";
                                break;
                            }
                            case 2: {
                                ((EntityPlayer)entitysummon).playerName = "Vulpovile";
                                break;
                            }
                            case 3: {
                                ((EntityPlayer)entitysummon).playerName = "VivianFox";
                                break;
                            }
                            case 4: {
                                ((EntityPlayer)entitysummon).playerName = "deadmau5";
                                break;
                            }
                            case 5: {
                                ((EntityPlayer)entitysummon).playerName = "Herobrine";
                                break;
                            }
                            case 6: {
                                ((EntityPlayer)entitysummon).playerName = "GenericPnPMonior";
                                break;
                            }
                            case 7: {
                                ((EntityPlayer)entitysummon).playerName = "Steve";
                                break;
                            }
                            case 8: {
                                ((EntityPlayer)entitysummon).playerName = "Rene";
                                ((EntityPlayer)entitysummon).modelRene = true;
                                break;
                            }
                            case 9: {
                                ((EntityPlayer)entitysummon).playerName = "jom";
                            }
                        }
                        if (!(((EntityPlayer)entitysummon).playerName.equals("Rene") || ((EntityPlayer)entitysummon).playerName.equals("Steve") || ((EntityPlayer)entitysummon).playerName.equals("Herobrine"))) {
                            SkinManager.getSkinFromName(((EntityPlayer)entitysummon).playerName, (EntityPlayer)entitysummon);
                        }
                        ((EntityPlayer)entitysummon).yOffset = 0.0f;
                        this.mc.mcWorld.obtainEntitySkin(entitysummon);
                    }
                } else {
                    this.sendText("\u00a7cA " + commandArgs[1] + " is not a valid entity!");
                }
                return;
            }
        } else if (commandArgs.length == 1) {
            if (commandArgs[0].equalsIgnoreCase("spawn")) {
                try {
                    int x = this.mc.thePlayer.worldObj.spawnX;
                    int y = this.mc.thePlayer.worldObj.spawnY;
                    int z = this.mc.thePlayer.worldObj.spawnZ;
                    if (this.mc.thePlayer.worldObj.getBlockId(x, y, z) != 0) {
                        // empty if block
                    }
                    y = this.getHighestBlock(this.mc.thePlayer.worldObj, x, y, z);
                    this.mc.thePlayer.setPosition(x, y, z);
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("help")) {
                this.sendText("\u00a7b---------------Command help (Page 1 of 1)---------------");
                this.sendText("\u00a7e/teleport/tp <x> <y> <z> - teleport to a location");
                this.sendText("\u00a7e/give <item> [quantity] - gives requested item");
                this.sendText("\u00a7e/i <item> [quantity] - alias to give");
                this.sendText("\u00a7e/time <set/add> <ticks> - changes the time");
                this.sendText("\u00a7e/setwinter <true/false> - sets the world's climate");
                this.sendText("\u00a7e/setseason <true/false> - sets the world's season");
                this.sendText("\u00a7e/setweather <clear/precipitation/seasonal> - sets the world's weather");
                this.sendText("\u00a7e/summon <entity> - spawns the requested entity");
                this.sendText("\u00a7e/spawn - sends you to the spawn location");
                this.sendText("\u00a7e/gamemode <survival/creative> - sets your current gamemode");
                this.sendText("\u00a7e/noclip - toggles noclip");
                this.sendText("\u00a7b-----------------------------------------------------");
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("season")) {
                this.sendText("The current season is " + (Object)((Object)this.mc.mcWorld.getCurrentSeason()));
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("time_y")) {
                this.sendText("The current year is " + this.mc.mcWorld.worldTime / (long)(24000 * this.mc.mcWorld.daysInSeason * 4));
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("time_d")) {
                this.sendText("The current day is " + this.mc.mcWorld.worldTime / 24000L);
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("time_t")) {
                this.sendText("The current time is " + this.mc.mcWorld.worldTime);
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("noclip")) {
                this.mc.thePlayer.noClip = !this.mc.thePlayer.noClip;
                this.mc.thePlayer.isFlying = this.mc.thePlayer.isCamera = this.mc.thePlayer.noClip;
                this.sendText("Noclip is now " + (this.mc.thePlayer.noClip ? "on" : "off"));
                return;
            }
        }
        this.sendText("\u00a7cInvalid command: " + command);
    }

    private int getHighestBlock(World world, int x, int y, int z) {
        int i = 128;
        while (i > 0) {
            if (world.getBlockId(x, i, z) != 0) {
                return i + 2;
            }
            --i;
        }
        return 0;
    }

    public void drawScreen(int i, int j, float f) {
        this.drawRect(2, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        ScaledResolution scaledresolution = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight, this.mc);
        int factor = scaledresolution.scaleFactor;
        int scrollwidth = this.width / factor * factor - 14;
        int m = this.fontRenderer.getStringWidth(this.message);
        int scrollamount = 0;
        if (m > scrollwidth + 0) {
            scrollamount = m - scrollwidth;
        }
        this.drawString(this.fontRenderer, (scrollamount <= 0 ? "> " : "  ") + this.message + (this.updateCounter / 6 % 2 != 0 ? " " : "_"), 4 - scrollamount, this.height - 12, 0xE0E0E0);
        super.drawScreen(i, j, f);
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        if (this.scrollAmount < 0) {
            this.scrollAmount = 0;
        }
        if (this.scrollAmount > 512) {
            this.scrollAmount = 512;
        }
    }

    public void sendScroll(int j) {
        if (j > 0) {
            j = 1;
        }
        if (j < 0) {
            j = -1;
        }
        this.scrollAmount += j;
    }

    protected void mouseClicked(int i, int j, int k) {
        System.out.println(this.message);
        if (k != 0 || this.mc.ingameGUI.hoveredPlayer == null) {
            return;
        }
        if (this.message.length() > 0 && !this.message.endsWith(" ")) {
            this.message = String.valueOf(this.message) + " ";
        }
        this.message = String.valueOf(this.message) + this.mc.ingameGUI.hoveredPlayer;
        int byte0 = 256;
        if (this.message.length() > byte0) {
            this.message = this.message.substring(0, byte0);
        }
    }
}

