/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.entity.render.RenderItem;
import com.mojang.minecraft.client.gui.GuiCrafting;
import com.mojang.minecraft.client.gui.GuiFurnace;
import com.mojang.minecraft.client.gui.GuiScreen;
import com.mojang.minecraft.client.render.RenderHelper;
import com.mojang.minecraft.core.crafting.CraftingManager;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.core.player.inventory.Container;
import com.mojang.minecraft.core.player.inventory.ContainerWorkbench;
import com.mojang.minecraft.core.player.inventory.InventoryPlayer;
import com.mojang.minecraft.core.player.inventory.Slot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainer
extends GuiScreen {
    private static RenderItem itemRenderer = new RenderItem();
    public int xSize = 176;
    public int ySize = 166;
    protected Container inventorySlots;
    private boolean mouseOver;

    public GuiContainer(Container container) {
        this.inventorySlots = container;
    }

    public void initGui() {
        super.initGui();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)k, (float)l, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        this.mouseOver = false;
        int i1 = 0;
        while (i1 < this.inventorySlots.slots.size()) {
            Slot slot1 = (Slot)this.inventorySlots.slots.get(i1);
            this.drawSlotInventory(slot1);
            if (this.getIsPosOverSlot(slot1, i, j)) {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                int j1 = slot1.xDisplayPosition;
                int k1 = slot1.yDisplayPosition;
                this.drawRect(j1, k1, j1 + 16, k1 + 16, this.getSlotColor(slot1, this.mc.thePlayer.inventory.itemStack != null, this.mc.thePlayer.inventory.itemStack));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            this.mouseOver = this.getIsPosOverSlot(slot1, i - 16, j);
            ++i1;
        }
        InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
        if (inventoryplayer.itemStack != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, inventoryplayer.itemStack, i - k - 8, j - l - 8);
            itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, inventoryplayer.itemStack, true, this.getSlotAtPosition(i, j), i - k - 8, j - l - 8);
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawGuiContainerForegroundLayer();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    protected void drawGuiContainerForegroundLayer() {
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    private void drawSlotInventory(Slot slot) {
        int k;
        int i = slot.xDisplayPosition;
        int j = slot.yDisplayPosition;
        ItemStack itemstack = slot.getStack();
        if (itemstack == null && (k = slot.getBackgroundIconIndex()) >= 0) {
            GL11.glDisable((int)2896);
            this.mc.renderEngine.bindTex(this.mc.renderEngine.getTex("/gui/items.png"));
            this.drawTexturedModalRect(i, j, k % 16 * 16, k / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
            return;
        }
        itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, itemstack, i, j);
        itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, itemstack, this.mouseOver, slot, i, j);
    }

    private Slot getSlotAtPosition(int i, int j) {
        int k = 0;
        while (k < this.inventorySlots.slots.size()) {
            Slot slot = (Slot)this.inventorySlots.slots.get(k);
            if (this.getIsPosOverSlot(slot, i, j)) {
                return slot;
            }
            ++k;
        }
        return null;
    }

    public boolean getIsPosOverSlot(Slot slot, int i, int j) {
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        return (i -= k) >= slot.xDisplayPosition - 1 && i < slot.xDisplayPosition + 16 + 1 && (j -= l) >= slot.yDisplayPosition - 1 && j < slot.yDisplayPosition + 16 + 1;
    }

    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (k == 0 || k == 1) {
            Slot slot = this.getSlotAtPosition(i, j);
            int l = (this.width - this.xSize) / 2;
            int i1 = (this.height - this.ySize) / 2;
            boolean flag = i < l || j < i1 || i >= l + this.xSize || j >= i1 + this.ySize;
            int j1 = -1;
            if (slot != null) {
                j1 = slot.slotNumber;
            }
            if (flag) {
                j1 = -999;
            }
            if (j1 != -1) {
                boolean shiftMove = j1 != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                this.mc.playerController.onClick(this.inventorySlots.windowId, j1, k, shiftMove, this.mc.thePlayer);
            }
        }
    }

    protected void mouseMovedOrUp(int i, int j, int k) {
        if (k != 0) {
            // empty if block
        }
    }

    protected void keyTyped(char c, int i) {
        if (i == 1 || i == this.mc.options.keyBindInventory.keyCode) {
            this.mc.thePlayer.closeScreen();
        }
    }

    public void onGuiClosed() {
        if (this.mc.thePlayer == null) {
            return;
        }
        this.mc.playerController.func_20086_a(this.inventorySlots.windowId, this.mc.thePlayer);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public int getSlotColor(Slot slot, boolean isHolding, ItemStack held) {
        int color = -2130706433;
        if (slot != null && Minecraft.getMinecraft().options.hints) {
            if (slot.getStack() != null) {
                ItemStack item = slot.getStack();
                if (this instanceof GuiFurnace) {
                    if (TileEntityFurnace.getCookTime(item) > 0) {
                        color = 0x40FF0000;
                    } else if (TileEntityFurnace.getCookResult(item.itemID) != -1) {
                        color = 0x40FFFF00;
                    }
                }
                if (this instanceof GuiCrafting && !isHolding && CraftingManager.getInstance().existsAcceptingRecipe(((ContainerWorkbench)this.inventorySlots).craftMatrix, item)) {
                    color = 0x40FFFF00;
                }
            } else if (this instanceof GuiCrafting && isHolding) {
                int craftSlot = slot.slotNumber;
                if (craftSlot < 1) {
                    return color;
                }
                if (craftSlot > 9) {
                    return color;
                }
                int[] match = CraftingManager.getInstance().findAcceptingRecipe(((ContainerWorkbench)this.inventorySlots).craftMatrix, held, craftSlot);
                if (match[craftSlot - 1] > 0) {
                    return 0x400000FF;
                }
            }
        }
        return color;
    }
}

