/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.GuiButton;
import com.mojang.minecraft.client.render.FontRenderer;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiListBox
extends GuiButton {
    int defheight;
    protected int width = 200;
    protected int height = 20;
    public int xPosition;
    public int yPosition;
    public ArrayList<String> displayString;
    public String defaultString;
    public int index;
    public int id;
    public boolean enabled = true;
    public boolean enabled2 = true;
    public boolean shrink;
    public int scrolledValue = 0;

    public GuiListBox(int i, int j, int k, ArrayList<String> s, int index) {
        this(i, j, k, 200, 20, s, index);
    }

    protected GuiListBox(int i, int j, int k, int l, int i1, ArrayList<String> s, int index) {
        super(i, j, k, l, i1, "Listbox");
        this.id = i;
        this.xPosition = j;
        this.yPosition = k;
        this.width = l;
        this.height = i1;
        this.defheight = i1;
        this.displayString = s;
        this.index = index;
    }

    protected GuiListBox setDefaultString(String s) {
        this.defaultString = s;
        return this;
    }

    @Override
    protected int getHoverState(boolean flag) {
        int byte0 = 1;
        if (!this.enabled) {
            byte0 = 0;
        } else if (flag) {
            byte0 = 2;
        }
        return byte0;
    }

    @Override
    public void drawButton(Minecraft minecraft, int i, int j) {
        boolean flag;
        if (!this.enabled2) {
            return;
        }
        FontRenderer fontrenderer = minecraft.fontRender;
        GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTex("/gui/gui.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean bl = flag = i >= this.xPosition && j >= this.yPosition && i < this.xPosition + this.width && j < this.yPosition + this.height;
        if (this.shrink) {
            flag = false;
            this.shrink = false;
        }
        int k = this.getHoverState(flag);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, 46 + k * 20, this.width / 2, this.defheight);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, 200 - this.width / 2, 46 + k * 20, this.width / 2, this.defheight);
        this.mouseDragged(minecraft, i, j);
        if (!this.enabled) {
            this.height = this.defheight;
            if (this.index != -1) {
                this.drawCenteredString(fontrenderer, this.displayString.get(this.index), this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2, -6250336);
            } else {
                this.drawCenteredString(fontrenderer, this.defaultString, this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2, -6250336);
            }
        } else if (flag) {
            this.height = this.defheight * this.displayString.size();
            if (this.index != -1) {
                this.drawCenteredString(fontrenderer, this.displayString.get(this.index), this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2, 0xFFFFA0);
            } else {
                this.drawCenteredString(fontrenderer, this.defaultString, this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2, 0xFFFFA0);
            }
            int idx = this.scrolledValue;
            while (idx < this.displayString.size()) {
                boolean flag2 = i >= this.xPosition && j >= this.yPosition + (idx - this.scrolledValue) * this.defheight && i < this.xPosition + this.width && j < this.yPosition + this.defheight + (idx - this.scrolledValue) * this.defheight;
                int k2 = this.getHoverState(flag2);
                GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTex("/gui/gui.png"));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(this.xPosition, this.yPosition + (idx - this.scrolledValue) * this.defheight, 0, 46 + k2 * 20, this.width / 2, this.defheight);
                this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition + (idx - this.scrolledValue) * this.defheight, 200 - this.width / 2, 46 + k2 * 20, this.width / 2, this.defheight);
                this.mouseDragged(minecraft, i, j + (idx - this.scrolledValue) * this.defheight);
                if (idx - this.scrolledValue != -1) {
                    this.drawCenteredString(fontrenderer, this.displayString.get(idx), this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2 + this.defheight * (idx - this.scrolledValue), 0xFFFFA0);
                } else {
                    this.drawCenteredString(fontrenderer, this.defaultString, this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2 + this.defheight * (idx - this.scrolledValue), 0xFFFFA0);
                }
                ++idx;
            }
        } else {
            this.height = this.defheight;
            if (this.index != -1) {
                this.drawCenteredString(fontrenderer, this.displayString.get(this.index), this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2, 0xE0E0E0);
            } else {
                this.drawCenteredString(fontrenderer, this.defaultString, this.xPosition + this.width / 2, this.yPosition + (this.defheight - 8) / 2, 0xE0E0E0);
            }
        }
    }

    public int getOption(int i, int j) {
        boolean flag;
        boolean bl = flag = i >= this.xPosition && j >= this.yPosition && i < this.xPosition + this.width && j < this.yPosition + this.height;
        if (flag) {
            int idx = this.scrolledValue;
            while (idx < this.displayString.size()) {
                boolean flag2;
                boolean bl2 = flag2 = i >= this.xPosition && j >= this.yPosition + (idx - this.scrolledValue) * this.defheight && i < this.xPosition + this.width && j < this.yPosition + this.defheight + (idx - this.scrolledValue) * this.defheight;
                if (flag2) {
                    return idx;
                }
                ++idx;
            }
        }
        return -1;
    }

    @Override
    protected void mouseDragged(Minecraft minecraft, int i, int j) {
    }

    @Override
    public void mouseReleased(int i, int j) {
    }

    @Override
    public boolean mousePressed(Minecraft minecraft, int i, int j) {
        return this.enabled && i >= this.xPosition && j >= this.yPosition && i < this.xPosition + this.width && j < this.yPosition + this.height;
    }

    public void shrink() {
        this.shrink = true;
    }
}

