/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.ChatAllowedCharacters;
import com.mojang.minecraft.client.gui.GuiButton;
import com.mojang.minecraft.client.gui.GuiScreen;
import com.mojang.minecraft.client.gui.GuiSelectServer;
import com.mojang.minecraft.core.level.World;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class GuiNameServer
extends GuiScreen {
    int serverid;
    int worldType = 0;
    boolean cheatsEnabled = false;
    private GuiScreen field_968_a;
    private int field_970_h = 0;
    private int field_970_h2 = 0;
    private String serverName = "";
    private String serverIP = "";
    private boolean typingName = true;

    public GuiNameServer(GuiSelectServer guiscreen, int gameid) {
        this.field_968_a = guiscreen;
        this.serverid = gameid;
        File servers = new File(Minecraft.getMinecraftDir(), "NSSSservers/Server" + this.serverid);
        servers.mkdirs();
        System.out.println(servers.getAbsolutePath());
    }

    public void updateScreen() {
        if (this.typingName) {
            ++this.field_970_h;
            this.field_970_h2 = 7;
        } else {
            ++this.field_970_h2;
            this.field_970_h = 7;
        }
    }

    public void initGui() {
        this.controlList.clear();
        GuiButton button = new GuiButton(3, this.width / 2 - 100, this.height / 4 + 90, "Season: Summer");
        button.width = 99;
        GuiButton button2 = new GuiButton(4, this.width / 2 + 2, this.height / 4 + 90, "Commands: " + this.cheatsEnabled);
        button2.width = 99;
        GuiButton button3 = new GuiButton(2, this.width / 2 - 100, this.height / 4 + 90 + 22, "World Type: " + World.TYPENAMES.get(this.worldType));
        button2.width = 99;
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 44, "Create"));
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 44, "Cancel"));
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 4) {
            this.cheatsEnabled = !this.cheatsEnabled;
            guibutton.displayString = "Commands: " + this.cheatsEnabled;
        }
        if (guibutton.id == 3) {
            guibutton.displayString = guibutton.displayString.equalsIgnoreCase("Season: Summer") ? "Season: Winter" : "Season: Summer";
        }
        if (guibutton.id == 5) {
            guibutton.displayString = "BigTree Percentage: ";
        }
        if (guibutton.id == 2) {
            ++this.worldType;
            if (this.worldType > World.TYPENAMES.size() - 1) {
                this.worldType = 0;
            }
            guibutton.displayString = "World Type: " + World.TYPENAMES.get(this.worldType);
        }
        if (guibutton.id == 1) {
            this.mc.setCurrentScreen(this.field_968_a);
        } else if (guibutton.id == 0) {
            String as2;
            String as = this.serverName;
            if (as.trim().length() > 0) {
                File file = Minecraft.getMinecraftDir();
                File f = new File(file, "NSSSservers/Server" + this.serverid + "/name.data");
                try {
                    f.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(f));
                    writer.write(as);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((as2 = this.serverIP).trim().length() > 0) {
                File file = Minecraft.getMinecraftDir();
                File f = new File(file, "NSSSservers/Server" + this.serverid + "/ip.data");
                try {
                    f.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(f));
                    writer.write(as2);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            String[] ipport = as2.split(":");
            ((GuiSelectServer)this.field_968_a).func_584_c(this.serverid, ipport);
        }
    }

    protected void keyTyped(char c, int i) {
        if (c == '\u0016') {
            int j;
            String s = GuiScreen.getClipboardString();
            if (s == null) {
                s = "";
            }
            if ((j = this.typingName ? 32 - this.serverName.length() : 32 - this.serverIP.length()) > s.length()) {
                j = s.length();
            }
            if (j > 0) {
                if (this.typingName) {
                    this.serverName = String.valueOf(this.serverName) + s.substring(0, j);
                } else {
                    this.serverIP = String.valueOf(this.serverIP) + s.substring(0, j);
                }
            }
        }
        if (c == '\r' || c == '\t' || c == '\n') {
            boolean bl = this.typingName = !this.typingName;
        }
        if (this.typingName) {
            if (i == 14 && this.serverName.length() > 0) {
                this.serverName = this.serverName.substring(0, this.serverName.length() - 1);
            }
            if (ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0 && this.serverName.length() < 20) {
                this.serverName = String.valueOf(this.serverName) + c;
            }
        } else {
            if (i == 14 && this.serverIP.length() > 0) {
                this.serverIP = this.serverIP.substring(0, this.serverIP.length() - 1);
            }
            if (ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0 && this.serverName.length() < 20) {
                this.serverIP = String.valueOf(this.serverIP) + c;
            }
        }
    }

    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, "Setup Server", this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, "Enter the name of the server and the IP address to connect to.", this.width / 2 - 140, this.height / 4 - 60 + 60 + 0, 0xA0A0A0);
        this.drawString(this.fontRenderer, "Leaving name empty will set a default name.", this.width / 2 - 140, this.height / 4 - 60 + 60 + 9, 0xA0A0A0);
        this.drawString(this.fontRenderer, "<In Development!>", this.width / 2 - 140, this.height / 4 - 60 + 60 + 36, 0xA0A0A0);
        int k = this.width / 2 - 100;
        int l = this.height / 4 - 10 + 50 + 18;
        int c = 200;
        int byte0 = 20;
        this.drawRect(k - 1, l - 1, k + c + 1, l + byte0 + 1, -6250336);
        this.drawRect(k, l, k + c, l + byte0, -16777216);
        this.drawString(this.fontRenderer, this.serverName + (this.field_970_h / 6 % 2 != 0 ? "" : "_"), k + 4, l + (byte0 - 8) / 2, 0xE0E0E0);
        int k2 = this.width / 2 - 100;
        int l2 = this.height / 4 - 10 + 75 + 18;
        int c2 = 200;
        int byte1 = 20;
        this.drawRect(k2 - 1, l2 - 1, k2 + c2 + 1, l2 + byte1 + 1, -6250336);
        this.drawRect(k2, l2, k2 + c2, l2 + byte1, -16777216);
        this.drawString(this.fontRenderer, this.serverIP + (this.field_970_h2 / 6 % 2 != 0 ? "" : "_"), k2 + 4, l2 + (byte1 - 8) / 2, 0xE0E0E0);
        super.drawScreen(i, j, f);
    }
}

