/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.ChatAllowedCharacters;
import com.mojang.minecraft.client.gui.GuiButton;
import com.mojang.minecraft.client.gui.GuiPreSeasonWorld;
import com.mojang.minecraft.client.gui.GuiScreen;
import com.mojang.minecraft.client.gui.GuiSelectWorld;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.enums.EnumWeather;
import com.mojang.minecraft.core.level.World;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class GuiNameWorld
extends GuiScreen {
    int gameid;
    int worldType = 0;
    boolean cheatsEnabled = false;
    private GuiScreen field_968_a;
    private int field_970_h = 0;
    private String worldName = "";
    EnumWeather wet = EnumWeather.seasonal;
    EnumSeason sea = EnumSeason.cycle;

    public GuiNameWorld(GuiSelectWorld guiscreen, int gameid) {
        this.field_968_a = guiscreen;
        this.gameid = gameid;
    }

    public void updateScreen() {
        ++this.field_970_h;
    }

    public void initGui() {
        this.controlList.clear();
        GuiButton buttonsea = new GuiButton(3, this.width / 2 - 110, this.height / 4 + 72, "Season: " + GuiPreSeasonWorld.getSeasonString(this.sea));
        GuiButton buttonwet = new GuiButton(5, this.width / 2 - 20, this.height / 4 + 72, "Weather: " + GuiPreSeasonWorld.getWeatherString(this.wet));
        buttonsea.width = 89;
        buttonwet.width = 129;
        this.controlList.add(buttonsea);
        this.controlList.add(buttonwet);
        GuiButton button2 = new GuiButton(4, this.width / 2 + 20, this.height / 4 + 48, "Commands: " + this.cheatsEnabled);
        button2.width = 89;
        this.controlList.add(button2);
        GuiButton buttontype = new GuiButton(2, this.width / 2 - 110, this.height / 4 + 48, "World Type: " + World.TYPENAMES.get(this.worldType));
        buttontype.width = 129;
        this.controlList.add(buttontype);
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, "Create"));
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, "Cancel"));
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 4) {
            this.cheatsEnabled = !this.cheatsEnabled;
            guibutton.displayString = "Commands: " + this.cheatsEnabled;
        }
        if (guibutton.id == 3) {
            guibutton.displayString = "Season: " + GuiPreSeasonWorld.getSeasonString(GuiPreSeasonWorld.getNextSeason(this.sea));
            this.sea = GuiPreSeasonWorld.getNextSeason(this.sea);
        }
        if (guibutton.id == 5) {
            guibutton.displayString = "Weather: " + GuiPreSeasonWorld.getWeatherString(GuiPreSeasonWorld.getNextWeather(this.wet));
            this.wet = GuiPreSeasonWorld.getNextWeather(this.wet);
        }
        if (guibutton.id == 2) {
            ++this.worldType;
            if (this.worldType > World.TYPENAMES.size() - 1) {
                this.worldType = 0;
            }
            guibutton.displayString = "World Type: " + World.TYPENAMES.get(this.worldType);
        }
        if (guibutton.id == 1) {
            this.mc.setCurrentScreen(this.field_968_a);
        } else if (guibutton.id == 0) {
            ((GuiSelectWorld)this.field_968_a).createWorldWithSettings(this.gameid, this.sea, this.wet, this.cheatsEnabled, this.worldType);
            String as = this.worldName;
            if (as.trim().length() > 0) {
                File file = Minecraft.getMinecraftDir();
                File f = new File(file, "NSSSsaves/World" + this.gameid + "/name.data");
                try {
                    f.createNewFile();
                    BufferedWriter writer = new BufferedWriter(new FileWriter(f));
                    writer.write(as);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void keyTyped(char c, int i) {
        if (c == '\u0016') {
            int j;
            String s = GuiScreen.getClipboardString();
            if (s == null) {
                s = "";
            }
            if ((j = 32 - this.worldName.length()) > s.length()) {
                j = s.length();
            }
            if (j > 0) {
                this.worldName = String.valueOf(this.worldName) + s.substring(0, j);
            }
        }
        if (c == '\r') {
            this.actionPerformed((GuiButton)this.controlList.get(3));
        }
        if (i == 14 && this.worldName.length() > 0) {
            this.worldName = this.worldName.substring(0, this.worldName.length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0 && this.worldName.length() < 20) {
            this.worldName = String.valueOf(this.worldName) + c;
        }
    }

    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, "Setup World", this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, "Enter the name of your world and set it up the way you want.", this.width / 2 - 140, this.height / 4 - 60 + 40 + 0, 0xA0A0A0);
        this.drawString(this.fontRenderer, "Leaving name empty will set a default name.", this.width / 2 - 140, this.height / 4 - 60 + 40 + 9, 0xA0A0A0);
        this.drawString(this.fontRenderer, "<In Development!>", this.width / 2 - 140, this.height / 4 - 60 + 40 + 27, 0xA0A0A0);
        int k = this.width / 2 - 100;
        int l = this.height / 4 - 10 + 20 + 12;
        int c = 200;
        int byte0 = 20;
        this.drawRect(k - 1, l - 1, k + c + 1, l + byte0 + 1, -6250336);
        this.drawRect(k, l, k + c, l + byte0, -16777216);
        this.drawString(this.fontRenderer, this.worldName + (this.field_970_h / 6 % 2 != 0 ? "" : "_"), k + 4, l + (byte0 - 8) / 2, 0xE0E0E0);
        super.drawScreen(i, j, f);
    }
}

