/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.gui.GuiButton;
import com.mojang.minecraft.client.gui.GuiControls;
import com.mojang.minecraft.client.gui.GuiCredits;
import com.mojang.minecraft.client.gui.GuiExtraVideoSettings;
import com.mojang.minecraft.client.gui.GuiScreen;
import com.mojang.minecraft.client.gui.GuiSlider;
import com.mojang.minecraft.client.gui.GuiSmallButton;
import com.mojang.minecraft.client.gui.GuiTexturePacks;
import com.mojang.minecraft.client.player.controller.GameSettings;
import com.mojang.minecraft.client.render.ScaledResolution;

public class GuiOptions
extends GuiScreen {
    private GuiScreen parentScreen;
    protected String screenTitle = "Options";
    private GameSettings options;

    public GuiOptions(GuiScreen guiscreen, GameSettings gamesettings) {
        this.parentScreen = guiscreen;
        this.options = gamesettings;
    }

    public void initGui() {
        this.controlList.clear();
        int i = 0;
        while (i < this.options.numberOfOptions) {
            int j = this.options.func_1046_b(i);
            if (j == 0) {
                this.controlList.add(new GuiSmallButton(i, this.width / 2 - 155 + i % 2 * 160, this.height / 6 + 24 * (i >> 1), this.options.getOptionValue(i)));
            } else if (i != 4) {
                this.controlList.add(new GuiSlider(i, this.width / 2 - 155 + i % 2 * 160, this.height / 6 + 24 * (i >> 1), i, this.options.getOptionValue(i), this.options.sliderType(i)));
            } else {
                this.controlList.add(new GuiSlider(i, this.width / 2 - 155 + i % 2 * 160, this.height / 6 + 24 * (i >> 1), i, this.options.getOptionValue(i), 1.0f - (this.options.sliderType(i) + 3.0f) / 6.0f));
            }
            ++i;
        }
        this.controlList.add(new GuiButton(100, this.width / 2 - 100, this.height / 6 + 145, 98, 20, "Controls..."));
        this.controlList.add(new GuiButton(300, this.width / 2 + 2, this.height / 6 + 145, 98, 20, "Extra Settings..."));
        this.controlList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168, "Done"));
        if (this.mc.mcWorld != null && this.mc.mcWorld.multiplayerWorld) {
            ((GuiButton)this.controlList.get((int)8)).enabled = false;
        }
        ((GuiButton)this.controlList.get((int)9)).displayString = "Mods & Texture Packs...";
        ((GuiButton)this.controlList.get((int)6)).displayString = this.options.getOptionValue(2003);
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 6) {
            this.options.setOptionValue(2003, 0);
            guibutton.displayString = this.options.getOptionValue(2003);
        }
        if (guibutton.id == 7) {
            this.mc.setCurrentScreen(new GuiCredits(this));
        }
        if (guibutton.id == 9) {
            this.mc.setCurrentScreen(new GuiTexturePacks(this));
        }
        if (guibutton.id < 100 && guibutton.id != 6) {
            if (guibutton.id != 4 && guibutton.id != 7) {
                this.options.setOptionValue(guibutton.id, 1);
            }
            guibutton.displayString = this.options.getOptionValue(guibutton.id);
        }
        if (guibutton.id == 11) {
            this.mc.setIngameNotInFocus();
            ScaledResolution scaledresolution = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight, this.mc);
            int i = scaledresolution.getScaledWidth();
            int j = scaledresolution.getScaledHeight();
            this.setResolution(this.mc, i, j);
            this.mc.skipRenderWorld = false;
        }
        if (guibutton.id == 100) {
            this.mc.setCurrentScreen(new GuiControls(this, this.options));
        }
        if (guibutton.id == 200) {
            this.mc.setCurrentScreen(this.parentScreen);
        }
        if (guibutton.id == 300) {
            this.mc.setCurrentScreen(new GuiExtraVideoSettings(this, this.options));
        }
    }

    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(i, j, f);
    }
}

