/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.gui.GuiButton;
import com.mojang.minecraft.client.gui.GuiScreen;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.enums.EnumWeather;
import com.mojang.minecraft.core.level.World;

public class GuiPreSeasonWorld
extends GuiScreen {
    private GuiScreen prevScreen;
    private int updateCounter;
    EnumWeather wet = EnumWeather.clear;
    EnumSeason sea = EnumSeason.winter;
    World worldObj;

    public GuiPreSeasonWorld(GuiScreen prev, World world) {
        this.prevScreen = prev;
        this.updateCounter = 0;
        this.worldObj = world;
        this.wet = this.worldObj.weather;
        this.sea = this.worldObj.season;
    }

    public void updateScreen() {
        ++this.updateCounter;
    }

    public void initGui() {
        this.controlList.clear();
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120 + 12, "Load World..."));
        this.controlList.add(new GuiButton(1, this.width / 2 - 60, this.height / 4 + 80 + 12, 120, 20, "Season: " + GuiPreSeasonWorld.getSeasonString(this.sea)));
        this.controlList.add(new GuiButton(2, this.width / 2 - 60, this.height / 4 + 60 + 12, 120, 20, "Weather: " + GuiPreSeasonWorld.getWeatherString(this.wet)));
    }

    public static String getWeatherString(EnumWeather weather) {
        switch (weather) {
            case clear: {
                return "Clear";
            }
            case precipitation: {
                return "Precipitating";
            }
            case cycle: {
                return "Cycle";
            }
            case seasonal: {
                return "Seasonal";
            }
        }
        return "Texas";
    }

    public static String getSeasonString(EnumSeason season) {
        switch (season) {
            case winter: {
                return "Winter";
            }
            case spring: {
                return "Spring";
            }
            case summer: {
                return "Summer";
            }
            case fall: {
                return "Fall";
            }
            case cycle: {
                return "Cycle";
            }
        }
        return "Texas";
    }

    public static EnumWeather getNextWeather(EnumWeather weather) {
        switch (weather) {
            case clear: {
                return EnumWeather.precipitation;
            }
            case precipitation: {
                return EnumWeather.seasonal;
            }
            case seasonal: {
                return EnumWeather.clear;
            }
        }
        return EnumWeather.seasonal;
    }

    public static EnumSeason getNextSeason(EnumSeason season) {
        switch (season) {
            case summer: {
                return EnumSeason.winter;
            }
            case winter: {
                return EnumSeason.cycle;
            }
            case cycle: {
                return EnumSeason.summer;
            }
        }
        return EnumSeason.summer;
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 0) {
            this.mc.changeWorld(this.worldObj, "Loading level");
            this.mc.setCurrentScreen(null);
        }
        if (guibutton.id == 1) {
            this.worldObj.season = this.sea = GuiPreSeasonWorld.getNextSeason(this.sea);
            guibutton.displayString = "Season: " + GuiPreSeasonWorld.getSeasonString(this.sea);
        }
        if (guibutton.id == 2) {
            this.worldObj.weather = this.wet = GuiPreSeasonWorld.getNextWeather(this.wet);
            guibutton.displayString = "Weather: " + GuiPreSeasonWorld.getWeatherString(this.wet);
        }
    }

    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, "Old World Save Detected!", this.width / 2, this.height / 4 - 60 + 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, "This world was last saved in a version of Minecraft     ", this.width / 2, this.height / 4 - 60 + 60 + 12, 0xA0A0A0);
        this.drawCenteredString(this.fontRenderer, "which did not support seasons or weather.                ", this.width / 2, this.height / 4 - 60 + 60 + 24, 0xA0A0A0);
        this.drawCenteredString(this.fontRenderer, "If you would like to change the settings for this world, ", this.width / 2, this.height / 4 - 60 + 60 + 36, 0xA0A0A0);
        this.drawCenteredString(this.fontRenderer, "you may do so below, or keep the auto-applied settings.", this.width / 2, this.height / 4 - 60 + 60 + 48, 0xA0A0A0);
        super.drawScreen(i, j, f);
    }
}

