/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.Gui;
import com.mojang.minecraft.client.gui.GuiButton;
import com.mojang.minecraft.client.render.FontRenderer;
import com.mojang.minecraft.client.render.Tessellator;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    protected Minecraft mc;
    public int width;
    public int height;
    protected List<Object> controlList = new ArrayList<Object>();
    public boolean field_948_f = false;
    protected FontRenderer fontRenderer;
    private GuiButton field_946_a = null;
    public int scrollAmount = 0;
    private int roll = 0;

    public void drawScreen(int i, int j, float f) {
        int k = 0;
        while (k < this.controlList.size()) {
            GuiButton guibutton = (GuiButton)this.controlList.get(k);
            guibutton.drawButton(this.mc, i, j);
            ++k;
        }
    }

    public void moveCursorController() {
    }

    protected void keyTyped(char c, int i) {
        if (i == 1) {
            this.mc.setCurrentScreen(null);
            this.mc.setIngameFocus();
        }
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void mouseClicked(int i, int j, int k) {
        if (k == 0) {
            int l = this.controlList.size() - 1;
            while (l >= 0) {
                GuiButton guibutton = (GuiButton)this.controlList.get(l);
                if (guibutton.mousePressed(this.mc, i, j)) {
                    this.field_946_a = guibutton;
                    this.mc.soundMGR.playSoundFX("random.click", 1.0f, 1.0f);
                    this.actionPerformed(guibutton);
                    break;
                }
                --l;
            }
        }
    }

    protected void mouseMovedOrUp(int i, int j, int k) {
        if (this.field_946_a != null && k == 0) {
            this.field_946_a.mouseReleased(i, j);
            this.field_946_a = null;
        }
    }

    protected void actionPerformed(GuiButton guibutton) {
    }

    public void setResolution(Minecraft minecraft, int i, int j) {
        this.mc = minecraft;
        this.fontRenderer = minecraft.fontRender;
        this.width = i;
        this.height = j;
        this.initGui();
    }

    public void initGui() {
    }

    public void handleInput() {
        while (Mouse.next()) {
            this.handleMouseInput();
        }
        while (Keyboard.next()) {
            this.handleKeyboardInput();
        }
    }

    public void handleMouseInput() {
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            this.sendScroll(wheel);
        }
        if (Mouse.getEventButtonState()) {
            int i = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int k = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.mouseClicked(i, k, Mouse.getEventButton());
        } else {
            int j = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int l = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.mouseMovedOrUp(j, l, Mouse.getEventButton());
        }
    }

    public void handleKeyboardInput() {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 87) {
                this.mc.toggleFullscreen();
                return;
            }
            this.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void updateScreen() {
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.func_567_a(0);
    }

    public void func_567_a(int i) {
        if (this.mc.mcWorld != null) {
            this.drawGradientRect(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.func_579_b(i);
        }
    }

    public void func_579_b(int in) {
        double i = (double)in / 2500.0;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/dirt.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (double)this.height / (double)f + i);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (double)this.width / (double)f, (double)this.height / (double)f + i);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (double)this.width / (double)f, i);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, i);
        tessellator.draw();
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void func_568_a(boolean flag, int i) {
    }

    public void selectNextField() {
    }

    public void sendScroll(int j) {
        if (j > 0) {
            j = 1;
        }
        if (j < 0) {
            j = -1;
        }
        this.scrollAmount -= j;
    }
}

