/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.gui;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.gui.GuiConnecting;
import com.mojang.minecraft.client.util.ThreadConnectToServer;

class ThreadDial
extends Thread {
    String ip;
    int port;
    Minecraft minecraft;
    GuiConnecting guiconnecting;
    public boolean cancel = false;

    ThreadDial(GuiConnecting gc, Minecraft mc, String internetProtocol, int toport) {
        this.guiconnecting = gc;
        this.minecraft = mc;
        this.ip = internetProtocol;
        this.port = toport;
    }

    public void interrupt() {
        this.cancel = true;
    }

    public void run() {
        this.minecraft.soundMGR.playSoundFX("dial.line", this.minecraft.options.modemVolume, 1.0f);
        if (this.cancel) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.ip.length()) {
            if (!(this.minecraft.currentScreen instanceof GuiConnecting)) {
                this.cancel = true;
            }
            if (this.cancel) {
                Thread.currentThread().interrupt();
                return;
            }
            String digit = "";
            int digint = this.getMatchingDigit(this.ip.toLowerCase().charAt(i));
            switch (digint) {
                case 0: {
                    digit = "dial.zero";
                    break;
                }
                case 1: {
                    digit = "dial.one";
                    break;
                }
                case 2: {
                    digit = "dial.two";
                    break;
                }
                case 3: {
                    digit = "dial.three";
                    break;
                }
                case 4: {
                    digit = "dial.four";
                    break;
                }
                case 5: {
                    digit = "dial.five";
                    break;
                }
                case 6: {
                    digit = "dial.six";
                    break;
                }
                case 7: {
                    digit = "dial.seven";
                    break;
                }
                case 8: {
                    digit = "dial.eight";
                    break;
                }
                case 9: {
                    digit = "dial.nine";
                    break;
                }
                case -1: {
                    digit = "";
                    break;
                }
                default: {
                    digit = "";
                }
            }
            if (!digit.equals("")) {
                this.minecraft.soundMGR.playSoundFX(digit, this.minecraft.options.modemVolume * 0.5f, 1.0f);
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (this.cancel) {
            return;
        }
        this.minecraft.soundMGR.playSoundFXLOUD("dial.handshake", this.minecraft.options.modemVolume * 2.0f, 1.0f);
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new ThreadConnectToServer(this.guiconnecting, this.minecraft, this.ip, this.port).start();
    }

    public int getMatchingDigit(char c) {
        String[] digits = new String[]{"0", "1", "2abc", "3def", "4ghi", "5jkl", "6mno", "7pqrs", "8tuv", "9wxyz"};
        int i = 0;
        while (i < digits.length) {
            if (digits[i].contains("" + c)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

