/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.level.tile.fx;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.level.tile.fx.TextureFX;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.util.MathHelper;
import javax.imageio.ImageIO;

public class TextureLeavesFX
extends TextureFX {
    private int[] leaves = new int[1024];
    private int[] branches = new int[1024];
    private int[] buds = new int[8192];
    private Minecraft minec;
    private int alternate;
    private int tickCounter;

    public TextureLeavesFX(int n, Minecraft mc) {
        super(105 + n);
        this.minec = mc;
        this.alternate = (n << 1) - 1;
        this.tickCounter = 2;
        try {
            ImageIO.read(Minecraft.class.getResource("/leaves.png")).getRGB(0 + n * 16, 0, 16, 16, this.leaves, 0, 16);
            ImageIO.read(Minecraft.class.getResource("/branches.png")).getRGB(0 + n * 16, 0, 16, 16, this.branches, 0, 16);
            ImageIO.read(Minecraft.class.getResource("/buds.png")).getRGB(0 + n * 16, 0, 16, 128, this.buds, 0, 16);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final void render() {
        this.tickCounter = 1 + this.alternate & 0x3F;
        float a = MathHelper.sin((float)this.tickCounter / 64.0f * (float)Math.PI * 2.0f);
        float b = MathHelper.cos((float)this.tickCounter / 64.0f * (float)Math.PI * 2.0f);
        int u = 0;
        while (u < 16) {
            int v = 0;
            while (v < 16) {
                float n = ((float)u / 15.0f - 0.5f) * 31.0f;
                float n2 = ((float)v / 15.0f - 0.5f) * 31.0f;
                float n3 = b * n - a * n2;
                n = b * n2 + a * n;
                int n4 = (int)(n3 + 16.0f);
                int n5 = (int)(n + 16.0f);
                int n6 = 0;
                n5 = this.leaves[u + (v << 4)];
                if (n5 >>> 24 > 128) {
                    n6 = n5;
                    if (this.minec.mcWorld != null) {
                        if (this.minec.mcWorld.getCurrentSeason() == EnumSeason.winter && (n5 = this.buds[u + (v << 4)]) >>> 24 > -1) {
                            n6 = n5;
                        }
                        if (this.minec.mcWorld.getCurrentSeason() == EnumSeason.spring && (n5 = this.buds[u + (v + 16 * (int)Math.floor(this.minec.mcWorld.getSeasonProgress() * 8.0f) << 4)]) >>> 24 > -1) {
                            n6 = n5;
                        }
                        if (this.minec.mcWorld.getCurrentSeason() == EnumSeason.summer && (n5 = this.buds[u + (v + 112 << 4)]) >>> 24 > -1) {
                            n6 = n5;
                        }
                        if (this.minec.mcWorld.getCurrentSeason() == EnumSeason.fall && (n5 = this.leaves[u + (v << 4)]) >>> 24 > -1) {
                            n6 = n5;
                        }
                    }
                }
                n5 = n6 >> 16 & 0xFF;
                n4 = n6 >> 8 & 0xFF;
                int n7 = n6 & 0xFF;
                n6 = n6 >>> 24 > 128 ? 255 : 0;
                int n8 = u + (v << 4);
                this.bitMap[n8 << 2] = (byte)n5;
                this.bitMap[(n8 << 2) + 1] = (byte)n4;
                this.bitMap[(n8 << 2) + 2] = (byte)n7;
                this.bitMap[(n8 << 2) + 3] = (byte)n6;
                ++v;
            }
            ++u;
        }
    }

    public void render_() {
        int pixelIndex = 0;
        while (pixelIndex < 256) {
            int alpha;
            int colorPix = this.leaves[pixelIndex];
            int red = colorPix >> 16 & 0xFF;
            int green = colorPix >> 8 & 0xFF;
            int blue = colorPix & 0xFF;
            int n = alpha = pixelIndex % 2 == 0 ? 0 : 128;
            if (!this.field_1131_c) {
                int r2 = (red * 30 + green * 59 + blue * 11) / 100;
                int g2 = (red * 30 + green * 70) / 100;
                int b2 = (red * 30 + blue * 70) / 100;
                red = r2;
                green = g2;
                blue = b2;
            }
            this.bitMap[pixelIndex * 4 + 0] = (byte)red;
            this.bitMap[pixelIndex * 4 + 1] = (byte)green;
            this.bitMap[pixelIndex * 4 + 2] = (byte)blue;
            this.bitMap[pixelIndex * 4 + 3] = (byte)alpha;
            ++pixelIndex;
        }
    }
}

