/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.mods;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.mods.TexturePackBase;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class TexturePackDefault
extends TexturePackBase {
    private int texturePackName = -1;
    private BufferedImage texturePackThumbnail;

    public TexturePackDefault() {
        this.texturePackFileName = "Default";
        this.firstDescriptionLine = "The default look of Minecraft";
        try {
            this.texturePackThumbnail = ImageIO.read(TexturePackDefault.class.getResource("/pack.png"));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public void func_6484_b(Minecraft minecraft) {
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.deleteTexture(this.texturePackName);
        }
    }

    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.texturePackThumbnail != null && this.texturePackName < 0) {
            this.texturePackName = minecraft.renderEngine.allocateAndSetupTexture(this.texturePackThumbnail);
        }
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.bindTex(this.texturePackName);
        } else {
            GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTex("/gui/unknown_pack.png"));
        }
    }
}

