/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.network.packet;

import com.mojang.minecraft.client.network.NetHandler;
import com.mojang.minecraft.client.network.packet.Packet0KeepAlive;
import com.mojang.minecraft.client.network.packet.Packet100OpenWindow;
import com.mojang.minecraft.client.network.packet.Packet101CloseWindow;
import com.mojang.minecraft.client.network.packet.Packet102WindowClick;
import com.mojang.minecraft.client.network.packet.Packet103SetSlot;
import com.mojang.minecraft.client.network.packet.Packet104WindowItems;
import com.mojang.minecraft.client.network.packet.Packet105UpdateProgressbar;
import com.mojang.minecraft.client.network.packet.Packet106Transaction;
import com.mojang.minecraft.client.network.packet.Packet10Flying;
import com.mojang.minecraft.client.network.packet.Packet11PlayerPosition;
import com.mojang.minecraft.client.network.packet.Packet12PlayerLook;
import com.mojang.minecraft.client.network.packet.Packet130UpdateSign;
import com.mojang.minecraft.client.network.packet.Packet131MapData;
import com.mojang.minecraft.client.network.packet.Packet13PlayerLookMove;
import com.mojang.minecraft.client.network.packet.Packet14BlockDig;
import com.mojang.minecraft.client.network.packet.Packet15Place;
import com.mojang.minecraft.client.network.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.client.network.packet.Packet17Sleep;
import com.mojang.minecraft.client.network.packet.Packet18Animation;
import com.mojang.minecraft.client.network.packet.Packet19EntityAction;
import com.mojang.minecraft.client.network.packet.Packet1Login;
import com.mojang.minecraft.client.network.packet.Packet200Statistic;
import com.mojang.minecraft.client.network.packet.Packet20NamedEntitySpawn;
import com.mojang.minecraft.client.network.packet.Packet21PickupSpawn;
import com.mojang.minecraft.client.network.packet.Packet22Collect;
import com.mojang.minecraft.client.network.packet.Packet23VehicleSpawn;
import com.mojang.minecraft.client.network.packet.Packet24MobSpawn;
import com.mojang.minecraft.client.network.packet.Packet255KickDisconnect;
import com.mojang.minecraft.client.network.packet.Packet25EntityPainting;
import com.mojang.minecraft.client.network.packet.Packet27Position;
import com.mojang.minecraft.client.network.packet.Packet28EntityVelocity;
import com.mojang.minecraft.client.network.packet.Packet29DestroyEntity;
import com.mojang.minecraft.client.network.packet.Packet2Handshake;
import com.mojang.minecraft.client.network.packet.Packet30Entity;
import com.mojang.minecraft.client.network.packet.Packet31RelEntityMove;
import com.mojang.minecraft.client.network.packet.Packet32EntityLook;
import com.mojang.minecraft.client.network.packet.Packet33RelEntityMoveLook;
import com.mojang.minecraft.client.network.packet.Packet34EntityTeleport;
import com.mojang.minecraft.client.network.packet.Packet38EntityStatus;
import com.mojang.minecraft.client.network.packet.Packet39AttachEntity;
import com.mojang.minecraft.client.network.packet.Packet3Chat;
import com.mojang.minecraft.client.network.packet.Packet40EntityMetadata;
import com.mojang.minecraft.client.network.packet.Packet4UpdateTime;
import com.mojang.minecraft.client.network.packet.Packet50PreChunk;
import com.mojang.minecraft.client.network.packet.Packet51MapChunk;
import com.mojang.minecraft.client.network.packet.Packet52MultiBlockChange;
import com.mojang.minecraft.client.network.packet.Packet53BlockChange;
import com.mojang.minecraft.client.network.packet.Packet54PlayNoteBlock;
import com.mojang.minecraft.client.network.packet.Packet5PlayerInventory;
import com.mojang.minecraft.client.network.packet.Packet60Explosion;
import com.mojang.minecraft.client.network.packet.Packet61DoorChange;
import com.mojang.minecraft.client.network.packet.Packet62CompassPosition;
import com.mojang.minecraft.client.network.packet.Packet69PlayerScore;
import com.mojang.minecraft.client.network.packet.Packet6SpawnPosition;
import com.mojang.minecraft.client.network.packet.Packet70Bed;
import com.mojang.minecraft.client.network.packet.Packet71Weather;
import com.mojang.minecraft.client.network.packet.Packet7UseEntity;
import com.mojang.minecraft.client.network.packet.Packet8UpdateHealth;
import com.mojang.minecraft.client.network.packet.Packet9Respawn;
import com.mojang.minecraft.client.network.packet.PacketCounter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Packet {
    private static Map packetIdToClassMap = new HashMap();
    private static Map packetClassToIdMap = new HashMap();
    private static Set clientPacketIdList = new HashSet();
    private static Set serverPacketIdList = new HashSet();
    public final long creationTimeMillis = System.currentTimeMillis();
    public boolean isChunkDataPacket = false;
    private static HashMap packetStats = new HashMap();
    private static int totalPacketsCount = 0;

    static {
        Packet.addIdClassMapping(0, true, true, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, true, true, Packet1Login.class);
        Packet.addIdClassMapping(2, true, true, Packet2Handshake.class);
        Packet.addIdClassMapping(3, true, true, Packet3Chat.class);
        Packet.addIdClassMapping(4, true, false, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, true, false, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, true, false, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(7, false, true, Packet7UseEntity.class);
        Packet.addIdClassMapping(8, true, false, Packet8UpdateHealth.class);
        Packet.addIdClassMapping(9, true, true, Packet9Respawn.class);
        Packet.addIdClassMapping(10, true, true, Packet10Flying.class);
        Packet.addIdClassMapping(11, true, true, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, true, true, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, true, true, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, false, true, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, false, true, Packet15Place.class);
        Packet.addIdClassMapping(16, true, true, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(17, true, false, Packet17Sleep.class);
        Packet.addIdClassMapping(18, true, true, Packet18Animation.class);
        Packet.addIdClassMapping(19, false, true, Packet19EntityAction.class);
        Packet.addIdClassMapping(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, true, false, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, true, false, Packet22Collect.class);
        Packet.addIdClassMapping(23, true, false, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, true, false, Packet24MobSpawn.class);
        Packet.addIdClassMapping(25, true, false, Packet25EntityPainting.class);
        Packet.addIdClassMapping(27, false, true, Packet27Position.class);
        Packet.addIdClassMapping(28, true, false, Packet28EntityVelocity.class);
        Packet.addIdClassMapping(29, true, false, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, true, false, Packet30Entity.class);
        Packet.addIdClassMapping(31, true, false, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, true, false, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, true, false, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(38, true, false, Packet38EntityStatus.class);
        Packet.addIdClassMapping(39, true, false, Packet39AttachEntity.class);
        Packet.addIdClassMapping(40, true, false, Packet40EntityMetadata.class);
        Packet.addIdClassMapping(50, true, false, Packet50PreChunk.class);
        Packet.addIdClassMapping(51, true, false, Packet51MapChunk.class);
        Packet.addIdClassMapping(52, true, false, Packet52MultiBlockChange.class);
        Packet.addIdClassMapping(53, true, false, Packet53BlockChange.class);
        Packet.addIdClassMapping(54, true, false, Packet54PlayNoteBlock.class);
        Packet.addIdClassMapping(60, true, false, Packet60Explosion.class);
        Packet.addIdClassMapping(61, true, false, Packet61DoorChange.class);
        Packet.addIdClassMapping(62, true, false, Packet62CompassPosition.class);
        Packet.addIdClassMapping(69, true, true, Packet69PlayerScore.class);
        Packet.addIdClassMapping(70, true, false, Packet70Bed.class);
        Packet.addIdClassMapping(71, true, false, Packet71Weather.class);
        Packet.addIdClassMapping(100, true, false, Packet100OpenWindow.class);
        Packet.addIdClassMapping(101, true, true, Packet101CloseWindow.class);
        Packet.addIdClassMapping(102, false, true, Packet102WindowClick.class);
        Packet.addIdClassMapping(103, true, false, Packet103SetSlot.class);
        Packet.addIdClassMapping(104, true, false, Packet104WindowItems.class);
        Packet.addIdClassMapping(105, true, false, Packet105UpdateProgressbar.class);
        Packet.addIdClassMapping(106, true, true, Packet106Transaction.class);
        Packet.addIdClassMapping(130, true, true, Packet130UpdateSign.class);
        Packet.addIdClassMapping(131, true, false, Packet131MapData.class);
        Packet.addIdClassMapping(200, true, false, Packet200Statistic.class);
        Packet.addIdClassMapping(255, true, true, Packet255KickDisconnect.class);
    }

    static void addIdClassMapping(int i, boolean flag, boolean flag1, Class class1) {
        if (packetIdToClassMap.containsKey(i)) {
            throw new IllegalArgumentException("Duplicate packet id:" + i);
        }
        if (packetClassToIdMap.containsKey(class1)) {
            throw new IllegalArgumentException("Duplicate packet class:" + class1);
        }
        packetIdToClassMap.put(i, class1);
        packetClassToIdMap.put(class1, i);
        if (flag) {
            clientPacketIdList.add(i);
        }
        if (flag1) {
            serverPacketIdList.add(i);
        }
    }

    public static Packet getNewPacket(int i) {
        Class class1;
        block3: {
            try {
                class1 = (Class)packetIdToClassMap.get(i);
                if (class1 != null) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Skipping packet with id " + i);
                return null;
            }
        }
        return (Packet)class1.newInstance();
    }

    public final int getPacketId() {
        return (Integer)packetClassToIdMap.get(this.getClass());
    }

    public static Packet readPacket(DataInputStream datainputstream, boolean flag) throws IOException {
        Packet packet;
        int i;
        block7: {
            i = 0;
            packet = null;
            try {
                i = datainputstream.read();
                if (i != -1) break block7;
                return null;
            }
            catch (EOFException eofexception) {
                System.out.println("Reached end of stream");
                return null;
            }
        }
        if (flag && !serverPacketIdList.contains(i) || !flag && !clientPacketIdList.contains(i)) {
            System.out.println(datainputstream.read());
            System.out.println(datainputstream.read());
            System.out.println(datainputstream.read());
            System.out.println(datainputstream.read());
            throw new IOException("Bad packet id " + i);
        }
        packet = Packet.getNewPacket(i);
        if (packet == null) {
            throw new IOException("Bad packet id " + i);
        }
        packet.readPacketData(datainputstream);
        PacketCounter packetcounter = (PacketCounter)packetStats.get(i);
        if (packetcounter == null) {
            packetcounter = new PacketCounter(null);
            packetStats.put(i, packetcounter);
        }
        packetcounter.addPacket(packet.getPacketSize());
        if (++totalPacketsCount % 1000 != 0) {
            // empty if block
        }
        return packet;
    }

    public static void writePacket(Packet packet, DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.write(packet.getPacketId());
        packet.writePacketData(dataoutputstream);
    }

    public static void writeString(String s, DataOutputStream dataoutputstream) throws IOException {
        if (s.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dataoutputstream.writeShort(s.length());
        dataoutputstream.writeChars(s);
    }

    public static String readString(DataInputStream datainputstream, int i) throws IOException {
        int word0 = datainputstream.readShort();
        StringBuilder stringbuilder1 = new StringBuilder();
        if (word0 > i) {
            throw new IOException("Received string length longer than maximum allowed (" + word0 + " > " + i + ")");
        }
        if (word0 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringbuilder = new StringBuilder();
        int j = 0;
        while (j < word0) {
            stringbuilder.append(datainputstream.readChar());
            ++j;
        }
        return stringbuilder.toString();
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public abstract void writePacketData(DataOutputStream var1) throws IOException;

    public abstract void processPacket(NetHandler var1);

    public abstract int getPacketSize();

    static Class _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }
}

