/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.player.controller;

import org.lwjgl.input.Controller;

public class ControllerHelper {
    public int buttonCount = 0;
    public boolean[] buttons;
    public boolean[] lastState;
    public int pressedButton = -1;
    public Controller controller;

    public ControllerHelper() {
        this.controller = null;
        this.buttonCount = 0;
        this.lastState = new boolean[this.buttonCount];
        this.buttons = new boolean[this.buttonCount];
    }

    public ControllerHelper(Controller con) {
        this.controller = con;
        this.buttonCount = this.controller.getButtonCount();
        this.lastState = new boolean[this.buttonCount];
        this.buttons = new boolean[this.buttonCount];
    }

    public void poll() {
        this.controller.poll();
        this.pressedButton = -1;
        int i = 0;
        while (i < this.buttonCount) {
            this.lastState[i] = this.buttons[i];
            this.buttons[i] = this.controller.isButtonPressed(i);
            if (this.lastState[i] != this.buttons[i]) {
                this.pressedButton = i;
            }
            ++i;
        }
    }

    public String getName() {
        return this.controller.getName();
    }

    public boolean isButtonJustPressed(int i) {
        return i == this.pressedButton && this.buttons[i];
    }

    public boolean isButtonJustUnpressed(int i) {
        return i == this.pressedButton && this.lastState[i];
    }

    public boolean isButtonPressed(int i) {
        if (i > this.buttonCount) {
            return false;
        }
        return this.buttons[i];
    }

    public float getXAxisValue() {
        return this.controller.getXAxisValue();
    }

    public float getRXAxisValue() {
        return this.controller.getRXAxisValue();
    }

    public float getYAxisValue() {
        return this.controller.getYAxisValue();
    }

    public float getRYAxisValue() {
        return this.controller.getRYAxisValue();
    }

    public float getZAxisValue() {
        if (this.controller == null) {
            return 0.0f;
        }
        return this.controller.getZAxisValue();
    }

    public float getRZAxisValue() {
        if (this.controller == null) {
            return 0.0f;
        }
        return this.controller.getRZAxisValue();
    }

    public float getPovX() {
        return this.controller.getPovX();
    }

    public float getPovY() {
        return this.controller.getPovY();
    }
}

