/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.player.controller;

import com.mojang.minecraft.client.player.controller.GameSettings;
import com.mojang.minecraft.client.player.controller.MovementInput;
import com.mojang.minecraft.core.entity.EntityPlayer;

public class MovementInputFromOptions
extends MovementInput {
    private boolean[] currentPlayerMovement = new boolean[10];
    private GameSettings currentInput;

    public MovementInputFromOptions(GameSettings gamesettings) {
        this.currentInput = gamesettings;
    }

    public void getCurrentMovement(int i, boolean flag) {
        int movement = -1;
        if (i == this.currentInput.keyBindForward.keyCode) {
            movement = 0;
        }
        if (i == this.currentInput.keyBindBack.keyCode) {
            movement = 1;
        }
        if (i == this.currentInput.keyBindLeft.keyCode) {
            movement = 2;
        }
        if (i == this.currentInput.keyBindRight.keyCode) {
            movement = 3;
        }
        if (i == this.currentInput.keyBindJump.keyCode) {
            movement = 4;
        }
        if (i == this.currentInput.keyBindSneak.keyCode) {
            movement = 5;
        }
        if (i == this.currentInput.keyBindRun.keyCode) {
            movement = 6;
        }
        if (movement >= 0) {
            this.currentPlayerMovement[movement] = flag;
        }
    }

    public void getCurrentMovementJoystick(float rotate, float axis) {
        this.resetWalking();
        int movement = -1;
        if (axis < -0.2f) {
            this.currentPlayerMovement[0] = true;
        }
        if (axis > 0.2f) {
            this.currentPlayerMovement[1] = true;
        }
        if (rotate < -0.2f) {
            this.currentPlayerMovement[2] = true;
        }
        if (rotate > 0.2f) {
            this.currentPlayerMovement[3] = true;
        }
    }

    public void resetWalking() {
        int i = 0;
        while (i < 4) {
            this.currentPlayerMovement[i] = false;
            ++i;
        }
        this.currentPlayerMovement[7] = false;
        this.currentPlayerMovement[8] = false;
    }

    public void resetMovement() {
        int i = 0;
        while (i < 10) {
            this.currentPlayerMovement[i] = false;
            ++i;
        }
    }

    public void applyCurrentMovement(EntityPlayer entityplayer) {
        this.movementLeftRight = 0.0f;
        this.movementForwardBack = 0.0f;
        this.movementUpDown = 0.0f;
        if (this.currentPlayerMovement[0]) {
            this.movementForwardBack += 1.0f;
        }
        if (this.currentPlayerMovement[1]) {
            this.movementForwardBack -= 1.0f;
        }
        if (this.currentPlayerMovement[2]) {
            this.movementLeftRight += 1.0f;
        }
        if (this.currentPlayerMovement[3]) {
            this.movementLeftRight -= 1.0f;
        }
        if (this.currentPlayerMovement[7]) {
            this.movementUpDown += 1.0f;
        }
        if (this.currentPlayerMovement[8]) {
            this.movementUpDown -= 1.0f;
        }
        this.movementIsJumping = this.currentPlayerMovement[4];
        this.movementIsSneaking = this.currentPlayerMovement[5];
        this.movementIsRunning = this.currentPlayerMovement[6];
        if (this.movementIsSneaking && !this.currentInput.mc.thePlayer.isCamera) {
            this.movementIsRunning = false;
            this.movementLeftRight = (float)((double)this.movementLeftRight * 0.3);
            this.movementForwardBack = (float)((double)this.movementForwardBack * 0.3);
        }
    }
}

