/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.player.controller;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.entity.EntityPlayerSP;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.WorldClient;
import com.mojang.minecraft.core.level.tile.Block;

public class PlayerController {
    protected final Minecraft mc;
    public boolean isCreative = false;
    public boolean isCamera;

    public PlayerController(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void func_717_a(World world) {
    }

    public void clickBlock(int i, int j, int k, int l) {
        this.doDigBlock(i, j, k, l);
    }

    public boolean doDigBlock(int i, int j, int k, int l) {
        this.mc.effectRenderer.addBlockDestroyEffects(i, j, k);
        World world = this.mc.mcWorld;
        Block block = Block.allBlocks[world.getBlockId(i, j, k)];
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = world.setBlockWithNotify(i, j, k, 0);
        if (block != null && flag) {
            this.mc.soundMGR.playSound(block.stepSound.stepSoundDir(), (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (!(world instanceof WorldClient)) {
                block.onBlockDestroyedByPlayer(world, i, j, k, i1);
            }
        }
        return flag;
    }

    public void sendRemovingBlock(int i, int j, int k, int l) {
    }

    public void resetBlockRemoving() {
    }

    public void setPartialTime(float f) {
    }

    public float getBlockReachDistance() {
        return 5.0f;
    }

    public boolean sendUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        if (entityplayer.worldObj.multiplayerWorld && itemstack.itemID != Item.compass.shiftedIndex) {
            int i = itemstack.stackSize;
            ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
            if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != i) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = itemstack1;
                if (itemstack1.stackSize == 0) {
                    entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = null;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void flipPlayer(EntityPlayer entityplayer) {
    }

    public void updateController() {
    }

    public boolean isVulnerable() {
        return true;
    }

    public void initiateInventory(EntityPlayer entityplayer) {
    }

    public boolean sendPlaceBlock(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, int l) {
        int i1 = world.getBlockId(i, j, k);
        if (!entityplayer.getIsSneaking() && i1 > 0 && Block.allBlocks[i1].blockActivated(world, i, j, k, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, i, j, k, l);
    }

    public EntityPlayer createPlayer(World world) {
        return new EntityPlayerSP(this.mc, world, this.mc.session);
    }

    public ItemStack onClick(int window, int slot, int click, boolean shift, EntityPlayer entityplayer) {
        return entityplayer.craftingInventory.onClickSlot(slot, click, shift, entityplayer);
    }

    public void func_20086_a(int i, EntityPlayer entityplayer) {
        entityplayer.craftingInventory.onCraftGuiClosed(entityplayer);
        entityplayer.craftingInventory = entityplayer.inventorySlots;
    }

    public void sendStoppedUsing(EntityPlayer entityplayer) {
        entityplayer.onPlayerStoppedUsing();
    }

    public void attackEntity(EntityPlayer thePlayer, Entity entityHit) {
    }

    public void interactWithEntity(EntityPlayer thePlayer, Entity entityHit) {
    }
}

