/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.player.controller;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.network.NetClientHandler;
import com.mojang.minecraft.client.network.packet.Packet102WindowClick;
import com.mojang.minecraft.client.network.packet.Packet14BlockDig;
import com.mojang.minecraft.client.network.packet.Packet15Place;
import com.mojang.minecraft.client.network.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.client.network.packet.Packet7UseEntity;
import com.mojang.minecraft.client.player.controller.PlayerController;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityClientPlayerMP;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;

public class PlayerControllerMP
extends PlayerController {
    private int currentBlockX = -1;
    private int currentBlockY = -1;
    private int currentBlockZ = -1;
    private float curBlockDamageMP = 0.0f;
    private float prevBlockDamageMP = 0.0f;
    private float h = 0.0f;
    private int blockHitDelay = 0;
    private boolean isHittingBlock = false;
    private NetClientHandler netClientHandler;
    private int currentPlayerItem = 0;

    public PlayerControllerMP(Minecraft minecraft, NetClientHandler netclienthandler) {
        super(minecraft);
        this.netClientHandler = netclienthandler;
    }

    public void flipPlayer(EntityPlayer entityplayer) {
        entityplayer.rotationYaw = -180.0f;
    }

    public boolean doDigBlock(int i, int j, int k, int l) {
        this.netClientHandler.addToSendQueue(new Packet14BlockDig(2, i, j, k, l));
        int i1 = this.mc.mcWorld.getBlockId(i, j, k);
        int j1 = this.mc.mcWorld.getBlockMetadata(i, j, k);
        boolean flag = super.doDigBlock(i, j, k, l);
        boolean flag1 = this.mc.thePlayer.checkBreakBlock(Block.allBlocks[i1]);
        boolean flag2 = this.mc.thePlayer.checkGoldTouch(Block.allBlocks[i1]);
        ItemStack itemstack = this.mc.thePlayer.getCurrentEquippedItem();
        if (itemstack != null) {
            itemstack.onDestroyBlock(i1, i, j, k);
            if (itemstack.stackSize == 0) {
                itemstack.func_1097_a(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        if (flag && flag2) {
            Block.allBlocks[i1].dropBlockGoldTouch(this.mc.mcWorld, i, j, k, j1, 1.0f);
        } else if (flag && flag1) {
            Block.allBlocks[i1].harvestBlock(this.mc.mcWorld, i, j, k, j1);
        }
        return flag;
    }

    public boolean sendBlockRemoved(int i, int j, int k, int l) {
        int i1 = this.mc.mcWorld.getBlockId(i, j, k);
        boolean flag = super.doDigBlock(i, j, k, l);
        ItemStack itemstack = this.mc.thePlayer.getCurrentEquippedItem();
        if (itemstack != null) {
            itemstack.onDestroyBlock(i1, i, j, k);
            if (itemstack.stackSize == 0) {
                itemstack.func_1097_a(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    public void clickBlock(int i, int j, int k, int l) {
        if (!this.isHittingBlock || i != this.currentBlockX || j != this.currentBlockY || k != this.currentBlockZ) {
            this.netClientHandler.addToSendQueue(new Packet14BlockDig(0, i, j, k, l));
            int i1 = this.mc.mcWorld.getBlockId(i, j, k);
            if (i1 > 0 && this.curBlockDamageMP == 0.0f) {
                Block.allBlocks[i1].onBlockClicked(this.mc.mcWorld, i, j, k, this.mc.thePlayer);
            }
            if (i1 > 0 && Block.allBlocks[i1].blockStrength(this.mc.thePlayer) >= 1.0f) {
                this.sendBlockRemoved(i, j, k, l);
            } else {
                this.isHittingBlock = true;
                this.currentBlockX = i;
                this.currentBlockY = j;
                this.currentBlockZ = k;
                this.curBlockDamageMP = 0.0f;
                this.prevBlockDamageMP = 0.0f;
                this.h = 0.0f;
            }
        }
    }

    public void resetBlockRemoving() {
        this.curBlockDamageMP = 0.0f;
        this.isHittingBlock = false;
    }

    public void sendRemovingBlock(int i, int j, int k, int l) {
        if (!this.isHittingBlock) {
            return;
        }
        this.syncCurrentPlayItem();
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
            return;
        }
        if (i == this.currentBlockX && j == this.currentBlockY && k == this.currentBlockZ) {
            int i1 = this.mc.mcWorld.getBlockId(i, j, k);
            if (i1 == 0) {
                this.isHittingBlock = false;
                return;
            }
            Block block = Block.allBlocks[i1];
            this.curBlockDamageMP += block.blockStrength(this.mc.thePlayer);
            if (this.h % 4.0f == 0.0f && block != null) {
                this.mc.soundMGR.playSound(block.stepSound.func_1145_d(), (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, (block.stepSound.getVolume() + 1.0f) / 8.0f, block.stepSound.getPitch() * 0.5f);
            }
            this.h += 1.0f;
            if (this.curBlockDamageMP >= 1.0f) {
                this.isHittingBlock = false;
                this.netClientHandler.addToSendQueue(new Packet14BlockDig(2, i, j, k, l));
                this.sendBlockRemoved(i, j, k, l);
                this.curBlockDamageMP = 0.0f;
                this.prevBlockDamageMP = 0.0f;
                this.h = 0.0f;
                this.blockHitDelay = 5;
            }
        } else {
            this.clickBlock(i, j, k, l);
        }
    }

    public void setPartialTime(float f) {
        if (this.curBlockDamageMP <= 0.0f) {
            this.mc.ingameGUI.field_932_b = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float f1;
            this.mc.ingameGUI.field_932_b = f1 = this.prevBlockDamageMP + (this.curBlockDamageMP - this.prevBlockDamageMP) * f;
            this.mc.renderGlobal.damagePartialTime = f1;
        }
    }

    public float getBlockReachDistance() {
        return 4.0f;
    }

    public void func_717_a(World world) {
        super.func_717_a(world);
    }

    public void updateController() {
        this.syncCurrentPlayItem();
        this.prevBlockDamageMP = this.curBlockDamageMP;
        this.mc.soundMGR.func_341_c();
    }

    private void syncCurrentPlayItem() {
        int i = this.mc.thePlayer.inventory.currentItem;
        if (i != this.currentPlayerItem) {
            this.currentPlayerItem = i;
            this.netClientHandler.addToSendQueue(new Packet16BlockItemSwitch(this.currentPlayerItem));
        }
    }

    public void attackEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 1));
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    public void interactWithEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 0));
        entityplayer.useCurrentItemOnEntity(entity);
    }

    public boolean sendPlaceBlock(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, int l) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet15Place(i, j, k, l, itemstack));
        return super.sendPlaceBlock(entityplayer, world, itemstack, i, j, k, l);
    }

    public boolean sendUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet15Place(-1, -1, -1, 255, entityplayer.inventory.getCurrentItem()));
        boolean flag = super.sendUseItem(entityplayer, world, itemstack);
        return flag;
    }

    public void sendStoppedUsing(EntityPlayer entityplayer) {
        System.out.println("stopping use");
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet15Place(-1, -1, -1, 254, entityplayer.inventory.getCurrentItem()));
        super.sendStoppedUsing(entityplayer);
    }

    public ItemStack onClick(int window, int slot, int click, boolean flag, EntityPlayer entityplayer) {
        short act = entityplayer.craftingInventory.func_20111_a(entityplayer.inventory);
        ItemStack itemstack = super.onClick(window, slot, click, flag, entityplayer);
        this.netClientHandler.addToSendQueue(new Packet102WindowClick(window, slot, click, flag, itemstack, act));
        return itemstack;
    }

    public EntityPlayer createPlayer(World world) {
        return new EntityClientPlayerMP(this.mc, world, this.mc.session, this.netClientHandler);
    }

    public void func_20086_a(int i, EntityPlayer entityplayer) {
        if (i == -9999) {
            return;
        }
    }
}

