/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.entity.EntityDiggingFX;
import com.mojang.minecraft.client.entity.EntityFX;
import com.mojang.minecraft.client.render.RenderEngine;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.util.MathHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    protected World worldObj;
    private List<Object>[] fxLayers = new List[4];
    private RenderEngine renderer;
    private Random rand = new Random();
    protected Minecraft mc;

    public EffectRenderer(World world, RenderEngine renderengine, Minecraft minecraft) {
        if (world != null) {
            this.worldObj = world;
        }
        if (minecraft != null) {
            this.mc = minecraft;
        }
        this.renderer = renderengine;
        int i = 0;
        while (i < 4) {
            this.fxLayers[i] = new ArrayList<Object>();
            ++i;
        }
    }

    public void addEffect(EntityFX entityfx) {
        int i = entityfx.func_404_c();
        this.fxLayers[i].add(entityfx);
    }

    public void updateEffects() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < this.fxLayers[i].size()) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i].get(j);
                entityfx.onUpdate();
                if (entityfx.isDead) {
                    this.fxLayers[i].remove(j--);
                }
                ++j;
            }
            ++i;
        }
    }

    public void renderParticles(Entity entity, float f) {
        float f1 = MathHelper.cos(entity.rotationYaw * 3.141593f / 180.0f);
        float f2 = MathHelper.sin(entity.rotationYaw * 3.141593f / 180.0f);
        float f3 = -f2 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f);
        float f4 = f1 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(entity.rotationPitch * 3.141593f / 180.0f);
        EntityFX.field_660_l = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)f;
        EntityFX.field_659_m = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)f;
        EntityFX.field_658_n = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)f;
        int i = 0;
        while (i < 3) {
            if (this.fxLayers[i].size() != 0) {
                int j = 0;
                if (i == 0) {
                    j = this.renderer.getTex("/particles.png");
                }
                if (i == 1) {
                    j = this.renderer.getTex("/terrain.png");
                }
                if (i == 2) {
                    j = this.renderer.getTex("/gui/items.png");
                }
                GL11.glBindTexture((int)3553, (int)j);
                Tessellator tessellator = Tessellator.instance;
                tessellator.startDrawingQuads();
                int k = 0;
                while (k < this.fxLayers[i].size()) {
                    EntityFX entityfx = (EntityFX)this.fxLayers[i].get(k);
                    entityfx.renderParticle(tessellator, f, f1, f5, f2, f3, f4);
                    ++k;
                }
                tessellator.draw();
            }
            ++i;
        }
    }

    public void func_1187_b(Entity entity, float f) {
        int byte0 = 3;
        if (this.fxLayers[byte0].size() != 0) {
            Tessellator tessellator = Tessellator.instance;
            int i = 0;
            while (i < this.fxLayers[byte0].size()) {
                EntityFX entityfx = (EntityFX)this.fxLayers[byte0].get(i);
                entityfx.renderParticle(tessellator, f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                ++i;
            }
        }
    }

    public void clearEffects(World world) {
        this.worldObj = world;
        int i = 0;
        while (i < 4) {
            this.fxLayers[i].clear();
            ++i;
        }
    }

    public void addBlockDestroyEffects(int i, int j, int k) {
        int l = this.worldObj.getBlockId(i, j, k);
        if (l != 0 && this.mc.options.particles) {
            Block block = Block.allBlocks[l];
            int i1 = 4;
            int j1 = 0;
            while (j1 < i1) {
                int k1 = 0;
                while (k1 < i1) {
                    int l1 = 0;
                    while (l1 < i1) {
                        double d = (double)i + ((double)j1 + 0.5) / (double)i1;
                        double d1 = (double)j + ((double)k1 + 0.5) / (double)i1;
                        double d2 = (double)k + ((double)l1 + 0.5) / (double)i1;
                        this.addEffect(new EntityDiggingFX(this.worldObj, d, d1, d2, d - (double)i - 0.5, d1 - (double)j - 0.5, d2 - (double)k - 0.5, block));
                        ++l1;
                    }
                    ++k1;
                }
                ++j1;
            }
        }
    }

    public void addBlockHitEffects(int i, int j, int k, int l) {
        int i1 = this.worldObj.getBlockId(i, j, k);
        if (i1 != 0 && this.mc.options.particles) {
            Block block = Block.allBlocks[i1];
            float f = 0.1f;
            double d = (double)i + this.rand.nextDouble() * (block.maxX - block.minX - (double)(f * 2.0f)) + (double)f + block.minX;
            double d1 = (double)j + this.rand.nextDouble() * (block.maxY - block.minY - (double)(f * 2.0f)) + (double)f + block.minY;
            double d2 = (double)k + this.rand.nextDouble() * (block.maxZ - block.minZ - (double)(f * 2.0f)) + (double)f + block.minZ;
            if (l == 0) {
                d1 = (double)j + block.minY - (double)f;
            }
            if (l == 1) {
                d1 = (double)j + block.maxY + (double)f;
            }
            if (l == 2) {
                d2 = (double)k + block.minZ - (double)f;
            }
            if (l == 3) {
                d2 = (double)k + block.maxZ + (double)f;
            }
            if (l == 4) {
                d = (double)i + block.minX - (double)f;
            }
            if (l == 5) {
                d = (double)i + block.maxX + (double)f;
            }
            this.addEffect(new EntityDiggingFX(this.worldObj, d, d1, d2, 0.0, 0.0, 0.0, block).func_407_b(0.2f).func_405_d(0.6f));
        }
    }

    public String getStatistics() {
        return "" + (this.fxLayers[0].size() + this.fxLayers[1].size() + this.fxLayers[2].size());
    }
}

