/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.entity.EntityPlayerSP;
import com.mojang.minecraft.client.entity.EntityRainFX;
import com.mojang.minecraft.client.entity.item.ItemRenderer;
import com.mojang.minecraft.client.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.client.render.ClippingHelperImplementation;
import com.mojang.minecraft.client.render.EffectRenderer;
import com.mojang.minecraft.client.render.Frustrum;
import com.mojang.minecraft.client.render.GLAllocation;
import com.mojang.minecraft.client.render.RenderGlobal;
import com.mojang.minecraft.client.render.RenderHelper;
import com.mojang.minecraft.client.render.ScaledResolution;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.MovingObjectPosition;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.enums.EnumWeather;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.core.level.generate.IChunkProvider;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.core.util.MathHelper;
import com.mojang.minecraft.core.util.MouseFilter;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Random;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class EntityRenderer {
    private Minecraft mc;
    private float farPlaneDistance = 0.0f;
    public ItemRenderer itemRenderer;
    private int rendererUpdateCount;
    private Entity pointedEntity = null;
    private MouseFilter mouseFilterXAxis = new MouseFilter();
    private MouseFilter mouseFilterYAxis = new MouseFilter();
    private double cameraZoom = 1.0;
    private double cameraYaw = 0.0;
    private double cameraPitch = 0.0;
    private long prevFrameTime = System.currentTimeMillis();
    private Random random = new Random();
    volatile int field_1394_b = 0;
    volatile int field_1393_c = 0;
    FloatBuffer fogColorBuffer = GLAllocation.func_1123_d(16);
    float fogColorRed;
    float fogColorGreen;
    float fogColorBlue;
    private float fogColor2;
    private float fogColor1;
    private int rainSoundCounter;

    public EntityRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.itemRenderer = new ItemRenderer(minecraft);
        this.rainSoundCounter = 0;
    }

    public void updateRenderer() {
        this.fogColor2 = this.fogColor1;
        float f = this.mc.mcWorld.getBrightness(MathHelper.floor_double(this.mc.thePlayer.posX), MathHelper.floor_double(this.mc.thePlayer.posY), MathHelper.floor_double(this.mc.thePlayer.posZ));
        float f1 = (float)(3 - this.mc.options.renderDistance) / 3.0f;
        float f2 = f * (1.0f - f1) + f1;
        this.fogColor1 += (f2 - this.fogColor1) * 0.1f;
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
    }

    public void getMouseOver(float f) {
        if (this.mc.thePlayer != null) {
            double d = this.mc.playerController.getBlockReachDistance();
            this.mc.objectMouseOver = this.mc.thePlayer.rayTrace(d, f);
            double d1 = d;
            Vec3D vec3d = this.mc.thePlayer.getPosition(f);
            if (this.mc.objectMouseOver != null) {
                d1 = this.mc.objectMouseOver.hitVec.distanceTo(vec3d);
            }
            if (this.mc.playerController instanceof PlayerControllerCreative) {
                d = 32.0;
                d1 = 32.0;
            } else {
                if (d1 > 3.0) {
                    d1 = 3.0;
                }
                d = d1;
            }
            Vec3D vec3d1 = this.mc.thePlayer.getLook(f);
            Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d);
            this.pointedEntity = null;
            float f1 = 1.0f;
            List<Entity> list = this.mc.mcWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, this.mc.thePlayer.boundingBox.addCoord(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d).expand(f1, f1, f1));
            double d2 = 0.0;
            int i = 0;
            while (i < list.size()) {
                Entity entity = list.get(i);
                if (entity.canBeCollidedWith()) {
                    double d3;
                    float f2 = 0.1f;
                    AxisAlignedBB axisalignedbb = entity.boundingBox.expand(f2, f2, f2);
                    MovingObjectPosition movingobjectposition = axisalignedbb.func_1169_a(vec3d, vec3d2);
                    if (axisalignedbb.isVecInside(vec3d)) {
                        if (0.0 < d2 || d2 == 0.0) {
                            this.pointedEntity = entity;
                            d2 = 0.0;
                        }
                    } else if (movingobjectposition != null && ((d3 = vec3d.distanceTo(movingobjectposition.hitVec)) < d2 || d2 == 0.0)) {
                        this.pointedEntity = entity;
                        d2 = d3;
                    }
                }
                ++i;
            }
            if (this.pointedEntity != null) {
                this.mc.objectMouseOver = new MovingObjectPosition(this.pointedEntity);
            }
        }
    }

    private float getFOV(float f) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f1 = 70.0f;
        if (entityplayersp.isInsideOfMaterial(Material.water)) {
            f1 = 60.0f;
        }
        if (entityplayersp.isRunning() && this.mc.options.difficulty < 3) {
            f1 = 71.5f;
        }
        if (entityplayersp.health <= 0) {
            float f2 = (float)entityplayersp.deathTime + f;
            f1 /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        return f1 + (float)this.mc.options.FOV;
    }

    private void hurtCameraEffect(float f) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f1 = (float)entityplayersp.hurtTime - f;
        if (entityplayersp.health <= 0) {
            float f2 = (float)entityplayersp.deathTime + f;
            GL11.glRotatef((float)(40.0f - 8000.0f / (f2 + 200.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (f1 >= 0.0f) {
            f1 /= (float)entityplayersp.maxHurtTime;
            f1 = MathHelper.sin(f1 * f1 * f1 * f1 * 3.141593f);
            float f3 = entityplayersp.attackedAtYaw;
            GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-f1 * 14.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void setupViewBobbing(float f) {
        if (!this.mc.options.thirdPersonView) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            float f1 = entityplayersp.distanceWalkedModified - entityplayersp.prevDistanceWalkedModified;
            float f2 = entityplayersp.distanceWalkedModified + f1 * f;
            float f3 = entityplayersp.field_775_e + (entityplayersp.field_774_f - entityplayersp.field_775_e) * f;
            float f4 = entityplayersp.lookPitch + (entityplayersp.field_709_M - entityplayersp.lookPitch) * f;
            GL11.glTranslatef((float)(MathHelper.sin(f2 * 3.141593f) * f3 * 0.5f), (float)(-Math.abs(MathHelper.cos(f2 * 3.141593f) * f3)), (float)0.0f);
            GL11.glRotatef((float)(MathHelper.sin(f2 * 3.141593f) * f3 * 3.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(Math.abs(MathHelper.cos(f2 * 3.141593f + 0.2f) * f3) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)f4, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void orientCamera(float f) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.prevPosX + (entityplayersp.posX - entityplayersp.prevPosX) * (double)f;
        double d1 = entityplayersp.prevPosY + (entityplayersp.posY - entityplayersp.prevPosY) * (double)f;
        double d2 = entityplayersp.prevPosZ + (entityplayersp.posZ - entityplayersp.prevPosZ) * (double)f;
        if (this.mc.options.thirdPersonView) {
            double d3 = 4.0;
            float f1 = entityplayersp.rotationYaw;
            float f2 = entityplayersp.rotationPitch;
            if (Keyboard.isKeyDown((int)59)) {
                f2 += 180.0f;
                d3 += 2.0;
            }
            double d4 = (double)(-MathHelper.sin(f1 / 180.0f * 3.141593f) * MathHelper.cos(f2 / 180.0f * 3.141593f)) * d3;
            double d5 = (double)(MathHelper.cos(f1 / 180.0f * 3.141593f) * MathHelper.cos(f2 / 180.0f * 3.141593f)) * d3;
            double d6 = (double)(-MathHelper.sin(f2 / 180.0f * 3.141593f)) * d3;
            int i = 0;
            while (i < 8) {
                double d7;
                MovingObjectPosition movingobjectposition;
                float f3 = (i & 1) * 2 - 1;
                float f4 = (i >> 1 & 1) * 2 - 1;
                float f5 = (i >> 2 & 1) * 2 - 1;
                if ((movingobjectposition = this.mc.mcWorld.rayTraceBlocks(Vec3D.createVector(d + (double)(f3 *= 0.1f), d1 + (double)(f4 *= 0.1f), d2 + (double)(f5 *= 0.1f)), Vec3D.createVector(d - d4 + (double)f3 + (double)f5, d1 - d6 + (double)f4, d2 - d5 + (double)f5))) != null && (d7 = movingobjectposition.hitVec.distanceTo(Vec3D.createVector(d, d1, d2))) < d3) {
                    d3 = d7;
                }
                ++i;
            }
            if (Keyboard.isKeyDown((int)59)) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glRotatef((float)(entityplayersp.rotationPitch - f2), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(entityplayersp.rotationYaw - f1), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)(-d3)));
            GL11.glRotatef((float)(f1 - entityplayersp.rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(f2 - entityplayersp.rotationPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.1f);
        }
        GL11.glRotatef((float)(entityplayersp.prevRotationPitch + (entityplayersp.rotationPitch - entityplayersp.prevRotationPitch) * f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(entityplayersp.prevRotationYaw + (entityplayersp.rotationYaw - entityplayersp.prevRotationYaw) * f + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private void setupCameraTransform(float f, int i) {
        this.farPlaneDistance = this.mc.options.fog ? (this.mc.options.renderDistance > 0 ? (float)(256 >> this.mc.options.renderDistance) : (float)(256 << -this.mc.options.renderDistance)) : 512.0f;
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float f1 = 0.07f;
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)((float)(-(i * 2 - 1)) * f1), (float)0.0f, (float)0.0f);
        }
        GLU.gluPerspective((float)this.getFOV(f), (float)((float)this.mc.displayWidth / (float)this.mc.displayHeight), (float)0.05f, (float)this.farPlaneDistance);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)((float)(i * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        this.hurtCameraEffect(f);
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(f);
        }
        this.orientCamera(f);
    }

    private void func_907_b(float f, int i) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        float fov = 70.0f;
        if (this.mc.options.anaglyph) {
            GL11.glTranslatef((float)((float)(i * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
        }
        GLU.gluPerspective((float)fov, (float)((float)this.mc.displayWidth / (float)this.mc.displayHeight), (float)0.05f, (float)this.farPlaneDistance);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glPushMatrix();
        this.hurtCameraEffect(f);
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(f);
        }
        if (!this.mc.options.thirdPersonView && this.mc.ingameGUI.showHud) {
            this.itemRenderer.renderViewModel(f);
        }
        GL11.glPopMatrix();
        if (!this.mc.options.thirdPersonView) {
            this.itemRenderer.func_893_b(f);
            this.hurtCameraEffect(f);
        }
        if (this.mc.options.viewBobbing) {
            this.setupViewBobbing(f);
        }
    }

    public void updateCameraAndRender(float f) {
        if (!Display.isActive()) {
            if (System.currentTimeMillis() - this.prevFrameTime > 500L) {
                this.mc.displayInGameMenu();
            }
        } else {
            this.prevFrameTime = System.currentTimeMillis();
        }
        if (this.mc.inGameHasFocus) {
            this.mc.mouseHelper.mouseXYChange();
            if (Keyboard.isKeyDown((int)203)) {
                this.mc.mouseHelper.moveX -= 3;
            }
            if (Keyboard.isKeyDown((int)205)) {
                this.mc.mouseHelper.moveX += 3;
            }
            if (Keyboard.isKeyDown((int)200)) {
                this.mc.mouseHelper.moveY += 3;
            }
            if (Keyboard.isKeyDown((int)208)) {
                this.mc.mouseHelper.moveY -= 3;
            }
            float f1 = this.mc.options.mouseSensitivity * 0.6f + 0.2f;
            float f2 = f1 * f1 * f1 * 8.0f;
            float f3 = (float)this.mc.mouseHelper.moveX * f2;
            float f4 = (float)this.mc.mouseHelper.moveY * f2;
            int l = 1;
            if (this.mc.options.invertMouse) {
                l = -1;
            }
            if (this.mc.options.smoothCamera) {
                f3 = this.mouseFilterXAxis.func_22386_a(f3, 0.05f * f2);
                f4 = this.mouseFilterYAxis.func_22386_a(f4, 0.05f * f2);
            }
            this.mc.thePlayer.func_346_d(f3, f4 * (float)l);
        }
        if (!this.mc.skipRenderWorld) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight, this.mc);
            int i = scaledresolution.getScaledWidth();
            int j = scaledresolution.getScaledHeight();
            int k = Mouse.getX() * i / this.mc.displayWidth;
            int i1 = j - Mouse.getY() * j / this.mc.displayHeight - 1;
            if (this.mc.mcWorld != null) {
                this.renderWorld(f);
                this.mc.ingameGUI.renderGameOverlay(f, this.mc.currentScreen != null, k, i1);
            } else {
                GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glLoadIdentity();
                this.func_905_b();
            }
            if (this.mc.currentScreen != null) {
                GL11.glClear((int)256);
                this.mc.currentScreen.drawScreen(k, i1, f);
                if (this.mc.controllerDetected) {
                    this.mc.currentScreen.moveCursorController();
                }
            }
        }
    }

    public void renderWorld(float f) {
        int i;
        this.getMouseOver(f);
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        RenderGlobal renderglobal = this.mc.renderGlobal;
        EffectRenderer effectrenderer = this.mc.effectRenderer;
        double d = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
        double d1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
        double d2 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
        IChunkProvider ichunkprovider = this.mc.mcWorld.getIChunkProvider();
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            int l = MathHelper.floor_float((int)d) >> 4;
            i = MathHelper.floor_float((int)d2) >> 4;
            chunkproviderloadorgenerate.setCurrentChunkOver(l, i);
        }
        int k = 0;
        while (k < (this.mc.options.anaglyph ? 2 : 1)) {
            if (this.mc.options.anaglyph) {
                if (k == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                }
            }
            GL11.glViewport((int)0, (int)0, (int)this.mc.displayWidth, (int)this.mc.displayHeight);
            this.updateFogColor(f);
            GL11.glClear((int)16384);
            GL11.glClear((int)256);
            GL11.glEnable((int)2884);
            this.setupCameraTransform(f, k);
            ClippingHelperImplementation.func_1155_a();
            if (this.mc.options.fog) {
                if (this.mc.options.renderDistance < 4) {
                    this.renderFog(-1);
                    renderglobal.renderSky(f);
                }
            } else {
                this.renderFog(4);
                renderglobal.renderSky(f);
            }
            GL11.glEnable((int)2912);
            this.renderFog(1);
            Frustrum frustrum = new Frustrum();
            frustrum.func_343_a(d, d1, d2);
            this.mc.renderGlobal.func_960_a(frustrum, f);
            this.mc.renderGlobal.updateRenderers(entityplayersp, false);
            this.renderFog(0);
            GL11.glEnable((int)2912);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/terrain.png"));
            RenderHelper.disableStandardItemLighting();
            renderglobal.func_943_a(entityplayersp, 0, f);
            RenderHelper.enableStandardItemLighting();
            renderglobal.handleTileEntityRendering(entityplayersp.getPosition(f), frustrum, f);
            effectrenderer.func_1187_b(entityplayersp, f);
            RenderHelper.disableStandardItemLighting();
            this.renderFog(0);
            effectrenderer.renderParticles(entityplayersp, f);
            if (this.mc.objectMouseOver != null && entityplayersp.isInsideOfMaterial(Material.water)) {
                GL11.glDisable((int)3008);
                renderglobal.renderHeldItem(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f);
                renderglobal.drawSelectionBox(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f);
                GL11.glEnable((int)3008);
            }
            GL11.glBlendFunc((int)770, (int)771);
            this.renderFog(0);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/terrain.png"));
            if (this.mc.options.fancyGraphics) {
                if (this.mc.options.anaglyph) {
                    if (k == 0) {
                        GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)false);
                    } else {
                        GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                    }
                }
                i = renderglobal.func_943_a(entityplayersp, 1, f);
            } else {
                renderglobal.func_943_a(entityplayersp, 1, f);
            }
            if (this.mc.options.noTextures) {
                renderglobal.func_943_a(entityplayersp, 2, f);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            if (this.mc.objectMouseOver != null && !entityplayersp.isInsideOfMaterial(Material.water)) {
                GL11.glDisable((int)3008);
                renderglobal.renderHeldItem(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f);
                renderglobal.drawSelectionBox(entityplayersp, this.mc.objectMouseOver, 0, entityplayersp.inventory.getCurrentItem(), f);
                GL11.glEnable((int)3008);
            }
            if (entityplayersp.isMeasuringBlock()) {
                int mX = entityplayersp.measureBlockX;
                int mY = entityplayersp.measureBlockY;
                int mZ = entityplayersp.measureBlockZ;
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                GL11.glLineWidth((float)2.0f);
                GL11.glDisable((int)3553);
                GL11.glDepthMask((boolean)false);
                float f1 = 0.002f;
                int j = this.mc.mcWorld.getBlockId(mX, mY, mZ);
                if (j == 0) {
                    j = 1;
                }
                Block.allBlocks[j].setBlockBoundsBasedOnState(this.mc.mcWorld, mX, mY, mZ);
                double md = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
                double md1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
                double md2 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
                renderglobal.drawOutlinedBoundingBox(Block.allBlocks[j].getSelectedCollisionBoundingBoxFromPool(this.mc.mcWorld, mX, mY, mZ).expand(f1, f1, f1).getOffsetBoundingBox(-md, -md1, -md2));
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            GL11.glDisable((int)2912);
            if (this.mc.mcWorld.weather == EnumWeather.precipitation) {
                if (this.mc.mcWorld.getCurrentSeason() == EnumSeason.winter) {
                    this.snowFall(f);
                } else {
                    this.rainFall(f);
                    if (this.mc.currentScreen == null) {
                        this.raining();
                    }
                }
            } else if (this.mc.mcWorld.weather == EnumWeather.cycle) {
                this.renderRainSnow(f);
            }
            if (this.mc.mcWorld.getCurrentSeason() == EnumSeason.winter && this.mc.mcWorld.weather == EnumWeather.seasonal) {
                this.snowFall(f);
            }
            if (this.pointedEntity == null) {
                // empty if block
            }
            this.renderFog(0);
            GL11.glEnable((int)2912);
            renderglobal.renderClouds(f);
            GL11.glDisable((int)2912);
            this.renderFog(1);
            GL11.glClear((int)256);
            this.func_907_b(f, k);
            if (!this.mc.options.anaglyph) {
                return;
            }
            ++k;
        }
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    protected void renderRainSnow(float f) {
        int top;
        int checkZ;
        float f1 = 1.0f;
        if (f1 <= 0.0f) {
            return;
        }
        EntityPlayerSP entityliving = this.mc.thePlayer;
        World world = this.mc.mcWorld;
        int pX = MathHelper.floor_double(entityliving.posX);
        int pY = MathHelper.floor_double(entityliving.posY);
        int pZ = MathHelper.floor_double(entityliving.posZ);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/snow.png"));
        double entX = entityliving.lastTickPosX + (entityliving.posX - entityliving.lastTickPosX) * (double)f;
        double entY = entityliving.lastTickPosY + (entityliving.posY - entityliving.lastTickPosY) * (double)f;
        double entZ = entityliving.lastTickPosZ + (entityliving.posZ - entityliving.lastTickPosZ) * (double)f;
        int entYFloor = MathHelper.floor_double(entY);
        int precipitationDensity = 5;
        if (this.mc.options.fancyGraphics) {
            precipitationDensity = 10;
        }
        boolean j1 = false;
        int checkX = pX - precipitationDensity;
        while (checkX <= pX + precipitationDensity) {
            checkZ = pZ - precipitationDensity;
            while (checkZ <= pZ + precipitationDensity) {
                if (this.mc.mcWorld.getCurrentSeason() == EnumSeason.winter) {
                    int topMin;
                    top = world.findTopSolidBlock(checkX, checkZ);
                    if (top < 0) {
                        top = 0;
                    }
                    if ((topMin = top) < entYFloor) {
                        topMin = entYFloor;
                    }
                    int k3 = pY - precipitationDensity;
                    int i4 = pY + precipitationDensity;
                    if (k3 < top) {
                        k3 = top;
                    }
                    if (i4 < top) {
                        i4 = top;
                    }
                    float f3 = 1.0f;
                    if (k3 != i4) {
                        this.random.setSeed(checkX * checkX * 3121 + checkX * 45238971 + checkZ * checkZ * 418711 + checkZ * 13761);
                        float f5 = (float)this.rendererUpdateCount + f;
                        float f6 = ((float)(this.rendererUpdateCount & 0x1FF) + f) / 512.0f;
                        float f7 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                        float f8 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                        double d5 = (double)((float)checkX + 0.5f) - entityliving.posX;
                        double d6 = (double)((float)checkZ + 0.5f) - entityliving.posZ;
                        float f11 = MathHelper.sqrt_double(d5 * d5 + d6 * d6) / (float)precipitationDensity;
                        tessellator.startDrawingQuads();
                        float f12 = world.getBrightness(checkX, topMin, checkZ);
                        GL11.glColor4f((float)f12, (float)f12, (float)f12, (float)(((1.0f - f11 * f11) * 0.3f + 0.5f) * f1));
                        tessellator.setTranslationD(-entX * 1.0, -entY * 1.0, -entZ * 1.0);
                        tessellator.addVertexWithUV(checkX + 0, k3, (double)checkZ + 0.5, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.addVertexWithUV(checkX + 1, k3, (double)checkZ + 0.5, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.addVertexWithUV(checkX + 1, i4, (double)checkZ + 0.5, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.addVertexWithUV(checkX + 0, i4, (double)checkZ + 0.5, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.addVertexWithUV((double)checkX + 0.5, k3, checkZ + 0, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.addVertexWithUV((double)checkX + 0.5, k3, checkZ + 1, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.addVertexWithUV((double)checkX + 0.5, i4, checkZ + 1, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.addVertexWithUV((double)checkX + 0.5, i4, checkZ + 0, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                        tessellator.setTranslationD(0.0, 0.0, 0.0);
                        tessellator.draw();
                    }
                }
                ++checkZ;
            }
            ++checkX;
        }
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/rain.png"));
        if (this.mc.options.fancyGraphics) {
            precipitationDensity = 10;
        }
        j1 = false;
        checkX = pX - precipitationDensity;
        while (checkX <= pX + precipitationDensity) {
            checkZ = pZ - precipitationDensity;
            while (checkZ <= pZ + precipitationDensity) {
                if (this.mc.mcWorld.getCurrentSeason() == EnumSeason.winter) {
                    top = world.findTopSolidBlock(checkX, checkZ);
                    int j3 = pY - precipitationDensity;
                    int l3 = pY + precipitationDensity;
                    if (j3 < top) {
                        j3 = top;
                    }
                    if (l3 < top) {
                        l3 = top;
                    }
                    float f2 = 1.0f;
                    if (j3 != l3) {
                        this.random.setSeed(checkX * checkX * 3121 + checkX * 45238971 + checkZ * checkZ * 418711 + checkZ * 13761);
                        float f4 = ((float)(this.rendererUpdateCount + checkX * checkX * 3121 + checkX * 45238971 + checkZ * checkZ * 418711 + checkZ * 13761 & 0x1F) + f) / 32.0f * (3.0f + this.random.nextFloat());
                        double d3 = (double)((float)checkX + 0.5f) - entityliving.posX;
                        double d4 = (double)((float)checkZ + 0.5f) - entityliving.posZ;
                        float f9 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)precipitationDensity;
                        tessellator.startDrawingQuads();
                        float f10 = world.getBrightness(checkX, 128, checkZ) * 0.85f + 0.15f;
                        GL11.glColor4f((float)f10, (float)f10, (float)f10, (float)(((1.0f - f9 * f9) * 0.5f + 0.5f) * f1));
                        tessellator.setTranslationD(-entX * 1.0, -entY * 1.0, -entZ * 1.0);
                        tessellator.addVertexWithUV(checkX + 0, j3, (double)checkZ + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                        tessellator.addVertexWithUV(checkX + 1, j3, (double)checkZ + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                        tessellator.addVertexWithUV(checkX + 1, l3, (double)checkZ + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                        tessellator.addVertexWithUV(checkX + 0, l3, (double)checkZ + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                        tessellator.addVertexWithUV((double)checkX + 0.5, j3, checkZ + 0, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                        tessellator.addVertexWithUV((double)checkX + 0.5, j3, checkZ + 1, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                        tessellator.addVertexWithUV((double)checkX + 0.5, l3, checkZ + 1, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                        tessellator.addVertexWithUV((double)checkX + 0.5, l3, checkZ + 0, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                        tessellator.setTranslationD(0.0, 0.0, 0.0);
                        tessellator.draw();
                    }
                }
                ++checkZ;
            }
            ++checkX;
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    private void raining() {
        if (this.mc.options.precipLevel && this.mc.options.particles) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            World world = this.mc.mcWorld;
            int i = MathHelper.floor_double(entityplayersp.posX);
            int j = MathHelper.floor_double(entityplayersp.posY);
            int k = MathHelper.floor_double(entityplayersp.posZ);
            int byte0 = 16;
            int l = 0;
            while (l < 15) {
                float fx = (float)Math.random() * 16.0f + (float)i - 8.0f;
                float fz = (float)Math.random() * 16.0f + (float)k - 8.0f;
                if (world.weather == EnumWeather.precipitation) {
                    float fy = world.findTopSolidBlock(Math.round(fx), Math.round(fz));
                    int l1 = world.getBlockId(Math.round(fx), Math.round(fy - 1.0f), Math.round(fz));
                    this.mc.effectRenderer.addEffect(new EntityRainFX(world, fx, (double)(fy + 0.1f) - Block.allBlocks[l1].minY, fz));
                    if (l > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
                        this.rainSoundCounter = 0;
                        entityplayersp.loopHandler.overHang = (double)fy > entityplayersp.posY + 1.0 && world.findTopSolidBlock(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posZ)) > MathHelper.floor_double(entityplayersp.posY) ? (entityplayersp.loopHandler.overHang += 1.0f) : (entityplayersp.loopHandler.overHang -= 1.0f);
                    }
                }
                ++l;
            }
        }
    }

    private void rainFall(float f) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        World world = this.mc.mcWorld;
        int i = MathHelper.floor_double(entityplayersp.posX);
        int j = MathHelper.floor_double(entityplayersp.posY);
        int k = MathHelper.floor_double(entityplayersp.posZ);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/rain.png"));
        double d = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
        double d1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
        double d2 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
        int l = 5;
        if (this.mc.options.precipLevel) {
            l = 10;
        }
        int i1 = i - l;
        while (i1 <= i + l) {
            int j1 = k - l;
            while (j1 <= k + l) {
                int k1 = world.getTopSolidOrLiquidBlock(i1, j1);
                if (k1 < 0) {
                    k1 = 0;
                }
                int l1 = j - l;
                int i2 = j + l;
                if (l1 < k1) {
                    l1 = k1;
                }
                if (i2 < k1) {
                    i2 = k1;
                }
                float f1 = 2.0f;
                if (l1 != i2) {
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 + j1 * j1 * 418711 + j1 * 13761);
                    float f2 = this.rendererUpdateCount;
                    float f3 = ((float)(this.rendererUpdateCount & 0x1FF) + f) / 25.0f;
                    float f4 = this.random.nextFloat() + f2 * 0.01f * (float)this.random.nextGaussian();
                    float f5 = this.random.nextFloat() + f2 * (float)this.random.nextGaussian() * 0.001f;
                    double d3 = (double)((float)i1 + 0.5f) - entityplayersp.posX;
                    double d4 = (double)((float)j1 + 0.5f) - entityplayersp.posZ;
                    float f6 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)l;
                    tessellator.startDrawingQuads();
                    float f7 = world.getBrightness(i1, 128, j1);
                    GL11.glColor4f((float)f7, (float)f7, (float)f7, (float)((1.0f - f6 * f6) * 0.7f));
                    tessellator.setTranslationD(-d * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 0, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 1, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i2, j1 + 1, 1.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i2, j1 + 0, 0.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 1, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 0, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i2, j1 + 0, 1.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i2, j1 + 1, 0.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.setTranslationD(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
                ++j1;
            }
            ++i1;
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    private void snowFall(float f) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        World world = this.mc.mcWorld;
        int i = MathHelper.floor_double(entityplayersp.posX);
        int j = MathHelper.floor_double(entityplayersp.posY);
        int k = MathHelper.floor_double(entityplayersp.posZ);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTex("/snow.png"));
        double d = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
        double d1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
        double d2 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
        int l = 5;
        if (this.mc.options.precipLevel) {
            l = 10;
        }
        int i1 = i - l;
        while (i1 <= i + l) {
            int j1 = k - l;
            while (j1 <= k + l) {
                int k1 = world.getTopSolidOrLiquidBlock(i1, j1);
                if (k1 < 0) {
                    k1 = 0;
                }
                int l1 = j - l;
                int i2 = j + l;
                if (l1 < k1) {
                    l1 = k1;
                }
                if (i2 < k1) {
                    i2 = k1;
                }
                float f1 = 2.0f;
                if (l1 != i2) {
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 + j1 * j1 * 418711 + j1 * 13761);
                    float f2 = (float)this.rendererUpdateCount + f;
                    float f3 = ((float)(this.rendererUpdateCount & 0x1FF) + f) / 512.0f;
                    float f4 = this.random.nextFloat() + f2 * 0.01f * (float)this.random.nextGaussian();
                    float f5 = this.random.nextFloat() + f2 * (float)this.random.nextGaussian() * 0.001f;
                    double d3 = (double)((float)i1 + 0.5f) - entityplayersp.posX;
                    double d4 = (double)((float)j1 + 0.5f) - entityplayersp.posZ;
                    float f6 = MathHelper.sqrt_double(d3 * d3 + d4 * d4) / (float)l;
                    tessellator.startDrawingQuads();
                    float f7 = world.getBrightness(i1, 128, j1);
                    GL11.glColor4f((float)f7, (float)f7, (float)f7, (float)((1.0f - f6 * f6) * 0.7f));
                    tessellator.setTranslationD(-d * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 0, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 1, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i2, j1 + 1, 1.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i2, j1 + 0, 0.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, l1, j1 + 1, 0.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, l1, j1 + 0, 1.0f * f1 + f4, (float)l1 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 1, i2, j1 + 0, 1.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.addVertexWithUV(i1 + 0, i2, j1 + 1, 0.0f * f1 + f4, (float)i2 * f1 / 8.0f + f3 * f1 + f5);
                    tessellator.setTranslationD(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
                ++j1;
            }
            ++i1;
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    public void func_905_b() {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight, this.mc);
        int i = scaledresolution.getScaledWidth();
        int j = scaledresolution.getScaledHeight();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)i, (double)j, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    private void updateFogColor(float f) {
        World world = this.mc.mcWorld;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        float f1 = 1.0f;
        if (this.mc.options.fog) {
            f1 = 1.0f / (float)(4 - this.mc.options.renderDistance);
        }
        f1 = 1.0f - (float)Math.pow(f1, 0.25);
        Vec3D vec3d = world.calculateSkyTopColor(f);
        float f2 = (float)vec3d.xCoord;
        float f3 = (float)vec3d.yCoord;
        float f4 = (float)vec3d.zCoord;
        Vec3D vec3d1 = world.calculateSkyEdgeColor(f);
        this.fogColorRed = (float)vec3d1.xCoord;
        this.fogColorGreen = (float)vec3d1.yCoord;
        this.fogColorBlue = (float)vec3d1.zCoord;
        this.fogColorRed += (f2 - this.fogColorRed) * f1;
        this.fogColorGreen += (f3 - this.fogColorGreen) * f1;
        this.fogColorBlue += (f4 - this.fogColorBlue) * f1;
        if (entityplayersp.isInsideOfMaterial(Material.water)) {
            this.fogColorRed = 0.02f;
            this.fogColorGreen = 0.02f;
            this.fogColorBlue = 0.2f;
        } else if (entityplayersp.isInsideOfMaterial(Material.lava)) {
            this.fogColorRed = 0.6f;
            this.fogColorGreen = 0.1f;
            this.fogColorBlue = 0.0f;
        }
        float f5 = this.fogColor2 + (this.fogColor1 - this.fogColor2) * f;
        this.fogColorRed *= f5;
        this.fogColorGreen *= f5;
        this.fogColorBlue *= f5;
        if (this.mc.options.anaglyph) {
            float f6 = (this.fogColorRed * 30.0f + this.fogColorGreen * 59.0f + this.fogColorBlue * 11.0f) / 100.0f;
            float f7 = (this.fogColorRed * 30.0f + this.fogColorGreen * 70.0f) / 100.0f;
            float f8 = (this.fogColorRed * 30.0f + this.fogColorBlue * 70.0f) / 100.0f;
            this.fogColorRed = f6;
            this.fogColorGreen = f7;
            this.fogColorBlue = f8;
        }
        GL11.glClearColor((float)this.fogColorRed, (float)this.fogColorGreen, (float)this.fogColorBlue, (float)0.0f);
    }

    private void renderFog(int i) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        GL11.glFog((int)2918, (FloatBuffer)this.func_908_a(this.fogColorRed, this.fogColorGreen, this.fogColorBlue, 1.0f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (entityplayersp.isInsideOfMaterial(Material.water)) {
            GL11.glFogi((int)2917, (int)2048);
            if (entityplayersp.inventory.armorInventory[3] != null && entityplayersp.inventory.armorInventory[3].itemID == Item.helmetSponge.shiftedIndex) {
                GL11.glFogf((int)2914, (float)0.025f);
            } else {
                GL11.glFogf((int)2914, (float)0.1f);
            }
            float f = 0.4f;
            float f2 = 0.4f;
            float f4 = 0.9f;
            if (this.mc.options.anaglyph) {
                float f6 = (f * 30.0f + f2 * 59.0f + f4 * 11.0f) / 100.0f;
                float f8 = (f * 30.0f + f2 * 70.0f) / 100.0f;
                float f10 = (f * 30.0f + f4 * 70.0f) / 100.0f;
                f = f6;
                f2 = f8;
                f4 = f10;
            }
        } else if (entityplayersp.isInsideOfMaterial(Material.lava)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
            float f1 = 0.4f;
            float f3 = 0.3f;
            float f5 = 0.3f;
            if (this.mc.options.anaglyph) {
                float f7 = (f1 * 30.0f + f3 * 59.0f + f5 * 11.0f) / 100.0f;
                float f9 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
                float f11 = (f1 * 30.0f + f5 * 70.0f) / 100.0f;
                f1 = f7;
                f3 = f9;
                f5 = f11;
            }
        } else {
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)(this.farPlaneDistance * 0.25f));
            GL11.glFogf((int)2916, (float)this.farPlaneDistance);
            if (i < 0) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(this.farPlaneDistance * 0.8f));
            }
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GL11.glFogi((int)34138, (int)34139);
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    private FloatBuffer func_908_a(float f, float f1, float f2, float f3) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(f).put(f1).put(f2).put(f3);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

