/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.gui.ChatAllowedCharacters;
import com.mojang.minecraft.client.player.controller.GameSettings;
import com.mojang.minecraft.client.render.RenderEngine;
import com.mojang.minecraft.client.sound.CodecMus;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private int[] colors;
    private byte[] basicWidth;
    private byte[] unicodeWidth;
    private final int[] unicodeTexID = new int[256];
    private final int basicTexID;
    private int lastBoundTexID;
    private RenderEngine tex;
    private float xPos;
    private float yPos;
    private Random r;

    public FontRenderer(GameSettings gamesettings, String s, RenderEngine renderengine) {
        BufferedImage bufferedimage;
        this.colors = new int[32];
        this.basicWidth = new byte[256];
        this.unicodeWidth = new byte[65536];
        this.r = new Random();
        this.tex = renderengine;
        try {
            Class<?> class1 = Class.forName("ModLoader");
            if (class1 != null) {
                Method method = class1.getDeclaredMethod("RegisterAllTextureOverrides", RenderEngine.class);
                method.invoke(null, renderengine);
            }
        }
        catch (Throwable class1) {
            // empty catch block
        }
        try {
            bufferedimage = ImageIO.read(RenderEngine.class.getResourceAsStream(s));
            InputStream inputstream = RenderEngine.class.getResourceAsStream("/font/glyph_sizes.bin");
            if (inputstream != null) {
                inputstream.read(this.unicodeWidth);
                inputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] ai = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, ai, 0, i);
        int k = 0;
        while (k < 256) {
            int i2;
            int i1 = k % 16;
            int k1 = k / 16;
            for (i2 = 7; i2 >= 0; --i2) {
                int k2 = i1 * 8 + i2;
                boolean flag = true;
                int j3 = 0;
                while (j3 < 8 && flag) {
                    int l3 = ai[k2 + (k1 * 8 + j3) * i] & 0xFF;
                    if (l3 > 0) {
                        flag = false;
                    }
                    ++j3;
                }
                if (!flag) break;
            }
            if (k == 32) {
                i2 = 2;
            }
            this.basicWidth[k] = (byte)(i2 + 2);
            ++k;
        }
        this.basicTexID = renderengine.allocateAndSetupTexture(bufferedimage);
        int l = 0;
        while (l < 32) {
            int j1 = (l >> 3 & 1) * 85;
            int l1 = (l >> 2 & 1) * 170 + j1;
            int j2 = (l >> 1 & 1) * 170 + j1;
            int l2 = (l >> 0 & 1) * 170 + j1;
            if (l == 6) {
                l1 += 85;
            }
            if (gamesettings.anaglyph) {
                int i3 = (l1 * 30 + j2 * 59 + l2 * 11) / 100;
                int k3 = (l1 * 30 + j2 * 70) / 100;
                int i4 = (l1 * 30 + l2 * 70) / 100;
                l1 = i3;
                j2 = k3;
                l2 = i4;
            }
            if (l >= 16) {
                l1 /= 4;
                j2 /= 4;
                l2 /= 4;
            }
            this.colors[l] = (l1 & 0xFF) << 16 | (j2 & 0xFF) << 8 | l2 & 0xFF;
            ++l;
        }
    }

    private void func_21002_o(int i) {
        float f = i % 16 * 8;
        float f1 = i / 16 * 8;
        if (this.lastBoundTexID != this.basicTexID) {
            GL11.glBindTexture((int)3553, (int)this.basicTexID);
            this.lastBoundTexID = this.basicTexID;
        }
        float f2 = (float)this.basicWidth[i] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)this.xPos, (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)(f / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)this.xPos, (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f + f2) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.xPos + f2), (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)((f + f2) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.xPos + f2), (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glEnd();
        this.xPos += (float)this.basicWidth[i];
    }

    private void func_21003_loadUnicodePage(int i) {
        BufferedImage bufferedimage;
        StringBuilder stringbuilder = new StringBuilder();
        Formatter f = new Formatter(stringbuilder);
        f.format("/font/glyph_%02X.png", i);
        f.close();
        try {
            bufferedimage = ImageIO.read(CodecMus.class.getResourceAsStream(stringbuilder.toString()));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.unicodeTexID[i] = this.tex.allocateAndSetupTexture(bufferedimage);
        this.lastBoundTexID = this.unicodeTexID[i];
    }

    private String func_21001_a(int i) {
        char[] ac = new char[i];
        while (i-- != 0) {
            int j = this.r.nextInt() & 0xF;
            ac[i] = j == 0 ? 167 : (char)(48 + j);
        }
        return new String(ac);
    }

    private void func_21004_a(char c) {
        float f;
        float f1;
        if (this.unicodeWidth[c] == 0) {
            return;
        }
        int i = c / 256;
        if (this.unicodeTexID[i] == 0) {
            this.func_21003_loadUnicodePage(i);
        }
        if (this.lastBoundTexID != this.unicodeTexID[i]) {
            GL11.glBindTexture((int)3553, (int)this.unicodeTexID[i]);
            this.lastBoundTexID = this.unicodeTexID[i];
        }
        int j = this.unicodeWidth[c] >> 4;
        int k = this.unicodeWidth[c] & 0xF;
        if (k > 7) {
            f1 = 16.0f;
            f = 0.0f;
        } else {
            f1 = k + 1;
            f = j;
        }
        float f2 = (float)(c % 16 * 16) + f;
        float f3 = (c & 0xFF) / 16 * 16;
        float f4 = f1 - f - 0.02f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)this.xPos, (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)this.xPos, (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.xPos + f4 / 2.0f), (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.xPos + f4 / 2.0f), (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glEnd();
        this.xPos += (f1 - f) / 2.0f + 1.0f;
    }

    private void func_21006_b(String s, boolean flag) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\u00a7' && i + 1 < s.length()) {
                int j = "0123456789abcdef".indexOf(s.toLowerCase().charAt(i + 1));
                if (j < 0 || j > 15) {
                    j = 15;
                }
                if (flag) {
                    j += 16;
                }
                int l = this.colors[j];
                GL11.glColor3f((float)((float)(l >> 16) / 255.0f), (float)((float)(l >> 8 & 0xFF) / 255.0f), (float)((float)(l & 0xFF) / 255.0f));
                ++i;
            } else {
                int k = ChatAllowedCharacters.allowedCharacters.indexOf(c);
                if (c == ' ') {
                    this.xPos += 4.0f;
                } else if (k > 0) {
                    this.func_21002_o(k + 1);
                } else {
                    this.func_21004_a(c);
                }
            }
            ++i;
        }
    }

    private void func_21005_a(String s, int i, int j, int k, boolean flag) {
        if (s != null) {
            this.lastBoundTexID = 0;
            if ((k & 0xFF000000) == 0) {
                k |= 0xFF000000;
            }
            if (flag) {
                k = (k & 0xFCFCFC) >> 2 | k & 0xFF000000;
            }
            GL11.glColor4f((float)((float)(k >> 16 & 0xFF) / 255.0f), (float)((float)(k >> 8 & 0xFF) / 255.0f), (float)((float)(k & 0xFF) / 255.0f), (float)((float)(k >> 24 & 0xFF) / 255.0f));
            this.xPos = i;
            this.yPos = j;
            this.func_21006_b(s, flag);
        }
    }

    public void drawStringWithShadow(String s, int i, int j, int k) {
        this.func_21005_a(s, i + 1, j + 1, k, true);
        this.func_21005_a(s, i, j, k, false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawString(String s, int i, int j, int k) {
        this.func_21005_a(s, i, j, k, false);
    }

    public int getStringWidth(String s) {
        if (s == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        while (j < s.length()) {
            char c = s.charAt(j);
            if (c == '\u00a7') {
                ++j;
            } else {
                int k = ChatAllowedCharacters.allowedCharacters.indexOf(c);
                if (k >= 0) {
                    i += this.basicWidth[k + 1];
                } else if (this.unicodeWidth[c] != 0) {
                    int l = this.unicodeWidth[c] >> 4;
                    int i1 = this.unicodeWidth[c] & 0xF;
                    if (i1 > 7) {
                        i1 = 15;
                        l = 0;
                    }
                    i += (++i1 - l) / 2 + 1;
                }
            }
            ++j;
        }
        return i;
    }

    public List listFormattedStringToWidth(String par1Str, int par2) {
        return Arrays.asList(this.wrapFormattedStringToWidth(par1Str, par2).split("\n"));
    }

    String wrapFormattedStringToWidth(String par1Str, int par2) {
        int i = this.sizeStringToWidth(par1Str, par2);
        if (par1Str.length() <= i) {
            return par1Str;
        }
        String s = par1Str.substring(0, i);
        String s1 = FontRenderer.getFormatFromString(s) + par1Str.substring(i + (par1Str.charAt(i) != ' ' ? 0 : 1));
        return s + "\n" + this.wrapFormattedStringToWidth(s1, par2);
    }

    public int getCharWidth(char par1) {
        if (par1 == '\u00a7') {
            return -1;
        }
        if (par1 == ' ') {
            return 4;
        }
        int i = ChatAllowedCharacters.allowedCharacters.indexOf(par1);
        if (i >= 0) {
            return this.basicWidth[i];
        }
        if (this.unicodeWidth[par1] != 0) {
            int j = this.unicodeWidth[par1] >>> 4;
            int k = this.unicodeWidth[par1] & 0xF;
            if (k > 7) {
                k = 15;
                j = 0;
            }
            return (++k - j) / 2 + 1;
        }
        return 0;
    }

    private int sizeStringToWidth(String par1Str, int par2) {
        int k;
        int i = par1Str.length();
        int j = 0;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c = par1Str.charAt(k);
            switch (c) {
                case '\u00a7': {
                    char c1;
                    if (k == i) break;
                    if ((c1 = par1Str.charAt(++k)) == 'l' || c1 == 'L') {
                        flag = true;
                        break;
                    }
                    if (c1 != 'r' && c1 != 'R') break;
                    flag = false;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += this.getCharWidth(c);
                    if (!flag) break;
                    ++j;
                }
            }
            if (c == '\n') {
                l = ++k;
                break;
            }
            if (j > par2) break;
        }
        if (k != i && l != -1 && l < k) {
            return l;
        }
        return k;
    }

    private static boolean isFormatColor(char par0) {
        return par0 >= '0' && par0 <= '9' || par0 >= 'a' && par0 <= 'h' || par0 >= 'A' && par0 <= 'H';
    }

    private static String getFormatFromString(String par0Str) {
        String s = "";
        int i = -1;
        int j = par0Str.length();
        while ((i = par0Str.indexOf(167, i + 1)) != -1) {
            char c;
            if (i >= j - 1 || !FontRenderer.isFormatColor(c = par0Str.charAt(i + 1))) continue;
            s = "\u00a7" + c;
        }
        return s;
    }
}

