/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GLAllocation {
    private static List<Integer> displayLists = new ArrayList<Integer>();
    private static List<Integer> field_1670_b = new ArrayList<Integer>();

    public static synchronized int generateDisplayLists(int i) {
        int j = GL11.glGenLists((int)i);
        displayLists.add(j);
        displayLists.add(i);
        return j;
    }

    public static synchronized void generateTextureNames(IntBuffer intbuffer) {
        GL11.glGenTextures((IntBuffer)intbuffer);
        int i = intbuffer.position();
        while (i < intbuffer.limit()) {
            field_1670_b.add(intbuffer.get(i));
            ++i;
        }
    }

    public static synchronized void func_28194_b(int i) {
        int j = displayLists.indexOf(i);
        GL11.glDeleteLists((int)displayLists.get(j), (int)displayLists.get(j + 1));
        displayLists.remove(j);
        displayLists.remove(j);
    }

    public static synchronized void deleteTexturesAndDisplayLists() {
        int i = 0;
        while (i < displayLists.size()) {
            GL11.glDeleteLists((int)displayLists.get(i), (int)displayLists.get(i + 1));
            i += 2;
        }
        IntBuffer intbuffer = GLAllocation.createDirectIntBuffer(field_1670_b.size());
        intbuffer.flip();
        GL11.glDeleteTextures((IntBuffer)intbuffer);
        int j = 0;
        while (j < field_1670_b.size()) {
            intbuffer.put(field_1670_b.get(j));
            ++j;
        }
        intbuffer.flip();
        GL11.glDeleteTextures((IntBuffer)intbuffer);
        displayLists.clear();
        field_1670_b.clear();
    }

    public static synchronized ByteBuffer createDirectByteBuffer(int i) {
        ByteBuffer bytebuffer = ByteBuffer.allocateDirect(i).order(ByteOrder.nativeOrder());
        return bytebuffer;
    }

    public static IntBuffer createDirectIntBuffer(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asIntBuffer();
    }

    public static FloatBuffer func_1123_d(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asFloatBuffer();
    }
}

