/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.render.RenderBlocks;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.core.entity.tile.IBlockAccess;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.BlockDoor;
import com.mojang.minecraft.core.level.tile.BlockFluids;
import com.mojang.minecraft.core.level.tile.BlockRedDustWire;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.util.MathHelper;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class RenderBlocksFlat
extends RenderBlocks {
    private IBlockAccess renderIBlockAccess;
    private int overrideBlockTexture = -1;
    private boolean flipTexture = false;
    private boolean renderAllFaces = false;
    private boolean randomWater = false;

    public RenderBlocksFlat(IBlockAccess iblockaccess) {
        this.renderIBlockAccess = iblockaccess;
    }

    public RenderBlocksFlat() {
    }

    public void setFlip(boolean flip) {
        this.flipTexture = flip;
    }

    public void renderBlockUsingTexture(Block block, int i, int j, int k, int l) {
        this.overrideBlockTexture = l;
        this.renderBlockByRenderType(block, i, j, k);
        this.overrideBlockTexture = -1;
    }

    public boolean renderBlockByRenderType(Block block, int i, int j, int k) {
        int renderType = block.getRenderType();
        block.setBlockBoundsBasedOnState(this.renderIBlockAccess, i, j, k);
        if (renderType == 0) {
            return this.renderBlock(block, i, j, k);
        }
        if (renderType == 4) {
            return this.renderFluid(block, i, j, k);
        }
        if (renderType == 13) {
            return this.renderCactus(block, i, j, k);
        }
        if (renderType == 1) {
            return this.renderPlant(block, i, j, k);
        }
        if (renderType == 6) {
            return this.renderCrops(block, i, j, k);
        }
        if (renderType == 2) {
            return this.renderTorch(block, i, j, k);
        }
        if (renderType == 3) {
            return this.renderFire(block, i, j, k);
        }
        if (renderType == 5) {
            return this.renderRedWire(block, i, j, k);
        }
        if (renderType == 8) {
            return this.renderLadder(block, i, j, k);
        }
        if (renderType == 7) {
            return this.renderDoor(block, i, j, k);
        }
        if (renderType == 9) {
            return this.renderMinecartTrack(block, i, j, k);
        }
        if (renderType == 10) {
            return this.renderStairs(block, i, j, k);
        }
        if (renderType == 11) {
            return this.renderPressurePlate(block, i, j, k);
        }
        if (renderType == 12) {
            return this.renderLever(block, i, j, k);
        }
        if (renderType == 14) {
            return this.renderGear(block, i, j, k);
        }
        return false;
    }

    public boolean renderGear(Block block, int n, int n2, int n3) {
        int n29 = n;
        int n30 = n2;
        int a = n3;
        n3 = n30;
        n2 = n29;
        Tessellator a8 = Tessellator.instance;
        int n18 = block.getBlockTextureFromSideAndMetadata(1, this.renderIBlockAccess.getBlockMetadata(n2, n3, a));
        if (this.overrideBlockTexture >= 0) {
            n18 = this.overrideBlockTexture;
        }
        float n15 = block.getBlockBrightness(this.renderIBlockAccess, n2, n3, a);
        a8.setColorOpaque_F(n15, n15, n15);
        n = ((n18 & 0xF) << 4) + 16;
        int n19 = (n18 & 0xF) << 4;
        int n31 = n18 & 0xF0;
        if ((n2 + n3 + a & 1) == 1) {
            n = (n18 & 0xF) << 4;
            n19 = ((n18 & 0xF) << 4) + 16;
        }
        float av = (float)n / 256.0f;
        float ay = ((float)n + 15.99f) / 256.0f;
        float n8 = (float)n31 / 256.0f;
        float n32 = ((float)n31 + 15.99f) / 256.0f;
        float n21 = (float)n19 / 256.0f;
        float n22 = ((float)n19 + 15.99f) / 256.0f;
        float n23 = (float)n31 / 256.0f;
        float n24 = ((float)n31 + 15.99f) / 256.0f;
        if (this.renderIBlockAccess.isBlockNormalCube(n2 - 1, n3, a)) {
            a8.addVertex((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)(a + 1) + 0.125f);
            a8.addVertex((float)n2 + 0.05f, (float)n3 - 0.125f, (float)(a + 1) + 0.125f);
            a8.addVertex((float)n2 + 0.05f, (float)n3 - 0.125f, (float)a - 0.125f);
            a8.addVertex((float)n2 + 0.05f, (float)(n3 + 1) + 0.125f, (float)a - 0.125f);
        }
        if (this.renderIBlockAccess.isBlockNormalCube(n2 + 1, n3, a)) {
            a8.addVertex((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)(a + 1) + 0.125f);
            a8.addVertex((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)(a + 1) + 0.125f);
            a8.addVertex((float)(n2 + 1) - 0.05f, (float)(n3 + 1) + 0.125f, (float)a - 0.125f);
            a8.addVertex((float)(n2 + 1) - 0.05f, (float)n3 - 0.125f, (float)a - 0.125f);
        }
        if (this.renderIBlockAccess.isBlockNormalCube(n2, n3, a - 1)) {
            a8.addVertex((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)a + 0.05f);
            a8.addVertex((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)a + 0.05f);
            a8.addVertex((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)a + 0.05f);
            a8.addVertex((float)n2 - 0.125f, (float)n3 - 0.125f, (float)a + 0.05f);
        }
        if (this.renderIBlockAccess.isBlockNormalCube(n2, n3, a + 1)) {
            a8.addVertex((float)(n2 + 1) + 0.125f, (float)(n3 + 1) + 0.125f, (float)(a + 1) - 0.05f);
            a8.addVertex((float)(n2 + 1) + 0.125f, (float)n3 - 0.125f, (float)(a + 1) - 0.05f);
            a8.addVertex((float)n2 - 0.125f, (float)n3 - 0.125f, (float)(a + 1) - 0.05f);
            a8.addVertex((float)n2 - 0.125f, (float)(n3 + 1) + 0.125f, (float)(a + 1) - 0.05f);
        }
        return true;
    }

    public boolean renderTorch(Block block, int x, int y, int z) {
        int l = this.renderIBlockAccess.getBlockMetadata(x, y, z);
        Tessellator tessellator = Tessellator.instance;
        float f = block.getBlockBrightness(this.renderIBlockAccess, x, y, z);
        if (Block.lightValue[block.blockID] > 0) {
            f = 1.0f;
        }
        int l2 = block.colorMultiplierFlat(this.renderIBlockAccess, x, y, z);
        float r = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(l2 & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(r, g, b);
        double thicknessX = 0.4f;
        double heightY = 0.5 - thicknessX;
        double thicknessZ = 0.2f;
        if (l == 1) {
            this.renderTorchFace(block, (double)x - heightY, (double)y + thicknessZ, z, -thicknessX, 0.0);
        } else if (l == 2) {
            this.renderTorchFace(block, (double)x + heightY, (double)y + thicknessZ, z, thicknessX, 0.0);
        } else if (l == 3) {
            this.renderTorchFace(block, x, (double)y + thicknessZ, (double)z - heightY, 0.0, -thicknessX);
        } else if (l == 4) {
            this.renderTorchFace(block, x, (double)y + thicknessZ, (double)z + heightY, 0.0, thicknessX);
        } else {
            this.renderTorchFace(block, x, y, z, 0.0, 0.0);
        }
        return true;
    }

    public boolean renderLever(Block block, int i, int j, int k) {
        boolean flag1;
        int l = this.renderIBlockAccess.getBlockMetadata(i, j, k);
        int i1 = l & 7;
        boolean flag = (l & 8) > 0;
        Tessellator tessellator = Tessellator.instance;
        boolean bl = flag1 = this.overrideBlockTexture >= 0;
        if (!flag1) {
            this.overrideBlockTexture = Block.cobblestone.blockIndexInTexture;
        }
        float f = 0.25f;
        float f1 = 0.1875f;
        float f2 = 0.1875f;
        if (i1 == 5) {
            block.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
        } else if (i1 == 6) {
            block.setBlockBounds(0.5f - f, 0.0f, 0.5f - f1, 0.5f + f, f2, 0.5f + f1);
        } else if (i1 == 4) {
            block.setBlockBounds(0.5f - f1, 0.5f - f, 1.0f - f2, 0.5f + f1, 0.5f + f, 1.0f);
        } else if (i1 == 3) {
            block.setBlockBounds(0.5f - f1, 0.5f - f, 0.0f, 0.5f + f1, 0.5f + f, f2);
        } else if (i1 == 2) {
            block.setBlockBounds(1.0f - f2, 0.5f - f, 0.5f - f1, 1.0f, 0.5f + f, 0.5f + f1);
        } else if (i1 == 1) {
            block.setBlockBounds(0.0f, 0.5f - f, 0.5f - f1, f2, 0.5f + f, 0.5f + f1);
        }
        this.renderBlock(block, i, j, k);
        if (!flag1) {
            this.overrideBlockTexture = -1;
        }
        float f3 = block.getBlockBrightness(this.renderIBlockAccess, i, j, k);
        if (Block.lightValue[block.blockID] > 0) {
            f3 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3, f3, f3);
        int j1 = block.getTextureIndex(0);
        if (this.overrideBlockTexture >= 0) {
            j1 = this.overrideBlockTexture;
        }
        int k1 = (j1 & 0xF) << 4;
        int l1 = j1 & 0xF0;
        float f4 = (float)k1 / 256.0f;
        float f5 = ((float)k1 + 15.99f) / 256.0f;
        float f6 = (float)l1 / 256.0f;
        float f7 = ((float)l1 + 15.99f) / 256.0f;
        Vec3D[] avec3d = new Vec3D[8];
        float f8 = 0.0625f;
        float f9 = 0.0625f;
        float f10 = 0.625f;
        avec3d[0] = Vec3D.createVector(-f8, 0.0, -f9);
        avec3d[1] = Vec3D.createVector(f8, 0.0, -f9);
        avec3d[2] = Vec3D.createVector(f8, 0.0, f9);
        avec3d[3] = Vec3D.createVector(-f8, 0.0, f9);
        avec3d[4] = Vec3D.createVector(-f8, f10, -f9);
        avec3d[5] = Vec3D.createVector(f8, f10, -f9);
        avec3d[6] = Vec3D.createVector(f8, f10, f9);
        avec3d[7] = Vec3D.createVector(-f8, f10, f9);
        int i2 = 0;
        while (i2 < 8) {
            if (flag) {
                avec3d[i2].zCoord -= 0.0625;
                avec3d[i2].rotateAroundX(0.6981317f);
            } else {
                avec3d[i2].zCoord += 0.0625;
                avec3d[i2].rotateAroundX(-0.6981317f);
            }
            if (i1 == 6) {
                avec3d[i2].rotateAroundY(1.570796f);
            }
            if (i1 < 5) {
                avec3d[i2].yCoord -= 0.375;
                avec3d[i2].rotateAroundX(1.570796f);
                if (i1 == 4) {
                    avec3d[i2].rotateAroundY(0.0f);
                }
                if (i1 == 3) {
                    avec3d[i2].rotateAroundY(3.141593f);
                }
                if (i1 == 2) {
                    avec3d[i2].rotateAroundY(1.570796f);
                }
                if (i1 == 1) {
                    avec3d[i2].rotateAroundY(-1.570796f);
                }
                avec3d[i2].xCoord += (double)i + 0.5;
                avec3d[i2].yCoord += (double)((float)j + 0.5f);
                avec3d[i2].zCoord += (double)k + 0.5;
            } else {
                avec3d[i2].xCoord += (double)i + 0.5;
                avec3d[i2].yCoord += (double)((float)j + 0.125f);
                avec3d[i2].zCoord += (double)k + 0.5;
            }
            ++i2;
        }
        Vec3D vec3d = null;
        Vec3D vec3d1 = null;
        Vec3D vec3d2 = null;
        Vec3D vec3d3 = null;
        int j2 = 0;
        while (j2 < 6) {
            if (j2 == 0) {
                f4 = (float)(k1 + 7) / 256.0f;
                f5 = ((float)(k1 + 9) - 0.01f) / 256.0f;
                f6 = (float)(l1 + 6) / 256.0f;
                f7 = ((float)(l1 + 8) - 0.01f) / 256.0f;
            } else if (j2 == 2) {
                f4 = (float)(k1 + 7) / 256.0f;
                f5 = ((float)(k1 + 9) - 0.01f) / 256.0f;
                f6 = (float)(l1 + 6) / 256.0f;
                f7 = ((float)(l1 + 16) - 0.01f) / 256.0f;
            }
            if (j2 == 0) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[2];
                vec3d3 = avec3d[3];
            } else if (j2 == 1) {
                vec3d = avec3d[7];
                vec3d1 = avec3d[6];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[4];
            } else if (j2 == 2) {
                vec3d = avec3d[1];
                vec3d1 = avec3d[0];
                vec3d2 = avec3d[4];
                vec3d3 = avec3d[5];
            } else if (j2 == 3) {
                vec3d = avec3d[2];
                vec3d1 = avec3d[1];
                vec3d2 = avec3d[5];
                vec3d3 = avec3d[6];
            } else if (j2 == 4) {
                vec3d = avec3d[3];
                vec3d1 = avec3d[2];
                vec3d2 = avec3d[6];
                vec3d3 = avec3d[7];
            } else if (j2 == 5) {
                vec3d = avec3d[0];
                vec3d1 = avec3d[3];
                vec3d2 = avec3d[7];
                vec3d3 = avec3d[4];
            }
            tessellator.addVertex(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            tessellator.addVertex(vec3d1.xCoord, vec3d1.yCoord, vec3d1.zCoord);
            tessellator.addVertex(vec3d2.xCoord, vec3d2.yCoord, vec3d2.zCoord);
            tessellator.addVertex(vec3d3.xCoord, vec3d3.yCoord, vec3d3.zCoord);
            ++j2;
        }
        return true;
    }

    public boolean renderFire(Block block, int i, int j, int k) {
        Tessellator tessellator = Tessellator.instance;
        int l = block.getTextureIndex(0);
        if (this.overrideBlockTexture >= 0) {
            l = this.overrideBlockTexture;
        }
        float f = block.getBlockBrightness(this.renderIBlockAccess, i, j, k);
        tessellator.setColorOpaque_F(f, f, f);
        int i1 = (l & 0xF) << 4;
        int j1 = l & 0xF0;
        double d = (float)i1 / 256.0f;
        double d2 = ((float)i1 + 15.99f) / 256.0f;
        double d4 = (float)j1 / 256.0f;
        double d6 = ((float)j1 + 15.99f) / 256.0f;
        float f1 = 1.4f;
        if (this.renderIBlockAccess.isBlockNormalCube(i, j - 1, k) || Block.fire.canBlockCatchFire(this.renderIBlockAccess, i, j - 1, k)) {
            double d8 = (double)i + 0.5 + 0.2;
            double d9 = (double)i + 0.5 - 0.2;
            double d12 = (double)k + 0.5 + 0.2;
            double d14 = (double)k + 0.5 - 0.2;
            double d16 = (double)i + 0.5 - 0.3;
            double d18 = (double)i + 0.5 + 0.3;
            double d20 = (double)k + 0.5 - 0.3;
            double d22 = (double)k + 0.5 + 0.3;
            tessellator.addVertex(d16, (float)j + f1, k + 1);
            tessellator.addVertex(d8, j + 0, k + 1);
            tessellator.addVertex(d8, j + 0, k + 0);
            tessellator.addVertex(d16, (float)j + f1, k + 0);
            tessellator.addVertex(d18, (float)j + f1, k + 0);
            tessellator.addVertex(d9, j + 0, k + 0);
            tessellator.addVertex(d9, j + 0, k + 1);
            tessellator.addVertex(d18, (float)j + f1, k + 1);
            d = (float)i1 / 256.0f;
            d2 = ((float)i1 + 15.99f) / 256.0f;
            d4 = (float)(j1 + 16) / 256.0f;
            d6 = ((float)j1 + 15.99f + 16.0f) / 256.0f;
            tessellator.addVertex(i + 1, (float)j + f1, d22);
            tessellator.addVertex(i + 1, j + 0, d14);
            tessellator.addVertex(i + 0, j + 0, d14);
            tessellator.addVertex(i + 0, (float)j + f1, d22);
            tessellator.addVertex(i + 0, (float)j + f1, d20);
            tessellator.addVertex(i + 0, j + 0, d12);
            tessellator.addVertex(i + 1, j + 0, d12);
            tessellator.addVertex(i + 1, (float)j + f1, d20);
            d8 = (double)i + 0.5 - 0.5;
            d9 = (double)i + 0.5 + 0.5;
            d12 = (double)k + 0.5 - 0.5;
            d14 = (double)k + 0.5 + 0.5;
            d16 = (double)i + 0.5 - 0.4;
            d18 = (double)i + 0.5 + 0.4;
            d20 = (double)k + 0.5 - 0.4;
            d22 = (double)k + 0.5 + 0.4;
            tessellator.addVertex(d16, (float)j + f1, k + 0);
            tessellator.addVertex(d8, j + 0, k + 0);
            tessellator.addVertex(d8, j + 0, k + 1);
            tessellator.addVertex(d16, (float)j + f1, k + 1);
            tessellator.addVertex(d18, (float)j + f1, k + 1);
            tessellator.addVertex(d9, j + 0, k + 1);
            tessellator.addVertex(d9, j + 0, k + 0);
            tessellator.addVertex(d18, (float)j + f1, k + 0);
            d = (float)i1 / 256.0f;
            d2 = ((float)i1 + 15.99f) / 256.0f;
            d4 = (float)j1 / 256.0f;
            d6 = ((float)j1 + 15.99f) / 256.0f;
            tessellator.addVertex(i + 0, (float)j + f1, d22);
            tessellator.addVertex(i + 0, j + 0, d14);
            tessellator.addVertex(i + 1, j + 0, d14);
            tessellator.addVertex(i + 1, (float)j + f1, d22);
            tessellator.addVertex(i + 1, (float)j + f1, d20);
            tessellator.addVertex(i + 1, j + 0, d12);
            tessellator.addVertex(i + 0, j + 0, d12);
            tessellator.addVertex(i + 0, (float)j + f1, d20);
        } else {
            float f3 = 0.2f;
            float f4 = 0.0625f;
            if ((i + j + k & 1) == 1) {
                d = (float)i1 / 256.0f;
                d2 = ((float)i1 + 15.99f) / 256.0f;
                d4 = (float)(j1 + 16) / 256.0f;
                d6 = ((float)j1 + 15.99f + 16.0f) / 256.0f;
            }
            if ((i / 2 + j / 2 + k / 2 & 1) == 1) {
                double d10 = d2;
                d2 = d;
                d = d10;
            }
            if (Block.fire.canBlockCatchFire(this.renderIBlockAccess, i - 1, j, k)) {
                tessellator.addVertex((float)i + f3, (float)j + f1 + f4, k + 1);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 1);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex((float)i + f3, (float)j + f1 + f4, k + 0);
                tessellator.addVertex((float)i + f3, (float)j + f1 + f4, k + 0);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 1);
                tessellator.addVertex((float)i + f3, (float)j + f1 + f4, k + 1);
            }
            if (Block.fire.canBlockCatchFire(this.renderIBlockAccess, i + 1, j, k)) {
                tessellator.addVertex((float)(i + 1) - f3, (float)j + f1 + f4, k + 0);
                tessellator.addVertex(i + 1 - 0, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex(i + 1 - 0, (float)(j + 0) + f4, k + 1);
                tessellator.addVertex((float)(i + 1) - f3, (float)j + f1 + f4, k + 1);
                tessellator.addVertex((float)(i + 1) - f3, (float)j + f1 + f4, k + 1);
                tessellator.addVertex(i + 1 - 0, (float)(j + 0) + f4, k + 1);
                tessellator.addVertex(i + 1 - 0, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex((float)(i + 1) - f3, (float)j + f1 + f4, k + 0);
            }
            if (Block.fire.canBlockCatchFire(this.renderIBlockAccess, i, j, k - 1)) {
                tessellator.addVertex(i + 0, (float)j + f1 + f4, (float)k + f3);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex(i + 1, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex(i + 1, (float)j + f1 + f4, (float)k + f3);
                tessellator.addVertex(i + 1, (float)j + f1 + f4, (float)k + f3);
                tessellator.addVertex(i + 1, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 0);
                tessellator.addVertex(i + 0, (float)j + f1 + f4, (float)k + f3);
            }
            if (Block.fire.canBlockCatchFire(this.renderIBlockAccess, i, j, k + 1)) {
                tessellator.addVertex(i + 1, (float)j + f1 + f4, (float)(k + 1) - f3);
                tessellator.addVertex(i + 1, (float)(j + 0) + f4, k + 1 - 0);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 1 - 0);
                tessellator.addVertex(i + 0, (float)j + f1 + f4, (float)(k + 1) - f3);
                tessellator.addVertex(i + 0, (float)j + f1 + f4, (float)(k + 1) - f3);
                tessellator.addVertex(i + 0, (float)(j + 0) + f4, k + 1 - 0);
                tessellator.addVertex(i + 1, (float)(j + 0) + f4, k + 1 - 0);
                tessellator.addVertex(i + 1, (float)j + f1 + f4, (float)(k + 1) - f3);
            }
            if (Block.fire.canBlockCatchFire(this.renderIBlockAccess, i, j + 1, k)) {
                double d11 = (double)i + 0.5 + 0.5;
                double d13 = (double)i + 0.5 - 0.5;
                double d15 = (double)k + 0.5 + 0.5;
                double d17 = (double)k + 0.5 - 0.5;
                double d19 = (double)i + 0.5 - 0.5;
                double d21 = (double)i + 0.5 + 0.5;
                double d23 = (double)k + 0.5 - 0.5;
                double d24 = (double)k + 0.5 + 0.5;
                double d1 = (float)i1 / 256.0f;
                double d3 = ((float)i1 + 15.99f) / 256.0f;
                double d5 = (float)j1 / 256.0f;
                double d7 = ((float)j1 + 15.99f) / 256.0f;
                float f2 = -0.2f;
                if ((i + ++j + k & 1) == 0) {
                    tessellator.addVertex(d19, (float)j + f2, k + 0);
                    tessellator.addVertex(d11, j + 0, k + 0);
                    tessellator.addVertex(d11, j + 0, k + 1);
                    tessellator.addVertex(d19, (float)j + f2, k + 1);
                    d1 = (float)i1 / 256.0f;
                    d3 = ((float)i1 + 15.99f) / 256.0f;
                    d5 = (float)(j1 + 16) / 256.0f;
                    d7 = ((float)j1 + 15.99f + 16.0f) / 256.0f;
                    tessellator.addVertex(d21, (float)j + f2, k + 1);
                    tessellator.addVertex(d13, j + 0, k + 1);
                    tessellator.addVertex(d13, j + 0, k + 0);
                    tessellator.addVertex(d21, (float)j + f2, k + 0);
                } else {
                    tessellator.addVertex(i + 0, (float)j + f2, d24);
                    tessellator.addVertex(i + 0, j + 0, d17);
                    tessellator.addVertex(i + 1, j + 0, d17);
                    tessellator.addVertex(i + 1, (float)j + f2, d24);
                    d1 = (float)i1 / 256.0f;
                    d3 = ((float)i1 + 15.99f) / 256.0f;
                    d5 = (float)(j1 + 16) / 256.0f;
                    d7 = ((float)j1 + 15.99f + 16.0f) / 256.0f;
                    tessellator.addVertex(i + 1, (float)j + f2, d23);
                    tessellator.addVertex(i + 1, j + 0, d15);
                    tessellator.addVertex(i + 0, j + 0, d15);
                    tessellator.addVertex(i + 0, (float)j + f2, d23);
                }
            }
        }
        return true;
    }

    public boolean renderRedWire(Block block, int x, int y, int z) {
        boolean flag3;
        Tessellator tessellator = Tessellator.instance;
        int l = block.getBlockTextureFromSideAndMetadata(1, this.renderIBlockAccess.getBlockMetadata(x, y, z));
        if (this.overrideBlockTexture >= 0) {
            l = this.overrideBlockTexture;
        }
        int l2 = block.colorMultiplierFlat(this.renderIBlockAccess, x, y, z);
        float r = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(l2 & 0xFF) / 255.0f;
        tessellator.setColorRGBA_F(r, g, b, 0.7f);
        int i1 = (l & 0xF) << 4;
        int j1 = l & 0xF0;
        double d = (float)i1 / 256.0f;
        double d1 = ((float)i1 + 15.99f) / 256.0f;
        double d2 = (float)j1 / 256.0f;
        double d3 = ((float)j1 + 15.99f) / 256.0f;
        float f1 = 0.0f;
        float f2 = 0.03125f;
        boolean flag = BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x - 1, y, z) || !this.renderIBlockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x - 1, y - 1, z);
        boolean flag1 = BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x + 1, y, z) || !this.renderIBlockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x + 1, y - 1, z);
        boolean flag2 = BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x, y, z - 1) || !this.renderIBlockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x, y - 1, z - 1);
        boolean bl = flag3 = BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x, y, z + 1) || !this.renderIBlockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x, y - 1, z + 1);
        if (!this.renderIBlockAccess.isBlockNormalCube(x, y + 1, z)) {
            if (this.renderIBlockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x - 1, y + 1, z)) {
                flag = true;
            }
            if (this.renderIBlockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x + 1, y + 1, z)) {
                flag1 = true;
            }
            if (this.renderIBlockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x, y + 1, z - 1)) {
                flag2 = true;
            }
            if (this.renderIBlockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedDustWire.isPowerProviderOrWire(this.renderIBlockAccess, x, y + 1, z + 1)) {
                flag3 = true;
            }
        }
        float f3 = 0.3125f;
        float f4 = x + 0;
        float f5 = x + 1;
        float f6 = z + 0;
        float f7 = z + 1;
        int byte0 = 0;
        if ((flag || flag1) && !flag2 && !flag3) {
            byte0 = 1;
        }
        if ((flag2 || flag3) && !flag1 && !flag) {
            byte0 = 2;
        }
        if (byte0 != 0) {
            d = (float)(i1 + 16) / 256.0f;
            d1 = ((float)(i1 + 16) + 15.99f) / 256.0f;
            d2 = (float)j1 / 256.0f;
            d3 = ((float)j1 + 15.99f) / 256.0f;
        }
        if (byte0 == 0) {
            if (flag1 || flag2 || flag3 || flag) {
                if (!flag) {
                    f4 += f3;
                }
                if (!flag) {
                    d += (double)(f3 / 16.0f);
                }
                if (!flag1) {
                    f5 -= f3;
                }
                if (!flag1) {
                    d1 -= (double)(f3 / 16.0f);
                }
                if (!flag2) {
                    f6 += f3;
                }
                if (!flag2) {
                    d2 += (double)(f3 / 16.0f);
                }
                if (!flag3) {
                    f7 -= f3;
                }
                if (!flag3) {
                    d3 -= (double)(f3 / 16.0f);
                }
            }
            tessellator.addVertex(f5 + f1, (float)y + f2, f7 + f1);
            tessellator.addVertex(f5 + f1, (float)y + f2, f6 - f1);
            tessellator.addVertex(f4 - f1, (float)y + f2, f6 - f1);
            tessellator.addVertex(f4 - f1, (float)y + f2, f7 + f1);
        }
        if (byte0 == 1) {
            tessellator.addVertex(f5 + f1, (float)y + f2, f7 + f1);
            tessellator.addVertex(f5 + f1, (float)y + f2, f6 - f1);
            tessellator.addVertex(f4 - f1, (float)y + f2, f6 - f1);
            tessellator.addVertex(f4 - f1, (float)y + f2, f7 + f1);
        }
        if (byte0 == 2) {
            tessellator.addVertex(f5 + f1, (float)y + f2, f7 + f1);
            tessellator.addVertex(f5 + f1, (float)y + f2, f6 - f1);
            tessellator.addVertex(f4 - f1, (float)y + f2, f6 - f1);
            tessellator.addVertex(f4 - f1, (float)y + f2, f7 + f1);
        }
        d = (float)(i1 + 16) / 256.0f;
        d1 = ((float)(i1 + 16) + 15.99f) / 256.0f;
        d2 = (float)j1 / 256.0f;
        d3 = ((float)j1 + 15.99f) / 256.0f;
        if (!this.renderIBlockAccess.isBlockNormalCube(x, y + 1, z)) {
            if (this.renderIBlockAccess.isBlockNormalCube(x - 1, y, z) && this.renderIBlockAccess.getBlockId(x - 1, y + 1, z) == Block.redWire.blockID) {
                tessellator.addVertex((float)x + f2, (float)(y + 1) + f1, (float)(z + 1) + f1);
                tessellator.addVertex((float)x + f2, (float)(y + 0) - f1, (float)(z + 1) + f1);
                tessellator.addVertex((float)x + f2, (float)(y + 0) - f1, (float)(z + 0) - f1);
                tessellator.addVertex((float)x + f2, (float)(y + 1) + f1, (float)(z + 0) - f1);
            }
            if (this.renderIBlockAccess.isBlockNormalCube(x + 1, y, z) && this.renderIBlockAccess.getBlockId(x + 1, y + 1, z) == Block.redWire.blockID) {
                tessellator.addVertex((float)(x + 1) - f2, (float)(y + 0) - f1, (float)(z + 1) + f1);
                tessellator.addVertex((float)(x + 1) - f2, (float)(y + 1) + f1, (float)(z + 1) + f1);
                tessellator.addVertex((float)(x + 1) - f2, (float)(y + 1) + f1, (float)(z + 0) - f1);
                tessellator.addVertex((float)(x + 1) - f2, (float)(y + 0) - f1, (float)(z + 0) - f1);
            }
            if (this.renderIBlockAccess.isBlockNormalCube(x, y, z - 1) && this.renderIBlockAccess.getBlockId(x, y + 1, z - 1) == Block.redWire.blockID) {
                tessellator.addVertex((float)(x + 1) + f1, (float)(y + 0) - f1, (float)z + f2);
                tessellator.addVertex((float)(x + 1) + f1, (float)(y + 1) + f1, (float)z + f2);
                tessellator.addVertex((float)(x + 0) - f1, (float)(y + 1) + f1, (float)z + f2);
                tessellator.addVertex((float)(x + 0) - f1, (float)(y + 0) - f1, (float)z + f2);
            }
            if (this.renderIBlockAccess.isBlockNormalCube(x, y, z + 1) && this.renderIBlockAccess.getBlockId(x, y + 1, z + 1) == Block.redWire.blockID) {
                tessellator.addVertex((float)(x + 1) + f1, (float)(y + 1) + f1, (float)(z + 1) - f2);
                tessellator.addVertex((float)(x + 1) + f1, (float)(y + 0) - f1, (float)(z + 1) - f2);
                tessellator.addVertex((float)(x + 0) - f1, (float)(y + 0) - f1, (float)(z + 1) - f2);
                tessellator.addVertex((float)(x + 0) - f1, (float)(y + 1) + f1, (float)(z + 1) - f2);
            }
        }
        return true;
    }

    public boolean renderMinecartTrack(Block block, int i, int j, int k) {
        Tessellator tessellator = Tessellator.instance;
        int l = this.renderIBlockAccess.getBlockMetadata(i, j, k);
        int i1 = block.getBlockTextureFromSideAndMetadata(0, l);
        if (this.overrideBlockTexture >= 0) {
            i1 = this.overrideBlockTexture;
        }
        float f = block.getBlockBrightness(this.renderIBlockAccess, i, j, k);
        tessellator.setColorOpaque_F(f, f, f);
        int j1 = (i1 & 0xF) << 4;
        int k1 = i1 & 0xF0;
        double d = (float)j1 / 256.0f;
        double d1 = ((float)j1 + 15.99f) / 256.0f;
        double d2 = (float)k1 / 256.0f;
        double d3 = ((float)k1 + 15.99f) / 256.0f;
        float f1 = 0.0625f;
        float f2 = i + 1;
        float f3 = i + 1;
        float f4 = i + 0;
        float f5 = i + 0;
        float f6 = k + 0;
        float f7 = k + 1;
        float f8 = k + 1;
        float f9 = k + 0;
        float f10 = (float)j + f1;
        float f11 = (float)j + f1;
        float f12 = (float)j + f1;
        float f13 = (float)j + f1;
        if (l == 1 || l == 2 || l == 3 || l == 7) {
            f2 = f5 = (float)(i + 1);
            f3 = f4 = (float)(i + 0);
            f6 = f7 = (float)(k + 1);
            f8 = f9 = (float)(k + 0);
        } else if (l == 8) {
            f2 = f3 = (float)(i + 0);
            f4 = f5 = (float)(i + 1);
            f6 = f9 = (float)(k + 1);
            f7 = f8 = (float)(k + 0);
        } else if (l == 9) {
            f2 = f5 = (float)(i + 0);
            f3 = f4 = (float)(i + 1);
            f6 = f7 = (float)(k + 0);
            f8 = f9 = (float)(k + 1);
        }
        if (l == 2 || l == 4) {
            f10 += 1.0f;
            f13 += 1.0f;
        } else if (l == 3 || l == 5) {
            f11 += 1.0f;
            f12 += 1.0f;
        }
        tessellator.addVertex(f2, f10, f6);
        tessellator.addVertex(f3, f11, f7);
        tessellator.addVertex(f4, f12, f8);
        tessellator.addVertex(f5, f13, f9);
        tessellator.addVertex(f5, f13, f9);
        tessellator.addVertex(f4, f12, f8);
        tessellator.addVertex(f3, f11, f7);
        tessellator.addVertex(f2, f10, f6);
        return true;
    }

    public boolean renderLadder(Block block, int i, int j, int k) {
        Tessellator tessellator = Tessellator.instance;
        int l = block.getTextureIndex(0);
        if (this.overrideBlockTexture >= 0) {
            l = this.overrideBlockTexture;
        }
        float f = block.getBlockBrightness(this.renderIBlockAccess, i, j, k);
        tessellator.setColorOpaque_F(f, f, f);
        int i1 = (l & 0xF) << 4;
        int j1 = l & 0xF0;
        double d = (float)i1 / 256.0f;
        double d1 = ((float)i1 + 15.99f) / 256.0f;
        double d2 = (float)j1 / 256.0f;
        double d3 = ((float)j1 + 15.99f) / 256.0f;
        int k1 = this.renderIBlockAccess.getBlockMetadata(i, j, k);
        float f1 = 0.0f;
        float f2 = 0.05f;
        if (k1 == 5) {
            tessellator.addVertex((float)i + f2, (float)(j + 1) + f1, (float)(k + 1) + f1);
            tessellator.addVertex((float)i + f2, (float)(j + 0) - f1, (float)(k + 1) + f1);
            tessellator.addVertex((float)i + f2, (float)(j + 0) - f1, (float)(k + 0) - f1);
            tessellator.addVertex((float)i + f2, (float)(j + 1) + f1, (float)(k + 0) - f1);
        }
        if (k1 == 4) {
            tessellator.addVertex((float)(i + 1) - f2, (float)(j + 0) - f1, (float)(k + 1) + f1);
            tessellator.addVertex((float)(i + 1) - f2, (float)(j + 1) + f1, (float)(k + 1) + f1);
            tessellator.addVertex((float)(i + 1) - f2, (float)(j + 1) + f1, (float)(k + 0) - f1);
            tessellator.addVertex((float)(i + 1) - f2, (float)(j + 0) - f1, (float)(k + 0) - f1);
        }
        if (k1 == 3) {
            tessellator.addVertex((float)(i + 1) + f1, (float)(j + 0) - f1, (float)k + f2);
            tessellator.addVertex((float)(i + 1) + f1, (float)(j + 1) + f1, (float)k + f2);
            tessellator.addVertex((float)(i + 0) - f1, (float)(j + 1) + f1, (float)k + f2);
            tessellator.addVertex((float)(i + 0) - f1, (float)(j + 0) - f1, (float)k + f2);
        }
        if (k1 == 2) {
            tessellator.addVertex((float)(i + 1) + f1, (float)(j + 1) + f1, (float)(k + 1) - f2);
            tessellator.addVertex((float)(i + 1) + f1, (float)(j + 0) - f1, (float)(k + 1) - f2);
            tessellator.addVertex((float)(i + 0) - f1, (float)(j + 0) - f1, (float)(k + 1) - f2);
            tessellator.addVertex((float)(i + 0) - f1, (float)(j + 1) + f1, (float)(k + 1) - f2);
        }
        return true;
    }

    public boolean renderPlant(Block block, int x, int y, int z) {
        Tessellator tessellator = Tessellator.instance;
        int l2 = block.colorMultiplierFlat(this.renderIBlockAccess, x, y, z);
        float r = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(l2 & 0xFF) / 255.0f;
        tessellator.setColorRGBA_F(r, g, b, 0.7f);
        this.renderCrossedSquares(block, this.renderIBlockAccess.getBlockMetadata(x, y, z), x, y, z);
        return true;
    }

    public boolean renderCrops(Block block, int x, int y, int z) {
        Tessellator tessellator = Tessellator.instance;
        int l2 = block.colorMultiplierFlat(this.renderIBlockAccess, x, y, z);
        float r = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(l2 & 0xFF) / 255.0f;
        tessellator.setColorRGBA_F(r, g, b, 0.7f);
        this.func_1245_b(block, this.renderIBlockAccess.getBlockMetadata(x, y, z), x, (float)y - 0.0625f, z);
        return true;
    }

    public void renderTorchFace(Block block, double x, double y, double z, double leanX, double leanZ) {
        Tessellator tessellator = Tessellator.instance;
        int textureIndex = block.getTextureIndex(0);
        if (this.overrideBlockTexture >= 0) {
            textureIndex = this.overrideBlockTexture;
        }
        int topA = (textureIndex & 0xF) << 4;
        int topB = textureIndex & 0xF0;
        float top1 = (float)topA / 256.0f;
        float top2 = ((float)topA + 15.99f) / 256.0f;
        float top3 = (float)topB / 256.0f;
        float top4 = ((float)topB + 15.99f) / 256.0f;
        double topOff1 = (double)top1 + 0.02734375;
        double topOff2 = (double)top3 + 0.0234375;
        double topOff3 = (double)top1 + 0.03515625;
        double topOff4 = (double)top3 + 0.03125;
        double otherX = (x += 0.5) - 0.0625;
        double otherX2 = x + 0.0625;
        double otherZ = (z += 0.5) - 0.0625;
        double otherZ2 = z + 0.0625;
        double otherY = 0.0625;
        double otherY2 = 0.625;
        tessellator.addVertex(x + leanX * (1.0 - otherY2) - otherY, y + otherY2, z + leanZ * (1.0 - otherY2) - otherY);
        tessellator.addVertex(x + leanX * (1.0 - otherY2) - otherY, y + otherY2, z + leanZ * (1.0 - otherY2) + otherY);
        tessellator.addVertex(x + leanX * (1.0 - otherY2) + otherY, y + otherY2, z + leanZ * (1.0 - otherY2) + otherY);
        tessellator.addVertex(x + leanX * (1.0 - otherY2) + otherY, y + otherY2, z + leanZ * (1.0 - otherY2) - otherY);
        tessellator.addVertex(x - otherY, y + 0.625, otherZ);
        tessellator.addVertex(x - otherY + leanX, y + 0.0, otherZ + leanZ);
        tessellator.addVertex(x - otherY + leanX, y + 0.0, otherZ2 + leanZ);
        tessellator.addVertex(x - otherY, y + 0.625, otherZ2);
        tessellator.addVertex(x + otherY, y + 0.625, otherZ2);
        tessellator.addVertex(x + leanX + otherY, y + 0.0, otherZ2 + leanZ);
        tessellator.addVertex(x + leanX + otherY, y + 0.0, otherZ + leanZ);
        tessellator.addVertex(x + otherY, y + 0.625, otherZ);
        tessellator.addVertex(otherX, y + 0.625, z + otherY);
        tessellator.addVertex(otherX + leanX, y + 0.0, z + otherY + leanZ);
        tessellator.addVertex(otherX2 + leanX, y + 0.0, z + otherY + leanZ);
        tessellator.addVertex(otherX2, y + 0.625, z + otherY);
        tessellator.addVertex(otherX2, y + 0.625, z - otherY);
        tessellator.addVertex(otherX2 + leanX, y + 0.0, z - otherY + leanZ);
        tessellator.addVertex(otherX + leanX, y + 0.0, z - otherY + leanZ);
        tessellator.addVertex(otherX, y + 0.625, z - otherY);
    }

    public void renderCrossedSquares(Block block, int i, double d, double d1, double d2) {
        Tessellator tessellator = Tessellator.instance;
        int j = block.getBlockTextureFromSideAndMetadata(0, i);
        if (this.overrideBlockTexture >= 0) {
            j = this.overrideBlockTexture;
        }
        int k = (j & 0xF) << 4;
        int l = j & 0xF0;
        double d3 = (float)k / 256.0f;
        double d4 = ((float)k + 15.99f) / 256.0f;
        double d5 = (float)l / 256.0f;
        double d6 = ((float)l + 15.99f) / 256.0f;
        double d7 = d + 0.5 - 0.25;
        double d8 = d + 0.5 + 0.25;
        double d9 = d2 + 0.5 - 0.25;
        double d10 = d2 + 0.5 + 0.25;
        tessellator.addVertex(d7, d1 + 0.5, d9);
        tessellator.addVertex(d7, d1 + 0.0, d9);
        tessellator.addVertex(d8, d1 + 0.0, d10);
        tessellator.addVertex(d8, d1 + 0.5, d10);
        tessellator.addVertex(d8, d1 + 0.5, d10);
        tessellator.addVertex(d8, d1 + 0.0, d10);
        tessellator.addVertex(d7, d1 + 0.0, d9);
        tessellator.addVertex(d7, d1 + 0.5, d9);
        tessellator.addVertex(d7, d1 + 0.5, d10);
        tessellator.addVertex(d7, d1 + 0.0, d10);
        tessellator.addVertex(d8, d1 + 0.0, d9);
        tessellator.addVertex(d8, d1 + 0.5, d9);
        tessellator.addVertex(d8, d1 + 0.5, d9);
        tessellator.addVertex(d8, d1 + 0.0, d9);
        tessellator.addVertex(d7, d1 + 0.0, d10);
        tessellator.addVertex(d7, d1 + 0.5, d10);
    }

    public void func_1245_b(Block block, int i, double d, double d1, double d2) {
        Tessellator tessellator = Tessellator.instance;
        int j = block.getBlockTextureFromSideAndMetadata(0, i);
        if (this.overrideBlockTexture >= 0) {
            j = this.overrideBlockTexture;
        }
        int k = (j & 0xF) << 4;
        int l = j & 0xF0;
        double d3 = (float)k / 256.0f;
        double d4 = ((float)k + 15.99f) / 256.0f;
        double d5 = (float)l / 256.0f;
        double d6 = ((float)l + 15.99f) / 256.0f;
        double d7 = d + 0.5 - 0.25;
        double d8 = d + 0.5 + 0.25;
        double d9 = d2 + 0.5 - 0.5;
        double d10 = d2 + 0.5 + 0.5;
        tessellator.addVertex(d7, d1 + 1.0, d9);
        tessellator.addVertex(d7, d1 + 0.0, d9);
        tessellator.addVertex(d7, d1 + 0.0, d10);
        tessellator.addVertex(d7, d1 + 1.0, d10);
        tessellator.addVertex(d7, d1 + 1.0, d10);
        tessellator.addVertex(d7, d1 + 0.0, d10);
        tessellator.addVertex(d7, d1 + 0.0, d9);
        tessellator.addVertex(d7, d1 + 1.0, d9);
        tessellator.addVertex(d8, d1 + 1.0, d10);
        tessellator.addVertex(d8, d1 + 0.0, d10);
        tessellator.addVertex(d8, d1 + 0.0, d9);
        tessellator.addVertex(d8, d1 + 1.0, d9);
        tessellator.addVertex(d8, d1 + 1.0, d9);
        tessellator.addVertex(d8, d1 + 0.0, d9);
        tessellator.addVertex(d8, d1 + 0.0, d10);
        tessellator.addVertex(d8, d1 + 1.0, d10);
        d7 = d + 0.5 - 0.5;
        d8 = d + 0.5 + 0.5;
        d9 = d2 + 0.5 - 0.25;
        d10 = d2 + 0.5 + 0.25;
        tessellator.addVertex(d7, d1 + 1.0, d9);
        tessellator.addVertex(d7, d1 + 0.0, d9);
        tessellator.addVertex(d8, d1 + 0.0, d9);
        tessellator.addVertex(d8, d1 + 1.0, d9);
        tessellator.addVertex(d8, d1 + 1.0, d9);
        tessellator.addVertex(d8, d1 + 0.0, d9);
        tessellator.addVertex(d7, d1 + 0.0, d9);
        tessellator.addVertex(d7, d1 + 1.0, d9);
        tessellator.addVertex(d8, d1 + 1.0, d10);
        tessellator.addVertex(d8, d1 + 0.0, d10);
        tessellator.addVertex(d7, d1 + 0.0, d10);
        tessellator.addVertex(d7, d1 + 1.0, d10);
        tessellator.addVertex(d7, d1 + 1.0, d10);
        tessellator.addVertex(d7, d1 + 0.0, d10);
        tessellator.addVertex(d8, d1 + 0.0, d10);
        tessellator.addVertex(d8, d1 + 1.0, d10);
    }

    public float getRandomXYZOffset_Y(int x, int y, int z) {
        if (this.randomWater) {
            Random rand = new Random();
            rand.setSeed(x * x * y * y * z * z);
            return (rand.nextFloat() - 0.5f) / 10.0f;
        }
        return 0.0f;
    }

    public boolean renderFluid(Block block, int posX, int posY, int posZ) {
        Tessellator tessellator = Tessellator.instance;
        boolean topBlockCheck = block.shouldSideBeRendered(this.renderIBlockAccess, posX, posY + 1, posZ, 1);
        boolean bottomBlockCheck = block.shouldSideBeRendered(this.renderIBlockAccess, posX, posY - 1, posZ, 0);
        int blockColorFlat = block.colorMultiplierFlat(this.renderIBlockAccess, posX, posY, posZ);
        float r = (float)(blockColorFlat >> 16 & 0xFF) / 255.0f;
        float g = (float)(blockColorFlat >> 8 & 0xFF) / 255.0f;
        float b = (float)(blockColorFlat & 0xFF) / 255.0f;
        boolean[] blockFaceCheck = new boolean[]{block.shouldSideBeRendered(this.renderIBlockAccess, posX, posY, posZ - 1, 2), block.shouldSideBeRendered(this.renderIBlockAccess, posX, posY, posZ + 1, 3), block.shouldSideBeRendered(this.renderIBlockAccess, posX - 1, posY, posZ, 4), block.shouldSideBeRendered(this.renderIBlockAccess, posX + 1, posY, posZ, 5)};
        if (!(topBlockCheck || bottomBlockCheck || blockFaceCheck[0] || blockFaceCheck[1] || blockFaceCheck[2] || blockFaceCheck[3])) {
            return false;
        }
        boolean flag2 = false;
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        double d = 0.0;
        double d1 = 1.0;
        Material material = block.blockMaterial;
        int texIndexCheck = this.renderIBlockAccess.getBlockMetadata(posX, posY, posZ);
        float f4 = this.getFluidSideHeight(posX, posY, posZ, material) + this.getRandomXYZOffset_Y(posX, posY, posZ);
        float f5 = this.getFluidSideHeight(posX, posY, posZ + 1, material) + this.getRandomXYZOffset_Y(posX, posY, posZ + 1);
        float f6 = this.getFluidSideHeight(posX + 1, posY, posZ + 1, material) + this.getRandomXYZOffset_Y(posX + 1, posY, posZ + 1);
        float f7 = this.getFluidSideHeight(posX + 1, posY, posZ, material) + this.getRandomXYZOffset_Y(posX + 1, posY, posZ);
        if (this.renderAllFaces || topBlockCheck) {
            flag2 = true;
            int i1 = block.getTextureIndex(this.renderIBlockAccess, posX, posY, posZ, 1);
            float f9 = (float)BlockFluids.getFlowDirectionRadians(this.renderIBlockAccess, posX, posY, posZ, material);
            if (f9 > -999.0f) {
                i1 = block.getTextureIndex(this.renderIBlockAccess, posX, posY, posZ, 7);
            }
            int l1 = (i1 & 0xF) << 4;
            int j2 = i1 & 0xF0;
            double d2 = ((double)l1 + 8.0) / 256.0;
            double d3 = ((double)j2 + 8.0) / 256.0;
            if (f9 < -999.0f) {
                f9 = 0.0f;
            } else {
                d2 = (float)(l1 + 16) / 256.0f;
                d3 = (float)(j2 + 16) / 256.0f;
            }
            float f11 = MathHelper.sin(f9) * 8.0f / 256.0f;
            float f13 = MathHelper.cos(f9) * 8.0f / 256.0f;
            float f15 = block.getBlockBrightness(this.renderIBlockAccess, posX, posY, posZ);
            tessellator.setColorRGBA_F(r, g, b, 0.7f);
            tessellator.addVertex(posX + 0, (float)posY + f4, posZ + 0);
            tessellator.addVertex(posX + 0, (float)posY + f5, posZ + 1);
            tessellator.addVertex(posX + 1, (float)posY + f6, posZ + 1);
            tessellator.addVertex(posX + 1, (float)posY + f7, posZ + 0);
        }
        if (this.renderAllFaces || bottomBlockCheck) {
            float f8 = block.getBlockBrightness(this.renderIBlockAccess, posX, posY - 1, posZ);
            tessellator.setColorRGBA_F(r * f * f8, g * f * f8, b * f * f8, 0.7f);
            this.textureFaceBelow(block, posX, posY, posZ, block.getTextureIndex(0));
            flag2 = true;
        }
        int sideIterator = 0;
        while (sideIterator < 4) {
            int pointX = posX;
            int pointY = posY;
            int pointZ = posZ;
            if (sideIterator == 0) {
                --pointZ;
            }
            if (sideIterator == 1) {
                ++pointZ;
            }
            if (sideIterator == 2) {
                --pointX;
            }
            if (sideIterator == 3) {
                ++pointX;
            }
            int l2 = block.getTextureIndex(this.renderIBlockAccess, posX, posY, posZ, sideIterator + 2);
            int i3 = (l2 & 0xF) << 4;
            int j3 = l2 & 0xF0;
            if (this.renderAllFaces || blockFaceCheck[sideIterator]) {
                float f18;
                float f16;
                float f17;
                float f14;
                float f12;
                float f10;
                if (sideIterator == 0) {
                    f10 = f4;
                    f12 = f7;
                    f14 = posX;
                    f17 = posX + 1;
                    f16 = posZ;
                    f18 = posZ;
                } else if (sideIterator == 1) {
                    f10 = f6;
                    f12 = f5;
                    f14 = posX + 1;
                    f17 = posX;
                    f16 = posZ + 1;
                    f18 = posZ + 1;
                } else if (sideIterator == 2) {
                    f10 = f5;
                    f12 = f4;
                    f14 = posX;
                    f17 = posX;
                    f16 = posZ + 1;
                    f18 = posZ;
                } else {
                    f10 = f7;
                    f12 = f6;
                    f14 = posX + 1;
                    f17 = posX + 1;
                    f16 = posZ;
                    f18 = posZ + 1;
                }
                flag2 = true;
                double d4 = (float)(i3 + 0) / 256.0f;
                double d5 = ((double)(i3 + 16) - 0.01) / 256.0;
                double d6 = ((float)j3 + (1.0f - f10) * 16.0f) / 256.0f;
                double d7 = ((float)j3 + (1.0f - f12) * 16.0f) / 256.0f;
                double d8 = ((double)(j3 + 16) - 0.01) / 256.0;
                float f19 = block.getBlockBrightness(this.renderIBlockAccess, pointX, pointY, pointZ);
                f19 = sideIterator < 2 ? (f19 *= f2) : (f19 *= f3);
                tessellator.setColorRGBA_F(r * f1 * f19, g * f1 * f19, b * f1 * f19, 0.7f);
                tessellator.addVertex(f14, (float)posY + f10, f16);
                tessellator.addVertex(f17, (float)posY + f12, f18);
                tessellator.addVertex(f17, posY + 0, f18);
                tessellator.addVertex(f14, posY + 0, f16);
            }
            ++sideIterator;
        }
        block.minY = d;
        block.maxY = d1;
        return flag2;
    }

    private float getFluidSideHeight(int x, int y, int z, Material material) {
        int l = 0;
        float f = 0.0f;
        int sideIterator = 0;
        while (sideIterator < 4) {
            int j1 = x - (sideIterator & 1);
            int k1 = y;
            int l1 = z - (sideIterator >> 1 & 1);
            if (this.renderIBlockAccess.getMaterialXYZ(j1, k1 + 1, l1) == material) {
                return 1.0f;
            }
            Material material1 = this.renderIBlockAccess.getMaterialXYZ(j1, k1, l1);
            if (material1 == material) {
                int i2 = this.renderIBlockAccess.getBlockMetadata(j1, k1, l1);
                if (i2 >= 8 || i2 == 0) {
                    f += BlockFluids.getFluidLevel(i2) * 10.0f;
                    l += 10;
                }
                f += BlockFluids.getFluidLevel(i2);
                ++l;
            } else if (!material1.isSolidMaterial()) {
                f += 1.0f;
                ++l;
            }
            ++sideIterator;
        }
        return 1.0f - f / (float)l;
    }

    public void func_1243_a(Block block, World world, int i, int j, int k) {
        float bottomBrightness = 0.5f;
        float topBrightness = 1.0f;
        float ewBrightness = 0.8f;
        float nsBrightness = 0.6f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        float blockBrightnessLevel = block.getBlockBrightness(world, i, j, k);
        float belowBrightnessLevel = block.getBlockBrightness(world, i, j - 1, k);
        if (belowBrightnessLevel < blockBrightnessLevel) {
            belowBrightnessLevel = blockBrightnessLevel;
        }
        tessellator.setColorOpaque_F(bottomBrightness * belowBrightnessLevel, bottomBrightness * belowBrightnessLevel, bottomBrightness * belowBrightnessLevel);
        this.textureFaceBelow(block, -0.5, -0.5, -0.5, block.getTextureIndex(0));
        belowBrightnessLevel = block.getBlockBrightness(world, i, j + 1, k);
        if (belowBrightnessLevel < blockBrightnessLevel) {
            belowBrightnessLevel = blockBrightnessLevel;
        }
        tessellator.setColorOpaque_F(topBrightness * belowBrightnessLevel, topBrightness * belowBrightnessLevel, topBrightness * belowBrightnessLevel);
        this.textureFaceAbove(block, -0.5, -0.5, -0.5, block.getTextureIndex(1));
        belowBrightnessLevel = block.getBlockBrightness(world, i, j, k - 1);
        if (belowBrightnessLevel < blockBrightnessLevel) {
            belowBrightnessLevel = blockBrightnessLevel;
        }
        tessellator.setColorOpaque_F(ewBrightness * belowBrightnessLevel, ewBrightness * belowBrightnessLevel, ewBrightness * belowBrightnessLevel);
        this.textureFaceSouth(block, -0.5, -0.5, -0.5, block.getTextureIndex(2));
        belowBrightnessLevel = block.getBlockBrightness(world, i, j, k + 1);
        if (belowBrightnessLevel < blockBrightnessLevel) {
            belowBrightnessLevel = blockBrightnessLevel;
        }
        tessellator.setColorOpaque_F(ewBrightness * belowBrightnessLevel, ewBrightness * belowBrightnessLevel, ewBrightness * belowBrightnessLevel);
        this.textureFaceNorth(block, -0.5, -0.5, -0.5, block.getTextureIndex(3));
        belowBrightnessLevel = block.getBlockBrightness(world, i - 1, j, k);
        if (belowBrightnessLevel < blockBrightnessLevel) {
            belowBrightnessLevel = blockBrightnessLevel;
        }
        tessellator.setColorOpaque_F(nsBrightness * belowBrightnessLevel, nsBrightness * belowBrightnessLevel, nsBrightness * belowBrightnessLevel);
        this.textureFaceWest(block, -0.5, -0.5, -0.5, block.getTextureIndex(4));
        belowBrightnessLevel = block.getBlockBrightness(world, i + 1, j, k);
        if (belowBrightnessLevel < blockBrightnessLevel) {
            belowBrightnessLevel = blockBrightnessLevel;
        }
        tessellator.setColorOpaque_F(nsBrightness * belowBrightnessLevel, nsBrightness * belowBrightnessLevel, nsBrightness * belowBrightnessLevel);
        this.textureFaceEast(block, -0.5, -0.5, -0.5, block.getTextureIndex(5));
        tessellator.draw();
    }

    public boolean renderBlock(Block block, int x, int y, int z) {
        int l = block.colorMultiplierFlat(this.renderIBlockAccess, x, y, z);
        if (l == 0) {
            return false;
        }
        float r = (float)(l >> 16 & 0xFF) / 255.0f;
        float g = (float)(l >> 8 & 0xFF) / 255.0f;
        float b = (float)(l & 0xFF) / 255.0f;
        return this.renderBlockWithColoring(block, x, y, z, r, g, b);
    }

    public boolean renderBlockSecondary(Block block, int x, int y, int z) {
        int l2 = block.colorMultiplierSecondary(this.renderIBlockAccess, x, y, z);
        float r2 = (float)(l2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(l2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(l2 & 0xFF) / 255.0f;
        return this.renderBlockWithColoring(block, x, y, z, r2, g2, b2);
    }

    public boolean renderBlockWithColoring(Block block, int x, int y, int z, float red, float green, float blue) {
        Tessellator tessellator = Tessellator.instance;
        boolean faceRendered = false;
        float bottomColor = 0.5f;
        float topColor = 1.0f;
        float southColor = 0.8f;
        float westColor = 0.6f;
        float bcRed = bottomColor * red;
        float tcRed = topColor * red;
        float scRed = southColor * red;
        float wcRed = westColor * red;
        float bcGreen = bottomColor * green;
        float tcGreen = topColor * green;
        float scGreen = southColor * green;
        float wcGreen = westColor * green;
        float bcBlue = bottomColor * blue;
        float tcBlue = topColor * blue;
        float scBlue = southColor * blue;
        float wcBlue = westColor * blue;
        float blockBrightness = block.getBlockBrightness(this.renderIBlockAccess, x, y, z);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y - 1, z, 0)) {
            float below = block.getBlockBrightness(this.renderIBlockAccess, x, y - 1, z);
            tessellator.setColorOpaque_F(bcRed * below, bcGreen * below, bcBlue * below);
            this.textureFaceBelow(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 0));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y + 1, z, 1)) {
            float above = block.getBlockBrightness(this.renderIBlockAccess, x, y + 1, z);
            if (block.maxY != 1.0 && !block.blockMaterial.getIsGroundCover()) {
                above = blockBrightness;
            }
            tessellator.setColorOpaque_F(tcRed * above, tcGreen * above, tcBlue * above);
            this.textureFaceAbove(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 1));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y, z - 1, 2)) {
            float south = block.getBlockBrightness(this.renderIBlockAccess, x, y, z - 1);
            if (block.minZ > 0.0) {
                south = blockBrightness;
            }
            tessellator.setColorOpaque_F(scRed * south, scGreen * south, scBlue * south);
            this.textureFaceSouth(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 2));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y, z + 1, 3)) {
            float north = block.getBlockBrightness(this.renderIBlockAccess, x, y, z + 1);
            if (block.maxZ < 1.0) {
                north = blockBrightness;
            }
            tessellator.setColorOpaque_F(scRed * north, scGreen * north, scBlue * north);
            this.textureFaceNorth(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 3));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x - 1, y, z, 4)) {
            float west = block.getBlockBrightness(this.renderIBlockAccess, x - 1, y, z);
            if (block.minX > 0.0) {
                west = blockBrightness;
            }
            tessellator.setColorOpaque_F(wcRed * west, wcGreen * west, wcBlue * west);
            this.textureFaceWest(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 4));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x + 1, y, z, 5)) {
            float east = block.getBlockBrightness(this.renderIBlockAccess, x + 1, y, z);
            if (block.maxX < 1.0) {
                east = blockBrightness;
            }
            tessellator.setColorOpaque_F(wcRed * east, wcGreen * east, wcBlue * east);
            this.textureFaceEast(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 5));
            faceRendered = true;
        }
        return faceRendered;
    }

    public boolean renderBlockWithColoringSecondary(Block block, int x, int y, int z, float red, float green, float blue) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        boolean faceRendered = false;
        float bottomColor = 0.5f;
        float topColor = 1.0f;
        float southColor = 0.8f;
        float westColor = 0.6f;
        float bcRed = bottomColor * red;
        float tcRed = topColor * red;
        float scRed = southColor * red;
        float wcRed = westColor * red;
        float bcGreen = bottomColor * green;
        float tcGreen = topColor * green;
        float scGreen = southColor * green;
        float wcGreen = westColor * green;
        float bcBlue = bottomColor * blue;
        float tcBlue = topColor * blue;
        float scBlue = southColor * blue;
        float wcBlue = westColor * blue;
        float blockBrightness = block.getBlockBrightness(this.renderIBlockAccess, x, y, z);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y - 1, z, 0)) {
            float below = block.getBlockBrightness(this.renderIBlockAccess, x, y - 1, z);
            tessellator.setColorOpaque_F(bcRed * below, bcGreen * below, bcBlue * below);
            this.textureFaceBelow(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 0));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y + 1, z, 1)) {
            float above = block.getBlockBrightness(this.renderIBlockAccess, x, y + 1, z);
            if (block.maxY != 1.0 && !block.blockMaterial.getIsGroundCover()) {
                above = blockBrightness;
            }
            tessellator.setColorOpaque_F(tcRed * above, tcGreen * above, tcBlue * above);
            this.textureFaceAbove(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 1));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y, z - 1, 2)) {
            float south = block.getBlockBrightness(this.renderIBlockAccess, x, y, z - 1);
            if (block.minZ > 0.0) {
                south = blockBrightness;
            }
            tessellator.setColorOpaque_F(scRed * south, scGreen * south, scBlue * south);
            this.textureFaceSouth(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 2));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x, y, z + 1, 3)) {
            float north = block.getBlockBrightness(this.renderIBlockAccess, x, y, z + 1);
            if (block.maxZ < 1.0) {
                north = blockBrightness;
            }
            tessellator.setColorOpaque_F(scRed * north, scGreen * north, scBlue * north);
            this.textureFaceNorth(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 3));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x - 1, y, z, 4)) {
            float west = block.getBlockBrightness(this.renderIBlockAccess, x - 1, y, z);
            if (block.minX > 0.0) {
                west = blockBrightness;
            }
            tessellator.setColorOpaque_F(wcRed * west, wcGreen * west, wcBlue * west);
            this.textureFaceWest(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 4));
            faceRendered = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, x + 1, y, z, 5)) {
            float east = block.getBlockBrightness(this.renderIBlockAccess, x + 1, y, z);
            if (block.maxX < 1.0) {
                east = blockBrightness;
            }
            tessellator.setColorOpaque_F(wcRed * east, wcGreen * east, wcBlue * east);
            this.textureFaceEast(block, x, y, z, block.getTextureIndex(this.renderIBlockAccess, x, y, z, 5));
            faceRendered = true;
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        return faceRendered;
    }

    public boolean renderCactus(Block block, int i, int j, int k) {
        int l = block.colorMultiplierFlat(this.renderIBlockAccess, i, j, k);
        float f = (float)(l >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(l & 0xFF) / 255.0f;
        return this.func_1230_b(block, i, j, k, f, f1, f2);
    }

    public boolean func_1230_b(Block block, int i, int j, int k, float f, float f1, float f2) {
        Tessellator tessellator = Tessellator.instance;
        boolean flag = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f3 * f;
        float f8 = f4 * f;
        float f9 = f5 * f;
        float f10 = f6 * f;
        float f11 = f3 * f1;
        float f12 = f4 * f1;
        float f13 = f5 * f1;
        float f14 = f6 * f1;
        float f15 = f3 * f2;
        float f16 = f4 * f2;
        float f17 = f5 * f2;
        float f18 = f6 * f2;
        float f19 = 0.0625f;
        float f20 = block.getBlockBrightness(this.renderIBlockAccess, i, j, k);
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, i, j - 1, k, 0)) {
            float f21 = block.getBlockBrightness(this.renderIBlockAccess, i, j - 1, k);
            tessellator.setColorOpaque_F(f7 * f21, f11 * f21, f15 * f21);
            this.textureFaceBelow(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 0));
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, i, j + 1, k, 1)) {
            float f22 = block.getBlockBrightness(this.renderIBlockAccess, i, j + 1, k);
            if (block.maxY != 1.0 && !block.blockMaterial.getIsGroundCover()) {
                f22 = f20;
            }
            tessellator.setColorOpaque_F(f8 * f22, f12 * f22, f16 * f22);
            this.textureFaceAbove(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 1));
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, i, j, k - 1, 2)) {
            float f23 = block.getBlockBrightness(this.renderIBlockAccess, i, j, k - 1);
            if (block.minZ > 0.0) {
                f23 = f20;
            }
            tessellator.setColorOpaque_F(f9 * f23, f13 * f23, f17 * f23);
            tessellator.setTranslationF(0.0f, 0.0f, f19);
            this.textureFaceSouth(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 2));
            tessellator.setTranslationF(0.0f, 0.0f, -f19);
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, i, j, k + 1, 3)) {
            float f24 = block.getBlockBrightness(this.renderIBlockAccess, i, j, k + 1);
            if (block.maxZ < 1.0) {
                f24 = f20;
            }
            tessellator.setColorOpaque_F(f9 * f24, f13 * f24, f17 * f24);
            tessellator.setTranslationF(0.0f, 0.0f, -f19);
            this.textureFaceNorth(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 3));
            tessellator.setTranslationF(0.0f, 0.0f, f19);
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, i - 1, j, k, 4)) {
            float f25 = block.getBlockBrightness(this.renderIBlockAccess, i - 1, j, k);
            if (block.minX > 0.0) {
                f25 = f20;
            }
            tessellator.setColorOpaque_F(f10 * f25, f14 * f25, f18 * f25);
            tessellator.setTranslationF(f19, 0.0f, 0.0f);
            this.textureFaceWest(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 4));
            tessellator.setTranslationF(-f19, 0.0f, 0.0f);
            flag = true;
        }
        if (this.renderAllFaces || block.shouldSideBeRendered(this.renderIBlockAccess, i + 1, j, k, 5)) {
            float f26 = block.getBlockBrightness(this.renderIBlockAccess, i + 1, j, k);
            if (block.maxX < 1.0) {
                f26 = f20;
            }
            tessellator.setColorOpaque_F(f10 * f26, f14 * f26, f18 * f26);
            tessellator.setTranslationF(-f19, 0.0f, 0.0f);
            this.textureFaceEast(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 5));
            tessellator.setTranslationF(f19, 0.0f, 0.0f);
            flag = true;
        }
        return flag;
    }

    public boolean renderPressurePlate(Block block, int i, int j, int k) {
        float f7;
        boolean flag = false;
        float f = 0.375f;
        float f1 = 0.625f;
        block.setBlockBounds(f, 0.0f, f, f1, 1.0f, f1);
        this.renderBlock(block, i, j, k);
        boolean blockNorth = false;
        boolean blockEast = false;
        boolean blockSouth = false;
        boolean blockWest = false;
        if (Block.allBlocks[this.renderIBlockAccess.getBlockId(i - 1, j, k)] != null && (Block.allBlocks[this.renderIBlockAccess.getBlockId(i - 1, j, k)].isOpaqueCube() || Block.allBlocks[this.renderIBlockAccess.getBlockId(i - 1, j, k)] == block)) {
            blockSouth = true;
        }
        if (Block.allBlocks[this.renderIBlockAccess.getBlockId(i + 1, j, k)] != null && (Block.allBlocks[this.renderIBlockAccess.getBlockId(i + 1, j, k)].isOpaqueCube() || Block.allBlocks[this.renderIBlockAccess.getBlockId(i + 1, j, k)] == block)) {
            blockNorth = true;
        }
        if (Block.allBlocks[this.renderIBlockAccess.getBlockId(i, j, k - 1)] != null && (Block.allBlocks[this.renderIBlockAccess.getBlockId(i, j, k - 1)].isOpaqueCube() || Block.allBlocks[this.renderIBlockAccess.getBlockId(i, j, k - 1)] == block)) {
            blockEast = true;
        }
        if (Block.allBlocks[this.renderIBlockAccess.getBlockId(i, j, k + 1)] != null && (Block.allBlocks[this.renderIBlockAccess.getBlockId(i, j, k + 1)].isOpaqueCube() || Block.allBlocks[this.renderIBlockAccess.getBlockId(i, j, k + 1)] == block)) {
            blockWest = true;
        }
        boolean flag1 = blockNorth || blockSouth;
        boolean flag2 = blockEast || blockWest;
        boolean flag3 = blockSouth;
        boolean flag4 = blockNorth;
        boolean flag5 = blockEast;
        boolean flag6 = blockWest;
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        f = 0.4375f;
        f1 = 0.5625f;
        float f2 = 0.75f;
        float f3 = 0.9375f;
        float f4 = flag3 ? 0.0f : f;
        float f5 = flag4 ? 1.0f : f1;
        float f6 = flag5 ? 0.0f : f;
        float f8 = f7 = flag6 ? 1.0f : f1;
        if (flag1) {
            block.setBlockBounds(f4, f2, f, f5, f3, f1);
            this.renderBlock(block, i, j, k);
        }
        if (flag2) {
            block.setBlockBounds(f, f2, f6, f1, f3, f7);
            this.renderBlock(block, i, j, k);
        }
        f2 = 0.375f;
        f3 = 0.5625f;
        if (flag1) {
            block.setBlockBounds(f4, f2, f, f5, f3, f1);
            this.renderBlock(block, i, j, k);
        }
        if (flag2) {
            block.setBlockBounds(f, f2, f6, f1, f3, f7);
            this.renderBlock(block, i, j, k);
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return flag;
    }

    public boolean renderStairs(Block block, int i, int j, int k) {
        boolean flag = false;
        int l = this.renderIBlockAccess.getBlockMetadata(i, j, k);
        if (l == 0) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            this.renderBlock(block, i, j, k);
            block.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            this.renderBlock(block, i, j, k);
        } else if (l == 1) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            this.renderBlock(block, i, j, k);
            block.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            this.renderBlock(block, i, j, k);
        } else if (l == 2) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            this.renderBlock(block, i, j, k);
            block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            this.renderBlock(block, i, j, k);
        } else if (l == 3) {
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            this.renderBlock(block, i, j, k);
            block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            this.renderBlock(block, i, j, k);
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return flag;
    }

    public boolean renderDoor(Block block, int i, int j, int k) {
        Tessellator tessellator = Tessellator.instance;
        BlockDoor blockdoor = (BlockDoor)block;
        boolean flag = false;
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        float f4 = block.getBlockBrightness(this.renderIBlockAccess, i, j, k);
        float f5 = block.getBlockBrightness(this.renderIBlockAccess, i, j - 1, k);
        if (blockdoor.minY > 0.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f * f5, f * f5, f * f5);
        this.textureFaceBelow(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 0));
        flag = true;
        f5 = block.getBlockBrightness(this.renderIBlockAccess, i, j + 1, k);
        if (blockdoor.maxY < 1.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        this.textureFaceAbove(block, i, j, k, block.getTextureIndex(this.renderIBlockAccess, i, j, k, 1));
        flag = true;
        f5 = block.getBlockBrightness(this.renderIBlockAccess, i, j, k - 1);
        if (blockdoor.minZ > 0.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        int l = block.getTextureIndex(this.renderIBlockAccess, i, j, k, 2);
        if (l < 0) {
            this.flipTexture = true;
            l = -l;
        }
        this.textureFaceSouth(block, i, j, k, l);
        flag = true;
        this.flipTexture = false;
        f5 = block.getBlockBrightness(this.renderIBlockAccess, i, j, k + 1);
        if (blockdoor.maxZ < 1.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        l = block.getTextureIndex(this.renderIBlockAccess, i, j, k, 3);
        if (l < 0) {
            this.flipTexture = true;
            l = -l;
        }
        this.textureFaceNorth(block, i, j, k, l);
        flag = true;
        this.flipTexture = false;
        f5 = block.getBlockBrightness(this.renderIBlockAccess, i - 1, j, k);
        if (blockdoor.minX > 0.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        l = block.getTextureIndex(this.renderIBlockAccess, i, j, k, 4);
        if (l < 0) {
            this.flipTexture = true;
            l = -l;
        }
        this.textureFaceWest(block, i, j, k, l);
        flag = true;
        this.flipTexture = false;
        f5 = block.getBlockBrightness(this.renderIBlockAccess, i + 1, j, k);
        if (blockdoor.maxX < 1.0) {
            f5 = f4;
        }
        if (Block.lightValue[block.blockID] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        l = block.getTextureIndex(this.renderIBlockAccess, i, j, k, 5);
        if (l < 0) {
            this.flipTexture = true;
            l = -l;
        }
        this.textureFaceEast(block, i, j, k, l);
        flag = true;
        this.flipTexture = false;
        return flag;
    }

    public void textureFaceBelow(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + block.minX * 16.0) / 256.0;
        double d4 = ((double)j + block.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + block.minZ * 16.0) / 256.0;
        double d6 = ((double)k + block.maxZ * 16.0 - 0.01) / 256.0;
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d7 = d + block.minX;
        double d8 = d + block.maxX;
        double d9 = d1 + block.minY;
        double d10 = d2 + block.minZ;
        double d11 = d2 + block.maxZ;
        tessellator.addVertex(d7, d9, d11);
        tessellator.addVertex(d7, d9, d10);
        tessellator.addVertex(d8, d9, d10);
        tessellator.addVertex(d8, d9, d11);
    }

    public void textureFaceAbove(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + block.minX * 16.0) / 256.0;
        double d4 = ((double)j + block.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + block.minZ * 16.0) / 256.0;
        double d6 = ((double)k + block.maxZ * 16.0 - 0.01) / 256.0;
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d7 = d + block.minX;
        double d8 = d + block.maxX;
        double d9 = d1 + block.maxY;
        double d10 = d2 + block.minZ;
        double d11 = d2 + block.maxZ;
        tessellator.addVertex(d8, d9, d11);
        tessellator.addVertex(d8, d9, d10);
        tessellator.addVertex(d7, d9, d10);
        tessellator.addVertex(d7, d9, d11);
    }

    public void textureFaceSouth(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + block.minX * 16.0) / 256.0;
        double d4 = ((double)j + block.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + block.minY * 16.0) / 256.0;
        double d6 = ((double)k + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + block.minX;
        double d9 = d + block.maxX;
        double d10 = d1 + block.minY;
        double d11 = d1 + block.maxY;
        double d12 = d2 + block.minZ;
        tessellator.addVertex(d8, d11, d12);
        tessellator.addVertex(d9, d11, d12);
        tessellator.addVertex(d9, d10, d12);
        tessellator.addVertex(d8, d10, d12);
    }

    public void textureFaceNorth(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + block.minX * 16.0) / 256.0;
        double d4 = ((double)j + block.maxX * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + block.minY * 16.0) / 256.0;
        double d6 = ((double)k + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + block.minX;
        double d9 = d + block.maxX;
        double d10 = d1 + block.minY;
        double d11 = d1 + block.maxY;
        double d12 = d2 + block.maxZ;
        tessellator.addVertex(d8, d11, d12);
        tessellator.addVertex(d8, d10, d12);
        tessellator.addVertex(d9, d10, d12);
        tessellator.addVertex(d9, d11, d12);
    }

    public void textureFaceWest(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + block.minZ * 16.0) / 256.0;
        double d4 = ((double)j + block.maxZ * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + block.minY * 16.0) / 256.0;
        double d6 = ((double)k + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + block.minX;
        double d9 = d1 + block.minY;
        double d10 = d1 + block.maxY;
        double d11 = d2 + block.minZ;
        double d12 = d2 + block.maxZ;
        tessellator.addVertex(d8, d10, d12);
        tessellator.addVertex(d8, d10, d11);
        tessellator.addVertex(d8, d9, d11);
        tessellator.addVertex(d8, d9, d12);
    }

    public void textureFaceEast(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d3 = ((double)j + block.minZ * 16.0) / 256.0;
        double d4 = ((double)j + block.maxZ * 16.0 - 0.01) / 256.0;
        double d5 = ((double)k + block.minY * 16.0) / 256.0;
        double d6 = ((double)k + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + block.maxX;
        double d9 = d1 + block.minY;
        double d10 = d1 + block.maxY;
        double d11 = d2 + block.minZ;
        double d12 = d2 + block.maxZ;
        tessellator.addVertex(d8, d9, d12);
        tessellator.addVertex(d8, d9, d11);
        tessellator.addVertex(d8, d10, d11);
        tessellator.addVertex(d8, d10, d12);
    }

    public void textureFaceBlorth(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d4 = ((double)j + block.minX * 16.0) / 256.0;
        double d3 = ((double)j + block.maxX * 16.0 - 0.01) / 256.0;
        double d6 = ((double)k + block.minY * 16.0) / 256.0;
        double d5 = ((double)k + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + block.minX;
        double d9 = d + block.maxX;
        double d10 = d1 + block.minY;
        double d11 = d1 + block.maxY;
        double d12 = d2 + block.maxZ;
        tessellator.addVertex(d8, d11, d12);
        tessellator.addVertex(d8, d10, d12);
        tessellator.addVertex(d9, d10, d12);
        tessellator.addVertex(d9, d11, d12);
    }

    public void textureFaceBlest(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d4 = ((double)j + block.minZ * 16.0) / 256.0;
        double d3 = ((double)j + block.maxZ * 16.0 - 0.01) / 256.0;
        double d6 = ((double)k + block.minY * 16.0) / 256.0;
        double d5 = ((double)k + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + block.minX;
        double d9 = d1 + block.minY;
        double d10 = d1 + block.maxY;
        double d11 = d2 + block.minZ;
        double d12 = d2 + block.maxZ;
        tessellator.addVertex(d8, d10, d12);
        tessellator.addVertex(d8, d10, d11);
        tessellator.addVertex(d8, d9, d11);
        tessellator.addVertex(d8, d9, d12);
    }

    public void textureFaceBleast(Block block, double d, double d1, double d2, int i) {
        Tessellator tessellator = Tessellator.instance;
        if (this.overrideBlockTexture >= 0) {
            i = this.overrideBlockTexture;
        }
        int j = (i & 0xF) << 4;
        int k = i & 0xF0;
        double d4 = ((double)j + block.minZ * 16.0) / 256.0;
        double d3 = ((double)j + block.maxZ * 16.0 - 0.01) / 256.0;
        double d6 = ((double)k + block.minY * 16.0) / 256.0;
        double d5 = ((double)k + block.maxY * 16.0 - 0.01) / 256.0;
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = ((float)j + 0.0f) / 256.0f;
            d4 = ((float)j + 15.99f) / 256.0f;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / 256.0f;
            d6 = ((float)k + 15.99f) / 256.0f;
        }
        double d8 = d + block.maxX;
        double d9 = d1 + block.minY;
        double d10 = d1 + block.maxY;
        double d11 = d2 + block.minZ;
        double d12 = d2 + block.maxZ;
        tessellator.addVertex(d8, d9, d12);
        tessellator.addVertex(d8, d9, d11);
        tessellator.addVertex(d8, d10, d11);
        tessellator.addVertex(d8, d10, d12);
    }

    public void renderHeldItems(Block block, float f) {
        int i = block.getRenderType();
        Tessellator tessellator = Tessellator.instance;
        if (i == 0 || i == 4) {
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f1 = 0.5f;
            float f2 = 1.0f;
            float f3 = 0.8f;
            float f4 = 0.6f;
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_F(f2, f2, f2, f);
            this.textureFaceBelow(block, 0.0, 0.0, 0.0, block.getTextureIndex(0));
            tessellator.setColorRGBA_F(f1, f1, f1, f);
            this.textureFaceAbove(block, 0.0, 0.0, 0.0, block.getTextureIndex(1));
            tessellator.setColorRGBA_F(f3, f3, f3, f);
            this.textureFaceSouth(block, 0.0, 0.0, 0.0, block.getTextureIndex(2));
            this.textureFaceNorth(block, 0.0, 0.0, 0.0, block.getTextureIndex(3));
            tessellator.setColorRGBA_F(f4, f4, f4, f);
            this.textureFaceWest(block, 0.0, 0.0, 0.0, block.getTextureIndex(4));
            this.textureFaceEast(block, 0.0, 0.0, 0.0, block.getTextureIndex(5));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public void renderMenuItems(Block block, float f) {
        int i = block.getRenderType();
        Tessellator tessellator = Tessellator.instance;
        if (i == 0 || i == 4) {
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f1 = 0.5f;
            float f2 = 1.0f;
            float f3 = 0.8f;
            float f4 = 0.6f;
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_F(f2, f2, f2, f);
            this.textureFaceBelow(block, 0.0, 0.0, 0.0, block.getTextureIndex(1));
            tessellator.setColorRGBA_F(f1, f1, f1, f);
            this.textureFaceAbove(block, 0.0, 0.0, 0.0, block.getTextureIndex(0));
            tessellator.setColorRGBA_F(f3, f3, f3, f);
            this.textureFaceSouth(block, 0.0, 0.0, 0.0, block.getTextureIndex(2));
            this.textureFaceBlorth(block, 0.0, 0.0, 0.0, block.getTextureIndex(3));
            tessellator.setColorRGBA_F(f4, f4, f4, f);
            this.textureFaceBlest(block, 0.0, 0.0, 0.0, block.getTextureIndex(4));
            this.textureFaceBleast(block, 0.0, 0.0, 0.0, block.getTextureIndex(5));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    public void renderThrownItems(Block block) {
        int byte0 = -1;
        Tessellator tessellator = Tessellator.instance;
        int i = block.getRenderType();
        if (i == 0 || i == 4) {
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.textureFaceBelow(block, 0.0, 0.0, 0.0, block.getTextureIndex(0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.textureFaceAbove(block, 0.0, 0.0, 0.0, block.getTextureIndex(1));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.textureFaceSouth(block, 0.0, 0.0, 0.0, block.getTextureIndex(2));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.textureFaceNorth(block, 0.0, 0.0, 0.0, block.getTextureIndex(3));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.textureFaceWest(block, 0.0, 0.0, 0.0, block.getTextureIndex(4));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.textureFaceEast(block, 0.0, 0.0, 0.0, block.getTextureIndex(5));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (i == 1) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderCrossedSquares(block, byte0, -0.5, -0.5, -0.5);
            tessellator.draw();
        } else if (i == 13) {
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            float f = 0.0625f;
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.textureFaceBelow(block, 0.0, 0.0, 0.0, block.getTextureIndex(0));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.textureFaceAbove(block, 0.0, 0.0, 0.0, block.getTextureIndex(1));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            tessellator.setTranslationF(0.0f, 0.0f, f);
            this.textureFaceSouth(block, 0.0, 0.0, 0.0, block.getTextureIndex(2));
            tessellator.setTranslationF(0.0f, 0.0f, -f);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            tessellator.setTranslationF(0.0f, 0.0f, -f);
            this.textureFaceNorth(block, 0.0, 0.0, 0.0, block.getTextureIndex(3));
            tessellator.setTranslationF(0.0f, 0.0f, f);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            tessellator.setTranslationF(f, 0.0f, 0.0f);
            this.textureFaceWest(block, 0.0, 0.0, 0.0, block.getTextureIndex(4));
            tessellator.setTranslationF(-f, 0.0f, 0.0f);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            tessellator.setTranslationF(-f, 0.0f, 0.0f);
            this.textureFaceEast(block, 0.0, 0.0, 0.0, block.getTextureIndex(5));
            tessellator.setTranslationF(f, 0.0f, 0.0f);
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (i == 6) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.func_1245_b(block, byte0, -0.5, -0.5, -0.5);
            tessellator.draw();
        } else if (i == 2) {
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderTorchFace(block, -0.5, -0.5, -0.5, 0.0, 0.0);
            tessellator.draw();
        } else if (i == 10) {
            int j = 0;
            while (j < 2) {
                if (j == 0) {
                    block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                }
                if (j == 1) {
                    block.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.textureFaceBelow(block, 0.0, 0.0, 0.0, block.getTextureIndex(0));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                this.textureFaceAbove(block, 0.0, 0.0, 0.0, block.getTextureIndex(1));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                this.textureFaceSouth(block, 0.0, 0.0, 0.0, block.getTextureIndex(2));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                this.textureFaceNorth(block, 0.0, 0.0, 0.0, block.getTextureIndex(3));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                this.textureFaceWest(block, 0.0, 0.0, 0.0, block.getTextureIndex(4));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                this.textureFaceEast(block, 0.0, 0.0, 0.0, block.getTextureIndex(5));
                tessellator.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                ++j;
            }
        } else if (i == 11) {
            int k = 0;
            while (k < 4) {
                float f1 = 0.125f;
                if (k == 0) {
                    block.setBlockBounds(0.5f - f1, 0.0f, 0.0f, 0.5f + f1, 1.0f, f1 * 2.0f);
                }
                if (k == 1) {
                    block.setBlockBounds(0.5f - f1, 0.0f, 1.0f - f1 * 2.0f, 0.5f + f1, 1.0f, 1.0f);
                }
                f1 = 0.0625f;
                if (k == 2) {
                    block.setBlockBounds(0.5f - f1, 1.0f - f1 * 3.0f, -f1 * 2.0f, 0.5f + f1, 1.0f - f1, 1.0f + f1 * 2.0f);
                }
                if (k == 3) {
                    block.setBlockBounds(0.5f - f1, 0.5f - f1 * 3.0f, -f1 * 2.0f, 0.5f + f1, 0.5f - f1, 1.0f + f1 * 2.0f);
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                this.textureFaceBelow(block, 0.0, 0.0, 0.0, block.getTextureIndex(0));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                this.textureFaceAbove(block, 0.0, 0.0, 0.0, block.getTextureIndex(1));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                this.textureFaceSouth(block, 0.0, 0.0, 0.0, block.getTextureIndex(2));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                this.textureFaceNorth(block, 0.0, 0.0, 0.0, block.getTextureIndex(3));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                this.textureFaceWest(block, 0.0, 0.0, 0.0, block.getTextureIndex(4));
                tessellator.draw();
                tessellator.startDrawingQuads();
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                this.textureFaceEast(block, 0.0, 0.0, 0.0, block.getTextureIndex(5));
                tessellator.draw();
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                ++k;
            }
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static boolean getRenderItemType(int i) {
        if (i == 0) {
            return true;
        }
        if (i == 13) {
            return true;
        }
        if (i == 10) {
            return true;
        }
        if (i == 4) {
            return true;
        }
        return i == 11;
    }
}

