/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.level.tile.fx.TextureFX;
import com.mojang.minecraft.client.mods.TexturePackBase;
import com.mojang.minecraft.client.mods.TexturePackList;
import com.mojang.minecraft.client.player.controller.GameSettings;
import com.mojang.minecraft.client.render.GLAllocation;
import com.mojang.minecraft.client.render.ImageBuffer;
import com.mojang.minecraft.client.util.DownloadImageThreadData;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class RenderEngine {
    public static boolean useMipMaps = false;
    private HashMap<String, Integer> textureMap = new HashMap();
    private HashMap field_28151_c;
    private HashMap<Integer, BufferedImage> textureNameToImageMap = new HashMap();
    private IntBuffer singleIntBuffer = GLAllocation.createDirectIntBuffer(1);
    private ByteBuffer imageData = GLAllocation.createDirectByteBuffer(0x100000);
    private List<TextureFX> textureFXs = new ArrayList<TextureFX>();
    private List<TextureFX> textureFXcloud = new ArrayList<TextureFX>();
    private Map<String, DownloadImageThreadData> urlToImageDataMap = new HashMap<String, DownloadImageThreadData>();
    private GameSettings options;
    private boolean clampTexture = false;
    private TexturePackList texturePack;
    private BufferedImage missingTextureImage = new BufferedImage(64, 64, 2);
    public long cloudPassNumber = 0L;

    public RenderEngine(TexturePackList texturepacklist, GameSettings gamesettings) {
        this.texturePack = texturepacklist;
        this.options = gamesettings;
        Graphics g = this.missingTextureImage.getGraphics();
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, 64, 64);
        g.setColor(Color.RED);
        g.drawString("missingtex", 1, 10);
        g.dispose();
    }

    public int[] func_28149_a(String s) {
        TexturePackBase texturepackbase = this.texturePack.selectedTexturePack;
        int[] ai = (int[])this.field_28151_c.get(s);
        if (ai != null) {
            return ai;
        }
        try {
            int[] ai1 = null;
            if (s.startsWith("##")) {
                ai1 = this.func_28148_b(this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2)))));
            } else if (s.startsWith("%%")) {
                this.clampTexture = true;
                ai1 = this.func_28148_b(this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(7))));
                this.clampTexture = false;
            } else {
                InputStream inputstream = texturepackbase.getResourceAsStream(s);
                ai1 = inputstream == null ? this.func_28148_b(this.missingTextureImage) : this.func_28148_b(this.readTextureImage(inputstream));
            }
            this.field_28151_c.put(s, ai1);
            return ai1;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            int[] ai2 = this.func_28148_b(this.missingTextureImage);
            this.field_28151_c.put(s, ai2);
            return ai2;
        }
    }

    private int[] func_28148_b(BufferedImage bufferedimage) {
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] ai = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, ai, 0, i);
        return ai;
    }

    private int[] func_28147_a(BufferedImage bufferedimage, int[] ai) {
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        bufferedimage.getRGB(0, 0, i, j, ai, 0, i);
        return ai;
    }

    public int getTex(String s) {
        TexturePackBase texturepackbase = this.texturePack.selectedTexturePack;
        Integer integer = this.textureMap.get(s);
        if (integer != null) {
            return integer;
        }
        try {
            this.singleIntBuffer.clear();
            GLAllocation.generateTextureNames(this.singleIntBuffer);
            int i = this.singleIntBuffer.get(0);
            if (s.startsWith("##")) {
                this.setupTexture(this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2)))), i);
            } else if (s.startsWith("%%")) {
                this.clampTexture = true;
                this.setupTexture(this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2))), i);
                this.clampTexture = false;
            } else {
                InputStream inputstream = texturepackbase.getResourceAsStream(s);
                if (inputstream == null) {
                    this.setupTexture(this.missingTextureImage, i);
                } else {
                    this.setupTexture(this.readTextureImage(inputstream), i);
                }
            }
            this.textureMap.put(s, i);
            return i;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            GLAllocation.generateTextureNames(this.singleIntBuffer);
            int j = this.singleIntBuffer.get(0);
            this.setupTexture(this.missingTextureImage, j);
            this.textureMap.put(s, j);
            return j;
        }
    }

    private BufferedImage unwrapImageByColumns(BufferedImage bufferedimage) {
        int i = bufferedimage.getWidth() / 16;
        BufferedImage bufferedimage1 = new BufferedImage(16, bufferedimage.getHeight() * i, 2);
        Graphics g = bufferedimage1.getGraphics();
        int j = 0;
        while (j < i) {
            g.drawImage(bufferedimage, -j * 16, j * bufferedimage.getHeight(), null);
            ++j;
        }
        g.dispose();
        return bufferedimage1;
    }

    public int allocateAndSetupTexture(BufferedImage bufferedimage) {
        this.singleIntBuffer.clear();
        GLAllocation.generateTextureNames(this.singleIntBuffer);
        int i = this.singleIntBuffer.get(0);
        this.setupTexture(bufferedimage, i);
        this.textureNameToImageMap.put(i, bufferedimage);
        return i;
    }

    public void setupTexture(BufferedImage bufferedimage, int i) {
        GL11.glBindTexture((int)3553, (int)i);
        if (useMipMaps) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (this.clampTexture) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int j = bufferedimage.getWidth();
        int k = bufferedimage.getHeight();
        int[] ai = new int[j * k];
        byte[] abyte0 = new byte[j * k * 4];
        bufferedimage.getRGB(0, 0, j, k, ai, 0, j);
        int l = 0;
        while (l < ai.length) {
            int j1 = ai[l] >> 24 & 0xFF;
            int l1 = ai[l] >> 16 & 0xFF;
            int j2 = ai[l] >> 8 & 0xFF;
            int l2 = ai[l] & 0xFF;
            if (this.options != null && this.options.anaglyph) {
                int j3 = (l1 * 30 + j2 * 59 + l2 * 11) / 100;
                int l3 = (l1 * 30 + j2 * 70) / 100;
                int j4 = (l1 * 30 + l2 * 70) / 100;
                l1 = j3;
                j2 = l3;
                l2 = j4;
            }
            abyte0[l * 4 + 0] = (byte)l1;
            abyte0[l * 4 + 1] = (byte)j2;
            abyte0[l * 4 + 2] = (byte)l2;
            abyte0[l * 4 + 3] = (byte)j1;
            ++l;
        }
        this.imageData.clear();
        this.imageData.put(abyte0);
        this.imageData.position(0).limit(abyte0.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)j, (int)k, (int)0, (int)6408, (int)5121, (ByteBuffer)this.imageData);
        if (useMipMaps) {
            int i1 = 1;
            while (i1 <= 4) {
                int k1 = j >> i1 - 1;
                int i2 = j >> i1;
                int k2 = k >> i1;
                int i3 = 0;
                while (i3 < i2) {
                    int k3 = 0;
                    while (k3 < k2) {
                        int i4 = this.imageData.getInt((i3 * 2 + 0 + (k3 * 2 + 0) * k1) * 4);
                        int k4 = this.imageData.getInt((i3 * 2 + 1 + (k3 * 2 + 0) * k1) * 4);
                        int l4 = this.imageData.getInt((i3 * 2 + 1 + (k3 * 2 + 1) * k1) * 4);
                        int i5 = this.imageData.getInt((i3 * 2 + 0 + (k3 * 2 + 1) * k1) * 4);
                        int j5 = this.func_1077_b(this.func_1077_b(i4, k4), this.func_1077_b(l4, i5));
                        this.imageData.putInt((i3 + k3 * i2) * 4, j5);
                        ++k3;
                    }
                    ++i3;
                }
                GL11.glTexImage2D((int)3553, (int)i1, (int)6408, (int)i2, (int)k2, (int)0, (int)6408, (int)5121, (ByteBuffer)this.imageData);
                ++i1;
            }
        }
    }

    public void deleteTexture(int i) {
        this.textureNameToImageMap.remove(i);
        this.singleIntBuffer.clear();
        this.singleIntBuffer.put(i);
        this.singleIntBuffer.flip();
        GL11.glDeleteTextures((IntBuffer)this.singleIntBuffer);
    }

    public int getTextureForDownloadableImage(String s, String s1) {
        DownloadImageThreadData downloadimagethreaddata = this.urlToImageDataMap.get(s);
        if (downloadimagethreaddata != null && downloadimagethreaddata.field_1706_a != null && !downloadimagethreaddata.textureSetupComplete) {
            if (downloadimagethreaddata.field_1708_c < 0) {
                downloadimagethreaddata.field_1708_c = this.allocateAndSetupTexture(downloadimagethreaddata.field_1706_a);
            } else {
                this.setupTexture(downloadimagethreaddata.field_1706_a, downloadimagethreaddata.field_1708_c);
            }
            downloadimagethreaddata.textureSetupComplete = true;
        }
        if (downloadimagethreaddata == null || downloadimagethreaddata.field_1708_c < 0) {
            if (s1 == null) {
                return -1;
            }
            return this.getTex(s1);
        }
        return downloadimagethreaddata.field_1708_c;
    }

    public DownloadImageThreadData obtainImageData(String s, ImageBuffer imagebuffer) {
        DownloadImageThreadData downloadimagethreaddata = this.urlToImageDataMap.get(s);
        if (downloadimagethreaddata == null) {
            this.urlToImageDataMap.put(s, new DownloadImageThreadData(s, imagebuffer));
        } else {
            ++downloadimagethreaddata.field_1705_b;
        }
        return downloadimagethreaddata;
    }

    public void releaseImageData(String s) {
        DownloadImageThreadData downloadimagethreaddata = this.urlToImageDataMap.get(s);
        if (downloadimagethreaddata != null) {
            --downloadimagethreaddata.field_1705_b;
            if (downloadimagethreaddata.field_1705_b == 0) {
                if (downloadimagethreaddata.field_1708_c >= 0) {
                    this.deleteTexture(downloadimagethreaddata.field_1708_c);
                }
                this.urlToImageDataMap.remove(s);
            }
        }
    }

    public void bindTextureFX(TextureFX texturefx) {
        this.textureFXs.add(texturefx);
        texturefx.render();
    }

    public void bindTextureFXCloud(TextureFX texturefx) {
        this.textureFXcloud.add(texturefx);
        texturefx.render();
    }

    public void updateDynamicTextures() {
        int i = 0;
        while (i < this.textureFXs.size()) {
            TextureFX texturefx = this.textureFXs.get(i);
            texturefx.field_1131_c = this.options.anaglyph;
            texturefx.render();
            this.imageData.clear();
            this.imageData.put(texturefx.bitMap);
            this.imageData.position(0).limit(texturefx.bitMap.length);
            texturefx.bindTextureFXToTexture(this);
            int texFXU = 0;
            while (texFXU < texturefx.prevSize) {
                int texFXV = 0;
                while (texFXV < texturefx.prevSize) {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)(texturefx.texIndex % 16 * 16 + texFXU * 16), (int)(texturefx.texIndex / 16 * 16 + texFXV * 16), (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.imageData);
                    if (useMipMaps) {
                        for (int k1 = 1; k1 <= 4; ++k1) {
                            int i2 = 16 >> k1 - 1;
                            int k2 = 16 >> k1;
                            int i3 = 0;
                            while (i3 < k2) {
                                int k3 = 0;
                                while (k3 < k2) {
                                    int i4 = this.imageData.getInt((i3 * 2 + 0 + (k3 * 2 + 0) * i2) * 4);
                                    int k4 = this.imageData.getInt((i3 * 2 + 1 + (k3 * 2 + 0) * i2) * 4);
                                    int i5 = this.imageData.getInt((i3 * 2 + 1 + (k3 * 2 + 1) * i2) * 4);
                                    int k5 = this.imageData.getInt((i3 * 2 + 0 + (k3 * 2 + 1) * i2) * 4);
                                    int l5 = this.func_1072_a(this.func_1072_a(i4, k4), this.func_1072_a(i5, k5));
                                    this.imageData.putInt((i3 + k3 * k2) * 4, l5);
                                    ++k3;
                                }
                                ++i3;
                            }
                            GL11.glTexSubImage2D((int)3553, (int)k1, (int)(texturefx.texIndex % 16 * k2), (int)(texturefx.texIndex / 16 * k2), (int)k2, (int)k2, (int)6408, (int)5121, (ByteBuffer)this.imageData);
                        }
                    }
                    ++texFXV;
                }
                ++texFXU;
            }
            ++i;
        }
        int j = 0;
        while (j < this.textureFXs.size()) {
            TextureFX texturefx1 = this.textureFXs.get(j);
            if (texturefx1.size > 0) {
                this.imageData.clear();
                this.imageData.put(texturefx1.bitMap);
                this.imageData.position(0).limit(texturefx1.bitMap.length);
                GL11.glBindTexture((int)3553, (int)texturefx1.size);
                GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)this.imageData);
                if (useMipMaps) {
                    for (int l = 1; l <= 4; ++l) {
                        int j1 = 16 >> l - 1;
                        int l1 = 16 >> l;
                        int j2 = 0;
                        while (j2 < l1) {
                            int l2 = 0;
                            while (l2 < l1) {
                                int j3 = this.imageData.getInt((j2 * 2 + 0 + (l2 * 2 + 0) * j1) * 4);
                                int l3 = this.imageData.getInt((j2 * 2 + 1 + (l2 * 2 + 0) * j1) * 4);
                                int j4 = this.imageData.getInt((j2 * 2 + 1 + (l2 * 2 + 1) * j1) * 4);
                                int l4 = this.imageData.getInt((j2 * 2 + 0 + (l2 * 2 + 1) * j1) * 4);
                                int j5 = this.func_1072_a(this.func_1072_a(j3, l3), this.func_1072_a(j4, l4));
                                this.imageData.putInt((j2 + l2 * l1) * 4, j5);
                                ++l2;
                            }
                            ++j2;
                        }
                        GL11.glTexSubImage2D((int)3553, (int)l, (int)0, (int)0, (int)l1, (int)l1, (int)6408, (int)5121, (ByteBuffer)this.imageData);
                    }
                }
            }
            ++j;
        }
    }

    private int func_1072_a(int i, int j) {
        int k = (i & 0xFF000000) >> 24 & 0xFF;
        int l = (j & 0xFF000000) >> 24 & 0xFF;
        return (k + l >> 1 << 24) + ((i & 0xFEFEFE) + (j & 0xFEFEFE) >> 1);
    }

    private int func_1077_b(int i, int j) {
        int k = (i & 0xFF000000) >> 24 & 0xFF;
        int l = (j & 0xFF000000) >> 24 & 0xFF;
        int c = 255;
        if (k + l == 0) {
            k = 1;
            l = 1;
            c = 0;
        }
        int i1 = (i >> 16 & 0xFF) * k;
        int j1 = (i >> 8 & 0xFF) * k;
        int k1 = (i & 0xFF) * k;
        int l1 = (j >> 16 & 0xFF) * l;
        int i2 = (j >> 8 & 0xFF) * l;
        int j2 = (j & 0xFF) * l;
        int k2 = (i1 + l1) / (k + l);
        int l2 = (j1 + i2) / (k + l);
        int i3 = (k1 + j2) / (k + l);
        return c << 24 | k2 << 16 | l2 << 8 | i3;
    }

    public void refreshTextures_() {
        TexturePackBase texturepackbase = this.texturePack.selectedTexturePack;
        for (int i : this.textureNameToImageMap.keySet()) {
            BufferedImage bufferedimage = this.textureNameToImageMap.get(i);
            this.setupTexture(bufferedimage, i);
        }
        for (DownloadImageThreadData downloadimagethreaddata : this.urlToImageDataMap.values()) {
            downloadimagethreaddata.textureSetupComplete = false;
        }
        for (String s : this.textureMap.keySet()) {
            try {
                BufferedImage bufferedimage1;
                if (s.startsWith("##")) {
                    bufferedimage1 = this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2))));
                } else if (s.startsWith("%%")) {
                    this.clampTexture = true;
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2)));
                    this.clampTexture = false;
                } else {
                    if (s.startsWith("%clamp%")) {
                        this.clampTexture = true;
                        bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(7)));
                        this.clampTexture = false;
                    }
                    bufferedimage1 = s.startsWith("%blur%") ? this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(6))) : this.readTextureImage(texturepackbase.getResourceAsStream(s));
                }
                this.func_28147_a(bufferedimage1, (int[])this.field_28151_c.get(s));
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    public void refreshTextures() {
        TexturePackBase texturepackbase = this.texturePack.selectedTexturePack;
        for (int i : this.textureNameToImageMap.keySet()) {
            BufferedImage bufferedimage = this.textureNameToImageMap.get(i);
            this.setupTexture(bufferedimage, i);
        }
        for (DownloadImageThreadData threaddownloadimagedata : this.urlToImageDataMap.values()) {
            threaddownloadimagedata.textureSetupComplete = false;
        }
        for (String s : this.textureMap.keySet()) {
            try {
                BufferedImage bufferedimage1;
                if (s.startsWith("##")) {
                    bufferedimage1 = this.unwrapImageByColumns(this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2))));
                } else if (s.startsWith("%%")) {
                    this.clampTexture = true;
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(2)));
                    this.clampTexture = false;
                } else if (s.startsWith("%clamp%")) {
                    this.clampTexture = true;
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(7)));
                } else if (s.startsWith("%blur%")) {
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s.substring(6)));
                } else {
                    System.out.println(s);
                    bufferedimage1 = this.readTextureImage(texturepackbase.getResourceAsStream(s));
                }
                int j = this.textureMap.get(s);
                this.setupTexture(bufferedimage1, j);
                this.clampTexture = false;
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
    }

    private BufferedImage readTextureImage(InputStream inputstream) throws IOException {
        BufferedImage bufferedimage = ImageIO.read(inputstream);
        inputstream.close();
        return bufferedimage;
    }

    public void bindTex(int i) {
        if (i < 0) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)i);
    }
}

