/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.entity.EntityBubbleFX;
import com.mojang.minecraft.client.entity.EntityExplodeFX;
import com.mojang.minecraft.client.entity.EntityFlameFX;
import com.mojang.minecraft.client.entity.EntityLavaFX;
import com.mojang.minecraft.client.entity.EntityLightningBugFX;
import com.mojang.minecraft.client.entity.EntityPlayerSP;
import com.mojang.minecraft.client.entity.EntityReddustFX;
import com.mojang.minecraft.client.entity.EntitySlimeFX;
import com.mojang.minecraft.client.entity.EntitySmokeFX;
import com.mojang.minecraft.client.entity.EntitySplashFX;
import com.mojang.minecraft.client.entity.EntityStarsFX;
import com.mojang.minecraft.client.entity.tile.TileEntityRenderer;
import com.mojang.minecraft.client.render.GLAllocation;
import com.mojang.minecraft.client.render.ICamera;
import com.mojang.minecraft.client.render.IWorldAccess;
import com.mojang.minecraft.client.render.ImageBufferDownload;
import com.mojang.minecraft.client.render.RenderBlocks;
import com.mojang.minecraft.client.render.RenderBlocksFlat;
import com.mojang.minecraft.client.render.RenderEngine;
import com.mojang.minecraft.client.render.RenderManager;
import com.mojang.minecraft.client.render.RenderSorter;
import com.mojang.minecraft.client.render.Tessellator;
import com.mojang.minecraft.client.render.Vec3D;
import com.mojang.minecraft.client.render.WorldRenderer;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.EntitySorter;
import com.mojang.minecraft.core.entity.MovingObjectPosition;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemRecord;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.TileEntity;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.core.util.MathHelper;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class RenderGlobal
implements IWorldAccess {
    public List<TileEntity> tileEntities;
    private World worldObj;
    private RenderEngine renderEngine;
    private List<WorldRenderer> worldRenderersToUpdate;
    private WorldRenderer[] sortedWorldRenderers;
    private WorldRenderer[] worldRenderers;
    private int d = GL11.glGenLists((int)2);
    private int renderChunksWide;
    private int renderChunksTall;
    private int renderChunksDeep;
    private int glRenderListBase;
    private Minecraft mc;
    private RenderBlocks globalRenderBlocks;
    private IntBuffer glOcclusionQueryBase;
    private boolean occlusionEnabled = false;
    public long cloudOffsetX = 0L;
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private int renderDistance = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    int[] dummyBuf50k = null;
    IntBuffer occlusionResult;
    private int renderersLoaded;
    private int renderersBeingClipped;
    private int renderersBeingOccluded;
    private int renderersBeingRendered;
    private int renderersSkippingRenderPass;
    private IntBuffer bone;
    int boop = 0;
    int glDummyList;
    double prevSortX = -9999.0;
    double prevSortY = -9999.0;
    double prevSortZ = -9999.0;
    public float damagePartialTime;
    private long field_1414_S;
    int frustrumCheckOffset = 0;
    private int field_21156_R = 0;
    FloatBuffer floatBuffer;
    boolean texClouds = true;
    float cloudHeight = 108.0f;
    public double cloudX = 0.0;
    public double cloudZ = 0.0;
    public long cloudPassNumber = 0L;

    public RenderGlobal(Minecraft minecraft, RenderEngine renderengine) {
        this.tileEntities = new ArrayList<TileEntity>();
        this.worldRenderersToUpdate = new ArrayList<WorldRenderer>();
        this.occlusionResult = GLAllocation.createDirectIntBuffer(64);
        this.bone = BufferUtils.createIntBuffer((int)65536);
        this.glDummyList = GLAllocation.generateDisplayLists(1);
        this.field_1414_S = System.currentTimeMillis();
        this.mc = minecraft;
        this.renderEngine = renderengine;
        this.floatBuffer = BufferUtils.createFloatBuffer((int)16);
        int byte0 = 64;
        this.glRenderListBase = GLAllocation.generateDisplayLists(byte0 * byte0 * byte0 * 3);
        this.occlusionEnabled = minecraft.getOpenGlCapsChecker().checkARBOcclusion(minecraft);
        if (this.occlusionEnabled) {
            this.occlusionResult.clear();
            this.glOcclusionQueryBase = GLAllocation.createDirectIntBuffer(byte0 * byte0 * byte0);
            this.glOcclusionQueryBase.clear();
            this.glOcclusionQueryBase.position(0);
            this.glOcclusionQueryBase.limit(byte0 * byte0 * byte0);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.glOcclusionQueryBase);
        }
        this.starGLCallList = GLAllocation.generateDisplayLists(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.func_950_f();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.instance;
        tessellator.noTextures = minecraft.options.noTextures;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte1 = 64;
        int i = 256 / byte1 + 2;
        float f = 16.0f;
        int j = -byte1 * i;
        while (j <= byte1 * i) {
            int l = -byte1 * i;
            while (l <= byte1 * i) {
                tessellator.startDrawingQuads();
                tessellator.addVertex(j + 0, f, l + 0);
                tessellator.addVertex(j + byte1, f, l + 0);
                tessellator.addVertex(j + byte1, f, l + byte1);
                tessellator.addVertex(j + 0, f, l + byte1);
                tessellator.draw();
                l += byte1;
            }
            j += byte1;
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        tessellator.startDrawingQuads();
        int k = -byte1 * i;
        while (k <= byte1 * i) {
            int i1 = -byte1 * i;
            while (i1 <= byte1 * i) {
                tessellator.addVertex(k + byte1, f, i1 + 0);
                tessellator.addVertex(k + 0, f, i1 + 0);
                tessellator.addVertex(k + 0, f, i1 + byte1);
                tessellator.addVertex(k + byte1, f, i1 + byte1);
                i1 += byte1;
            }
            k += byte1;
        }
        tessellator.draw();
        GL11.glEndList();
    }

    private void func_950_f() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        int i = 0;
        while (i < 1500) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (!(d4 >= 1.0) && !(d4 <= 0.01)) {
                d4 = 1.0 / Math.sqrt(d4);
                double d5 = (d *= d4) * 100.0;
                double d6 = (d1 *= d4) * 100.0;
                double d7 = (d2 *= d4) * 100.0;
                double d8 = Math.atan2(d, d2);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = random.nextDouble() * Math.PI * 2.0;
                double d15 = Math.sin(d14);
                double d16 = Math.cos(d14);
                int j = 0;
                while (j < 4) {
                    double d17 = 0.0;
                    double d18 = (double)((j & 2) - 1) * d3;
                    double d19 = (double)((j + 1 & 2) - 1) * d3;
                    double d20 = d18 * d16 - d19 * d15;
                    double d21 = d19 * d16 + d18 * d15;
                    double d22 = d20 * d12 + d17 * d13;
                    double d23 = d17 * d12 - d20 * d13;
                    double d24 = d23 * d9 - d21 * d10;
                    double d25 = d21 * d9 + d23 * d10;
                    tessellator.addVertex(d5 + d24, d6 + d22, d7 + d25);
                    ++j;
                }
            }
            ++i;
        }
        tessellator.draw();
    }

    public void changeWorld(World world) {
        if (world != null) {
            this.cloudHeight = world.cloudHeight;
        }
        if (this.worldObj != null) {
            this.worldObj.func_672_b(this);
        }
        this.prevSortX = -9999.0;
        this.prevSortY = -9999.0;
        this.prevSortZ = -9999.0;
        RenderManager.subManager.func_852_a(world);
        this.worldObj = world;
        RenderBlocks renderBlocks = this.globalRenderBlocks = this.worldObj.mc.options.noTextures ? new RenderBlocksFlat(world) : new RenderBlocks(world);
        if (world != null) {
            world.func_613_a(this);
            this.loadRenderers();
        }
    }

    public void loadRenderers() {
        int j;
        Block.leaves.setFastOrFancy(this.mc.options.leafLevel);
        this.renderDistance = this.mc.options.renderDistance;
        if (this.worldRenderers != null) {
            int i = 0;
            while (i < this.worldRenderers.length) {
                this.worldRenderers[i].func_1204_c();
                ++i;
            }
        }
        if ((j = 64 << 3 - this.renderDistance) == 1024) {
            j = 768;
        }
        if (j > 1024) {
            j = 1024;
        }
        this.renderChunksWide = j / 16 + 1;
        this.renderChunksTall = 8;
        this.renderChunksDeep = j / 16 + 1;
        this.worldRenderers = new WorldRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        this.sortedWorldRenderers = new WorldRenderer[this.renderChunksWide * this.renderChunksTall * this.renderChunksDeep];
        int k = 0;
        int l = 0;
        this.minBlockX = 0;
        this.minBlockY = 0;
        this.minBlockZ = 0;
        this.maxBlockX = this.renderChunksWide;
        this.maxBlockY = this.renderChunksTall;
        this.maxBlockZ = this.renderChunksDeep;
        int i1 = 0;
        while (i1 < this.worldRenderersToUpdate.size()) {
            this.worldRenderersToUpdate.get((int)i1).needsUpdate = false;
            ++i1;
        }
        this.worldRenderersToUpdate.clear();
        this.tileEntities.clear();
        int xIndex = 0;
        while (xIndex < this.renderChunksWide) {
            int yIndex = 0;
            while (yIndex < this.renderChunksTall) {
                int zIndex = 0;
                while (zIndex < this.renderChunksDeep) {
                    int pX = xIndex * 16;
                    int pY = yIndex * 16;
                    int pZ = zIndex * 16;
                    int dist = 0;
                    if (this.mc.thePlayer != null) {
                        dist = MathHelper.floor_double(this.mc.thePlayer.getDistance(pX, this.mc.thePlayer.posY, pZ) / 128.0);
                    }
                    this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex] = new WorldRenderer(this.worldObj, this.tileEntities, xIndex * 16, yIndex * 16, zIndex * 16, 16, this.glRenderListBase + k, dist);
                    if (this.occlusionEnabled) {
                        this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex].field_1732_z = this.glOcclusionQueryBase.get(l);
                    }
                    this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex].isWaitingOnOcclusionQuery = false;
                    this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex].isVisible = true;
                    this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex].isInFrustrum = true;
                    this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex].chunkIndex = l++;
                    this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex].markDirty();
                    this.sortedWorldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex] = this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex];
                    this.worldRenderersToUpdate.add(this.worldRenderers[(zIndex * this.renderChunksTall + yIndex) * this.renderChunksWide + xIndex]);
                    k += 3;
                    ++zIndex;
                }
                ++yIndex;
            }
            ++xIndex;
        }
        if (this.mc.mcWorld != null) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            this.func_956_b(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
            Arrays.sort(this.sortedWorldRenderers, new EntitySorter(entityplayersp));
        }
        this.renderEntitiesStartupCounter = 2;
    }

    public void handleTileEntityRendering(Vec3D vec3d, ICamera icamera, float f) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            Entity entity;
            TileEntityRenderer.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRender, this.mc.thePlayer, f);
            RenderManager.subManager.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRender, this.mc.thePlayer, this.mc.options, f);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            RenderManager.renderPosX = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
            RenderManager.renderPosY = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
            RenderManager.renderPosZ = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
            TileEntityRenderer.field_1553_b = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
            TileEntityRenderer.field_1552_c = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
            TileEntityRenderer.field_1551_d = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
            List<Entity> list = this.worldObj.getLoadedEntityList();
            this.countEntitiesTotal = list.size();
            int i = 0;
            while (i < this.worldObj.weatherEffects.size()) {
                entity = this.worldObj.weatherEffects.get(i);
                ++this.countEntitiesRendered;
                if (entity.isInRangeToRenderVec3D(vec3d)) {
                    RenderManager.subManager.renderEntity(entity, f);
                }
                ++i;
            }
            i = 0;
            while (i < list.size()) {
                entity = list.get(i);
                if (entity.isInRangeToRenderVec3D(vec3d) && icamera.func_342_a(entity.boundingBox) && (entity != this.mc.thePlayer || this.mc.options.thirdPersonView)) {
                    ++this.countEntitiesRendered;
                    RenderManager.subManager.renderEntity(entity, f);
                }
                ++i;
            }
            int j = 0;
            while (j < this.tileEntities.size()) {
                TileEntityRenderer.instance.renderTileEntity(this.tileEntities.get(j), f);
                ++j;
            }
        }
    }

    public String getDebugInfoRenders() {
        return "Chunks: " + this.renderersBeingRendered + "/" + this.renderersLoaded + ". Frustrum: " + this.renderersBeingClipped + ", Occluded: " + this.renderersBeingOccluded + ", Entities: " + this.renderersSkippingRenderPass;
    }

    public String getDebugInfoEntities() {
        return "Entities: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ". Occluded: " + this.countEntitiesHidden + ", Invisible: " + (this.countEntitiesTotal - this.countEntitiesHidden - this.countEntitiesRendered);
    }

    private void func_956_b(int i, int j, int k) {
        i -= 8;
        j -= 8;
        k -= 8;
        this.minBlockX = Integer.MAX_VALUE;
        this.minBlockY = Integer.MAX_VALUE;
        this.minBlockZ = Integer.MAX_VALUE;
        this.maxBlockX = Integer.MIN_VALUE;
        this.maxBlockY = Integer.MIN_VALUE;
        this.maxBlockZ = Integer.MIN_VALUE;
        int l = this.renderChunksWide * 16;
        int i1 = l / 2;
        int j1 = 0;
        while (j1 < this.renderChunksWide) {
            int k1 = j1 * 16;
            int l1 = k1 + i1 - i;
            if (l1 < 0) {
                l1 -= l - 1;
            }
            if ((k1 -= (l1 /= l) * l) < this.minBlockX) {
                this.minBlockX = k1;
            }
            if (k1 > this.maxBlockX) {
                this.maxBlockX = k1;
            }
            int i2 = 0;
            while (i2 < this.renderChunksDeep) {
                int j2 = i2 * 16;
                int k2 = j2 + i1 - k;
                if (k2 < 0) {
                    k2 -= l - 1;
                }
                if ((j2 -= (k2 /= l) * l) < this.minBlockZ) {
                    this.minBlockZ = j2;
                }
                if (j2 > this.maxBlockZ) {
                    this.maxBlockZ = j2;
                }
                int l2 = 0;
                while (l2 < this.renderChunksTall) {
                    int i3 = l2 * 16;
                    if (i3 < this.minBlockY) {
                        this.minBlockY = i3;
                    }
                    if (i3 > this.maxBlockY) {
                        this.maxBlockY = i3;
                    }
                    WorldRenderer worldrenderer = this.worldRenderers[(i2 * this.renderChunksTall + l2) * this.renderChunksWide + j1];
                    boolean flag = worldrenderer.needsUpdate;
                    worldrenderer.setPosition(k1, i3, j2);
                    if (!flag && worldrenderer.needsUpdate) {
                        this.worldRenderersToUpdate.add(worldrenderer);
                    }
                    ++l2;
                }
                ++i2;
            }
            ++j1;
        }
    }

    public int func_943_a(EntityPlayer entityplayer, int i, double d) {
        int j;
        if (this.occlusionEnabled) {
            int j2 = 0;
            while (j2 < 10) {
                this.field_21156_R = (this.field_21156_R + 1) % this.worldRenderers.length;
                WorldRenderer worldrenderer = this.worldRenderers[this.field_21156_R];
                if (worldrenderer.needsUpdate && !this.worldRenderersToUpdate.contains(worldrenderer)) {
                    this.worldRenderersToUpdate.add(worldrenderer);
                }
                ++j2;
            }
        }
        if (this.mc.options.renderDistance != this.renderDistance) {
            this.loadRenderers();
        }
        if (this.mc.mcWorld.seasonChanged) {
            this.loadRenderers();
            this.mc.mcWorld.seasonChanged = false;
        }
        if (i == 0) {
            this.renderersLoaded = 0;
            this.renderersBeingClipped = 0;
            this.renderersBeingOccluded = 0;
            this.renderersBeingRendered = 0;
            this.renderersSkippingRenderPass = 0;
        }
        double d1 = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * d;
        double d2 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * d;
        double d3 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * d;
        double d4 = entityplayer.posX - this.prevSortX;
        double d5 = entityplayer.posY - this.prevSortY;
        double d6 = entityplayer.posZ - this.prevSortZ;
        double d8 = d4 * d4 + d5 * d5 + d6 * d6;
        if (d8 > 16.0) {
            this.prevSortX = entityplayer.posX;
            this.prevSortY = entityplayer.posY;
            this.prevSortZ = entityplayer.posZ;
            this.func_956_b(MathHelper.floor_double(entityplayer.posX), MathHelper.floor_double(entityplayer.posY), MathHelper.floor_double(entityplayer.posZ));
            Arrays.sort(this.sortedWorldRenderers, new EntitySorter(entityplayer));
        }
        int playerOffsetX = (int)entityplayer.posX;
        int playerOffsetZ = (int)entityplayer.posZ;
        int x = 2000;
        if (Math.abs(playerOffsetX - Tessellator.chunkOffsetX) > 2000 || Math.abs(playerOffsetZ - Tessellator.chunkOffsetZ) > 2000) {
            Tessellator.chunkOffsetX = playerOffsetX;
            Tessellator.chunkOffsetZ = playerOffsetZ;
            this.loadRenderers();
        }
        if (this.occlusionEnabled && !this.mc.options.anaglyph && i == 0) {
            int k = 0;
            int l = 16;
            this.checkOcclusionQueryResult(k, l);
            int i1 = k;
            while (i1 < l) {
                this.sortedWorldRenderers[i1].isVisible = true;
                ++i1;
            }
            j = this.renderChunks(k, l, i, d);
            do {
                int byte0 = l;
                if ((l *= 2) > this.sortedWorldRenderers.length) {
                    l = this.sortedWorldRenderers.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                this.checkOcclusionQueryResult(byte0, l);
                GL11.glPushMatrix();
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int j1 = byte0;
                while (j1 < l) {
                    if (this.sortedWorldRenderers[j1].canRender()) {
                        this.sortedWorldRenderers[j1].isInFrustrum = false;
                    } else {
                        float f3;
                        int k1;
                        if (!this.sortedWorldRenderers[j1].isInFrustrum) {
                            this.sortedWorldRenderers[j1].isVisible = true;
                        }
                        if (this.sortedWorldRenderers[j1].isInFrustrum && !this.sortedWorldRenderers[j1].isWaitingOnOcclusionQuery && this.cloudOffsetX % (long)(k1 = (int)(1.0f + (f3 = MathHelper.sqrt_float(this.sortedWorldRenderers[j1].distanceToEntitySquared(entityplayer))) / 128.0f)) == (long)(j1 % k1)) {
                            WorldRenderer worldrenderer = this.sortedWorldRenderers[j1];
                            float f4 = (float)((double)worldrenderer.field_1755_i - d1);
                            float f5 = (float)((double)worldrenderer.field_1754_j - d2);
                            float f6 = (float)((double)worldrenderer.field_1753_k - d3);
                            float f7 = f4 - f;
                            float f8 = f5 - f1;
                            float f9 = f6 - f2;
                            if (f7 != 0.0f || f8 != 0.0f || f9 != 0.0f) {
                                GL11.glTranslatef((float)f7, (float)f8, (float)f9);
                                f += f7;
                                f1 += f8;
                                f2 += f9;
                            }
                            ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.sortedWorldRenderers[j1].field_1732_z);
                            this.sortedWorldRenderers[j1].callOcclusionQueryList();
                            ARBOcclusionQuery.glEndQueryARB((int)35092);
                            this.sortedWorldRenderers[j1].isWaitingOnOcclusionQuery = true;
                        }
                    }
                    ++j1;
                }
                GL11.glPopMatrix();
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                j += this.renderChunks(byte0, l, i, d);
            } while (l < this.sortedWorldRenderers.length);
        } else {
            j = this.renderChunks(0, this.sortedWorldRenderers.length, i, d);
        }
        return j;
    }

    private void checkOcclusionQueryResult(int i, int j) {
        int k = i;
        while (k < j) {
            if (this.sortedWorldRenderers[k].isWaitingOnOcclusionQuery) {
                this.occlusionResult.clear();
                ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[k].field_1732_z, (int)34919, (IntBuffer)this.occlusionResult);
                if (this.occlusionResult.get(0) != 0) {
                    this.sortedWorldRenderers[k].isWaitingOnOcclusionQuery = false;
                    this.occlusionResult.clear();
                    ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[k].field_1732_z, (int)34918, (IntBuffer)this.occlusionResult);
                    this.sortedWorldRenderers[k].isVisible = this.occlusionResult.get(0) != 0;
                }
            }
            ++k;
        }
    }

    private int renderChunks(int startIndex, int endIndex, int renderPass, double partialTicks) {
        int l = 0;
        this.bone.clear();
        int i1 = startIndex;
        while (i1 < endIndex) {
            int j1;
            if (renderPass == 0) {
                ++this.renderersLoaded;
                if (this.sortedWorldRenderers[i1].skipRenderPass[renderPass]) {
                    ++this.renderersSkippingRenderPass;
                } else if (!this.sortedWorldRenderers[i1].isInFrustrum) {
                    ++this.renderersBeingClipped;
                } else if (this.occlusionEnabled && !this.sortedWorldRenderers[i1].isVisible) {
                    ++this.renderersBeingOccluded;
                } else {
                    ++this.renderersBeingRendered;
                }
            }
            if (!this.sortedWorldRenderers[i1].skipRenderPass[renderPass] && this.sortedWorldRenderers[i1].isInFrustrum && this.sortedWorldRenderers[i1].isVisible && (j1 = this.sortedWorldRenderers[i1].getGLCallListForPass(renderPass)) >= 0) {
                this.bone.put(j1);
                ++l;
            }
            ++i1;
        }
        this.bone.flip();
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * partialTicks - (double)Tessellator.chunkOffsetX;
        double d1 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * partialTicks;
        double d2 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * partialTicks - (double)Tessellator.chunkOffsetZ;
        GL11.glTranslated((double)(-d), (double)(-d1), (double)(-d2));
        GL11.glCallLists((IntBuffer)this.bone);
        GL11.glTranslated((double)d, (double)d1, (double)d2);
        return l;
    }

    public void updateClouds() {
        this.cloudOffsetX = this.mc.mcWorld.worldTime;
    }

    public final void renderWater() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/water.png"));
        float var1 = this.worldObj.getBrightness(0, 0, 0);
        GL11.glColor4f((float)var1, (float)var1, (float)var1, (float)1.0f);
        GL11.glCallList((int)(this.d + 1));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void renderSky(float f) {
        GL11.glDisable((int)3553);
        Vec3D vec3d = this.worldObj.calculateSkyTopColor(f);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        if (this.mc.options.anaglyph) {
            float f9 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f4 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f9;
            f2 = f4;
            f3 = f6;
        }
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Object af = null;
        if (af != null) {
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float f7 = this.worldObj.calculateCelestialAngle(f);
            GL11.glRotatef((float)(f7 <= 0.5f ? 0.0f : 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.startDrawing(6);
            tessellator.setColorRGBA_F((float)af[0], (float)af[1], (float)af[2], (float)af[3]);
            tessellator.addVertex(0.0, 100.0, 0.0);
            int i = 16;
            tessellator.setColorRGBA_F((float)af[0], (float)af[1], (float)af[2], 0.0f);
            int j = 0;
            while (j <= i) {
                float f10 = (float)j * 3.141593f * 2.0f / (float)i;
                float f14 = MathHelper.sin(f10);
                float f15 = MathHelper.cos(f10);
                tessellator.addVertex(f14 * 120.0f, f15 * 120.0f, -f15 * 40.0f * af[3]);
                ++j;
            }
            tessellator.draw();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glPushMatrix();
        float f5 = 0.0f;
        float f8 = 0.0f;
        float f12 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)f5, (float)f8, (float)f12);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.worldObj.calculateCelestialAngle(f) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f13 = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain/sun.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f13, 100.0, -f13, 0.0, 0.0);
        tessellator.addVertexWithUV(f13, 100.0, -f13, 1.0, 0.0);
        tessellator.addVertexWithUV(f13, 100.0, f13, 1.0, 1.0);
        tessellator.addVertexWithUV(-f13, 100.0, f13, 0.0, 1.0);
        tessellator.draw();
        f13 = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain/moon.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f13, -100.0, f13, 1.0, 1.0);
        tessellator.addVertexWithUV(f13, -100.0, f13, 0.0, 1.0);
        tessellator.addVertexWithUV(f13, -100.0, -f13, 0.0, 0.0);
        tessellator.addVertexWithUV(-f13, -100.0, -f13, 1.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3553);
        float f11 = this.worldObj.func_679_f(f);
        if (f11 > 0.0f) {
            GL11.glColor4f((float)f11, (float)f11, (float)f11, (float)f11);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        GL11.glDisable((int)3553);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void renderSky_(float f) {
        GL11.glDisable((int)3553);
        Vec3D vec3d = this.worldObj.calculateSkyTopColor(f);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        if (this.mc.options.anaglyph) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f7 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f7;
        }
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glPushMatrix();
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)f6, (float)f8, (float)f9);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.worldObj.calculateCelestialAngle(f) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f10 = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain/sun.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f10, 100.0, -f10, 0.0, 0.0);
        tessellator.addVertexWithUV(f10, 100.0, -f10, 1.0, 0.0);
        tessellator.addVertexWithUV(f10, 100.0, f10, 1.0, 1.0);
        tessellator.addVertexWithUV(-f10, 100.0, f10, 0.0, 1.0);
        tessellator.draw();
        f10 = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain/moon.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f10, -100.0, f10, 1.0, 1.0);
        tessellator.addVertexWithUV(f10, -100.0, f10, 0.0, 1.0);
        tessellator.addVertexWithUV(f10, -100.0, -f10, 0.0, 0.0);
        tessellator.addVertexWithUV(-f10, -100.0, -f10, 1.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3553);
        float f11 = this.worldObj.func_679_f(f);
        if (f11 > 0.0f) {
            GL11.glColor4f((float)f11, (float)f11, (float)f11, (float)f11);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        GL11.glDisable((int)3553);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void renderClouds(float f) {
        if (this.mc.options.cloudLevel != 0) {
            if (this.mc.options.cloudLevel == 2) {
                this.renderFancyClouds(f);
            } else {
                GL11.glDisable((int)2884);
                float f1 = (float)(this.mc.thePlayer.lastTickPosY + (this.mc.thePlayer.posY - this.mc.thePlayer.lastTickPosY) * (double)f);
                int thirty_two = 32;
                int eight = 256 / thirty_two;
                Tessellator tessellator = Tessellator.instance;
                GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/clouds.png"));
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                Vec3D vec3d = this.worldObj.calculateFogColor(f);
                float f2 = (float)vec3d.xCoord;
                float f3 = (float)vec3d.yCoord;
                float f4 = (float)vec3d.zCoord;
                if (this.mc.options.anaglyph) {
                    float f5 = (f2 * 30.0f + f3 * 59.0f + f4 * 11.0f) / 100.0f;
                    float f7 = (f2 * 30.0f + f3 * 70.0f) / 100.0f;
                    float f8 = (f2 * 30.0f + f4 * 70.0f) / 100.0f;
                    f2 = f5;
                    f3 = f7;
                    f4 = f8;
                }
                float smol = 4.882813E-4f;
                double cloudU = this.mc.thePlayer.prevPosX + (this.mc.thePlayer.posX - this.mc.thePlayer.prevPosX) * (double)f + (double)(((float)this.cloudOffsetX + f) * 0.03f);
                double cloudV = this.mc.thePlayer.prevPosZ + (this.mc.thePlayer.posZ - this.mc.thePlayer.prevPosZ) * (double)f;
                int j = MathHelper.floor_double(cloudU / 2048.0);
                int k = MathHelper.floor_double(cloudV / 2048.0);
                this.cloudX = cloudU -= (double)(j * 2048);
                this.cloudZ = cloudV -= (double)(k * 2048);
                float f9 = this.worldObj.cloudHeight - f1 + 0.33f;
                float adjustedU = (float)(cloudU * (double)smol);
                float adjustedV = (float)(cloudV * (double)smol);
                tessellator.startDrawingQuads();
                tessellator.setColorRGBA_F(f2, f3, f4, 0.8f);
                int xVert = -thirty_two * eight;
                while (xVert < thirty_two * eight) {
                    int zVert = -thirty_two * eight;
                    while (zVert < thirty_two * eight) {
                        tessellator.addVertexWithUV(xVert + 0, f9, zVert + thirty_two, (float)(xVert + 0) * smol + adjustedU, (float)(zVert + thirty_two) * smol + adjustedV);
                        tessellator.addVertexWithUV(xVert + thirty_two, f9, zVert + thirty_two, (float)(xVert + thirty_two) * smol + adjustedU, (float)(zVert + thirty_two) * smol + adjustedV);
                        tessellator.addVertexWithUV(xVert + thirty_two, f9, zVert + 0, (float)(xVert + thirty_two) * smol + adjustedU, (float)(zVert + 0) * smol + adjustedV);
                        tessellator.addVertexWithUV(xVert + 0, f9, zVert + 0, (float)(xVert + 0) * smol + adjustedU, (float)(zVert + 0) * smol + adjustedV);
                        zVert += thirty_two;
                    }
                    xVert += thirty_two;
                }
                tessellator.draw();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2884);
            }
        }
    }

    public void func_947_b_(float f) {
        if (this.mc.options.clouds) {
            if (this.mc.options.cloudLevel == 2) {
                this.renderFancyClouds(f);
                return;
            }
            GL11.glDisable((int)2884);
            float f1 = (float)(this.mc.thePlayer.lastTickPosY + (this.mc.thePlayer.posY - this.mc.thePlayer.lastTickPosY) * (double)f);
            int byte0 = 32;
            int i = 256 / byte0;
            Tessellator tessellator = Tessellator.instance;
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/clouds.png"));
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Vec3D vec3d = this.worldObj.calculateFogColor(f);
            float f2 = (float)vec3d.xCoord;
            float f3 = (float)vec3d.yCoord;
            float f4 = (float)vec3d.zCoord;
            if (this.mc.options.anaglyph) {
                float f5 = (f2 * 30.0f + f3 * 59.0f + f4 * 11.0f) / 100.0f;
                float f7 = (f2 * 30.0f + f3 * 70.0f) / 100.0f;
                float f8 = (f2 * 30.0f + f4 * 70.0f) / 100.0f;
                f2 = f5;
                f3 = f7;
                f4 = f8;
            }
            float f6 = 4.882813E-4f;
            double posX = this.mc.thePlayer.prevPosX + (this.mc.thePlayer.posX - this.mc.thePlayer.prevPosX) * (double)f + (double)(((float)this.cloudOffsetX + f) * 0.03f);
            double posZ = this.mc.thePlayer.prevPosZ + (this.mc.thePlayer.posZ - this.mc.thePlayer.prevPosZ) * (double)f;
            int j = MathHelper.floor_double(posX / 2048.0);
            int k = MathHelper.floor_double(posZ / 2048.0);
            float f9 = 120.0f - f1 + 0.33f;
            float f10 = (float)((posX -= (double)(j * 2048)) * (double)f6);
            float f11 = (float)((posZ -= (double)(k * 2048)) * (double)f6);
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_F(f2, f3, f4, 0.8f);
            int l = -byte0 * i;
            while (l < byte0 * i) {
                int i1 = -byte0 * i;
                while (i1 < byte0 * i) {
                    tessellator.addVertexWithUV(l + 0, f9, i1 + byte0, (float)(l + 0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                    tessellator.addVertexWithUV(l + byte0, f9, i1 + byte0, (float)(l + byte0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                    tessellator.addVertexWithUV(l + byte0, f9, i1 + 0, (float)(l + byte0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
                    tessellator.addVertexWithUV(l + 0, f9, i1 + 0, (float)(l + 0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
                    i1 += byte0;
                }
                l += byte0;
            }
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
        }
    }

    private FloatBuffer a(float f1, float f2, float f3, float f4) {
        this.floatBuffer.clear();
        this.floatBuffer.put(f1).put(0.0f).put(f3).put(0.0f);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public void renderFancyCloudsWeather(float f) {
        GL11.glDisable((int)2884);
        float f1 = (float)(this.mc.thePlayer.lastTickPosY + (this.mc.thePlayer.posY - this.mc.thePlayer.lastTickPosY) * (double)f);
        Tessellator tessellator = Tessellator.instance;
        float cloudWidth = 16.0f;
        float cloudThickness = 4.0f;
        double posX = this.mc.thePlayer.prevPosX + (this.mc.thePlayer.posX - this.mc.thePlayer.prevPosX) * (double)f + (double)(((float)this.cloudOffsetX + f) * 0.03f);
        double posZ = this.mc.thePlayer.prevPosZ + (this.mc.thePlayer.posZ - this.mc.thePlayer.prevPosZ) * (double)f;
        double cloudsU = ((posX < 0.0 ? posX % 16.0 + 16.0 : posX % 16.0) + (double)(((float)this.cloudOffsetX + f) * 0.03f) % 16.0) / (double)cloudWidth;
        double cloudsV = (posZ < 0.0 ? posZ % 16.0 + 16.0 : posZ % 16.0) / (double)cloudWidth;
        float yVert = 108.0f - f1 - (108.0f - this.cloudHeight) + 0.33f;
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            this.renderEngine.getTex("/fluff.png");
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.a(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.a(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3553);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
            GL11.glTranslatef((float)((float)cloudsU), (float)((float)cloudsV), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL13.glActiveTexture((int)33984);
            GL11.glEnable((int)3553);
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/clouds_weather.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.worldObj.calculateFogColor(f);
        float red = (float)vec3d.xCoord;
        float green = (float)vec3d.yCoord;
        float blue = (float)vec3d.zCoord;
        if (this.mc.options.anaglyph) {
            float redAnaglyph = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            float greenAnaglyph = (red * 30.0f + green * 70.0f) / 100.0f;
            float blueAnaglyph = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = redAnaglyph;
            green = greenAnaglyph;
            blue = blueAnaglyph;
        }
        float adjustU1 = (float)(cloudsU * 0.0);
        float adjustV1 = (float)(cloudsV * 0.0);
        float xzShrinkAdjust = 0.00390625f;
        adjustU1 = -128.0f * xzShrinkAdjust + (float)MathHelper.floor_double(cloudsU);
        adjustV1 = -128.0f * xzShrinkAdjust + (float)MathHelper.floor_double(cloudsV);
        float adjustU2 = (float)(cloudsU - (double)MathHelper.floor_double(cloudsU));
        float adjustV2 = (float)(cloudsV - (double)MathHelper.floor_double(cloudsV));
        int eight = 8;
        int three = 3;
        float yShrinkAdjust = 9.765625E-4f;
        GL11.glScalef((float)cloudWidth, (float)1.0f, (float)cloudWidth);
        int l = 0;
        while (l < 2) {
            if (l == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            int uCoord = -three + 1;
            while (uCoord <= three) {
                int vCoord = -three + 1;
                while (vCoord <= three) {
                    tessellator.startDrawingQuads();
                    float uLoc = uCoord * eight;
                    float vLoc = vCoord * eight;
                    float xVert = uLoc - adjustU2;
                    float zVert = vLoc - adjustV2;
                    if (yVert > -cloudThickness - 1.0f) {
                        tessellator.setColorRGBA_F(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(xVert + 0.0f, yVert + 0.0f, zVert + (float)eight, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                        tessellator.addVertexWithUV(xVert + (float)eight, yVert + 0.0f, zVert + (float)eight, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                        tessellator.addVertexWithUV(xVert + (float)eight, yVert + 0.0f, zVert + 0.0f, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                        tessellator.addVertexWithUV(xVert + 0.0f, yVert + 0.0f, zVert + 0.0f, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                    }
                    if (yVert <= cloudThickness + 1.0f) {
                        tessellator.setColorRGBA_F(red, green, blue, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(xVert + 0.0f, yVert + cloudThickness - yShrinkAdjust, zVert + (float)eight, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                        tessellator.addVertexWithUV(xVert + (float)eight, yVert + cloudThickness - yShrinkAdjust, zVert + (float)eight, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                        tessellator.addVertexWithUV(xVert + (float)eight, yVert + cloudThickness - yShrinkAdjust, zVert + 0.0f, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                        tessellator.addVertexWithUV(xVert + 0.0f, yVert + cloudThickness - yShrinkAdjust, zVert + 0.0f, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                    }
                    tessellator.setColorRGBA_F(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                    if (uCoord > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        int k1 = 0;
                        while (k1 < eight) {
                            tessellator.addVertexWithUV(xVert + (float)k1 + 0.0f, yVert + 0.0f, zVert + (float)eight, (uLoc + (float)k1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)k1 + 0.0f, yVert + cloudThickness, zVert + (float)eight, (uLoc + (float)k1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)k1 + 0.0f, yVert + cloudThickness, zVert + 0.0f, (uLoc + (float)k1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)k1 + 0.0f, yVert + 0.0f, zVert + 0.0f, (uLoc + (float)k1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                            ++k1;
                        }
                    }
                    if (uCoord <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        int l1 = 0;
                        while (l1 < eight) {
                            tessellator.addVertexWithUV(xVert + (float)l1 + 1.0f - yShrinkAdjust, yVert + 0.0f, zVert + (float)eight, (uLoc + (float)l1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)l1 + 1.0f - yShrinkAdjust, yVert + cloudThickness, zVert + (float)eight, (uLoc + (float)l1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + (float)eight) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)l1 + 1.0f - yShrinkAdjust, yVert + cloudThickness, zVert + 0.0f, (uLoc + (float)l1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)l1 + 1.0f - yShrinkAdjust, yVert + 0.0f, zVert + 0.0f, (uLoc + (float)l1 + 0.5f) * xzShrinkAdjust + adjustU1, (vLoc + 0.0f) * xzShrinkAdjust + adjustV1);
                            ++l1;
                        }
                    }
                    tessellator.setColorRGBA_F(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                    if (vCoord > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        int i2 = 0;
                        while (i2 < eight) {
                            tessellator.addVertexWithUV(xVert + 0.0f, yVert + cloudThickness, zVert + (float)i2 + 0.0f, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + (float)i2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)eight, yVert + cloudThickness, zVert + (float)i2 + 0.0f, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + (float)i2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)eight, yVert + 0.0f, zVert + (float)i2 + 0.0f, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + (float)i2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + 0.0f, yVert + 0.0f, zVert + (float)i2 + 0.0f, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + (float)i2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            ++i2;
                        }
                    }
                    if (vCoord <= 1) {
                        tessellator.setNormal(0.0f, 0.0f, 1.0f);
                        int j2 = 0;
                        while (j2 < eight) {
                            tessellator.addVertexWithUV(xVert + 0.0f, yVert + cloudThickness, zVert + (float)j2 + 1.0f - yShrinkAdjust, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + (float)j2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)eight, yVert + cloudThickness, zVert + (float)j2 + 1.0f - yShrinkAdjust, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + (float)j2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + (float)eight, yVert + 0.0f, zVert + (float)j2 + 1.0f - yShrinkAdjust, (uLoc + (float)eight) * xzShrinkAdjust + adjustU1, (vLoc + (float)j2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            tessellator.addVertexWithUV(xVert + 0.0f, yVert + 0.0f, zVert + (float)j2 + 1.0f - yShrinkAdjust, (uLoc + 0.0f) * xzShrinkAdjust + adjustU1, (vLoc + (float)j2 + 0.5f) * xzShrinkAdjust + adjustV1);
                            ++j2;
                        }
                    }
                    tessellator.draw();
                    ++vCoord;
                }
                ++uCoord;
            }
            ++l;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3168);
            GL11.glDisable((int)3169);
            GL13.glActiveTexture((int)33984);
        }
    }

    public void renderFancyClouds(float f) {
        GL11.glDisable((int)2884);
        float f1 = (float)(this.mc.thePlayer.lastTickPosY + (this.mc.thePlayer.posY - this.mc.thePlayer.lastTickPosY) * (double)f);
        Tessellator tessellator = Tessellator.instance;
        float cloudWidth = 12.0f;
        float cloudThickness = 4.0f;
        double cloudsU = (this.mc.thePlayer.prevPosX + (this.mc.thePlayer.posX - this.mc.thePlayer.prevPosX) * (double)f + (double)(((float)this.cloudOffsetX + f) * 0.03f)) / (double)cloudWidth;
        double cloudsV = (this.mc.thePlayer.prevPosZ + (this.mc.thePlayer.posZ - this.mc.thePlayer.prevPosZ) * (double)f) / (double)cloudWidth + (double)0.33f;
        float f4 = 108.0f - f1 - (108.0f - this.cloudHeight) + 0.33f;
        int i = MathHelper.floor_double(cloudsU / 2048.0);
        int j = MathHelper.floor_double(cloudsV / 2048.0);
        this.cloudX = cloudsU -= (double)(i * 2048);
        this.cloudZ = cloudsV -= (double)(j * 2048);
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            this.renderEngine.getTex("/fluff.png");
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.a(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.a(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3553);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
            GL11.glTranslatef((float)((float)cloudsU), (float)((float)cloudsV), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL13.glActiveTexture((int)33984);
            GL11.glEnable((int)3553);
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.worldObj.calculateFogColor(f);
        float f5 = (float)vec3d.xCoord;
        float f6 = (float)vec3d.yCoord;
        float f7 = (float)vec3d.zCoord;
        if (this.mc.options.anaglyph) {
            float f8 = (f5 * 30.0f + f6 * 59.0f + f7 * 11.0f) / 100.0f;
            float f12 = (f5 * 30.0f + f6 * 70.0f) / 100.0f;
            float f10 = (f5 * 30.0f + f7 * 70.0f) / 100.0f;
            f5 = f8;
            f6 = f12;
            f7 = f10;
        }
        float f9 = (float)(cloudsU * 0.0);
        float f13 = (float)(cloudsV * 0.0);
        float f11 = 0.00390625f;
        f9 = (float)MathHelper.floor_double(cloudsU) * f11;
        f13 = (float)MathHelper.floor_double(cloudsV) * f11;
        float f14 = (float)(cloudsU - (double)MathHelper.floor_double(cloudsU));
        float f15 = (float)(cloudsV - (double)MathHelper.floor_double(cloudsV));
        int k = 8;
        int byte0 = 3;
        float f16 = 9.765625E-4f;
        GL11.glScalef((float)cloudWidth, (float)1.0f, (float)cloudWidth);
        int l = 0;
        while (l < 2) {
            if (l == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            int i1 = -byte0 + 1;
            while (i1 <= byte0) {
                int j1 = -byte0 + 1;
                while (j1 <= byte0) {
                    tessellator.startDrawingQuads();
                    float f17 = i1 * k;
                    float f18 = j1 * k;
                    float f19 = f17 - f14;
                    float f20 = f18 - f15;
                    if (f4 > -cloudThickness - 1.0f) {
                        tessellator.setColorRGBA_F(f5 * 0.7f, f6 * 0.7f, f7 * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)k, (f17 + 0.0f) * f11 + f9, (f18 + (float)k) * f11 + f13);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)k, (f17 + (float)k) * f11 + f9, (f18 + (float)k) * f11 + f13);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + 0.0f) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                    }
                    if (f4 <= cloudThickness + 1.0f) {
                        tessellator.setColorRGBA_F(f5, f6, f7, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness - f16, f20 + (float)k, (f17 + 0.0f) * f11 + f9, (f18 + (float)k) * f11 + f13);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + cloudThickness - f16, f20 + (float)k, (f17 + (float)k) * f11 + f9, (f18 + (float)k) * f11 + f13);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + cloudThickness - f16, f20 + 0.0f, (f17 + (float)k) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness - f16, f20 + 0.0f, (f17 + 0.0f) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                    }
                    tessellator.setColorRGBA_F(f5 * 0.9f, f6 * 0.9f, f7 * 0.9f, 0.8f);
                    if (i1 > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        int k1 = 0;
                        while (k1 < k) {
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + (float)k, (f17 + (float)k1 + 0.5f) * f11 + f9, (f18 + (float)k) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + cloudThickness, f20 + (float)k, (f17 + (float)k1 + 0.5f) * f11 + f9, (f18 + (float)k) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + cloudThickness, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                            ++k1;
                        }
                    }
                    if (i1 <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        int l1 = 0;
                        while (l1 < k) {
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + (float)k, (f17 + (float)l1 + 0.5f) * f11 + f9, (f18 + (float)k) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + cloudThickness, f20 + (float)k, (f17 + (float)l1 + 0.5f) * f11 + f9, (f18 + (float)k) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + cloudThickness, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f11 + f9, (f18 + 0.0f) * f11 + f13);
                            ++l1;
                        }
                    }
                    tessellator.setColorRGBA_F(f5 * 0.8f, f6 * 0.8f, f7 * 0.8f, 0.8f);
                    if (j1 > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        int i2 = 0;
                        while (i2 < k) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness, f20 + (float)i2 + 0.0f, (f17 + 0.0f) * f11 + f9, (f18 + (float)i2 + 0.5f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + cloudThickness, f20 + (float)i2 + 0.0f, (f17 + (float)k) * f11 + f9, (f18 + (float)i2 + 0.5f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)i2 + 0.0f, (f17 + (float)k) * f11 + f9, (f18 + (float)i2 + 0.5f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)i2 + 0.0f, (f17 + 0.0f) * f11 + f9, (f18 + (float)i2 + 0.5f) * f11 + f13);
                            ++i2;
                        }
                    }
                    if (j1 <= 1) {
                        tessellator.setNormal(0.0f, 0.0f, 1.0f);
                        int j2 = 0;
                        while (j2 < k) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + cloudThickness, f20 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f11 + f9, (f18 + (float)j2 + 0.5f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + cloudThickness, f20 + (float)j2 + 1.0f - f16, (f17 + (float)k) * f11 + f9, (f18 + (float)j2 + 0.5f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)j2 + 1.0f - f16, (f17 + (float)k) * f11 + f9, (f18 + (float)j2 + 0.5f) * f11 + f13);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f11 + f9, (f18 + (float)j2 + 0.5f) * f11 + f13);
                            ++j2;
                        }
                    }
                    tessellator.draw();
                    ++j1;
                }
                ++i1;
            }
            ++l;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3168);
            GL11.glDisable((int)3169);
            GL13.glActiveTexture((int)33984);
        }
    }

    public boolean updateRenderers(EntityPlayer entityplayer, boolean flag) {
        RenderSorter rendersorter = new RenderSorter(entityplayer);
        WorldRenderer[] aworldrenderer = new WorldRenderer[3];
        ArrayList<WorldRenderer> arraylist = null;
        int i = this.worldRenderersToUpdate.size();
        int j = 0;
        int k = 0;
        while (k < i) {
            block22: {
                WorldRenderer worldrenderer;
                block24: {
                    block23: {
                        worldrenderer = this.worldRenderersToUpdate.get(k);
                        if (flag) break block23;
                        if (!(worldrenderer.distanceToEntitySquared(entityplayer) > 1024.0f)) break block24;
                        int j1 = 0;
                        while (j1 < 3 && (aworldrenderer[j1] == null || rendersorter.doCompare(aworldrenderer[j1], worldrenderer) <= 0)) {
                            ++j1;
                        }
                        if (--j1 > 0) {
                            int l1 = j1;
                            while (true) {
                                if (--l1 == 0) {
                                    aworldrenderer[j1] = worldrenderer;
                                    break block22;
                                }
                                aworldrenderer[l1 - 1] = aworldrenderer[l1];
                            }
                        }
                        break block22;
                    }
                    if (!worldrenderer.isInFrustrum) break block22;
                }
                if (arraylist == null) {
                    arraylist = new ArrayList<WorldRenderer>();
                }
                ++j;
                arraylist.add(worldrenderer);
                this.worldRenderersToUpdate.set(k, null);
            }
            ++k;
        }
        if (arraylist != null) {
            if (arraylist.size() > 1) {
                Collections.sort(arraylist, rendersorter);
            }
            int l = arraylist.size() - 1;
            while (l >= 0) {
                WorldRenderer worldrenderer1 = (WorldRenderer)arraylist.get(l);
                worldrenderer1.updateRenderer();
                worldrenderer1.needsUpdate = false;
                --l;
            }
        }
        int i1 = 0;
        int j2 = 2;
        while (j2 >= 0) {
            WorldRenderer worldrenderer2 = aworldrenderer[j2];
            if (worldrenderer2 != null) {
                if (!worldrenderer2.isInFrustrum && j2 != 2) {
                    aworldrenderer[j2] = null;
                    aworldrenderer[0] = null;
                    break;
                }
                aworldrenderer[j2].updateRenderer();
                aworldrenderer[j2].needsUpdate = false;
                ++i1;
            }
            --j2;
        }
        int k2 = 0;
        int k1 = 0;
        int i2 = this.worldRenderersToUpdate.size();
        while (k2 != i2) {
            WorldRenderer worldrenderer3 = this.worldRenderersToUpdate.get(k2);
            if (worldrenderer3 != null && worldrenderer3 != aworldrenderer[0] && worldrenderer3 != aworldrenderer[1] && worldrenderer3 != aworldrenderer[2]) {
                if (k1 != k2) {
                    this.worldRenderersToUpdate.set(k1, worldrenderer3);
                }
                ++k1;
            }
            ++k2;
        }
        while (--k2 >= k1) {
            this.worldRenderersToUpdate.remove(k2);
        }
        return i == j + i1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateRenderers_(EntityPlayer entityplayer, boolean flag) {
        block27: {
            WorldRenderer chunk;
            if (!this.mc.options.particles) break block27;
            RenderSorter cmp = new RenderSorter(entityplayer);
            WorldRenderer[] toAdd = new WorldRenderer[3];
            ArrayList<WorldRenderer> nearChunks = null;
            float dist = 1024.0f;
            int pendingChunkSize = this.worldRenderersToUpdate.size();
            int pendingChunkRemoved = 0;
            int i = 0;
            while (i < pendingChunkSize) {
                block30: {
                    block29: {
                        block28: {
                            chunk = this.worldRenderersToUpdate.get(i);
                            if (flag) break block28;
                            if (!(chunk.distanceToEntitySquared(entityplayer) > dist)) break block29;
                            int index = 0;
                            while (index < 3) {
                                if (toAdd[index] != null && cmp.doCompare(toAdd[index], chunk) == 1) break;
                                ++index;
                            }
                            if (--index > 0) {
                                int x = index;
                                while (--x != 0) {
                                    toAdd[x - 1] = toAdd[x];
                                }
                                toAdd[index] = chunk;
                            }
                            break block30;
                        }
                        if (!chunk.isInFrustrum) break block30;
                    }
                    if (nearChunks == null) {
                        nearChunks = new ArrayList<WorldRenderer>();
                    }
                    ++pendingChunkRemoved;
                    nearChunks.add(chunk);
                    this.worldRenderersToUpdate.set(i, null);
                }
                ++i;
            }
            if (nearChunks != null) {
                if (nearChunks.size() > 1) {
                    Collections.sort(nearChunks, new RenderSorter(entityplayer));
                }
                i = nearChunks.size() - 1;
                while (i >= 0) {
                    chunk = (WorldRenderer)nearChunks.get(i);
                    chunk.updateRenderer();
                    chunk.needsUpdate = false;
                    --i;
                }
            }
            int secondaryRemoved = 0;
            int i2 = 2;
            while (i2 >= 0) {
                WorldRenderer chunk2 = toAdd[i2];
                if (chunk2 != null) {
                    if (!chunk2.isInFrustrum && i2 != 2) {
                        toAdd[i2] = null;
                        toAdd[0] = null;
                        break;
                    }
                    toAdd[i2].updateRenderer();
                    toAdd[i2].needsUpdate = false;
                    ++secondaryRemoved;
                }
                --i2;
            }
            int cursor = 0;
            int target = 0;
            int arraySize = this.worldRenderersToUpdate.size();
            while (cursor != arraySize) {
                WorldRenderer chunk3 = this.worldRenderersToUpdate.get(cursor);
                if (chunk3 != null && chunk3 != toAdd[0] && chunk3 != toAdd[1] && chunk3 != toAdd[2]) {
                    if (target != cursor) {
                        this.worldRenderersToUpdate.set(target, chunk3);
                    }
                    ++target;
                }
                ++cursor;
            }
            while (--cursor >= target) {
                this.worldRenderersToUpdate.remove(cursor);
            }
            return pendingChunkSize == pendingChunkRemoved + secondaryRemoved;
        }
        try {
            Collections.sort(this.worldRenderersToUpdate, new RenderSorter(entityplayer));
            int i = this.worldRenderersToUpdate.size() - 1;
            int j = this.worldRenderersToUpdate.size();
            int k = 0;
            while (k < j) {
                block34: {
                    block31: {
                        WorldRenderer worldrenderer;
                        block33: {
                            block32: {
                                worldrenderer = this.worldRenderersToUpdate.get(i - k);
                                if (flag) break block31;
                                if (!(worldrenderer.distanceToEntitySquared(entityplayer) > 1024.0f)) break block32;
                                if (worldrenderer.isInFrustrum ? k >= 3 : k >= 1) {
                                    return false;
                                }
                                break block33;
                            }
                            if (!worldrenderer.isInFrustrum) break block34;
                        }
                        worldrenderer.updateRenderer();
                        this.worldRenderersToUpdate.remove(worldrenderer);
                        worldrenderer.needsUpdate = false;
                    }
                    return this.worldRenderersToUpdate.size() == 0;
                }
                ++k;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return flag;
    }

    public void renderHeldItem(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i, ItemStack itemstack, float f) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (i == 0) {
            if (this.damagePartialTime > 0.0f) {
                GL11.glBlendFunc((int)774, (int)768);
                int j = this.renderEngine.getTex("/terrain.png");
                GL11.glBindTexture((int)3553, (int)j);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                int k = this.worldObj.getBlockId(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
                Block block = k <= 0 ? null : Block.allBlocks[k];
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                GL11.glEnable((int)32823);
                tessellator.startDrawingQuads();
                double d = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f;
                double d1 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f;
                double d2 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f;
                tessellator.setTranslationD(-d, -d1, -d2);
                tessellator.disableColor();
                if (block == null) {
                    block = Block.stone;
                }
                this.globalRenderBlocks.renderBlockUsingTexture(block, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ, 240 + (int)(this.damagePartialTime * 10.0f));
                tessellator.draw();
                tessellator.setTranslationD(0.0, 0.0, 0.0);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            }
        } else if (itemstack != null) {
            GL11.glBlendFunc((int)770, (int)771);
            float f1 = MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.8f;
            GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)(MathHelper.sin((float)System.currentTimeMillis() / 200.0f) * 0.2f + 0.5f));
            int l = this.renderEngine.getTex("/terrain.png");
            GL11.glBindTexture((int)3553, (int)l);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void drawSelectionBox(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i, ItemStack itemstack, float f) {
        if (i == 0 && movingobjectposition.typeOfHit == 0) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float f1 = 0.002f;
            int j = this.worldObj.getBlockId(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
            if (j > 0) {
                Block.allBlocks[j].setBlockBoundsBasedOnState(this.worldObj, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
                double d = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f;
                double d1 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f;
                double d2 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f;
                this.drawOutlinedBoundingBox(Block.allBlocks[j].getSelectedCollisionBoundingBoxFromPool(this.worldObj, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ).expand(f1, f1, f1).getOffsetBoundingBox(-d, -d1, -d2));
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    public void drawOutlinedBoundingBox(AxisAlignedBB axisalignedbb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.draw();
    }

    public void func_949_a(int i, int j, int k, int l, int i1, int j1) {
        int k1 = MathHelper.func_1111_a(i, 16);
        int l1 = MathHelper.func_1111_a(j, 16);
        int i2 = MathHelper.func_1111_a(k, 16);
        int j2 = MathHelper.func_1111_a(l, 16);
        int k2 = MathHelper.func_1111_a(i1, 16);
        int l2 = MathHelper.func_1111_a(j1, 16);
        int i3 = k1;
        while (i3 <= j2) {
            int j3 = i3 % this.renderChunksWide;
            if (j3 < 0) {
                j3 += this.renderChunksWide;
            }
            int k3 = l1;
            while (k3 <= k2) {
                int l3 = k3 % this.renderChunksTall;
                if (l3 < 0) {
                    l3 += this.renderChunksTall;
                }
                int i4 = i2;
                while (i4 <= l2) {
                    int j4 = i4 % this.renderChunksDeep;
                    if (j4 < 0) {
                        j4 += this.renderChunksDeep;
                    }
                    int k4 = (j4 * this.renderChunksTall + l3) * this.renderChunksWide + j3;
                    WorldRenderer worldrenderer = this.worldRenderers[k4];
                    if (!worldrenderer.needsUpdate) {
                        this.worldRenderersToUpdate.add(worldrenderer);
                    }
                    worldrenderer.markDirty();
                    ++i4;
                }
                ++k3;
            }
            ++i3;
        }
    }

    public void func_934_a(int i, int j, int k) {
        this.func_949_a(i - 1, j - 1, k - 1, i + 1, j + 1, k + 1);
    }

    public void markBlockRangeNeedsUpdate(int i, int j, int k, int l, int i1, int j1) {
        this.func_949_a(i - 1, j - 1, k - 1, l + 1, i1 + 1, j1 + 1);
    }

    public void func_960_a(ICamera icamera, float f) {
        int i = 0;
        while (i < this.worldRenderers.length) {
            if (!(this.worldRenderers[i].canRender() || this.worldRenderers[i].isInFrustrum && (i + this.frustrumCheckOffset & 0xF) != 0)) {
                this.worldRenderers[i].updateInFrustrum(icamera);
            }
            ++i;
        }
        ++this.frustrumCheckOffset;
    }

    public void playRecord(String s, int i, int j, int k) {
        if (s != null) {
            if (s.equalsIgnoreCase("magnet")) {
                this.mc.ingameGUI.func_553_b("Markus Alexei - Magnetic Circuit");
            } else {
                this.mc.ingameGUI.func_553_b("C418 - " + s);
            }
            if (s.equals("where are we now")) {
                this.mc.soundMGR.playStreaming("wait", i, j, k, 1.0f, 1.0f);
            }
            if (s.equals("magnet")) {
                this.mc.soundMGR.playStreaming("magnet", i, j, k, 1.0f, 1.0f);
            } else {
                this.mc.soundMGR.playStreaming(s, i, j, k, 1.0f, 1.0f);
            }
        } else {
            this.mc.soundMGR.playStreaming(s, i, j, k, 1.0f, 1.0f);
        }
    }

    public void displayInfoGUI(String s) {
        if (s != null) {
            this.mc.ingameGUI.showInfo(s);
        }
    }

    public void makeSound(String soundURL, double d, double d1, double d2, float f, float f1) {
        float f2 = 16.0f;
        if (f > 1.0f) {
            f2 *= f;
        }
        if (this.mc.thePlayer.getDistanceSq(d, d1, d2) < (double)(f2 * f2)) {
            this.mc.soundMGR.playSound(soundURL, (float)d, (float)d1, (float)d2, f, f1);
        }
    }

    public void makeAmbience(String soundURL, double posX, double posY, double posZ, float volume, float pitch) {
        this.mc.soundMGR.playLoop(soundURL, (float)posX, (float)posY, (float)posZ, volume, pitch);
    }

    public void updateAmbience(String soundURL, double d, double d1, double d2, float f, float f1) {
        this.mc.soundMGR.updateLoop(soundURL, (float)d, (float)d1, (float)d2, f, f1);
    }

    public void pauseAmbience(String soundURL, double d, double d1, double d2, float f, float f1) {
        this.mc.soundMGR.pauseLoop(soundURL, (float)d, (float)d1, (float)d2, f, f1);
    }

    public boolean isAmbienceEnabled() {
        return this.mc.soundMGR.isAmbienceEnabled();
    }

    public void spawnParticle(String s, double d, double d1, double d2, double d3, double d4, double d5) {
        double d6 = this.mc.thePlayer.posX - d;
        double d7 = this.mc.thePlayer.posY - d1;
        double d8 = this.mc.thePlayer.posZ - d2;
        double d9 = 16.0;
        if (d6 * d6 + d7 * d7 + d8 * d8 <= d9 * d9 && this.mc.options.particles) {
            if (s.equals("bubble")) {
                this.mc.effectRenderer.addEffect(new EntityBubbleFX(this.worldObj, d, d1, d2, d3, d4, d5));
            } else if (s.equals("bubble2")) {
                this.mc.effectRenderer.addEffect(new EntityBubbleFX(this.worldObj, d, d1, d2, d3, d4, d5, true));
            } else if (s.equals("smoke")) {
                this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, d, d1, d2));
            } else if (s.equals("explode")) {
                this.mc.effectRenderer.addEffect(new EntityExplodeFX(this.worldObj, d, d1, d2, d3, d4, d5));
            } else if (s.equals("flame")) {
                this.mc.effectRenderer.addEffect(new EntityFlameFX(this.worldObj, d, d1, d2, d3, d4, d5));
            } else if (s.equals("lava")) {
                this.mc.effectRenderer.addEffect(new EntityLavaFX(this.worldObj, d, d1, d2));
            } else if (s.equals("splash")) {
                this.mc.effectRenderer.addEffect(new EntitySplashFX(this.worldObj, d, d1, d2, d3, d4, d5));
            }
            if (s.equals("bigsplash")) {
                this.mc.effectRenderer.addEffect(new EntitySplashFX(this.worldObj, d, d1, d2, d3, d4, d5, 2.5f));
            } else if (s.equals("largesmoke")) {
                this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, d, d1, d2, 2.5f));
            } else if (s.equals("reddust")) {
                this.mc.effectRenderer.addEffect(new EntityReddustFX(this.worldObj, d, d1, d2));
            }
            if (s.equals("lightningbug")) {
                this.mc.effectRenderer.addEffect(new EntityLightningBugFX(this.worldObj, d, d1, d2));
            } else if (s.equals("snowballpoof")) {
                this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, d, d1, d2, Item.snowball));
            } else if (s.equals("slime")) {
                this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, d, d1, d2, Item.slimeBall));
            } else if (s.equals("stars")) {
                this.mc.effectRenderer.addEffect(new EntityStarsFX(this.worldObj, d, d1, d2));
            }
        }
    }

    public void spawnParticle_(String s, double d, double d1, double d2, double d3, double d4, double d5) {
        double d6 = this.mc.thePlayer.posX - d;
        double d7 = this.mc.thePlayer.posY - d1;
        double d8 = this.mc.thePlayer.posZ - d2;
        if (d6 * d6 + d7 * d7 + d8 * d8 > 256.0) {
            return;
        }
        if (s == "bubble") {
            this.mc.effectRenderer.addEffect(new EntityBubbleFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "smoke") {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, d, d1, d2));
        } else if (s == "explode") {
            this.mc.effectRenderer.addEffect(new EntityExplodeFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "flame") {
            this.mc.effectRenderer.addEffect(new EntityFlameFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "lava") {
            this.mc.effectRenderer.addEffect(new EntityLavaFX(this.worldObj, d, d1, d2));
        } else if (s == "splash") {
            this.mc.effectRenderer.addEffect(new EntitySplashFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "largesmoke") {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, d, d1, d2, 2.5f));
        } else if (s == "reddust") {
            this.mc.effectRenderer.addEffect(new EntityReddustFX(this.worldObj, d, d1, d2));
        } else if (s == "snowballpoof") {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, d, d1, d2, Item.snowball));
        } else if (s == "slime") {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, d, d1, d2, Item.slimeBall));
        }
    }

    public void obtainEntitySkin(Entity entity) {
        entity.updateCloak();
        if (entity.skinURL != null) {
            this.renderEngine.obtainImageData(entity.skinURL, new ImageBufferDownload());
        }
        if (entity.cloakURL != null) {
            this.renderEngine.obtainImageData(entity.cloakURL, new ImageBufferDownload());
        }
    }

    public void releaseEntitySkin(Entity entity) {
        if (entity.skinURL != null) {
            this.renderEngine.releaseImageData(entity.skinURL);
        }
        if (entity.cloakURL != null) {
            this.renderEngine.releaseImageData(entity.cloakURL);
        }
    }

    public void updateAllRenderers() {
        int i = 0;
        while (i < this.worldRenderers.length) {
            if (this.worldRenderers[i].field_1747_A) {
                if (!this.worldRenderers[i].needsUpdate) {
                    this.worldRenderersToUpdate.add(this.worldRenderers[i]);
                }
                this.worldRenderers[i].markDirty();
            }
            ++i;
        }
    }

    public void hashTileEntity(int i, int j, int k, TileEntity tileentity) {
    }

    public void func_28137_f() {
        GLAllocation.func_28194_b(this.glRenderListBase);
    }

    public void func_28136_a(EntityPlayer entityplayer, int i, int j, int k, int l, int i1) {
        Random random = this.worldObj.rand;
        switch (i) {
            default: {
                break;
            }
            case 1001: {
                this.worldObj.playSoundEffect(j, k, l, "random.click", 1.0f, 1.2f);
                break;
            }
            case 1000: {
                this.worldObj.playSoundEffect(j, k, l, "random.click", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.worldObj.playSoundEffect(j, k, l, "random.bow", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                int j1 = i1 % 3 - 1;
                int k1 = i1 / 3 % 3 - 1;
                double d = (double)j + (double)j1 * 0.6 + 0.5;
                double d1 = (double)k + 0.5;
                double d2 = (double)l + (double)k1 * 0.6 + 0.5;
                int l1 = 0;
                while (l1 < 10) {
                    double d3 = random.nextDouble() * 0.2 + 0.01;
                    double d4 = d + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k1 * 0.5;
                    double d5 = d1 + (random.nextDouble() - 0.5) * 0.5;
                    double d6 = d2 + (double)k1 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d7 = (double)j1 * d3 + random.nextGaussian() * 0.01;
                    double d8 = -0.03 + random.nextGaussian() * 0.01;
                    double d9 = (double)k1 * d3 + random.nextGaussian() * 0.01;
                    this.spawnParticle("smoke", d4, d5, d6, d7, d8, d9);
                    ++l1;
                }
                break;
            }
            case 2001: {
                int i2 = i1 & 0xFF;
                if (i2 > 0) {
                    Block block = Block.allBlocks[i2];
                    this.mc.soundMGR.playSound(block.stepSound.stepSoundDir(), (float)j + 0.5f, (float)k + 0.5f, (float)l + 0.5f, (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                }
                this.mc.effectRenderer.addBlockDestroyEffects(j, k, l);
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.worldObj.playSoundEffect((double)j + 0.5, (double)k + 0.5, (double)l + 0.5, "random.door_open", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.worldObj.playSoundEffect((double)j + 0.5, (double)k + 0.5, (double)l + 0.5, "random.door_close", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.worldObj.playSoundEffect((float)j + 0.5f, (float)k + 0.5f, (float)l + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                if (Item.itemsList[i1] instanceof ItemRecord) {
                    this.worldObj.playRecord(((ItemRecord)Item.itemsList[i1]).recordName, j, k, l);
                    break;
                }
                this.worldObj.playRecord(null, j, k, l);
            }
        }
    }

    public void clear() {
        this.worldObj = null;
        if (this.worldRenderers != null) {
            int i = 0;
            while (i < this.worldRenderers.length) {
                this.worldRenderers[i] = new WorldRenderer(null, null, 0, 0, 0, 0, 0, 0);
                ++i;
            }
            if (this.worldRenderersToUpdate != null) {
                i = 0;
                while (i < this.worldRenderersToUpdate.size()) {
                    this.worldRenderersToUpdate.set(i, new WorldRenderer(null, null, 0, 0, 0, 0, 0, 0));
                    ++i;
                }
            }
            if (this.sortedWorldRenderers != null) {
                i = 0;
                while (i < this.sortedWorldRenderers.length) {
                    this.sortedWorldRenderers[i] = new WorldRenderer(null, null, 0, 0, 0, 0, 0, 0);
                    ++i;
                }
            }
            this.updateAllRenderers();
        }
    }
}

