/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.entity.item.ItemRenderer;
import com.mojang.minecraft.client.entity.model.ModelBiped;
import com.mojang.minecraft.client.entity.model.ModelChicken;
import com.mojang.minecraft.client.entity.model.ModelCow;
import com.mojang.minecraft.client.entity.model.ModelPig;
import com.mojang.minecraft.client.entity.model.ModelSheep1;
import com.mojang.minecraft.client.entity.model.ModelSheep2;
import com.mojang.minecraft.client.entity.model.ModelSkeleton;
import com.mojang.minecraft.client.entity.model.ModelSlime;
import com.mojang.minecraft.client.entity.model.ModelZombie;
import com.mojang.minecraft.client.entity.render.RenderArrow;
import com.mojang.minecraft.client.entity.render.RenderBoat;
import com.mojang.minecraft.client.entity.render.RenderChicken;
import com.mojang.minecraft.client.entity.render.RenderCow;
import com.mojang.minecraft.client.entity.render.RenderCreeper;
import com.mojang.minecraft.client.entity.render.RenderEntity;
import com.mojang.minecraft.client.entity.render.RenderFallingSand;
import com.mojang.minecraft.client.entity.render.RenderFireExtinguisher;
import com.mojang.minecraft.client.entity.render.RenderFish;
import com.mojang.minecraft.client.entity.render.RenderItem;
import com.mojang.minecraft.client.entity.render.RenderLightningBolt;
import com.mojang.minecraft.client.entity.render.RenderLiving;
import com.mojang.minecraft.client.entity.render.RenderMinecart;
import com.mojang.minecraft.client.entity.render.RenderPainting;
import com.mojang.minecraft.client.entity.render.RenderPig;
import com.mojang.minecraft.client.entity.render.RenderPlayer;
import com.mojang.minecraft.client.entity.render.RenderSheep;
import com.mojang.minecraft.client.entity.render.RenderSlime;
import com.mojang.minecraft.client.entity.render.RenderSnowball;
import com.mojang.minecraft.client.entity.render.RenderSpider;
import com.mojang.minecraft.client.entity.render.RenderTNTPrimed;
import com.mojang.minecraft.client.entity.render.RenderZombieSimple;
import com.mojang.minecraft.client.player.controller.GameSettings;
import com.mojang.minecraft.client.render.FontRenderer;
import com.mojang.minecraft.client.render.Render;
import com.mojang.minecraft.client.render.RenderEngine;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityArrow;
import com.mojang.minecraft.core.entity.EntityBoat;
import com.mojang.minecraft.core.entity.EntityChicken;
import com.mojang.minecraft.core.entity.EntityCow;
import com.mojang.minecraft.core.entity.EntityCreeper;
import com.mojang.minecraft.core.entity.EntityFallingSand;
import com.mojang.minecraft.core.entity.EntityFireExtinguisher;
import com.mojang.minecraft.core.entity.EntityFish;
import com.mojang.minecraft.core.entity.EntityGiant;
import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.EntityLightningBolt;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityMinecart;
import com.mojang.minecraft.core.entity.EntityPainting;
import com.mojang.minecraft.core.entity.EntityPig;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.EntitySheep;
import com.mojang.minecraft.core.entity.EntitySkeleton;
import com.mojang.minecraft.core.entity.EntitySlime;
import com.mojang.minecraft.core.entity.EntitySnowball;
import com.mojang.minecraft.core.entity.EntitySpider;
import com.mojang.minecraft.core.entity.EntityTNTPrimed;
import com.mojang.minecraft.core.entity.EntityZombie;
import com.mojang.minecraft.core.level.World;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderManager {
    private Map<Class<?>, Render> entityRenderMap = new HashMap();
    public static RenderManager subManager = new RenderManager();
    private FontRenderer fontRenderer;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public RenderEngine renderEngine;
    public ItemRenderer itemRenderer;
    public World worldObj;
    public EntityPlayer livingPlayer;
    public float playerViewY;
    public float playerViewX;
    public GameSettings options;
    public double field_1222_l;
    public double field_1221_m;
    public double field_1220_n;

    private RenderManager() {
        this.entityRenderMap.put(EntitySpider.class, new RenderSpider());
        this.entityRenderMap.put(EntityPig.class, new RenderPig(new ModelPig(), new ModelPig(0.5f), 0.7f));
        this.entityRenderMap.put(EntitySheep.class, new RenderSheep(new ModelSheep2(), new ModelSheep1(), 0.7f));
        this.entityRenderMap.put(EntityCow.class, new RenderCow(new ModelCow(), 0.7f));
        this.entityRenderMap.put(EntityChicken.class, new RenderChicken(new ModelChicken(), 0.3f));
        this.entityRenderMap.put(EntityCreeper.class, new RenderCreeper());
        this.entityRenderMap.put(EntitySkeleton.class, new RenderLiving(new ModelSkeleton(), 0.5f));
        this.entityRenderMap.put(EntityZombie.class, new RenderLiving(new ModelZombie(), 0.5f));
        this.entityRenderMap.put(EntitySlime.class, new RenderSlime(new ModelSlime(16), new ModelSlime(0), 0.25f));
        this.entityRenderMap.put(EntityPlayer.class, new RenderPlayer());
        this.entityRenderMap.put(EntityGiant.class, new RenderZombieSimple(new ModelZombie(), 0.5f, 6.0f));
        this.entityRenderMap.put(EntityLiving.class, new RenderLiving(new ModelBiped(), 0.5f));
        this.entityRenderMap.put(Entity.class, new RenderEntity());
        this.entityRenderMap.put(EntityPainting.class, new RenderPainting());
        this.entityRenderMap.put(EntityArrow.class, new RenderArrow());
        this.entityRenderMap.put(EntitySnowball.class, new RenderSnowball());
        this.entityRenderMap.put(EntityItem.class, new RenderItem());
        this.entityRenderMap.put(EntityTNTPrimed.class, new RenderTNTPrimed());
        this.entityRenderMap.put(EntityFallingSand.class, new RenderFallingSand());
        this.entityRenderMap.put(EntityMinecart.class, new RenderMinecart());
        this.entityRenderMap.put(EntityBoat.class, new RenderBoat());
        this.entityRenderMap.put(EntityFish.class, new RenderFish());
        this.entityRenderMap.put(EntityLightningBolt.class, new RenderLightningBolt());
        this.entityRenderMap.put(EntityFireExtinguisher.class, new RenderFireExtinguisher());
        for (Render render : this.entityRenderMap.values()) {
            render.setRenderManager(this);
        }
    }

    public Render getRendererForEntity(Class<?> class1) {
        Render render = this.entityRenderMap.get(class1);
        if (render == null && class1 != Entity.class) {
            render = this.getRendererForEntity(class1.getSuperclass());
            this.entityRenderMap.put(class1, render);
        }
        return render;
    }

    public Render getEntityRenderObject(Entity entity) {
        return this.getRendererForEntity(entity.getClass());
    }

    public void cacheActiveRenderInfo(World world, RenderEngine renderengine, FontRenderer fontrenderer, EntityPlayer entityplayer, GameSettings gamesettings, float f) {
        this.worldObj = world;
        this.renderEngine = renderengine;
        this.options = gamesettings;
        this.livingPlayer = entityplayer;
        this.fontRenderer = fontrenderer;
        this.playerViewY = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * f;
        this.playerViewX = entityplayer.prevRotationPitch + (entityplayer.rotationPitch - entityplayer.prevRotationPitch) * f;
        this.field_1222_l = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f;
        this.field_1221_m = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f;
        this.field_1220_n = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f;
    }

    public void renderEntity(Entity entity, float f) {
        double d = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)f;
        double d1 = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)f;
        double d2 = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)f;
        float f1 = entity.prevRotationYaw + (entity.rotationYaw - entity.prevRotationYaw) * f;
        float f2 = entity.getEntityBrightness(f);
        GL11.glColor3f((float)f2, (float)f2, (float)f2);
        this.renderEntityWithPosYaw(entity, d - renderPosX, d1 - renderPosY, d2 - renderPosZ, f1, f);
    }

    public void renderEntityWithPosYaw(Entity entity, double d, double d1, double d2, float f, float f1) {
        Render render = this.getEntityRenderObject(entity);
        if (render != null) {
            render.doRender(entity, d, d1, d2, f, f1);
            render.renderEntity(entity, d, d1, d2, f, f1);
        }
    }

    public void func_852_a(World world) {
        this.worldObj = world;
    }

    public double func_851_a(double d, double d1, double d2) {
        double d3 = d - this.field_1222_l;
        double d4 = d1 - this.field_1221_m;
        double d5 = d2 - this.field_1220_n;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }
}

