/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.client.Minecraft;

public class ScaledResolution {
    private int scaledWidth;
    private int scaledHeight;
    public int scaleFactor;

    public ScaledResolution(int i, int j, Minecraft mc) {
        this.scaledWidth = i;
        this.scaledHeight = j;
        this.scaleFactor = 1;
        int k = mc.options.guiScale;
        if (k == 0) {
            k = 1000;
        }
        while (this.scaleFactor < k && this.scaledWidth / (this.scaleFactor + 1) >= 320 && this.scaledHeight / (this.scaleFactor + 1) >= 240) {
            ++this.scaleFactor;
        }
        this.scaledWidth /= this.scaleFactor;
        this.scaledHeight /= this.scaleFactor;
    }

    public int getScaledWidth() {
        return this.scaledWidth;
    }

    public int getScaledHeight() {
        return this.scaledHeight;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }
}

