/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.render;

import com.mojang.minecraft.core.util.MathHelper;
import java.util.ArrayList;
import java.util.List;

public class Vec3D {
    private static List<Vec3D> vectorList = new ArrayList<Vec3D>();
    private static int nextVector = 0;
    public double xCoord;
    public double yCoord;
    public double zCoord;

    public static Vec3D createVectorHelper(double d, double d1, double d2) {
        return new Vec3D(d, d1, d2);
    }

    public static void func_28215_a() {
        vectorList.clear();
        nextVector = 0;
    }

    public static void initialize() {
        nextVector = 0;
    }

    public static Vec3D createVector(double d, double d1, double d2) {
        if (nextVector >= vectorList.size()) {
            vectorList.add(Vec3D.createVectorHelper(0.0, 0.0, 0.0));
        }
        return vectorList.get(nextVector++).setComponents(d, d1, d2);
    }

    private Vec3D(double d, double d1, double d2) {
        if (d == -0.0) {
            d = 0.0;
        }
        if (d1 == -0.0) {
            d1 = 0.0;
        }
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        this.xCoord = d;
        this.yCoord = d1;
        this.zCoord = d2;
    }

    private Vec3D setComponents(double d, double d1, double d2) {
        this.xCoord = d;
        this.yCoord = d1;
        this.zCoord = d2;
        return this;
    }

    public Vec3D subtract(Vec3D vec3d) {
        return Vec3D.createVector(vec3d.xCoord - this.xCoord, vec3d.yCoord - this.yCoord, vec3d.zCoord - this.zCoord);
    }

    public Vec3D normalize() {
        double d = MathHelper.sqrt_double(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
        if (d < 1.0E-4) {
            return Vec3D.createVector(0.0, 0.0, 0.0);
        }
        return Vec3D.createVector(this.xCoord / d, this.yCoord / d, this.zCoord / d);
    }

    public Vec3D avgVector(Vec3D vec1, Vec3D vec2) {
        Vec3D vec3 = new Vec3D(0.5 * (vec1.xCoord + vec2.xCoord), 0.5 * (vec1.yCoord + vec2.yCoord), 0.5 * (vec1.zCoord + vec2.zCoord));
        return vec3;
    }

    public Vec3D crossProduct(Vec3D vec3d) {
        return Vec3D.createVector(this.yCoord * vec3d.zCoord - this.zCoord * vec3d.yCoord, this.zCoord * vec3d.xCoord - this.xCoord * vec3d.zCoord, this.xCoord * vec3d.yCoord - this.yCoord * vec3d.xCoord);
    }

    public Vec3D addVector(double d, double d1, double d2) {
        return Vec3D.createVector(this.xCoord + d, this.yCoord + d1, this.zCoord + d2);
    }

    public double distanceTo(Vec3D vec3d) {
        double d = vec3d.xCoord - this.xCoord;
        double d1 = vec3d.yCoord - this.yCoord;
        double d2 = vec3d.zCoord - this.zCoord;
        return MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2);
    }

    public double squareDistanceTo(Vec3D vec3d) {
        double d = vec3d.xCoord - this.xCoord;
        double d1 = vec3d.yCoord - this.yCoord;
        double d2 = vec3d.zCoord - this.zCoord;
        return d * d + d1 * d1 + d2 * d2;
    }

    public double squareDistanceTo(double d, double d1, double d2) {
        double d3 = d - this.xCoord;
        double d4 = d1 - this.yCoord;
        double d5 = d2 - this.zCoord;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double lengthVector() {
        return MathHelper.sqrt_double(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
    }

    public Vec3D getIntermediateWithXValue(Vec3D vec3d, double d) {
        double d1 = vec3d.xCoord - this.xCoord;
        double d2 = vec3d.yCoord - this.yCoord;
        double d3 = vec3d.zCoord - this.zCoord;
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (d - this.xCoord) / d1;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return Vec3D.createVector(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4);
    }

    public Vec3D getIntermediateWithYValue(Vec3D vec3d, double d) {
        double d1 = vec3d.xCoord - this.xCoord;
        double d2 = vec3d.yCoord - this.yCoord;
        double d3 = vec3d.zCoord - this.zCoord;
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (d - this.yCoord) / d2;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return Vec3D.createVector(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4);
    }

    public Vec3D getIntermediateWithZValue(Vec3D vec3d, double d) {
        double d1 = vec3d.xCoord - this.xCoord;
        double d2 = vec3d.yCoord - this.yCoord;
        double d3 = vec3d.zCoord - this.zCoord;
        if (d3 * d3 < (double)1.0E-7f) {
            return null;
        }
        double d4 = (d - this.zCoord) / d3;
        if (d4 < 0.0 || d4 > 1.0) {
            return null;
        }
        return Vec3D.createVector(this.xCoord + d1 * d4, this.yCoord + d2 * d4, this.zCoord + d3 * d4);
    }

    public String toString() {
        return "(" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + ")";
    }

    public void rotateAroundX(float f) {
        float f1 = MathHelper.cos(f);
        float f2 = MathHelper.sin(f);
        double d = this.xCoord;
        double d1 = this.yCoord * (double)f1 + this.zCoord * (double)f2;
        double d2 = this.zCoord * (double)f1 - this.yCoord * (double)f2;
        this.xCoord = d;
        this.yCoord = d1;
        this.zCoord = d2;
    }

    public void rotateAroundY(float f) {
        float f1 = MathHelper.cos(f);
        float f2 = MathHelper.sin(f);
        double d = this.xCoord * (double)f1 + this.zCoord * (double)f2;
        double d1 = this.yCoord;
        double d2 = this.zCoord * (double)f1 - this.xCoord * (double)f2;
        this.xCoord = d;
        this.yCoord = d1;
        this.zCoord = d2;
    }
}

