/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.sound;

import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.enums.EnumSeason;
import com.mojang.minecraft.core.enums.EnumWeather;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import java.util.ArrayList;
import java.util.Random;

public class AmbientLoopHandler {
    World world;
    EntityPlayer player;
    public int leaves;
    public boolean leavesPlaying = false;
    public boolean leavesPaused = true;
    public int waterSurface;
    public boolean waterPlaying = false;
    public boolean waterPaused = true;
    public int exposedOre;
    public boolean cavePlaying = false;
    public boolean cavePaused = true;
    public int[] rain;
    public boolean rainPlaying = false;
    public boolean rainPaused = true;
    public float overHang;
    public float lastOverHang;
    public float waterfall = 5.0f;
    public boolean waterfallPaused = true;
    public boolean waterfallPlaying = false;
    public int fallingWater;
    public int wind;
    public ArrayList<Double> wf_x;
    public ArrayList<Double> wf_y;
    public ArrayList<Double> wf_z;
    public double wfa_x;
    public double wfa_y;
    public double wfa_z;
    public double driftX;
    public double driftY;
    public double driftZ;
    public double lastX;
    public double lastY;
    public double lastZ;
    private int checkX;
    private int checkY;
    private int checkZ;
    public int ambienceWait = 0;
    Random random = new Random();
    int birds = 45;
    int chimes = 60;
    int ocean = 60;
    int killCount = 0;
    long timeOfDay = 0L;

    public AmbientLoopHandler(World wrld, EntityPlayer plyr) {
        this.world = wrld;
        this.player = plyr;
        this.driftX = this.lastX = this.player.posX;
        this.driftY = this.lastY = this.player.posY;
        this.driftZ = this.lastZ = this.player.posZ;
        this.checkZ = 50;
        this.checkY = 50;
        this.checkX = 50;
        this.wf_x = new ArrayList();
        this.wf_y = new ArrayList();
        this.wf_z = new ArrayList();
    }

    public void killLoops() {
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds screaming loop", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds raining loop", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cricketsloop", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.ocean", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.underwater", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cave chimes", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.waterfall", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.rain heavy loop", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.rain moderate loop", 0.001f, 1.0f);
        this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.rain light loop", 0.001f, 1.0f);
        this.killCount = 1;
    }

    public void update() {
        if (!this.world.isAmbienceEnabled()) {
            return;
        }
        this.timeOfDay = this.world.worldTime;
        ++this.ambienceWait;
        if (this.killCount > 0) {
            --this.killCount;
            return;
        }
        this.driftX = this.lastX - this.player.posX;
        this.driftY = this.lastY - this.player.posY;
        this.driftZ = this.lastZ - this.player.posZ;
        if (Math.abs(this.driftX) < 1.0 && Math.abs(this.driftY) < 1.0 && Math.abs(this.driftZ) < 1.0 && this.ambienceWait >= 2) {
            return;
        }
        boolean underWater = false;
        if (this.player.isInsideOfMaterial(Material.water)) {
            underWater = true;
        }
        this.leaves = 0;
        this.waterSurface = 0;
        this.exposedOre = 0;
        this.waterfall = 0.0f;
        this.rain = new int[3];
        this.rain[0] = 0;
        this.rain[1] = 0;
        this.rain[2] = 0;
        if (this.overHang < 0.0f) {
            this.overHang = 0.0f;
        }
        if (this.overHang > 50.0f) {
            this.overHang = 50.0f;
        }
        this.wf_x.clear();
        this.wf_y.clear();
        this.wf_z.clear();
        try {
            int x = -25;
            while (x < 25) {
                int y = -15;
                while (y < 15) {
                    int z = -25;
                    while (z < 25) {
                        this.checkBlock(x, y, z, 1);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.leavesPlaying = this.leaves > 0;
        this.waterPlaying = this.waterSurface > 0;
        this.cavePlaying = this.exposedOre > 0;
        boolean bl = this.rainPlaying = this.rain[0] > 0;
        if (this.leavesPlaying) {
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds screaming loop", (this.rain[0] >= 1 || this.rain[1] >= 1 || this.rain[2] >= 1 ? 1.0E-4f : 1.0f) * ((float)this.leaves / 5000.0f) * (1.001f - (float)underWater) * ((float)(24000L - this.timeOfDay % 24000L) / 14000.0f - 0.7f), 1.0f);
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds raining loop", (float)(this.rain[0] >= 1 ? 1 : 0) * ((float)this.leaves / 5000.0f) * (1.001f - (float)underWater) * ((float)(24000L - this.timeOfDay % 24000L) / 14000.0f - 0.7f), 1.0f);
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cricketsloop", (float)this.leaves / 5000.0f * (1.001f - (float)underWater) * ((float)(this.timeOfDay % 24000L) / 14000.0f), 1.0f);
            this.leavesPaused = false;
        } else if (!this.leavesPaused) {
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds screaming loop", (this.rain[0] >= 1 || this.rain[1] >= 1 || this.rain[2] >= 1 ? 1.0E-4f : 1.0f) * ((float)this.leaves / 5000.0f) * (1.001f - (float)underWater) * ((float)(24000L - this.timeOfDay % 24000L) / 14000.0f - 0.7f), 1.0f);
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds raining loop", (float)(this.rain[0] >= 1 ? 1 : 0) * ((float)this.leaves / 5000.0f) * (1.001f - (float)underWater) * ((float)(24000L - this.timeOfDay % 24000L) / 14000.0f - 0.7f), 1.0f);
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cricketsloop", (float)this.leaves / 5000.0f * (1.001f - (float)underWater) * ((float)(this.timeOfDay % 24000L) / 14000.0f), 1.0f);
            this.leavesPaused = true;
        }
        if (this.waterPlaying) {
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.ocean", (float)(this.waterSurface - 200) / 1000.0f * (1.001f - (float)underWater), 1.0f);
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.underwater", (float)this.waterSurface / 1000.0f * ((float)underWater + 0.001f), 1.0f);
            this.waterPaused = false;
        } else if (!this.waterPaused) {
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.ocean", (float)(this.waterSurface - 200) / 1000.0f * (1.001f - (float)underWater), 1.0f);
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.underwater", (float)this.waterSurface / 1000.0f * ((float)underWater + 0.001f), 1.0f);
            this.waterPaused = true;
        }
        if (this.cavePlaying) {
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cave chimes", (float)(this.exposedOre - 20) / 50.0f, 1.0f);
            this.cavePaused = false;
        } else if (!this.cavePaused) {
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cave chimes", (float)(this.exposedOre - 20) / 50.0f, 1.0f);
            this.cavePaused = true;
        }
        if (this.waterfall > 0.0f) {
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.waterfall", this.waterfall / 1000.0f, 1.0f);
            this.waterfallPaused = false;
        } else if (!this.waterfallPaused) {
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.waterfall", this.waterfall / 1000.0f, 1.0f);
            this.waterfallPaused = true;
        }
        if (this.rainPlaying) {
            this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.rain light loop", (float)this.rain[0] + 0.001f, 1.0f - (this.lastOverHang / 50.0f + (float)underWater / 2.0f));
            this.rainPaused = false;
        } else if (!this.rainPaused) {
            this.world.pauseAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.rain light loop", (float)this.rain[0] + 0.001f, 1.0f - (this.lastOverHang / 50.0f + (float)underWater / 2.0f));
            this.rainPaused = true;
        }
        this.lastOverHang = (float)((double)this.lastOverHang + (double)(this.overHang - this.lastOverHang) * 0.1);
        this.lastX = this.player.posX;
        this.lastY = this.player.posY;
        this.lastZ = this.player.posZ;
    }

    private void checkBlock(int x, int y, int z, int amount) {
        int block = this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ);
        if (this.world.canBlockSeeTheSky(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ) && this.world.weather == EnumWeather.precipitation && this.world.getCurrentSeason() != EnumSeason.winter) {
            this.rain[0] = this.rain[0] + 1;
        }
        if (block == Block.leaves.blockID && (this.world.season != EnumSeason.cycle || this.world.getCurrentSeason() != EnumSeason.winter)) {
            this.leaves += amount;
        }
        if (block == Block.waterStill.blockID && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY + 1, z + (int)this.player.posZ) == 0) {
            this.waterSurface += amount;
        }
        if (block == Block.waterStill.blockID || block == Block.waterMoving.blockID) {
            this.waterfall = (float)((double)this.waterfall + Block.waterStill.getFallyness(this.world, x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ));
        }
        if (!(block != Block.oreDiamond.blockID && block != Block.oreRed.blockID && block != Block.oreIron.blockID && block != Block.oreGold.blockID && block != Block.oreCopper.blockID || this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY + 1, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY - 1, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX + 1, y + (int)this.player.posY, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX - 1, y + (int)this.player.posY, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ + 1) != 0 && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ - 1) != 0)) {
            this.exposedOre += amount;
        }
    }
}

