/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.sound;

import com.mojang.minecraft.client.Minecraft;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThreadDownloadResources
extends Thread {
    public File resourceDir;
    private Minecraft mc;
    private boolean closing = false;

    public ThreadDownloadResources(File file, Minecraft minecraft) {
        this.mc = minecraft;
        this.setName("Resource download thread");
        this.setDaemon(true);
        this.resourceDir = new File(file, "resalpha/");
        if (!this.resourceDir.exists() && !this.resourceDir.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + this.resourceDir);
        }
    }

    public void run() {
        try {
            URL url = new URL("http://androdome.com/nsss/ResAlpha/");
            DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
            Document document = documentbuilder.parse(url.openStream());
            NodeList nodelist = document.getElementsByTagName("Contents");
            int i = 0;
            while (i < 2) {
                int j = 0;
                while (j < nodelist.getLength()) {
                    Node node = nodelist.item(j);
                    if (node.getNodeType() == 1) {
                        Element element = (Element)node;
                        String s = ((Element)element.getElementsByTagName("Key").item(0)).getChildNodes().item(0).getNodeValue();
                        long l = Long.parseLong(((Element)element.getElementsByTagName("Size").item(0)).getChildNodes().item(0).getNodeValue());
                        if (l > 0L) {
                            this.func_1211_a(url, s, l, i);
                            if (this.closing) {
                                return;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            this.addResourceFromDir(this.resourceDir, "");
            exception.printStackTrace();
        }
    }

    public void addRootResource() {
        this.addResourceFromDir(this.resourceDir, "");
    }

    private void addResourceFromDir(File file, String resourceName) {
        File[] afile = file.listFiles();
        int i = 0;
        while (i < afile.length) {
            if (afile[i].isDirectory()) {
                this.addResourceFromDir(afile[i], resourceName + afile[i].getName() + "/");
            } else {
                try {
                    this.mc.installResource(resourceName + afile[i].getName(), afile[i]);
                }
                catch (Exception exception) {
                    System.out.println("Failed to add " + resourceName + afile[i].getName());
                }
            }
            ++i;
        }
    }

    private void func_1211_a(URL url, String resourceName, long limit, int music) {
        try {
            int j = resourceName.indexOf("/");
            String s1 = resourceName.substring(0, j);
            if (s1.equals("sound") || s1.equals("newsound") ? music != 0 : music != 1) {
                return;
            }
            File file = new File(this.resourceDir, resourceName);
            if (!file.exists() || file.length() != limit) {
                file.getParentFile().mkdirs();
                String s2 = resourceName.replaceAll(" ", "%20");
                this.downloadResource(new URL(url, s2), file, limit);
                System.out.println("Downloaded " + resourceName);
                if (this.closing) {
                    return;
                }
            }
            this.mc.installResource(resourceName, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void downloadResource(URL url, File file, long l) throws IOException {
        byte[] abyte0 = new byte[4096];
        DataInputStream datainputstream = new DataInputStream(url.openStream());
        DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));
        int i = 0;
        while ((i = datainputstream.read(abyte0)) >= 0) {
            dataoutputstream.write(abyte0, 0, i);
            if (!this.closing) continue;
            dataoutputstream.close();
            return;
        }
        datainputstream.close();
        dataoutputstream.close();
    }

    public void closeMinecraft() {
        this.closing = true;
    }
}

