/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.util;

import com.mojang.minecraft.client.Minecraft;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SkinUrlGetPost {
    static File skinCache = new File(Minecraft.getMinecraftDir(), "surlcache");

    public static String getPostUrl(String username) throws IOException, JSONException {
        String inputLine;
        File file;
        if (!skinCache.isDirectory()) {
            skinCache.mkdir();
        }
        if ((file = new File(skinCache, String.valueOf(username) + ".surl")).exists()) {
            System.out.println("A " + file.lastModified() + " B " + System.currentTimeMillis() + " A - B " + (System.currentTimeMillis() - file.lastModified()));
            if (file.lastModified() < System.currentTimeMillis() - 86400000L) {
                System.out.println("Found skin cache for " + username + ", using");
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String thing = reader.readLine();
                reader.close();
                return thing;
            }
            System.out.println("Found outdated skin cache for " + username);
        }
        String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        String skin = SkinUrlGetPost.getSkinFrom(json.getString("id"));
        if (!file.exists() && skin.startsWith("http")) {
            try {
                file.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(skin);
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return skin;
    }

    private static String getSkinFrom(String uuid) throws IOException, JSONException {
        String inputLine;
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        JSONArray json2 = json.getJSONArray("properties");
        return new JSONObject(new String(Base64.decode(json2.getJSONObject(0).getString("value")))).getJSONObject("textures").getJSONObject("SKIN").getString("url");
    }

    public static String getCapeFrom(String uuid) throws IOException, JSONException {
        String inputLine;
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        JSONArray json2 = json.getJSONArray("properties");
        return new JSONObject(new String(Base64.decode(json2.getJSONObject(0).getString("value")))).getJSONObject("textures").getJSONObject("CAPE").getString("url");
    }
}

