/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.client.util;

import com.mojang.minecraft.client.Minecraft;
import com.mojang.minecraft.client.util.Session;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.TreeMap;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreadFetchSkins
extends Thread {
    public static TreeMap<String, String> customCapes = new TreeMap();
    public static TreeMap<String, String> customColors = new TreeMap();
    public static TreeMap<String, String> customParticles = new TreeMap();
    private EntityPlayer thePlayer;
    private Minecraft mc;
    private UUID id;
    private String name;

    public ThreadFetchSkins() {
        this.setName("Cape data download thread");
        this.setDaemon(true);
    }

    public static int getVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    private static String getSkinFrom(String uuid) throws IOException, JSONException {
        String inputLine;
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        if (ThreadFetchSkins.getVersion() < 8) {
            String nurl = URLEncoder.encode(url, "UTF-8");
            url = "http://androdome.com/api/nohsts.php?__hsts_rm_url=" + nurl;
        }
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        JSONArray json2 = json.getJSONArray("properties");
        return new JSONObject(new String(Base64.decode(json2.getJSONObject(0).getString("value")))).getJSONObject("textures").getJSONObject("SKIN").getString("url");
    }

    private static boolean getSlim(String uuid) throws IOException, JSONException {
        String inputLine;
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        if (ThreadFetchSkins.getVersion() < 8) {
            String nurl = URLEncoder.encode(url, "UTF-8");
            url = "http://androdome.com/api/nohsts.php?__hsts_rm_url=" + nurl;
        }
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        JSONArray json2 = json.getJSONArray("properties");
        return new JSONObject(new String(Base64.decode(json2.getJSONObject(0).getString("value")))).getJSONObject("textures").getJSONObject("SKIN").getJSONObject("metadata").getString("model").equalsIgnoreCase("slim");
    }

    private static String getCapeFrom(String uuid) throws IOException, JSONException {
        String inputLine;
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid;
        if (ThreadFetchSkins.getVersion() < 8) {
            String nurl = URLEncoder.encode(url, "UTF-8");
            url = "http://androdome.com/api/nohsts.php?__hsts_rm_url=" + nurl;
        }
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        JSONArray json2 = json.getJSONArray("properties");
        return new JSONObject(new String(Base64.decode(json2.getJSONObject(0).getString("value")))).getJSONObject("textures").getJSONObject("CAPE").getString("url");
    }

    public void run() {
        String[] textures = new String[2];
        boolean useRene = false;
        try {
            textures = this.getPostUrl(this.thePlayer.playerName);
            useRene = ThreadFetchSkins.getSlim(this.getUUIDFromName(this.thePlayer.playerName).toString());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.thePlayer.skinURL = textures[0];
        this.thePlayer.cloakURL = textures[1];
        this.thePlayer.worldObj.obtainEntitySkin(this.thePlayer);
        this.thePlayer.modelRene = useRene;
        System.out.println("Rene is " + this.thePlayer.modelRene);
    }

    public void grabCustomCapes() {
        try {
            URL capeDownload = new URL("http://androdome.com/nsss/capes.txt");
            File capeFile = File.createTempFile("nsss-capes", null);
            HttpURLConnection con = (HttpURLConnection)capeDownload.openConnection();
            con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            String line = in.readLine();
            customCapes.clear();
            while (line != null) {
                String[] data = line.split(";");
                customCapes.put(data[0], data[2]);
                customColors.put(data[0], data[3]);
                customParticles.put(data[0], data[4]);
                line = in.readLine();
            }
            in.close();
            if (capeFile.exists()) {
                try {
                    capeFile.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (customCapes.get(this.name) != null) {
                this.thePlayer.cloakURL = customCapes.get(this.name);
                if (!customColors.get(this.name).equals("n")) {
                    this.thePlayer.chatColor = customColors.get(this.name);
                }
                this.thePlayer.particleEffect = customParticles.get(this.name);
                this.thePlayer.worldObj.obtainEntitySkin(this.thePlayer);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void start(EntityPlayer player, Minecraft minecraft) {
        this.thePlayer = player;
        this.name = player.playerName;
        this.mc = minecraft;
        try {
            this.id = this.getUUIDFromName(player.playerName);
        }
        catch (JSONException e) {
            System.out.println("id fetch failed due to JSON error");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("id fetch failed due to IO error");
            e.printStackTrace();
        }
        super.start();
    }

    public String[] getPostUrl(String username) throws IOException, JSONException {
        String cape;
        String inputLine;
        String[] textures = new String[2];
        String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
        if (ThreadFetchSkins.getVersion() < 8) {
            String nurl = URLEncoder.encode(url, "UTF-8");
            url = "http://androdome.com/api/nohsts.php?__hsts_rm_url=" + nurl;
        }
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        String skin = ThreadFetchSkins.getSkinFrom(json.getString("id"));
        try {
            cape = ThreadFetchSkins.getCapeFrom(json.getString("id"));
        }
        catch (Exception ex) {
            this.grabCustomCapes();
            cape = this.thePlayer.cloakURL;
        }
        textures[0] = skin;
        textures[1] = cape;
        return textures;
    }

    public UUID getUUIDFromName(String username) throws IOException, JSONException {
        String inputLine;
        String url = "https://api.mojang.com/users/profiles/minecraft/" + username;
        if (ThreadFetchSkins.getVersion() < 8) {
            String nurl = URLEncoder.encode(url, "UTF-8");
            url = "http://androdome.com/api/nohsts.php?__hsts_rm_url=" + nurl;
        }
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        JSONObject json = new JSONObject(response.toString());
        String suuid = json.getString("id");
        Session cfr_ignored_0 = this.mc.session;
        UUID uuid = Session.fromString(suuid);
        return uuid;
    }

    public void start(String username, EntityPlayer player, Minecraft minecraft) {
        this.name = username;
        this.thePlayer = player;
        this.mc = minecraft;
        try {
            this.id = this.getUUIDFromName(username);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.id = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.id = null;
        }
        super.start();
    }

    public void start(UUID uuid, String username, EntityPlayer player, Minecraft minecraft) {
        this.id = uuid;
        this.name = username;
        this.thePlayer = player;
        this.mc = minecraft;
        super.start();
    }
}

