/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.crafting;

import com.mojang.minecraft.core.crafting.IRecipe;
import com.mojang.minecraft.core.crafting.RecipeSorter;
import com.mojang.minecraft.core.crafting.RecipesArmor;
import com.mojang.minecraft.core.crafting.RecipesCrafting;
import com.mojang.minecraft.core.crafting.RecipesFood;
import com.mojang.minecraft.core.crafting.RecipesIngots;
import com.mojang.minecraft.core.crafting.RecipesTools;
import com.mojang.minecraft.core.crafting.RecipesWeapons;
import com.mojang.minecraft.core.crafting.ShapedRecipes;
import com.mojang.minecraft.core.crafting.ShapelessRecipes;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.player.inventory.InventoryCrafting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class CraftingManager {
    private static final CraftingManager instance = new CraftingManager();
    private List<IRecipe> recipes = new ArrayList<IRecipe>();

    public static final CraftingManager getInstance() {
        return instance;
    }

    private CraftingManager() {
        new RecipesTools().addRecipes(this);
        new RecipesWeapons().addRecipes(this);
        new RecipesIngots().addRecipes(this);
        new RecipesFood().addRecipes(this);
        new RecipesCrafting().addRecipes(this);
        new RecipesArmor().addRecipes(this);
        this.addRecipe(new ItemStack(Item.paper, 3), new Object[]{"###", Character.valueOf('#'), Item.reed});
        this.addRecipe(new ItemStack(Item.book, 1), new Object[]{"#", "#", "#", Character.valueOf('#'), Item.paper});
        this.addRecipe(new ItemStack(Block.fence, 2), new Object[]{"###", "###", Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Block.jukebox, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Block.planks, Character.valueOf('X'), Item.diamond});
        this.addRecipe(new ItemStack(Block.bookShelf, 1), new Object[]{"###", "XXX", "###", Character.valueOf('#'), Block.planks, Character.valueOf('X'), Item.book});
        this.addRecipe(new ItemStack(Block.blockSnow, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.snowball});
        this.addRecipe(new ItemStack(Block.blockClay, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.clay});
        this.addRecipe(new ItemStack(Block.brick, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.brick});
        this.addRecipe(new ItemStack(Block.brickBlue, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.brick_blue});
        this.addRecipe(new ItemStack(Block.brickFlint, 1), new Object[]{"##", "##", Character.valueOf('#'), Item.flint});
        this.addRecipe(new ItemStack(Block.stoneSand, 1), new Object[]{"##", "##", Character.valueOf('#'), Block.sand});
        this.addRecipe(new ItemStack(Block.cloth, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), Item.silk});
        this.addRecipe(new ItemStack(Block.tnt, 1), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('X'), Item.gunpowder, Character.valueOf('#'), Block.sand});
        this.addRecipe(new ItemStack(Block.stepSingle, 6), new Object[]{"###", Character.valueOf('#'), Block.cobblestone});
        this.addRecipe(new ItemStack(Block.ladder, 4), new Object[]{"# #", "###", "# #", Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Item.doorWood, 1), new Object[]{"##", "##", "##", Character.valueOf('#'), Block.planks});
        this.addRecipe(new ItemStack(Item.doorSteel, 1), new Object[]{"##", "##", "##", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Item.sign, 4), new Object[]{"###", "###", " X ", Character.valueOf('#'), Block.planks, Character.valueOf('X'), Item.stick});
        this.addRecipe(new ItemStack(Block.planks, 4), new Object[]{"#", Character.valueOf('#'), Block.wood});
        this.addRecipe(new ItemStack(Item.stick, 4), new Object[]{"#", "#", Character.valueOf('#'), Block.planks});
        this.addRecipe(new ItemStack(Block.torchWood, 4), new Object[]{"X", "#", Character.valueOf('X'), Item.coal, Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Item.bowlEmpty, 4), new Object[]{"# #", " # ", Character.valueOf('#'), Block.planks});
        this.addRecipe(new ItemStack(Block.minecartTrack, 16), new Object[]{"X X", "X#X", "X X", Character.valueOf('X'), Item.ingotIron, Character.valueOf('#'), Item.stick});
        this.addRecipe(new ItemStack(Item.minecartEmpty, 1), new Object[]{"# #", "###", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Item.minecartBox, 1), new Object[]{"A", "B", Character.valueOf('A'), Block.crate, Character.valueOf('B'), Item.minecartEmpty});
        this.addRecipe(new ItemStack(Item.minecartEngine, 1), new Object[]{"A", "B", Character.valueOf('A'), Block.stoneOvenIdle, Character.valueOf('B'), Item.minecartEmpty});
        this.addRecipe(new ItemStack(Item.boat, 1), new Object[]{"# #", "###", Character.valueOf('#'), Block.planks});
        this.addRecipe(new ItemStack(Item.bucketEmpty, 1), new Object[]{"# #", " # ", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Item.striker, 1), new Object[]{"A ", " B", Character.valueOf('A'), Item.ingotIron, Character.valueOf('B'), Item.flint});
        this.addRecipe(new ItemStack(Item.bread, 1), new Object[]{"###", Character.valueOf('#'), Item.wheat});
        this.addRecipe(new ItemStack(Block.stairCompact_Wood, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.planks});
        this.addRecipe(new ItemStack(Item.fishingRod, 1), new Object[]{"  #", " #X", "# X", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.silk});
        this.addRecipe(new ItemStack(Block.stairCompactStone, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), Block.cobblestone});
        this.addRecipe(new ItemStack(Item.painting, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Block.cloth});
        this.addRecipe(new ItemStack(Item.appleGold, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), Item.ingotGold, Character.valueOf('X'), Item.appleRed});
        this.addRecipe(new ItemStack(Block.lever, 1), new Object[]{"X", "#", Character.valueOf('#'), Block.cobblestone, Character.valueOf('X'), Item.stick});
        this.addRecipe(new ItemStack(Block.torchRedActive, 1), new Object[]{"X", "#", Character.valueOf('#'), Item.stick, Character.valueOf('X'), Item.red_dust});
        this.addRecipe(new ItemStack(Item.compass, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Item.ingotIron, Character.valueOf('X'), Item.red_dust});
        this.addRecipe(new ItemStack(Block.button, 1), new Object[]{"#", "#", Character.valueOf('#'), Block.stone});
        this.addRecipe(new ItemStack(Block.pressurePlateStone, 1), new Object[]{"###", Character.valueOf('#'), Block.stone});
        this.addRecipe(new ItemStack(Block.pressurePlateWood, 1), new Object[]{"###", Character.valueOf('#'), Block.planks});
        this.addRecipe(new ItemStack(Block.pressurePlateSteel, 1), new Object[]{"###", Character.valueOf('#'), Item.ingotIron});
        this.addRecipe(new ItemStack(Block.gear, 5), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Item.ingotIron, Character.valueOf('X'), Item.ingotCopper});
        this.addRecipe(new ItemStack(Block.lightBulb, 2), new Object[]{"###", "#X#", "#Y#", Character.valueOf('#'), Block.glass, Character.valueOf('Y'), Item.ingotCopper, Character.valueOf('X'), Item.carbonFilament});
        this.addRecipe(new ItemStack(Item.fireExtinguisher, 4), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Block.glass, Character.valueOf('X'), Item.bucketWater});
        this.addShapelessRecipe(new ItemStack(Item.bowlSoup, 1), new Object[]{Item.bowlEmpty, Block.mushroomBrown, Block.mushroomRed});
        this.addShapelessRecipe(new ItemStack(Item.bread, 1), new Object[]{Item.wheat, Item.wheat, Item.wheat});
        this.addShapelessRecipe(new ItemStack(Item.dyeRed, 2), new Object[]{Block.plantRed});
        this.addShapelessRecipe(new ItemStack(Item.dyeBlack, 4), new Object[]{Item.coal, Item.coal});
        this.addShapelessRecipe(new ItemStack(Item.dyeYellow, 2), new Object[]{Block.plantYellow});
        this.addShapelessRecipe(new ItemStack(Item.bonemeal, 3), new Object[]{Item.bone});
        this.addShapelessRecipe(new ItemStack(Item.dyeGrey, 2), new Object[]{Item.bonemeal, Item.dyeBlack});
        this.addShapelessRecipe(new ItemStack(Item.dyeGrey, 2), new Object[]{Item.bonemeal, Item.dyeBlack});
        this.addShapelessRecipe(new ItemStack(Item.dyeOrange, 2), new Object[]{Item.dyeRed, Item.dyeYellow});
        this.addShapelessRecipe(new ItemStack(Item.dyeOrange, 2), new Object[]{Item.dyeRed, Item.dyeYellow});
        this.addShapelessRecipe(new ItemStack(Item.dyeLime, 2), new Object[]{Item.dyeGreen, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyeLime, 2), new Object[]{Item.dyeGreen, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyeAquaGreen, 2), new Object[]{Item.dyeGreen, Item.dyeBlue});
        this.addShapelessRecipe(new ItemStack(Item.dyeAquaGreen, 2), new Object[]{Item.dyeGreen, Item.dyeBlue});
        this.addShapelessRecipe(new ItemStack(Item.dyeCyan, 2), new Object[]{Item.dyeBlue, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyeCyan, 2), new Object[]{Item.dyeBlue, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyePurple, 2), new Object[]{Item.dyeBlue, Item.dyeRed});
        this.addShapelessRecipe(new ItemStack(Item.dyePurple, 2), new Object[]{Item.dyeBlue, Item.dyeRed});
        this.addShapelessRecipe(new ItemStack(Item.dyeIndigo, 2), new Object[]{Item.dyeBlue, Item.dyePurple});
        this.addShapelessRecipe(new ItemStack(Item.dyeIndigo, 2), new Object[]{Item.dyeBlue, Item.dyePurple});
        this.addShapelessRecipe(new ItemStack(Item.dyeMagenta, 2), new Object[]{Item.dyeRed, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyeMagenta, 2), new Object[]{Item.dyeRed, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyePink, 2), new Object[]{Item.dyeRed, Item.dyeMagenta});
        this.addShapelessRecipe(new ItemStack(Item.dyePink, 2), new Object[]{Item.dyeRed, Item.dyeMagenta});
        this.addShapelessRecipe(new ItemStack(Item.dyeViolet, 2), new Object[]{Item.dyeIndigo, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyeViolet, 2), new Object[]{Item.dyeIndigo, Item.bonemeal});
        this.addShapelessRecipe(new ItemStack(Item.dyeBlue, 2), new Object[]{Block.plantBlue});
        this.addShapelessRecipe(new ItemStack(Block.cloth_red, 1), new Object[]{Item.dyeRed, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_yellow, 1), new Object[]{Item.dyeYellow, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_blue, 1), new Object[]{Item.dyeBlue, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_darkgray, 1), new Object[]{Item.dyeBlack, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_cyan, 1), new Object[]{Item.dyeCyan, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_orange, 1), new Object[]{Item.dyeOrange, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_lime, 1), new Object[]{Item.dyeLime, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_green, 1), new Object[]{Item.dyeGreen, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_teal, 1), new Object[]{Item.dyeAquaGreen, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_lilac, 1), new Object[]{Item.dyePurple, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_indigo, 1), new Object[]{Item.dyeIndigo, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_violet, 1), new Object[]{Item.dyeViolet, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_pink, 1), new Object[]{Item.dyePink, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_magenta, 1), new Object[]{Item.dyeMagenta, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_lightgray, 1), new Object[]{Item.dyeGrey, Block.cloth});
        this.addShapelessRecipe(new ItemStack(Block.cloth_tekheles, 1), new Object[]{Item.snail, Block.cloth});
        Collections.sort(this.recipes, new RecipeSorter(this));
        System.out.println(this.recipes.size() + " recipes");
    }

    /*
     * Unable to fully structure code
     */
    void addRecipe(ItemStack itemstack, Object[] aobj) {
        block9: {
            s = "";
            i = 0;
            j = 0;
            k = 0;
            if (!(aobj[i] instanceof String[])) ** GOTO lbl20
            as = (String[])aobj[i++];
            l = 0;
            while (l < as.length) {
                s2 = as[l];
                ++k;
                j = s2.length();
                s = s + s2;
                ++l;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                s1 = (String)aobj[i++];
                ++k;
                j = s1.length();
                s = s + s1;
lbl20:
                // 2 sources

                ** while (aobj[i] instanceof String)
            }
        }
        hashmap = new HashMap<Character, ItemStack>();
        while (i < aobj.length) {
            character = (Character)aobj[i];
            itemstack1 = null;
            if (aobj[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)aobj[i + 1]);
            } else if (aobj[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)aobj[i + 1], 1, -1);
            } else if (aobj[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)aobj[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        aitemstack = new ItemStack[j * k];
        i1 = 0;
        while (i1 < j * k) {
            c = s.charAt(i1);
            aitemstack[i1] = hashmap.containsKey(Character.valueOf(c)) != false ? ((ItemStack)hashmap.get(Character.valueOf(c))).copy() : null;
            ++i1;
        }
        this.recipes.add(new ShapedRecipes(j, k, aitemstack, itemstack));
    }

    void addShapelessRecipe(ItemStack itemstack, Object[] aobj) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        Object[] aobj1 = aobj;
        int i = aobj1.length;
        int j = 0;
        while (j < i) {
            Object obj = aobj1[j];
            if (obj instanceof ItemStack) {
                arraylist.add(((ItemStack)obj).copy());
            } else if (obj instanceof Item) {
                arraylist.add(new ItemStack((Item)obj));
            } else if (obj instanceof Block) {
                arraylist.add(new ItemStack((Block)obj));
            } else {
                throw new RuntimeException("Invalid shapeless recipe!");
            }
            ++j;
        }
        this.recipes.add(new ShapelessRecipes(itemstack, arraylist));
    }

    public ItemStack findMatchingRecipe(InventoryCrafting inventorycrafting) {
        int i = 0;
        while (i < this.recipes.size()) {
            IRecipe irecipe = this.recipes.get(i);
            if (irecipe.matches(inventorycrafting)) {
                return irecipe.getCraftingResult(inventorycrafting);
            }
            ++i;
        }
        return null;
    }

    public int[] findAcceptingRecipe(InventoryCrafting inventorycrafting, ItemStack newItem) {
        int[] results = new int[9];
        int i = 0;
        while (i < this.recipes.size()) {
            IRecipe irecipe = this.recipes.get(i);
            int[] result = irecipe.accepts(inventorycrafting, newItem);
            int j = 0;
            while (j < 9) {
                int n = j;
                results[n] = results[n] + result[j];
                ++j;
            }
            ++i;
        }
        return results;
    }

    public int[] findAcceptingRecipe(InventoryCrafting inventorycrafting, ItemStack newItem, int index) {
        int[] results = new int[9];
        int i = 0;
        while (i < this.recipes.size()) {
            IRecipe irecipe = this.recipes.get(i);
            int[] result = irecipe.accepts(inventorycrafting, newItem);
            if (irecipe instanceof ShapedRecipes) {
                result = ((ShapedRecipes)irecipe).acceptsIn(inventorycrafting, newItem, index);
            }
            int j = 0;
            while (j < 9) {
                int n = j;
                results[n] = results[n] + result[j];
                ++j;
            }
            ++i;
        }
        return results;
    }

    public boolean existsAcceptingRecipe(InventoryCrafting inventorycrafting, ItemStack newItem) {
        int i = 0;
        while (i < 9) {
            if (i < 0) {
                return false;
            }
            int[] test = this.findAcceptingRecipe(inventorycrafting, newItem, i);
            int j = 0;
            while (j < 9) {
                if (test[j] != 0) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

