/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.crafting;

import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.player.inventory.InventoryCrafting;

public class CraftingRecipe {
    private int width;
    private int height;
    private int[] ingredientMap;
    private ItemStack resultStack;
    public final int resultId;

    public CraftingRecipe(int i, int j, int[] ai, ItemStack itemstack) {
        this.resultId = itemstack.itemID;
        this.width = i;
        this.height = j;
        this.ingredientMap = ai;
        this.resultStack = itemstack;
    }

    public boolean matches(int[] ai) {
        int i = 0;
        while (i <= 3 - this.width) {
            int j = 0;
            while (j <= 3 - this.height) {
                if (this.func_1185_a(ai, i, j, true)) {
                    return true;
                }
                if (this.func_1185_a(ai, i, j, false)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean matches(InventoryCrafting inventorycrafting) {
        int i = 0;
        while (i <= 3 - this.width) {
            int j = 0;
            while (j <= 3 - this.height) {
                if (this.func_21137_a(inventorycrafting, i, j, true)) {
                    return true;
                }
                if (this.func_21137_a(inventorycrafting, i, j, false)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean func_1185_a(int[] ai, int i, int j, boolean flag) {
        int k = 0;
        while (k < 3) {
            int l = 0;
            while (l < 3) {
                int i1 = k - i;
                int j1 = l - j;
                int k1 = -1;
                if (i1 >= 0 && j1 >= 0 && i1 < this.width && j1 < this.height) {
                    k1 = flag ? this.ingredientMap[this.width - i1 - 1 + j1 * this.width] : this.ingredientMap[i1 + j1 * this.width];
                }
                if (ai[k + l * 3] != k1) {
                    return false;
                }
                ++l;
            }
            ++k;
        }
        return true;
    }

    private boolean func_21137_a(InventoryCrafting inventorycrafting, int u, int v, boolean flag) {
        int gridU = 0;
        while (gridU < 3) {
            int gridV = 0;
            while (gridV < 3) {
                ItemStack checkItem;
                int checkU = gridU - u;
                int checkV = gridV - v;
                ItemStack ingredient = null;
                if (checkU >= 0 && checkV >= 0 && checkU < this.width && checkV < this.height) {
                    ingredient = flag ? new ItemStack(this.ingredientMap[this.width - checkU - 1 + checkV * this.width]) : new ItemStack(this.ingredientMap[checkU + checkV * this.width]);
                }
                if ((checkItem = inventorycrafting.getStackInPos(gridU, gridV)) != null || ingredient != null) {
                    if (checkItem == null && ingredient != null || checkItem != null && ingredient == null) {
                        return false;
                    }
                    if (ingredient.itemID != checkItem.itemID) {
                        return false;
                    }
                    if (ingredient.getItemDamage() != -1 && ingredient.getItemDamage() != checkItem.getItemDamage()) {
                        return false;
                    }
                }
                ++gridV;
            }
            ++gridU;
        }
        return true;
    }

    public ItemStack getCraftingResult(int[] ai) {
        return new ItemStack(this.resultStack.itemID, this.resultStack.stackSize);
    }

    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.resultStack.itemID, this.resultStack.stackSize, this.resultStack.getItemDamage());
    }

    public int getRecipeSize() {
        return this.width * this.height;
    }

    public boolean canPutAt(ItemStack item, InventoryCrafting craftTry, int u, int v, boolean flag) {
        int gridU = 0;
        while (gridU < 3) {
            int gridV = 0;
            while (gridV < 3) {
                int checkU = gridU - u;
                int checkV = gridV - v;
                ItemStack ingredient = null;
                if (checkU >= 0 && checkV >= 0 && checkU < this.width && checkV < this.height) {
                    ingredient = flag ? new ItemStack(this.ingredientMap[this.width - checkU - 1 + checkV * this.width]) : new ItemStack(this.ingredientMap[checkU + checkV * this.width]);
                }
                ItemStack checkItem = craftTry.getStackInPos(gridU, gridV);
                if (gridU == u && gridV == v) {
                    checkItem = item;
                }
                if (checkItem != null || ingredient != null) {
                    if (checkItem != null && ingredient == null) {
                        return false;
                    }
                    if (ingredient != checkItem) {
                        return false;
                    }
                    if (ingredient.getItemDamage() != -1 && ingredient.getItemDamage() != checkItem.getItemDamage()) {
                        return false;
                    }
                }
                ++gridV;
            }
            ++gridU;
        }
        return true;
    }
}

