/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.crafting;

import com.mojang.minecraft.core.crafting.IRecipe;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.player.inventory.InventoryCrafting;

public class ShapedRecipes
implements IRecipe {
    private int recipeWidth;
    private int recipeHeight;
    private ItemStack[] recipeItems;
    private ItemStack recipeOutput;
    public final int recipeOutputItemID;

    public ShapedRecipes(int i, int j, ItemStack[] aitemstack, ItemStack itemstack) {
        this.recipeOutputItemID = itemstack.itemID;
        this.recipeWidth = i;
        this.recipeHeight = j;
        this.recipeItems = aitemstack;
        this.recipeOutput = itemstack;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public boolean matches(InventoryCrafting inventorycrafting) {
        int i = 0;
        while (i <= 3 - this.recipeWidth) {
            int j = 0;
            while (j <= 3 - this.recipeHeight) {
                if (this.fits(inventorycrafting, i, j, true)) {
                    return true;
                }
                if (this.fits(inventorycrafting, i, j, false)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean fits(InventoryCrafting inventorycrafting, int x, int y, boolean flag) {
        int xIndex = 0;
        while (xIndex < 3) {
            int yIndex = 0;
            while (yIndex < 3) {
                ItemStack validIngredient;
                int xOff = xIndex - x;
                int yOff = yIndex - y;
                ItemStack itemstack = null;
                if (xOff >= 0 && yOff >= 0 && xOff < this.recipeWidth && yOff < this.recipeHeight) {
                    itemstack = flag ? this.recipeItems[this.recipeWidth - xOff - 1 + yOff * this.recipeWidth] : this.recipeItems[xOff + yOff * this.recipeWidth];
                }
                if ((validIngredient = inventorycrafting.getStackInPos(xIndex, yIndex)) != null || itemstack != null) {
                    if (validIngredient == null && itemstack != null || validIngredient != null && itemstack == null) {
                        return false;
                    }
                    if (itemstack.itemID != validIngredient.itemID) {
                        return false;
                    }
                    if (itemstack.getItemDamage() != -1 && itemstack.getItemDamage() != validIngredient.getItemDamage()) {
                        return false;
                    }
                }
                ++yIndex;
            }
            ++xIndex;
        }
        return true;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.recipeOutput.itemID, this.recipeOutput.stackSize, this.recipeOutput.getItemDamage());
    }

    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    public int[] accepts(InventoryCrafting inventorycrafting, ItemStack newItem) {
        int[] positions = new int[9];
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                int x2 = 0;
                while (x2 < 3) {
                    int y2 = 0;
                    while (y2 < 3) {
                        if (this.fitsIn(inventorycrafting, x, y, false, newItem, x2, y2)) {
                            int n = x + x * y;
                            positions[n] = positions[n] + 1;
                        }
                        ++y2;
                    }
                    ++x2;
                }
                ++y;
            }
            ++x;
        }
        return positions;
    }

    public int[] acceptsIn(InventoryCrafting inventorycrafting, ItemStack newItem, int index) {
        int[] positions = new int[9];
        if (--index < 0) {
            return positions;
        }
        int checkX = index % 3;
        int checkY = index / 3;
        int x = 0;
        while (x <= 3 - this.recipeWidth) {
            int y = 0;
            while (y <= 3 - this.recipeHeight) {
                if (this.fitsIn(inventorycrafting, x, y, true, newItem, checkX, checkY)) {
                    int n = index;
                    positions[n] = positions[n] + 1;
                }
                if (this.fitsIn(inventorycrafting, x, y, false, newItem, checkX, checkY)) {
                    int n = index;
                    positions[n] = positions[n] + 1;
                }
                ++y;
            }
            ++x;
        }
        return positions;
    }

    private boolean fitsIn(InventoryCrafting inventorycrafting, int x, int y, boolean flag, ItemStack newItem, int newItemX, int newItemY) {
        int xIndex = 0;
        while (xIndex < 3) {
            int yIndex = 0;
            while (yIndex < 3) {
                int xOff = xIndex - x;
                int yOff = yIndex - y;
                ItemStack ingredientInRecipe = null;
                if (xOff >= 0 && yOff >= 0 && xOff < this.recipeWidth && yOff < this.recipeHeight) {
                    ingredientInRecipe = flag ? this.recipeItems[this.recipeWidth - xOff - 1 + yOff * this.recipeWidth] : this.recipeItems[xOff + yOff * this.recipeWidth];
                }
                ItemStack checkedIngredient = inventorycrafting.getStackInPos(xIndex, yIndex);
                if (newItemX == xIndex && newItemY == yIndex) {
                    if (newItem == null) {
                        return false;
                    }
                    checkedIngredient = newItem;
                }
                if (checkedIngredient != null || ingredientInRecipe != null) {
                    if (checkedIngredient != null && ingredientInRecipe == null) {
                        return false;
                    }
                    if (ingredientInRecipe != null && checkedIngredient != null && ingredientInRecipe.itemID != checkedIngredient.itemID) {
                        return false;
                    }
                    if (ingredientInRecipe != null && checkedIngredient != null && ingredientInRecipe.getItemDamage() != -1 && ingredientInRecipe.getItemDamage() != checkedIngredient.getItemDamage()) {
                        return false;
                    }
                }
                ++yIndex;
            }
            ++xIndex;
        }
        return true;
    }
}

