/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.crafting;

import com.mojang.minecraft.core.crafting.IRecipe;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.player.inventory.InventoryCrafting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ShapelessRecipes
implements IRecipe {
    private final ItemStack recipeOutput;
    private final List recipeItems;

    public ShapelessRecipes(ItemStack itemstack, List list) {
        this.recipeOutput = itemstack;
        this.recipeItems = list;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public boolean matches(InventoryCrafting inventorycrafting) {
        ArrayList itemsInRecipe = new ArrayList(this.recipeItems);
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                ItemStack itemstack = inventorycrafting.getStackInPos(j, i);
                if (itemstack != null) {
                    boolean foundMatch = false;
                    for (ItemStack itemCheck : itemsInRecipe) {
                        if (itemstack.itemID != itemCheck.itemID || itemCheck.getItemDamage() != -1 && itemstack.getItemDamage() != itemCheck.getItemDamage()) continue;
                        foundMatch = true;
                        itemsInRecipe.remove(itemCheck);
                        break;
                    }
                    if (!foundMatch) {
                        return false;
                    }
                }
                ++j;
            }
        }
        return itemsInRecipe.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return this.recipeOutput.copy();
    }

    public int getRecipeSize() {
        return this.recipeItems.size();
    }

    public int[] accepts(InventoryCrafting inventorycrafting, ItemStack newItem) {
        ArrayList itemsInRecipe = new ArrayList(this.recipeItems);
        int index = -1;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                ItemStack itemstack = inventorycrafting.getStackInPos(j, i);
                if (itemstack != null) {
                    boolean foundMatch_current = false;
                    for (ItemStack itemCheck : itemsInRecipe) {
                        if (itemstack.itemID != itemCheck.itemID || itemCheck.getItemDamage() != -1 && itemstack.getItemDamage() != itemCheck.getItemDamage()) continue;
                        foundMatch_current = true;
                        itemsInRecipe.remove(itemCheck);
                        break;
                    }
                    boolean foundMatch_new = false;
                    Iterator item = itemsInRecipe.iterator();
                    if (foundMatch_current) {
                        while (item.hasNext()) {
                            ItemStack itemCheck = (ItemStack)item.next();
                            if (newItem.itemID != itemCheck.itemID || itemCheck.getItemDamage() != -1 && newItem.getItemDamage() != newItem.getItemDamage()) continue;
                            foundMatch_new = true;
                            itemsInRecipe.remove(itemCheck);
                            break;
                        }
                    }
                    if (!foundMatch_new) {
                        return new int[9];
                    }
                }
                ++j;
            }
        }
        return new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
    }
}

