/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity;

import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityCreature;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.EntityZombie;
import com.mojang.minecraft.core.entity.IMobs;
import com.mojang.minecraft.core.enums.EnumSkyBlock;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.nbt.NBTTagCompound;
import com.mojang.minecraft.core.util.MathHelper;

public class EntityMobs
extends EntityCreature
implements IMobs {
    protected int maxHealth = 2;
    public double currentSpeed;
    public boolean isStriking;
    public int strikeTime;

    public EntityMobs(World world) {
        super(world);
        this.health = 20;
        this.currentSpeed = 0.5;
        this.isRunning = true;
        this.isStriking = false;
        this.strikeTime = 0;
    }

    public void swingItem() {
        this.strikeTime = -1;
        this.isStriking = true;
    }

    protected void updateEntityActionState() {
        super.updateEntityActionState();
        if (this.isStriking) {
            ++this.strikeTime;
            if (this.strikeTime == 8) {
                this.strikeTime = 0;
                this.isStriking = false;
            }
        } else {
            this.strikeTime = 0;
        }
        this.swingProgress = (float)this.strikeTime / 8.0f;
    }

    public void onLivingUpdate() {
        float f = this.getEntityBrightness(1.0f);
        if (f > 0.5f) {
            this.lifeTimer += 2;
        }
        super.onLivingUpdate();
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.multiplayerWorld && this.worldObj.difficulty == 0) {
            this.setEntityDead();
        }
    }

    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer) && !entityplayer.isCreative) {
            return entityplayer;
        }
        return null;
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (super.attackEntityFrom(entity, i)) {
            if (this.riddenByEntity == entity || this.entityBeingRidden == entity) {
                return true;
            }
            if (entity != this) {
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    protected void attackEntity(Entity entity, float f) {
        if ((double)f < 2.5 && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            if (this.fire > 0 && this instanceof EntityZombie) {
                entity.fire = 100;
            }
            this.swingItem();
            entity.attackEntityFrom(this, this.maxHealth - (entity.chainArmor + entity.diamondArmor) / 2);
        }
    }

    protected float getBlockPathWeight(int i, int j, int k) {
        return 0.5f - this.worldObj.getBrightness(i, j, k);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    public boolean shouldSpawnOnTile() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        if (this.worldObj.getBlockLighting(EnumSkyBlock.Sky, i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.worldObj.getBlockLightValue(i, j, k);
        return l <= this.rand.nextInt(8) && super.shouldSpawnOnTile();
    }

    public double getRealMoveSpeed() {
        return this.currentSpeed;
    }
}

