/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity;

import com.mojang.minecraft.core.entity.EntityAnimals;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.nbt.NBTTagCompound;

public class EntityPig
extends EntityAnimals {
    public EntityPig(World world) {
        super(world);
        this.setSaddled(false);
        this.scoreYield = 10;
        this.texture = "/mob/pig.png";
        this.setSize(0.9f, 0.9f);
        this.setSaddled(false);
        this.setReal(true);
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (byte)0);
        this.dataWatcher.addObject(15, (byte)0);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBool("Saddle", this.getSaddled());
        nbttagcompound.setBool("Real", this.getReal());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSaddled(nbttagcompound.getBoolean("Saddle"));
        this.setReal(nbttagcompound.getBoolean("Real"));
    }

    protected String idleSound() {
        return "mob.pig";
    }

    protected String hurtSound() {
        return "mob.pig";
    }

    protected String deathSound() {
        if (this.getReal()) {
            return "mob.pigdeath";
        }
        return "mob.pigdissolve";
    }

    public boolean interact(EntityPlayer entityplayer) {
        if (this.getSaddled() && !this.worldObj.multiplayerWorld && (this.riddenByEntity == null || this.riddenByEntity == entityplayer)) {
            entityplayer.mountEntity(this);
            return true;
        }
        return false;
    }

    protected int deathDropItem() {
        if (this.worldObj.multiplayerWorld || !this.getReal()) {
            return 0;
        }
        if (!this.getSaddled()) {
            if (this.fire > 0) {
                return Item.porkCooked.shiftedIndex;
            }
            return Item.porkRaw.shiftedIndex;
        }
        this.dropItem(Item.saddle.shiftedIndex, 1);
        if (this.fire > 0) {
            return Item.porkCooked.shiftedIndex;
        }
        return Item.porkRaw.shiftedIndex;
    }

    public boolean getReal() {
        return (this.dataWatcher.getWatchableObjectByte(15) & 1) == 0;
    }

    public void setReal(boolean isReal) {
        if (isReal) {
            this.dataWatcher.updateObject(15, (byte)0);
        } else {
            this.dataWatcher.updateObject(15, (byte)1);
        }
    }

    public boolean getSaddled() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            if (!this.getReal() && !this.worldObj.multiplayerWorld) {
                this.worldObj.createExplosion(this, this.posX, this.posY, this.posZ, 2.0f);
                this.damageEntity(100);
            }
            this.dataWatcher.updateObject(16, (byte)1);
            this.isSpecial = true;
        } else {
            this.dataWatcher.updateObject(16, (byte)0);
            this.isSpecial = false;
        }
    }
}

