/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity;

import com.mojang.minecraft.client.entity.EntityPlayerSP;
import com.mojang.minecraft.client.player.controller.MovementInput;
import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityArrow;
import com.mojang.minecraft.core.entity.EntityFish;
import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.entity.EntityMobs;
import com.mojang.minecraft.core.entity.EntitySkeleton;
import com.mojang.minecraft.core.entity.EntitySpider;
import com.mojang.minecraft.core.entity.EntityZombie;
import com.mojang.minecraft.core.entity.item.IInventory;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.core.entity.tile.TileEntitySign;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.WorldClient;
import com.mojang.minecraft.core.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.nbt.NBTTagCompound;
import com.mojang.minecraft.core.nbt.NBTTagInt;
import com.mojang.minecraft.core.nbt.NBTTagList;
import com.mojang.minecraft.core.player.inventory.Container;
import com.mojang.minecraft.core.player.inventory.ContainerPlayer;
import com.mojang.minecraft.core.player.inventory.InventoryPlayer;
import com.mojang.minecraft.core.util.MathHelper;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class EntityPlayer
extends EntityLiving {
    static String[] PLAYER_COLORS = new String[]{"c", "b", "a", "5", "6", "e", "d", "7"};
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public MovementInput currentInput;
    public Container inventorySlots;
    public Container craftingInventory;
    public byte field_777_c = 0;
    public int score = 0;
    public float field_775_e;
    public float field_774_f;
    public boolean field_773_g = false;
    public int field_772_h = 0;
    public String playerName = "";
    public String particleEffect = "";
    public String chatColor;
    public String playerCloakUrl;
    public double field_20066_r;
    public double field_20065_s;
    public double field_20064_t;
    public double field_20063_u;
    public double field_20062_v;
    public double field_20061_w;
    private int damageRemainder = 0;
    public EntityFish fishEntity;
    private ItemStack itemBeingUsed;
    private int itemUseTime;
    public float speeb;
    public float maxSpeeb;
    public boolean modelRene = false;
    private ChunkCoordinates playerSpawnCoordinate;

    public EntityPlayer(World world) {
        super(world);
        this.craftingInventory = this.inventorySlots = new ContainerPlayer(this.inventory, !world.multiplayerWorld);
        this.yOffset = 1.62f;
        this.setLocationAndAngles((double)world.spawnX + 0.5, world.spawnY + 1, (double)world.spawnZ + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.field_725_x = "humanoid";
        this.field_726_w = 180.0f;
        this.fireResistance = 20;
        this.texture = "/char.png";
        this.spongeArmor = 0;
        this.leatherArmor = 0;
        this.goldArmor = 0;
        this.chainArmor = 0;
        this.steelArmor = 0;
        this.diamondArmor = 0;
        this.chatColor = EntityPlayer.computePlayerColor(this.worldObj.mc.session.username);
        this.measureBlockX = 0;
        this.measureBlockY = 0;
        this.measureBlockZ = 0;
    }

    public static String computePlayerColor(String name) {
        byte[] pName = null;
        try {
            pName = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int length = pName.length;
        int oddShift = 1 - length % 2;
        int value = 0;
        int i = 0;
        while (i < length) {
            byte by = pName[i];
            int rev = length - (i + 1) + oddShift;
            value = rev % 4 >= 2 ? (value -= by) : (value += by);
            ++i;
        }
        if ((value %= 8) < 0) {
            value = PLAYER_COLORS.length + value;
        }
        System.out.println(value);
        return PLAYER_COLORS[value];
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.multiplayerWorld && this.craftingInventory != null && !this.craftingInventory.isUsableByPlayer(this)) {
            this.closeScreen();
            this.craftingInventory = this.inventorySlots;
        }
        if (this.itemBeingUsed != null) {
            ItemStack itemstack = this.inventory.getCurrentItem();
            if (itemstack != this.itemBeingUsed) {
                this.stopUsing();
            } else {
                if (this.itemUseTime <= 25) {
                    int cfr_ignored_0 = this.itemUseTime % 4;
                }
                if (--this.itemUseTime == 0) {
                    boolean cfr_ignored_1 = this.worldObj.multiplayerWorld;
                }
            }
        }
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double d = this.posX - this.field_20063_u;
        double d1 = this.posY - this.field_20062_v;
        double d2 = this.posZ - this.field_20061_w;
        double d3 = 10.0;
        if (d > d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d2 > d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 > d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        if (d < -d3) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (d2 < -d3) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (d1 < -d3) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        this.field_20063_u += d * 0.25;
        this.field_20061_w += d2 * 0.25;
        this.field_20062_v += d1 * 0.25;
    }

    public int posXInt() {
        return (int)Math.round(this.posX);
    }

    public int posYInt() {
        return (int)Math.round(this.posY);
    }

    public int posZInt() {
        return (int)Math.round(this.posZ);
    }

    protected void closeScreen() {
        this.craftingInventory = this.inventorySlots;
    }

    public void updateCloak() {
        this.playerCloakUrl = this.cloakURL;
    }

    public void updateRidden() {
        super.updateRidden();
        this.field_775_e = this.field_774_f;
        this.field_774_f = 0.0f;
    }

    public void preparePlayerToSpawn() {
        this.yOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.health = 20;
        this.deathTime = 0;
    }

    protected void updateEntityActionState() {
        if (this.field_773_g) {
            ++this.field_772_h;
            if (this.field_772_h == 8) {
                this.field_772_h = 0;
                this.field_773_g = false;
            }
        } else {
            this.field_772_h = 0;
        }
        this.swingProgress = (float)this.field_772_h / 8.0f;
    }

    public void onLivingUpdate() {
        List<Entity> list;
        if (!(this.worldObj instanceof WorldClient) && this.worldObj.difficulty == 0 && this.health < 20 && this.ticksExisted % 20 * 4 == 0) {
            this.heal(1);
        }
        this.spongeArmor = this.inventory.getArmorCount("sponge");
        this.leatherArmor = this.inventory.getArmorCount("leather");
        this.goldArmor = this.inventory.getArmorCount("gold");
        this.chainArmor = this.inventory.getArmorCount("chain");
        this.steelArmor = this.inventory.getArmorCount("steel");
        this.diamondArmor = this.inventory.getArmorCount("diamond");
        this.inventory.decrementAnimations();
        this.field_775_e = this.field_774_f;
        super.onLivingUpdate();
        float hypotenuseMove = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (hypotenuseMove > this.maxSpeeb) {
            hypotenuseMove = this.maxSpeeb;
        }
        if (!this.onGround || this.health <= 0) {
            hypotenuseMove = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f1 = 0.0f;
        }
        this.field_774_f += (hypotenuseMove - this.field_774_f) * 0.4f;
        this.field_709_M += (f1 - this.field_709_M) * 0.8f;
        if (this.health > 0 && (list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0, 0.0, 1.0))) != null) {
            int i = 0;
            while (i < list.size()) {
                this.func_451_h(list.get(i));
                ++i;
            }
        }
        if (this.posY < -64.0) {
            this.health -= 4;
        }
    }

    private void func_451_h(Entity entity) {
        entity.onCollideWithPlayer(this);
    }

    public int getScore() {
        return this.score;
    }

    public void onDeath(Entity entity) {
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1;
        if (this.playerName.equals("Noptch")) {
            this.dropInventory(new ItemStack(Item.appleRed, 1), true);
        }
        if (!this.worldObj.multiplayerWorld) {
            this.inventory.dropAllItems();
        }
        if (entity != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * 3.141593f / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.yOffset = 0.1f;
    }

    public void addToPlayerScore(Entity entity, int i) {
        this.score += i;
    }

    public void dropPlayerItem(ItemStack itemstack) {
        this.dropInventory(itemstack, false);
    }

    public void dropInventory(ItemStack itemstack, boolean flag) {
        if (itemstack == null || this.worldObj.multiplayerWorld) {
            return;
        }
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY - (double)0.3f + (double)this.func_373_s(), this.posZ, itemstack);
        entityitem.delayBeforeCanPickup = 40;
        if (flag) {
            float f2 = this.rand.nextFloat() * 0.5f;
            float f4 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX = -MathHelper.sin(f4) * f2;
            entityitem.motionZ = MathHelper.cos(f4) * f2;
            entityitem.motionY = 0.2f;
        } else {
            float f1 = 0.3f;
            entityitem.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f1;
            entityitem.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f1 + 0.1f;
            f1 = 0.02f;
            float f3 = this.rand.nextFloat() * 3.141593f * 2.0f;
            entityitem.motionX += Math.cos(f3) * (double)(f1 *= this.rand.nextFloat());
            entityitem.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
            entityitem.motionZ += Math.sin(f3) * (double)f1;
        }
        this.func_446_a(entityitem);
    }

    protected void func_446_a(EntityItem entityitem) {
        this.worldObj.entityJoinedWorld(entityitem);
    }

    public float getMiningInhibitors(Block block) {
        float f = this.inventory.getStrVsBlock(block);
        if (this.isInsideOfMaterial(Material.water)) {
            f = this.spongeArmor > 0 ? (f /= (float)(5 - this.spongeArmor)) : (f /= 5.0f);
        }
        if (!this.onGround) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean checkBreakBlock(Block block) {
        return this.inventory.canHarvestBlock(block);
    }

    public boolean checkGoldTouch(Block block) {
        return this.inventory.canHarvestBlockGoldTouch(block);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Inventory");
        this.inventory.readFromNBT(nbttaglist);
        try {
            NBTTagList measure = nbttagcompound.getTagList("MeasuringFrom");
            this.measureBlockX = ((NBTTagInt)measure.tagAt((int)0)).intValue;
            this.measureBlockY = ((NBTTagInt)measure.tagAt((int)1)).intValue;
            this.measureBlockZ = ((NBTTagInt)measure.tagAt((int)2)).intValue;
        }
        catch (Exception ex) {
            System.out.println("Old save data was missing a doohickey and/or gizmo!");
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setList("Inventory", this.inventory.writeToNBT(new NBTTagList()));
        nbttagcompound.setList("MeasuringFrom", this.newIntNBTList(new int[]{this.measureBlockX, this.measureBlockY, this.measureBlockZ}));
    }

    public void displayGUIChest(IInventory iinventory) {
    }

    public void displayWorkbenchGUI() {
    }

    public void onItemPickup(Entity entity, int i) {
    }

    protected float func_373_s() {
        return 0.12f;
    }

    public boolean attackEntityFrom(Entity entity, int damage) {
        this.lifeTimer = 0;
        if (this.health <= 0) {
            return false;
        }
        if ((float)this.heartsLife > (float)this.maxHealth / 2.0f) {
            return false;
        }
        if (entity instanceof EntityMobs || entity instanceof EntityArrow) {
            if (this.worldObj.difficulty == 0) {
                damage = 0;
            }
            if (this.worldObj.difficulty == 1) {
                damage = damage / 3 + 1;
            }
            if (this.worldObj.difficulty == 3) {
                damage = damage * 3 / 2;
            }
        }
        int j = 25 - this.inventory.getTotalArmorValue();
        int k = damage * j + this.damageRemainder;
        this.inventory.damageArmor(damage);
        damage = k / 25;
        this.damageRemainder = k % 25;
        if (!(damage != 0 || entity instanceof EntityArrow || entity instanceof EntitySpider || entity instanceof EntityZombie || entity instanceof EntitySkeleton)) {
            return false;
        }
        return super.attackEntityFrom(entity, damage);
    }

    protected void damageEntity(int i) {
        int j = 25 - this.inventory.getTotalArmorValue();
        int k = i * j + this.damageRemainder;
        this.inventory.damageArmor(i);
        i = k / 25;
        this.damageRemainder = k % 25;
        super.damageEntity(i);
    }

    public void displayGUIFurnace(TileEntityFurnace tileentityfurnace) {
    }

    public void displayGUIEditSign(TileEntitySign tileentitysign) {
    }

    public void useCurrentItemOnEntity(Entity entity) {
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    public double getYOffset() {
        return this.yOffset - 0.5f;
    }

    public void swingItem() {
        this.field_772_h = -1;
        this.field_773_g = true;
    }

    public void attackTargetEntityWithCurrentItem(Entity entity) {
        int i = this.inventory.getDamageVsEntity(entity);
        if (i > 0) {
            if (this.motionY < 0.0) {
                ++i;
            }
            entity.attackEntityFrom(this, i);
            ItemStack itemstack = this.getCurrentEquippedItem();
            if (itemstack != null && entity instanceof EntityLiving) {
                itemstack.hitEntity((EntityLiving)entity);
                if (itemstack.stackSize <= 0) {
                    itemstack.func_1097_a(this);
                    this.destroyCurrentEquippedItem();
                }
            }
        }
    }

    public void func_6420_o() {
    }

    public void setEntityDead() {
        super.setEntityDead();
        this.inventorySlots.onCraftGuiClosed(this);
        if (this.craftingInventory != null) {
            this.craftingInventory.onCraftGuiClosed(this);
        }
    }

    public void onItemStackChanged(ItemStack itemstack) {
    }

    public static ChunkCoordinates func_25060_a(World world, ChunkCoordinates chunkcoordinates) {
        return null;
    }

    public ChunkCoordinates getPlayerSpawnCoordinate() {
        return this.playerSpawnCoordinate;
    }

    public void setPlayerSpawnCoordinate(ChunkCoordinates chunkcoordinates) {
        this.playerSpawnCoordinate = chunkcoordinates != null ? new ChunkCoordinates(chunkcoordinates.x, chunkcoordinates.z) : null;
    }

    public void onEntityUpdate() {
        if (!this.worldObj.mc.options.firstPersonParticles && this.worldObj.mc.options.thirdPersonView && this instanceof EntityPlayerSP) {
            float f1 = MathHelper.floor_double(this.boundingBox.minY);
            int i = 0;
            while ((float)i < 1.0f + this.width * 20.0f) {
                float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                this.worldObj.spawnParticle(this.particleEffect, this.posX + (double)f2, f1, this.posZ + (double)f4, this.motionX, this.motionY, this.motionZ);
                ++i;
            }
        }
        super.onEntityUpdate();
    }

    public void startUsing(ItemStack itemstack, int i) {
        if (itemstack == this.itemBeingUsed) {
            return;
        }
        this.itemBeingUsed = itemstack;
        if (!this.getUsing()) {
            this.itemUseTime = i;
        }
        if (!this.worldObj.multiplayerWorld) {
            this.setUsing(true);
        }
    }

    public void onPlayerStoppedUsing() {
        if (this.itemBeingUsed != null) {
            this.itemBeingUsed.onPlayerStoppedUsing(this.worldObj, this, this.itemUseTime);
        }
        this.stopUsing();
    }

    public void stopUsing() {
        this.itemBeingUsed = null;
        this.itemUseTime = 0;
        if (!this.worldObj.multiplayerWorld) {
            this.setUsing(false);
        }
    }

    public int getItemIcon(ItemStack itemstack) {
        int i = super.getItemIcon(itemstack);
        if (this.itemBeingUsed != null && itemstack.itemID == Item.bow.shiftedIndex) {
            int j = itemstack.getItemMaxUseDuration() - this.itemUseTime;
            if (j >= 18) {
                return 177;
            }
            if (j > 13) {
                return 161;
            }
            if (j > 0) {
                return 145;
            }
        }
        return i;
    }

    public void setEyeHeight(float f) {
    }

    public int[] getMeasuredBlock() {
        int[] list = new int[]{this.measureBlockX, this.measureBlockY, this.measureBlockZ};
        return list;
    }

    public boolean isMeasuringBlock() {
        return this.measureBlockX != 0 || this.measureBlockY != 0 || this.measureBlockZ != 0;
    }

    public void setMeasuredBlock(int x, int y, int z) {
        this.measureBlockX = x;
        this.measureBlockY = y;
        this.measureBlockZ = z;
    }

    public int getDistanceFromMeasureOrSpawn() {
        double distZ;
        double distY;
        double distX;
        if (this.isMeasuringBlock()) {
            distX = Math.abs(this.posX - (double)this.measureBlockX - 0.5);
            distY = Math.abs(this.posY - (double)this.measureBlockY - 0.5);
            distZ = Math.abs(this.posZ - (double)this.measureBlockZ - 0.5);
        } else {
            distX = Math.abs(this.posX - (double)this.worldObj.spawnX - 0.5);
            distY = Math.abs(this.posY - (double)this.worldObj.spawnY - 0.5);
            distZ = Math.abs(this.posZ - (double)this.worldObj.spawnZ - 0.5);
        }
        return (int)Math.round(Math.sqrt(distX * distX + distY * distY + distZ * distZ));
    }

    public void handleKeyPress(int eventKey, boolean eventKeyState) {
    }

    public void displayWorkbenchGUI(int i, int j, int k) {
    }
}

