/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity;

import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityAnimals;
import com.mojang.minecraft.core.entity.EntityItem;
import com.mojang.minecraft.core.entity.EntityLiving;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.WorldClient;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.nbt.NBTTagCompound;

public class EntitySheep
extends EntityAnimals {
    int field_754_i = 0;

    public EntitySheep(World world) {
        super(world);
        this.setSheared(false);
        this.scoreYield = 10;
        this.field_754_i = 0;
        this.texture = "/mob/sheep.png";
        this.setSize(0.9f, 1.3f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
    }

    public boolean attackEntityFrom(Entity entity, int i) {
        if (!this.getSheared() && entity instanceof EntityLiving && !(this.worldObj instanceof WorldClient)) {
            this.setSheared(true);
            int j = 1 + this.rand.nextInt(3);
            int k = 0;
            while (k < j) {
                EntityItem entityitem = this.dropItemWithOffset(Block.cloth.blockID, 1, 1.0f);
                entityitem.motionY += (double)(this.rand.nextFloat() * 0.05f);
                entityitem.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                entityitem.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                this.field_754_i = this.rand.nextInt(1200);
                ++k;
            }
        }
        return super.attackEntityFrom(entity, i);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.getSheared() && --this.field_754_i <= 0 && !this.worldObj.multiplayerWorld) {
            this.worldObj.playSoundAtEntity(this, "mob.chickenplop", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.setSheared(false);
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBool("Sheared", this.getSheared());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSheared(nbttagcompound.getBoolean("Sheared"));
    }

    protected String idleSound() {
        return "mob.sheep";
    }

    protected String hurtSound() {
        return "mob.sheep";
    }

    protected String deathSound() {
        return "mob.sheep";
    }

    public boolean getSheared() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 0x10));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFEF));
        }
    }
}

