/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity;

import com.mojang.minecraft.core.entity.Entity;
import com.mojang.minecraft.core.entity.EntityArrow;
import com.mojang.minecraft.core.entity.EntityMobs;
import com.mojang.minecraft.core.entity.Vector2;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.nbt.NBTTagCompound;
import com.mojang.minecraft.core.util.MathHelper;
import java.util.Random;

public class EntitySkeleton
extends EntityMobs {
    public EntitySkeleton(World world) {
        super(world);
        this.scoreYield = 40;
        this.texture = "/mob/skeleton.png";
        this.currentSpeed = 0.5;
    }

    protected String idleSound() {
        return "mob.skeleton";
    }

    protected String hurtSound() {
        return "mob.skeletonhurt";
    }

    protected String deathSound() {
        return "mob.skeletonhurt";
    }

    public void onLivingUpdate() {
        float f;
        if (this.worldObj.func_624_b() && (f = this.getEntityBrightness(1.0f)) > 0.5f && this.worldObj.func_647_i(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) && this.rand.nextFloat() * 30.0f < (f - 0.4f) * 2.0f) {
            this.fire = 300;
        }
        super.onLivingUpdate();
    }

    protected void attackEntity(Entity target, float f) {
        if (f < 10.0f && (this.worldObj.mc.options.difficulty <= 1 || (double)target.getDistanceToEntity(this) < 3.5)) {
            double distX = target.posX - this.posX;
            double distZ = target.posZ - this.posZ;
            if (this.attackTime == 0) {
                EntityArrow entityarrow = new EntityArrow(this.worldObj, this);
                if (this.fire > 0) {
                    entityarrow.fire = 300;
                }
                entityarrow.posY += (double)1.4f;
                double distY = target.posY - (double)0.2f - entityarrow.posY;
                float dotXZ = MathHelper.sqrt_double(distX * distX + distZ * distZ) * 0.2f;
                this.worldObj.playSoundAtEntity(this, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
                this.worldObj.entityJoinedWorld(entityarrow);
                entityarrow.setArrowHeading(distX, distY + (double)dotXZ, distZ, 0.6f, 12.0f);
                this.attackTime = 30;
            }
            this.rotationYaw = (float)(Math.atan2(distZ, distX) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        } else if (f < 10.0f) {
            double distXa = target.posX - this.posX;
            double distZa = target.posZ - this.posZ;
            float distXZa = MathHelper.sqrt_double(distXa * distXa + distZa * distZa) * 0.2f;
            Vector2 vec = EntitySkeleton.calculateFireDirection(new Vector2(target.posX, target.posZ), new Vector2(this.posX, this.posZ), new Vector2(target.motionX * 20.0, target.motionZ * 20.0), 12.0f - distXZa);
            if (vec == null) {
                return;
            }
            double distX = vec.x;
            double distZ = vec.z;
            if (this.attackTime == 0) {
                EntityArrow entityarrow = new EntityArrow(this.worldObj, this);
                if (this.fire > 0) {
                    entityarrow.fire = 300;
                }
                entityarrow.posY += (double)1.4f;
                double distY = target.posY - (double)0.2f - entityarrow.posY;
                float distXZ = MathHelper.sqrt_double(distX * distX + distZ * distZ) * 0.2f;
                this.worldObj.playSoundAtEntity(this, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
                this.worldObj.entityJoinedWorld(entityarrow);
                entityarrow.setArrowHeading(distX, distY + (double)distXZ, distZ, 0.6f, 12.0f);
                this.attackTime = 30;
            }
            this.rotationYaw = (float)(Math.atan2(distZ, distX) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        }
    }

    private static Vector2 sub(Vector2 lhs, Vector2 rhs) {
        return new Vector2(lhs).sub(rhs);
    }

    private static Vector2 calculateFireDirection(Vector2 targetPosition, Vector2 turretPosition, Vector2 targetVelocity, float bulletSpeed) {
        float q;
        Vector2 turretToTarget = EntitySkeleton.sub(targetPosition, turretPosition);
        float a = targetVelocity.x * targetVelocity.x + targetVelocity.z * targetVelocity.z - bulletSpeed * bulletSpeed;
        float b = 2.0f * targetVelocity.dot(turretToTarget);
        float p = -b / (2.0f * a);
        float t = Math.max(p - (q = (float)Math.sqrt(b * b - 4.0f * a * (turretToTarget.x * turretToTarget.z + turretToTarget.z * turretToTarget.z)) / (2.0f * a)), p + q);
        if (t > 0.0f) {
            Vector2 tp = new Vector2(targetPosition);
            Vector2 tv = new Vector2(targetVelocity);
            Vector2 collisionPoint = tp.add(tv);
            return EntitySkeleton.sub(collisionPoint, turretPosition);
        }
        return null;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    protected int deathDropItem() {
        if (new Random().nextBoolean()) {
            return Item.bone.shiftedIndex;
        }
        return Item.arrow.shiftedIndex;
    }

    public double getRealMoveSpeed() {
        return this.currentSpeed;
    }
}

