/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity.item;

import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;

public class ItemBlock
extends Item {
    private int blockID;

    public ItemBlock(int i) {
        super(i);
        this.blockID = i + 256;
        this.setIconIndex(Block.allBlocks[i + 256].getTextureIndex(2));
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        boolean alreadyPlaced = false;
        if (itemstack.itemID == Block.stepSingle.blockID && itemstack.stackSize != 0 && world.getBlockId(i, j, k) == Block.stepSingle.blockID && !entityplayer.getIsSneaking()) {
            Block doubleStep;
            int orientation = world.getBlockMetadata(i, j, k);
            if (l == 0 && orientation == 1) {
                doubleStep = Block.stepDouble;
                if (world.setBlockWithNotify(i, j, k, doubleStep.blockID)) {
                    doubleStep.onBlockPlaced(world, i, j, k, l);
                    doubleStep.onBlockPlacedBy(world, i, j, k, entityplayer);
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, doubleStep.stepSound.func_1145_d(), (doubleStep.stepSound.getVolume() + 1.0f) / 2.0f, doubleStep.stepSound.getPitch() * 0.8f);
                    --itemstack.stackSize;
                    alreadyPlaced = true;
                }
            }
            if (l == 1 && orientation == 0) {
                doubleStep = Block.stepDouble;
                if (world.setBlockWithNotify(i, j, k, doubleStep.blockID)) {
                    doubleStep.onBlockPlaced(world, i, j, k, l);
                    doubleStep.onBlockPlacedBy(world, i, j, k, entityplayer);
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, doubleStep.stepSound.func_1145_d(), (doubleStep.stepSound.getVolume() + 1.0f) / 2.0f, doubleStep.stepSound.getPitch() * 0.8f);
                    --itemstack.stackSize;
                    alreadyPlaced = true;
                }
            }
            if (l > 1 && orientation > 0 && l == orientation) {
                doubleStep = Block.stepDouble;
                if (world.setBlockWithNotify(i, j, k, doubleStep.blockID)) {
                    doubleStep.onBlockPlaced(world, i, j, k, l);
                    doubleStep.onBlockPlacedBy(world, i, j, k, entityplayer);
                    world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, doubleStep.stepSound.func_1145_d(), (doubleStep.stepSound.getVolume() + 1.0f) / 2.0f, doubleStep.stepSound.getPitch() * 0.8f);
                    --itemstack.stackSize;
                    alreadyPlaced = true;
                }
            }
        }
        if (world.getBlockId(i, j, k) == Block.snow.blockID) {
            l = 0;
        } else {
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (world.func_695_a(this.blockID, i, j, k, false) && !alreadyPlaced) {
            Block block = Block.allBlocks[this.blockID];
            if (world.setBlockWithNotify(i, j, k, this.blockID)) {
                Block.allBlocks[this.blockID].onBlockPlaced(world, i, j, k, l);
                Block.allBlocks[this.blockID].onBlockPlacedBy(world, i, j, k, entityplayer);
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                --itemstack.stackSize;
            }
        }
        return true;
    }
}

