/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity.item;

import com.mojang.minecraft.core.entity.EntityArrow;
import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.level.World;

public class ItemBow
extends Item {
    public ItemBow(int i) {
        super(i);
        this.maxStackSize = 1;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        float damageMult = 1.0f;
        if (entityplayer.inventory.armorInventory[2] != null && entityplayer.inventory.armorInventory[2].itemID == Item.quiver.shiftedIndex) {
            damageMult = 2.0f;
            entityplayer.startUsing(itemstack, this.getMaxItemUseDuration(itemstack));
            return itemstack;
        }
        if (entityplayer.inventory.consumeInventoryItem(Item.arrow.shiftedIndex) || entityplayer.isCreative) {
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.multiplayerWorld) {
                world.entityJoinedWorld(new EntityArrow(world, entityplayer, damageMult));
            }
        }
        return itemstack;
    }

    public int getMaxItemUseDuration(ItemStack par1ItemStack) {
        return 72000;
    }

    public boolean isFull3D() {
        return true;
    }

    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityplayer, int par4) {
        boolean flag = entityplayer.isCreative;
        if (flag || entityplayer.inventory.consumeInventoryItem(Item.arrow.shiftedIndex)) {
            int i = this.getMaxItemUseDuration(itemstack) - par4;
            float f = (float)i / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(world, entityplayer, f * 2.0f);
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!world.multiplayerWorld) {
                world.entityJoinedWorld(entityarrow);
            }
        }
    }
}

