/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.core.entity.item;

import com.mojang.minecraft.core.entity.EntityPlayer;
import com.mojang.minecraft.core.entity.item.Item;
import com.mojang.minecraft.core.entity.item.ItemStack;
import com.mojang.minecraft.core.level.World;
import com.mojang.minecraft.core.level.tile.Block;
import com.mojang.minecraft.core.level.tile.material.Material;
import com.mojang.minecraft.core.util.MathHelper;

public class ItemDoor
extends Item {
    private Material field_321_a;

    public ItemDoor(int i, Material material) {
        super(i);
        this.field_321_a = material;
        this.maxDamage = 64;
        this.maxStackSize = 16;
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        if (l != 1) {
            return false;
        }
        Block block = this.field_321_a == Material.wood ? Block.doorWood : Block.doorSteel;
        if (!block.canPlace(world, i, ++j, k)) {
            return false;
        }
        int i1 = MathHelper.floor_double((double)((entityplayer.rotationYaw + 180.0f) * 4.0f / 360.0f) - 0.5) & 3;
        int byte0 = 0;
        int byte1 = 0;
        if (i1 == 0) {
            byte1 = 1;
        }
        if (i1 == 1) {
            byte0 = -1;
        }
        if (i1 == 2) {
            byte1 = -1;
        }
        if (i1 == 3) {
            byte0 = 1;
        }
        int j1 = (world.isBlockNormalCube(i - byte0, j, k - byte1) ? 1 : 0) + (world.isBlockNormalCube(i - byte0, j + 1, k - byte1) ? 1 : 0);
        int k1 = (world.isBlockNormalCube(i + byte0, j, k + byte1) ? 1 : 0) + (world.isBlockNormalCube(i + byte0, j + 1, k + byte1) ? 1 : 0);
        boolean flag = world.getBlockId(i - byte0, j, k - byte1) == block.blockID || world.getBlockId(i - byte0, j + 1, k - byte1) == block.blockID;
        boolean flag1 = world.getBlockId(i + byte0, j, k + byte1) == block.blockID || world.getBlockId(i + byte0, j + 1, k + byte1) == block.blockID;
        boolean flag2 = false;
        if (flag && !flag1) {
            flag2 = true;
        } else if (k1 > j1) {
            flag2 = true;
        }
        if (flag2) {
            i1 = i1 - 1 & 3;
            i1 += 4;
        }
        world.setBlockWithNotify(i, j, k, block.blockID);
        world.setBlockMetadataWithNotify(i, j, k, i1);
        world.setBlockWithNotify(i, j + 1, k, block.blockID);
        world.setBlockMetadataWithNotify(i, j + 1, k, i1 + 8);
        --itemstack.stackSize;
        return true;
    }
}

